/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.config;

import com.google.inject.Injector;
import io.sarl.lang.mwe2.codebuilder.config.ExpressionConfig;
import io.sarl.lang.mwe2.codebuilder.config.Modifier;
import io.sarl.lang.mwe2.codebuilder.config.SuperTypeMapping;
import io.sarl.lang.mwe2.inject.InjectionAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.scoping.TypeParameterScope;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.util.BooleanGeneratorOption;

public class CodeBuilderConfig
implements IGuiceAwareGeneratorComponent {
    private static final String TYPE_EXTENSION_GRAMMAR_NAME = "extends";
    private static final String TYPE_IMPLEMENTATION_GRAMMAR_NAME = "implements";
    private static final String ANNOTATION_LIST_GRAMMAR_NAME = "annotations";
    private static final String MODIFIER_LIST_GRAMMAR_NAME = "modifiers";
    private static final String TYPE_PARAMETER_LIST_GRAMMAR_NAME = "typeParameters";
    private static final String TYPE_PARAMETER_RULE_NAME = "JvmTypeParameter";
    private static final String MEMBER_COLLECTION_GRAMMAR_NAME = "members";
    private static final String MEMBER_NAME_GRAMMAR_NAME = "name";
    private static final String MEMBER_THROWS_GRAMMAR_NAME = "exceptions";
    private static final String MEMBER_FIRES_GRAMMAR_NAME = "firedEvents";
    private static final String MEMBER_RETURN_TYPE_GRAMMAR_NAME = "returnType";
    private static final String MEMBER_TYPE_GRAMMAR_NAME = "type";
    private static final String MEMBER_BLOCK_EXPRESSION_GRAMMAR_NAME = "expression";
    private static final String TYPE_REFERENCE_GRAMMAR_PATTERN = "TypeReference$";
    private static final String AUTO_GENERATED_COMMENT = "Auto-generated code.";
    private static final String PARAMETER_NAME_GRAMMAR_NAME = "name";
    private static final String PARAMETER_TYPE_GRAMMAR_NAME = "parameterType";
    private static final String PARAMETER_VARARG_GRAMMAR_NAME = "varArg";
    private static final String PARAMETER_EXTENSION_GRAMMAR_NAME = "extension";
    private static final String PARAMETER_DEFAULT_VALUE_GRAMMAR_NAME = "defaultValue";
    private static final String PARAMETER_LIST_GRAMMAR_NAME = "parameters";
    private static final Class<? extends EObject> PARAMETER_CONTAINER_TYPE = XtendExecutable.class;
    private static final boolean XTEND_SUPPORT_ENABLED = true;
    private static final String FORBIDDEN_GOOGLE_INJECT = "com.google.inject";
    private static final String FORBIDDEN_LOGGER = "Logger";
    private static final Class<? extends IScope> TYPE_PARAMETER_SCOPE = TypeParameterScope.class;
    private static final EClass FORMAL_PARAMETER_SUPER_TYPE = XtendPackage.eINSTANCE.getXtendParameter();
    private InjectionAPI injectionAPI = InjectionAPI.getDefault();
    private String scriptRuleName;
    private String topElementRuleName;
    private String typeParameterRuleName = "JvmTypeParameter";
    private String formalParameterRuleName;
    private Class<? extends EObject> formalParameterContainerType = PARAMETER_CONTAINER_TYPE;
    private final Set<String> multilineCommentedTypes = new HashSet<String>();
    private String typeExtensionGrammarName = "extends";
    private String typeImplementationGrammarName = "implements";
    private String annotationListGrammarName = "annotations";
    private String modifierListGrammarName = "modifiers";
    private String typeParameterListGrammarName = "typeParameters";
    private String memberCollectionGrammarName = "members";
    private String memberNameGrammarName = "name";
    private final Set<String> jvmTypeNamedMemberGrammarNames = new HashSet<String>();
    private final Set<String> indirectlyNamedMemberGrammarNames = new HashSet<String>();
    private String memberTypeGrammarName = "type";
    private String memberThrowsGrammarName = "exceptions";
    private String memberFiresGrammarName = "firedEvents";
    private String memberReturnTypeGrammarName = "returnType";
    private String memberBlockExpressionGrammarName = "expression";
    private String typeReferenceGrammarPattern = "TypeReference$";
    private String autoGeneratedComment = "Auto-generated code.";
    private Set<String> noActionBodyContainer = new TreeSet<String>();
    private String parameterNameGrammarName = "name";
    private String parameterTypeGrammarName = "parameterType";
    private String parameterVarArgGrammarName = "varArg";
    private String parameterExtensionGrammarName = "extension";
    private String parameterDefaultValueGrammarName = "defaultValue";
    private String parameterListGrammarName = "parameters";
    private boolean isXtendSupportEnable = true;
    private final Map<String, String> superTypeMapping = new TreeMap<String, String>();
    private final Map<String, String> implementedSuperTypeMapping = new TreeMap<String, String>();
    private final Map<String, List<String>> modifiers = new TreeMap<String, List<String>>();
    private final Set<String> constructorFree = new TreeSet<String>();
    private final BooleanGeneratorOption enableISourceAppendable = new BooleanGeneratorOption(true);
    private final BooleanGeneratorOption generateUnitTests = new BooleanGeneratorOption(true);
    private final ExpressionConfig expression = new ExpressionConfig();
    private final Set<String> forbiddenInjectionPrefixes = new TreeSet<String>(Collections.singleton("com.google.inject"));
    private final Set<String> forbiddenInjectionPostfixes = new TreeSet<String>(Collections.singleton("Logger"));
    private Class<? extends IScope> superTypeParameterScopeType = TYPE_PARAMETER_SCOPE;
    private EClass formalParameterSuperType = FORMAL_PARAMETER_SUPER_TYPE;

    public void addForbiddenInjectionPrefix(String prefix) {
        if (!Strings.isEmpty((String)prefix)) {
            String real = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
            this.forbiddenInjectionPrefixes.add(real);
        }
    }

    public void addForbiddenInjectionPostfixes(String postfix) {
        if (!Strings.isEmpty((String)postfix)) {
            String real = postfix.startsWith(".") ? postfix.substring(1) : postfix;
            this.forbiddenInjectionPrefixes.add(real);
        }
    }

    @Pure
    public Set<String> getForbiddenInjectionPrefixes() {
        return this.forbiddenInjectionPrefixes;
    }

    @Pure
    public Set<String> getForbiddenInjectionPostfixes() {
        return this.forbiddenInjectionPostfixes;
    }

    public void addMultilineCommentedType(String type) {
        if (!Strings.isEmpty((String)type)) {
            this.multilineCommentedTypes.add(type);
        }
    }

    @Pure
    public boolean isXtendSupportEnabled() {
        return this.isXtendSupportEnable;
    }

    public void setXtendSupportEnabled(boolean enable) {
        this.isXtendSupportEnable = enable;
    }

    @Pure
    public Set<String> getMultilineCommentedTypes() {
        return this.multilineCommentedTypes;
    }

    public void setGenerateUnitTests(boolean enable) {
        this.generateUnitTests.set(enable);
    }

    @Pure
    public boolean isUnitTestGenerationEnable() {
        return this.generateUnitTests.get();
    }

    public void setEnableISourceAppendable(boolean enable) {
        this.enableISourceAppendable.set(enable);
    }

    @Pure
    public boolean isISourceAppendableEnable() {
        return this.enableISourceAppendable.get();
    }

    public void addConstructorFreeType(String typeName) {
        if (!Strings.isEmpty((String)typeName)) {
            this.constructorFree.add(typeName);
        }
    }

    @Pure
    public Set<String> getConstructorFreeTypes() {
        return this.constructorFree;
    }

    public void setParameterListGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.parameterListGrammarName = name;
        }
    }

    @Pure
    public String getParameterListGrammarName() {
        return this.parameterListGrammarName;
    }

    public void setFormalParameterSuperType(EClass type) {
        if (type != null) {
            this.formalParameterSuperType = type;
        }
    }

    @Pure
    public EClass getFormalParameterSuperType() {
        return this.formalParameterSuperType;
    }

    public void setParameterDefaultValueGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.parameterDefaultValueGrammarName = name;
        }
    }

    @Pure
    public String getParameterDefaultValueGrammarName() {
        return this.parameterDefaultValueGrammarName;
    }

    public void setParameterVarArgGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.parameterVarArgGrammarName = name;
        }
    }

    @Pure
    public String getParameterVarArgGrammarName() {
        return this.parameterVarArgGrammarName;
    }

    public void setParameterExtensionGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.parameterExtensionGrammarName = name;
        }
    }

    @Pure
    public String getParameterExtensionGrammarName() {
        return this.parameterExtensionGrammarName;
    }

    public void setParameterTypeGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.parameterTypeGrammarName = name;
        }
    }

    @Pure
    public String getParameterTypeGrammarName() {
        return this.parameterTypeGrammarName;
    }

    public void setParameterNameGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.parameterNameGrammarName = name;
        }
    }

    @Pure
    public String getParameterNameGrammarName() {
        return this.parameterNameGrammarName;
    }

    public void addModifier(Modifier modifier) {
        String ruleName;
        if (modifier != null && !Strings.isEmpty((String)(ruleName = modifier.getType()))) {
            List<String> modifiers = this.modifiers.get(ruleName);
            if (modifiers == null) {
                modifiers = new ArrayList<String>();
                this.modifiers.put(ruleName, modifiers);
            }
            modifiers.addAll(modifier.getModifiers());
        }
    }

    @Pure
    public Map<String, List<String>> getModifiers() {
        return this.modifiers;
    }

    public void addNoActionBodyType(String containerName) {
        if (!Strings.isEmpty((String)containerName)) {
            this.noActionBodyContainer.add(containerName);
        }
    }

    @Pure
    public Set<String> getNoActionBodyTypes() {
        return this.noActionBodyContainer;
    }

    public void setAutoGeneratedComment(String comment) {
        this.autoGeneratedComment = Strings.emptyIfNull((String)comment);
    }

    @Pure
    public String getAutoGeneratedComment() {
        return this.autoGeneratedComment;
    }

    public void setTypeReferenceGrammarPattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.typeReferenceGrammarPattern = pattern;
        }
    }

    @Pure
    public String getTypeReferenceGrammarPattern() {
        return this.typeReferenceGrammarPattern;
    }

    public void setMemberBlockExpressionGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.memberBlockExpressionGrammarName = name;
        }
    }

    @Pure
    public String getMemberBlockExpressionExtensionGrammarName() {
        return this.memberBlockExpressionGrammarName;
    }

    public void setMemberReturnTypeGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.memberReturnTypeGrammarName = name;
        }
    }

    @Pure
    public String getMemberReturnTypeExtensionGrammarName() {
        return this.memberReturnTypeGrammarName;
    }

    public void setMemberThrowsGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.memberThrowsGrammarName = name;
        }
    }

    @Pure
    public String getMemberThrowsExtensionGrammarName() {
        return this.memberThrowsGrammarName;
    }

    public void setMemberFiresGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.memberFiresGrammarName = name;
        }
    }

    @Pure
    public String getMemberFiresExtensionGrammarName() {
        return this.memberFiresGrammarName;
    }

    public void setMemberTypeGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.memberTypeGrammarName = name;
        }
    }

    @Pure
    public String getMemberTypeExtensionGrammarName() {
        return this.memberTypeGrammarName;
    }

    public void setMemberNameGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.memberNameGrammarName = name;
        }
    }

    @Pure
    public String getMemberNameExtensionGrammarName() {
        return this.memberNameGrammarName;
    }

    public void addJvmTypeNamedMemberExtensionGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.jvmTypeNamedMemberGrammarNames.add(name);
        }
    }

    @Pure
    public Set<String> getJvmTypeNamedMemberExtensionGrammarNames() {
        return this.jvmTypeNamedMemberGrammarNames;
    }

    public void addIndirectlyNamedMemberExtensionGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.indirectlyNamedMemberGrammarNames.add(name);
        }
    }

    @Pure
    public Set<String> getIndirectlyNamedMemberExtensionGrammarNames() {
        return this.indirectlyNamedMemberGrammarNames;
    }

    public void setMemberCollectionGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.memberCollectionGrammarName = name;
        }
    }

    @Pure
    public String getMemberCollectionExtensionGrammarName() {
        return this.memberCollectionGrammarName;
    }

    public void setTypeExtensionGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.typeExtensionGrammarName = name;
        }
    }

    @Pure
    public String getTypeExtensionGrammarName() {
        return this.typeExtensionGrammarName;
    }

    public void setTypeImplementationGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.typeImplementationGrammarName = name;
        }
    }

    @Pure
    public String getAnnotationListGrammarName() {
        return this.annotationListGrammarName;
    }

    public void setAnnotationListGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.annotationListGrammarName = name;
        }
    }

    @Pure
    public String getModifierListGrammarName() {
        return this.modifierListGrammarName;
    }

    public void setModifierListGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.modifierListGrammarName = name;
        }
    }

    @Pure
    public String getTypeParameterListGrammarName() {
        return this.typeParameterListGrammarName;
    }

    public void setTypeParameterListGrammarName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.typeParameterListGrammarName = name;
        }
    }

    @Pure
    public String getTypeImplementationGrammarName() {
        return this.typeImplementationGrammarName;
    }

    public void addDefaultSuper(SuperTypeMapping mapping) {
        if (mapping != null) {
            this.superTypeMapping.put(mapping.getType(), mapping.getSuper());
        }
    }

    @Pure
    public Map<String, String> getDefaultSupers() {
        return this.superTypeMapping;
    }

    public void addDefaultImplementedSuper(SuperTypeMapping mapping) {
        if (mapping != null) {
            this.implementedSuperTypeMapping.put(mapping.getType(), mapping.getSuper());
        }
    }

    @Pure
    public Map<String, String> getDefaultImplementedSupers() {
        return this.implementedSuperTypeMapping;
    }

    public void setScriptRuleName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.scriptRuleName = name;
        }
    }

    @Pure
    public String getScriptRuleName() {
        return this.scriptRuleName;
    }

    public void setTopElementRuleName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.topElementRuleName = name;
        }
    }

    @Pure
    public String getTopElementRuleName() {
        return this.topElementRuleName;
    }

    public void setTypeParameterRuleName(String name) {
        if (!Strings.isEmpty((String)name)) {
            this.typeParameterRuleName = name;
        }
    }

    @Pure
    public String getTypeParameterRuleName() {
        return this.typeParameterRuleName;
    }

    public void setFormalParameterContainerType(Class<? extends EObject> name) {
        if (name != null) {
            this.formalParameterContainerType = name;
        }
    }

    @Pure
    public Class<? extends EObject> getFormalParameterContainerType() {
        return this.formalParameterContainerType;
    }

    public void setFormalParameterRuleName(String rule) {
        if (!Strings.isEmpty((String)rule)) {
            this.formalParameterRuleName = rule;
        }
    }

    @Pure
    public String getFormalParameterRuleName() {
        return this.formalParameterRuleName;
    }

    public void initialize(Injector injector) {
        injector.injectMembers((Object)this);
        this.expression.initialize(injector);
    }

    public ExpressionConfig getExpression() {
        return this.expression;
    }

    public InjectionAPI getInjectionAPI() {
        return this.injectionAPI;
    }

    public void setInjectionAPI(InjectionAPI api) {
        this.injectionAPI = api == null ? InjectionAPI.getDefault() : api;
    }

    @Deprecated(since="0.15", forRemoval=true)
    public boolean getGoogleInjectionTypes() {
        return this.injectionAPI == InjectionAPI.GOOGLE_GUICE;
    }

    @Deprecated(since="0.15", forRemoval=true)
    public void setGoogleInjectionTypes(boolean isGoogle) {
        this.injectionAPI = isGoogle ? InjectionAPI.GOOGLE_GUICE : InjectionAPI.getDefault();
    }

    @Deprecated(since="0.15", forRemoval=true)
    public Class<?> getInjectType() {
        return this.getInjectionAPI().getInjectType();
    }

    @Deprecated(since="0.15", forRemoval=true)
    public Class<?> getNamedType() {
        return this.getInjectionAPI().getNamedType();
    }

    @Deprecated(since="0.15", forRemoval=true)
    public Class<?> getProviderType() {
        return this.getInjectionAPI().getProviderType();
    }

    @Deprecated(since="0.15", forRemoval=true)
    public Class<?> getSingletonType() {
        return this.getInjectionAPI().getSingletonType();
    }

    public Class<? extends IScope> getSuperTypeParameterScopeType() {
        return this.superTypeParameterScopeType;
    }

    public void setSuperTypeParameterScopeType(Class<? extends IScope> type) {
        this.superTypeParameterScopeType = type;
    }
}

