/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.extractor;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.sarl.lang.mwe2.codebuilder.config.CodeBuilderConfig;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.util.GenModelUtil2;

public abstract class AbstractCodeElementExtractor
implements CodeElementExtractor {
    private static final String ANNOTATION_INFO_FIELD_NAME = "annotationInfo";
    @Inject
    private XtextGeneratorNaming naming;
    @Inject
    private CodeBuilderConfig configuration;
    private Grammar grammar;

    protected CodeBuilderConfig getCodeBuilderConfig() {
        return this.configuration;
    }

    @Override
    public TypeReference newTypeReference(EClassifier classifier) {
        if (classifier == null) {
            return new TypeReference(Object.class);
        }
        String name = GenModelUtil2.getJavaTypeName((EClassifier)classifier, (ResourceSet)classifier.eResource().getResourceSet());
        if (Strings.isEmpty((String)name)) {
            return new TypeReference(Object.class);
        }
        return new TypeReference(name);
    }

    @Override
    public TypeReference newTypeReference(Class<?> type) {
        if (type == null) {
            return new TypeReference(Object.class);
        }
        return new TypeReference(type);
    }

    @Override
    public CodeElementExtractor.ElementDescription newElementDescription(String name, EObject grammarComponent, EClassifier elementType, TypeReference commonType) {
        TypeReference interfaceType = this.getElementBuilderInterface(name);
        TypeReference implementationType = this.getElementBuilderImpl(name);
        TypeReference customImplementationType = this.getElementBuilderImplCustom(name);
        TypeReference appenderType = this.getElementAppenderImpl(name);
        boolean isAnnotationInfo = AbstractCodeElementExtractor.findAction(grammarComponent, this.getAnnotationInfoFieldName()) != null;
        return new CodeElementExtractor.ElementDescription(Strings.toFirstUpper((String)name), grammarComponent, this.newTypeReference(elementType), commonType, interfaceType, implementationType, customImplementationType, appenderType, isAnnotationInfo);
    }

    public String getAnnotationInfoFieldName() {
        return ANNOTATION_INFO_FIELD_NAME;
    }

    protected static Action findAction(EObject grammarComponent, String assignmentName) {
        for (Action action : GrammarUtil.containedActions((EObject)grammarComponent)) {
            if (!GrammarUtil.isAssignedAction((EObject)action) || !Objects.equals(assignmentName, action.getFeature())) continue;
            return action;
        }
        return null;
    }

    @Override
    public EClassifier getGeneratedTypeFor(EObject grammarElement) {
        if (grammarElement == null) {
            return null;
        }
        if (grammarElement instanceof AbstractRule) {
            AbstractRule cvalue = (AbstractRule)grammarElement;
            return this.getGeneratedTypeFor(cvalue);
        }
        try {
            return ((Action)Iterables.find((Iterable)GrammarUtil.containedActions((EObject)grammarElement), it -> !Strings.isEmpty((String)it.getFeature()))).getType().getClassifier();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public EClassifier getGeneratedTypeFor(AbstractRule rule) {
        List actions = GrammarUtil.containedActions((EObject)rule);
        EClassifier classifier = actions.isEmpty() ? rule.getType().getClassifier() : ((Action)actions.get(0)).getType().getClassifier();
        return classifier;
    }

    protected EObject getContainerInRule(EObject root, EObject content) {
        EClassifier classifier;
        EObject container = content;
        do {
            if ((classifier = this.getGeneratedTypeFor(container)) == null) continue;
            return container;
        } while ((container = container.eContainer()) != root);
        classifier = this.getGeneratedTypeFor(root);
        if (classifier != null) {
            return root;
        }
        return null;
    }

    @Override
    public void initialize(Grammar grammar) {
        this.grammar = grammar;
    }

    protected Grammar getGrammar() {
        return this.grammar;
    }

    @Pure
    protected XtextGeneratorNaming getNaming() {
        return this.naming;
    }

    @Override
    @Pure
    public String getLanguageBasePackage() {
        Grammar grammar = this.getGrammar();
        String basePackage = this.getNaming().getRuntimeBasePackage(grammar);
        String ecorePackage = basePackage + "." + GrammarUtil.getSimpleName((Grammar)grammar).toLowerCase();
        return ecorePackage;
    }

    @Override
    @Pure
    public TypeReference getLanguageScriptInterface() {
        AbstractRule rule = GrammarUtil.findRuleForName((Grammar)this.getGrammar(), (String)this.configuration.getScriptRuleName());
        EClassifier type = this.getGeneratedTypeFor(rule);
        return this.newTypeReference(type);
    }

    @Override
    @Pure
    public String getBasePackage() {
        Grammar grammar = this.getGrammar();
        String basePackage = this.getNaming().getRuntimeBasePackage(grammar);
        return basePackage + ".codebuilder";
    }

    @Override
    @Pure
    public String getAppenderPackage() {
        return this.getBasePackage() + ".appenders";
    }

    @Override
    @Pure
    public String getDocumentationPackage() {
        Grammar grammar = this.getGrammar();
        String basePackage = this.getNaming().getRuntimeBasePackage(grammar);
        return basePackage + ".documentation";
    }

    @Override
    @Pure
    public TypeReference getInnerBlockDocumentationAdapter() {
        return new TypeReference(this.getDocumentationPackage() + ".InnerBlockDocumentationAdapter");
    }

    @Override
    @Pure
    public String getSerializerPackage() {
        Grammar grammar = this.getGrammar();
        String basePackage = this.getNaming().getRuntimeBasePackage(grammar);
        return basePackage + ".serializer";
    }

    @Override
    @Pure
    public TypeReference getElementAppenderImpl(String elementName) {
        return new TypeReference(this.getAppenderPackage() + "." + Strings.toFirstUpper((String)elementName) + "SourceAppender");
    }

    @Override
    @Pure
    public TypeReference getElementAppenderImplCustom(String elementName) {
        return new TypeReference(this.getAppenderPackage() + "." + Strings.toFirstUpper((String)elementName) + "SourceAppenderCustom");
    }

    @Override
    @Pure
    public TypeReference getAbstractAppenderImpl() {
        return new TypeReference(this.getAppenderPackage() + ".AbstractSourceAppender");
    }

    @Override
    @Pure
    public String getBuilderPackage() {
        return this.getBasePackage() + ".builders";
    }

    @Override
    @Pure
    public TypeReference getElementBuilderInterface(String elementName) {
        return new TypeReference(this.getBuilderPackage() + ".I" + Strings.toFirstUpper((String)elementName) + "Builder");
    }

    @Override
    @Pure
    public TypeReference getElementBuilderImpl(String elementName) {
        return new TypeReference(this.getBuilderPackage() + "." + Strings.toFirstUpper((String)elementName) + "BuilderImpl");
    }

    @Override
    @Pure
    public TypeReference getElementBuilderImplCustom(String elementName) {
        return new TypeReference(this.getBuilderPackage() + "." + Strings.toFirstUpper((String)elementName) + "BuilderImplCustom");
    }

    @Override
    @Pure
    public TypeReference getLanguageTopElementType() {
        Grammar grammar = this.getGrammar();
        AbstractRule rule = GrammarUtil.findRuleForName((Grammar)grammar, (String)this.getCodeBuilderConfig().getTopElementRuleName());
        return this.newTypeReference(rule.getType().getClassifier());
    }

    @Override
    public TypeReference getLanguageKeywordAccessor() {
        Grammar grammar = this.getGrammar();
        String basePackage = this.naming.getRuntimeBasePackage(grammar);
        return new TypeReference(basePackage + ".services." + GrammarUtil.getSimpleName((Grammar)grammar).toUpperCase() + "GrammarKeywordAccess");
    }

    @Override
    @Pure
    public TypeReference getSerializerScopeProvider() {
        Grammar grammar = this.getGrammar();
        return new TypeReference(this.getSerializerScopeProviderPackage() + "." + GrammarUtil.getSimpleName((Grammar)grammar).toUpperCase() + "SerializerScopeProvider");
    }

    @Override
    @Pure
    public TypeReference getSerializerTypeParameterScope() {
        Grammar grammar = this.getGrammar();
        return new TypeReference(this.getSerializerScopeProviderPackage() + "." + GrammarUtil.getSimpleName((Grammar)grammar).toUpperCase() + "TypeParameterScope");
    }

    @Override
    public TypeReference getFormalParameterContainerType() {
        return new TypeReference(this.getCodeBuilderConfig().getFormalParameterContainerType());
    }

    @Override
    public TypeReference getFormalParameterSuperType(ResourceSet set) {
        return new TypeReference(this.getFormalParameterSuperEClass(), set);
    }

    @Override
    public EClass getFormalParameterSuperEClass() {
        return this.getCodeBuilderConfig().getFormalParameterSuperType();
    }

    @Override
    public CodeElementExtractor.ElementDescription getFormalParameter() {
        AbstractRule rule = GrammarUtil.findRuleForName((Grammar)this.getGrammar(), (String)this.getCodeBuilderConfig().getFormalParameterRuleName());
        EClassifier classifier = this.getGeneratedTypeFor(rule);
        return this.newElementDescription(classifier.getName(), (EObject)rule, classifier, classifier);
    }

    @Override
    public CodeElementExtractor.ElementDescription getTypeParameter() {
        AbstractRule rule = GrammarUtil.findRuleForName((Grammar)this.getGrammar(), (String)this.getCodeBuilderConfig().getTypeParameterRuleName());
        EClassifier classifier = this.getGeneratedTypeFor(rule);
        return this.newElementDescription(classifier.getName(), (EObject)rule, classifier, classifier);
    }
}

