/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.extractor;

import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import io.sarl.lang.mwe2.codebuilder.config.CodeBuilderConfig;
import io.sarl.lang.mwe2.codebuilder.extractor.AbstractCodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class NoBacktrackGrammarCodeElementExtractor
extends AbstractCodeElementExtractor {
    @Override
    public Iterable<CodeElementExtractor.ElementDescription> getTopElements(Grammar grammar, CodeBuilderConfig config) {
        AbstractRule topRule = GrammarUtil.findRuleForName((Grammar)grammar, (String)config.getTopElementRuleName());
        if (topRule != null) {
            EClassifier commonType = this.getGeneratedTypeFor(topRule);
            Iterable filteredElements = Iterables.filter((Iterable)GrammarUtil.containedActions((EObject)topRule), it -> !Strings.isEmpty((String)it.getFeature()));
            return Iterables.transform((Iterable)filteredElements, it -> {
                EClassifier classifier = it.getType().getClassifier();
                String name = classifier.getName();
                Group container = GrammarUtil.containingGroup((EObject)it);
                return this.newElementDescription(name, (EObject)container, classifier, commonType);
            });
        }
        return Collections.emptyList();
    }

    private <T> T visitMembers(EObject grammarContainer, EObject container, Functions.Function4<? super CodeElementExtractor, ? super EObject, ? super EObject, ? super EClassifier, ? extends T> memberCallback) {
        HashSet<String> treatedMembers = new HashSet<String>();
        for (Assignment nameAssignment : IterableExtensions.filter((Iterable)GrammarUtil.containedAssignments((EObject)container), passignment -> this.getCodeBuilderConfig().getMemberNameExtensionGrammarName().equals(passignment.getFeature()))) {
            EClassifier classifier;
            EObject assignmentContainer = this.getContainerInRule(grammarContainer, (EObject)nameAssignment);
            if (assignmentContainer == null || treatedMembers.contains((classifier = this.getGeneratedTypeFor(assignmentContainer)).getName())) continue;
            treatedMembers.add(classifier.getName());
            Object retVal = memberCallback.apply((Object)this, (Object)grammarContainer, (Object)assignmentContainer, (Object)classifier);
            if (retVal == null) continue;
            return (T)retVal;
        }
        return null;
    }

    private <T> T visitTypeReferencingMembers(EObject grammarContainer, EObject container, Functions.Function4<? super CodeElementExtractor, ? super EObject, ? super EObject, ? super EClassifier, ? extends T> memberCallback) {
        HashSet<String> treatedMembers = new HashSet<String>();
        for (Assignment nameAssignment : IterableExtensions.filter((Iterable)GrammarUtil.containedAssignments((EObject)container), passignment -> this.getCodeBuilderConfig().getJvmTypeNamedMemberExtensionGrammarNames().contains(passignment.getFeature()))) {
            EClassifier classifier;
            EObject assignmentContainer = this.getContainerInRule(grammarContainer, (EObject)nameAssignment);
            if (assignmentContainer == null || treatedMembers.contains((classifier = this.getGeneratedTypeFor(assignmentContainer)).getName())) continue;
            treatedMembers.add(classifier.getName());
            Object retVal = memberCallback.apply((Object)this, (Object)grammarContainer, (Object)assignmentContainer, (Object)classifier);
            if (retVal == null) continue;
            return (T)retVal;
        }
        return null;
    }

    private <T> T visitIndirectlyNamedMembers(EObject grammarContainer, EObject container, Functions.Function4<? super CodeElementExtractor, ? super EObject, ? super EObject, ? super EClassifier, ? extends T> memberCallback) {
        HashSet<String> treatedMembers = new HashSet<String>();
        for (Assignment nameAssignment : IterableExtensions.filter((Iterable)GrammarUtil.containedAssignments((EObject)container), passignment -> this.getCodeBuilderConfig().getIndirectlyNamedMemberExtensionGrammarNames().contains(passignment.getFeature()))) {
            EClassifier classifier;
            EObject assignmentContainer = this.getContainerInRule(grammarContainer, (EObject)nameAssignment);
            if (assignmentContainer == null || treatedMembers.contains((classifier = this.getGeneratedTypeFor(assignmentContainer)).getName())) continue;
            treatedMembers.add(classifier.getName());
            Object retVal = memberCallback.apply((Object)this, (Object)grammarContainer, (Object)assignmentContainer, (Object)classifier);
            if (retVal == null) continue;
            return (T)retVal;
        }
        return null;
    }

    private <T> T visitConstructors(EObject grammarContainer, EObject container, Functions.Function4<? super CodeElementExtractor, ? super EObject, ? super EObject, ? super EClassifier, ? extends T> callback) {
        HashSet<String> treatedConstructors = new HashSet<String>();
        for (Assignment expressionAssignment : IterableExtensions.filter((Iterable)GrammarUtil.containedAssignments((EObject)container), passignment -> this.getCodeBuilderConfig().getMemberBlockExpressionExtensionGrammarName().equals(passignment.getFeature()))) {
            EClassifier classifier;
            EObject consContainer = this.getContainerInRule(grammarContainer, (EObject)expressionAssignment);
            if (consContainer == null || IterableExtensions.exists((Iterable)GrammarUtil.containedAssignments((EObject)consContainer), it -> this.getCodeBuilderConfig().getMemberNameExtensionGrammarName().equals(it.getFeature())) || treatedConstructors.contains((classifier = this.getGeneratedTypeFor(consContainer)).getName())) continue;
            treatedConstructors.add(classifier.getName());
            Object retVal = callback.apply((Object)this, (Object)grammarContainer, (Object)consContainer, (Object)classifier);
            if (retVal == null) continue;
            return (T)retVal;
        }
        return null;
    }

    @Override
    public <T> T visitMemberElements(CodeElementExtractor.ElementDescription element, EObject grammarContainer, Functions.Function4<? super CodeElementExtractor, ? super EObject, ? super EObject, ? super EClassifier, ? extends T> constructorCallback, Functions.Function4<? super CodeElementExtractor, ? super EObject, ? super EObject, ? super EClassifier, ? extends T> namedMemberCallback, Functions.Function4<? super CodeElementExtractor, ? super EObject, ? super EObject, ? super EClassifier, ? extends T> typeReferencingMemberCallback, Functions.Function4<? super CodeElementExtractor, ? super EObject, ? super EObject, ? super EClassifier, ? extends T> indirectlyNamedMemberCallback) {
        T retVal;
        if (namedMemberCallback != null && (retVal = this.visitMembers(grammarContainer, grammarContainer, namedMemberCallback)) != null) {
            return retVal;
        }
        if (typeReferencingMemberCallback != null && (retVal = this.visitTypeReferencingMembers(grammarContainer, grammarContainer, typeReferencingMemberCallback)) != null) {
            return retVal;
        }
        if (indirectlyNamedMemberCallback != null && (retVal = this.visitIndirectlyNamedMembers(grammarContainer, grammarContainer, indirectlyNamedMemberCallback)) != null) {
            return retVal;
        }
        if (constructorCallback != null && !this.getCodeBuilderConfig().getConstructorFreeTypes().contains(element.name()) && (retVal = this.visitConstructors(grammarContainer, grammarContainer, constructorCallback)) != null) {
            return retVal;
        }
        return null;
    }
}

