/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScopeProvider;
import org.eclipse.xtext.common.types.xtext.ClasspathBasedTypeScopeProvider;
import org.eclipse.xtext.formatting.impl.AbstractTokenStream;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.scoping.batch.DelegatingScopes;
import org.eclipse.xtext.xbase.scoping.batch.TypeScopes;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class AbstractAppenderBuilderFragment
extends AbstractSubCodeBuilderFragment {
    private static final String SCOPE_PROVIDER_NAME = "io.sarl.lang.codebuilder.appenders.SourceAppender.providerType";
    private static final String JDT_TYPE_SCOPE_PROVIDER_NAME = "org.eclipse.xtext.common.types.xtext.ui.JdtBasedSimpleTypeScopeProvider";

    @Override
    public void generate() {
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            this.generateAbstractAppender();
        }
    }

    private static void bind(GuiceModuleAccess.BindingFactory factory, final Class<?> type) {
        factory.addConfiguredBinding("AbstractTypeScopeProviderForSourceAppender", new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"binder.bind(");
                it.append(AbstractTypeScopeProvider.class);
                it.append((Object)".class).annotatedWith(");
                it.append(Names.class, "");
                it.append((Object)".named(\"");
                it.append((Object)AbstractAppenderBuilderFragment.SCOPE_PROVIDER_NAME);
                it.append((Object)"\")).to(");
                it.append((Object)type);
                it.append((Object)".class);");
            }
        });
    }

    private static void bind(GuiceModuleAccess.BindingFactory factory, final String type) {
        factory.addConfiguredBinding("AbstractTypeScopeProviderForSourceAppender", new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"binder.bind(");
                it.append(AbstractTypeScopeProvider.class);
                it.append((Object)".class).annotatedWith(");
                it.append(Names.class, "");
                it.append((Object)".named(\"");
                it.append((Object)AbstractAppenderBuilderFragment.SCOPE_PROVIDER_NAME);
                it.append((Object)"\")).to(");
                it.append((Object)type);
                it.append((Object)".class);");
            }
        });
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        AbstractAppenderBuilderFragment.bind(factory, ClasspathBasedTypeScopeProvider.class);
    }

    @Override
    public void generateEclipseBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        AbstractAppenderBuilderFragment.bind(factory, JDT_TYPE_SCOPE_PROVIDER_NAME);
    }

    @Override
    public void generateIdeaBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        AbstractAppenderBuilderFragment.bind(factory, JDT_TYPE_SCOPE_PROVIDER_NAME);
    }

    protected void generateAbstractAppender() {
        final TypeReference abstractAppender = this.getCodeElementExtractor().getAbstractAppenderImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Abstract implementation of an appender for the " + AbstractAppenderBuilderFragment.this.getLanguageName() + " language."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public abstract class ");
                it.append((Object)abstractAppender.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\tpublic static final String OVERRIDEN_TYPE_SCOPE_PROVIDER_NAME = \"");
                it.append((Object)AbstractAppenderBuilderFragment.SCOPE_PROVIDER_NAME);
                it.append((Object)"\";");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(Injector.class);
                it.append((Object)" originalInjector;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\t@");
                it.append(Named.class);
                it.append((Object)"(OVERRIDEN_TYPE_SCOPE_PROVIDER_NAME)");
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(AbstractTypeScopeProvider.class);
                it.append((Object)" scopeProvider;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(TypeScopes.class);
                it.append((Object)" typeScopes;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate boolean isFormatting;");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Set if this building is formatting the generated code.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param formatting {@code true} if the appender is formatting the generated code.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic void setFormatting(boolean formatting) {");
                it.newLine();
                it.append((Object)"\t\tthis.isFormatting = formatting;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies if this building is formatting the generated code.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return {@code true} if the appender is formatting the generated code.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic boolean isFormatting() {");
                it.newLine();
                it.append((Object)"\t\treturn this.isFormatting;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the context for type resolution.");
                it.newLine();
                it.append((Object)"\t * @return the context, or {@code null} if the Ecore object is the context.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tprotected abstract ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" getTypeResolutionContext();");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Build the source code and put it into the given appender.");
                it.newLine();
                it.append((Object)"\t * @param appender the object that permits to create the source code.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic abstract void build(");
                it.append(ISourceAppender.class);
                it.append((Object)" appender) throws ");
                it.append(IOException.class);
                it.append((Object)";");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Build the source code and put it into the given appender.");
                it.newLine();
                it.append((Object)"\t * @param object the object to serialize");
                it.newLine();
                it.append((Object)"\t * @param appender the object that permits to create the source code.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic void build(");
                it.append(EObject.class);
                it.append((Object)" object, ");
                it.append(ISourceAppender.class);
                it.append((Object)" appender) throws ");
                it.append(IOException.class);
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\tresolvesTypes(object);");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" provider = getTypeResolutionContext();");
                it.newLine();
                it.append((Object)"\t\tif (provider != null) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(Map.class);
                it.append((Object)"<");
                it.append(Key.class);
                it.append((Object)"<?>, ");
                it.append(Binding.class);
                it.append((Object)"<?>> bindings = this.originalInjector.getBindings();");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(Injector.class);
                it.append((Object)" localInjector = ");
                it.append((Object)AbstractAppenderBuilderFragment.this.getBuilderFactoryImpl());
                it.append((Object)".createOverridingInjector(this.originalInjector, ");
                it.append((Object)"(binder) -> binder.bind(");
                it.append(AbstractTypeScopeProvider.class);
                it.append((Object)".class).toInstance(");
                it.append((Object)abstractAppender.getSimpleName());
                it.append((Object)".this.scopeProvider));");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(IScopeProvider.class);
                it.append((Object)" oldDelegate = this.typeScopes.getDelegate();");
                it.newLine();
                it.append((Object)"\t\t\tlocalInjector.injectMembers(this.typeScopes);");
                it.newLine();
                it.append((Object)"\t\t\ttry {");
                it.newLine();
                it.append((Object)"\t\t\t\tfinal AppenderSerializer serializer = localInjector.getProvider(AppenderSerializer.class).get();");
                it.newLine();
                it.append((Object)"\t\t\t\tserializer.serialize(object, appender, isFormatting());");
                it.newLine();
                it.append((Object)"\t\t\t} finally {");
                it.newLine();
                it.append((Object)"\t\t\t\ttry {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tfinal ");
                it.append(Field.class);
                it.append((Object)" f = ");
                it.append(DelegatingScopes.class);
                it.append((Object)".class.getDeclaredField(\"delegate\");");
                it.newLine();
                it.append((Object)"\t\t\t\t\tf.setAccessible(true);");
                it.newLine();
                it.append((Object)"\t\t\t\t\tf.set(this.typeScopes, oldDelegate);");
                it.newLine();
                it.append((Object)"\t\t\t\t} catch (");
                it.append(Exception.class);
                it.append((Object)" exception) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tthrow new ");
                it.append(Error.class);
                it.append((Object)"(exception);");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\tfinal AppenderSerializer serializer = this.originalInjector.getProvider(AppenderSerializer.class).get();");
                it.newLine();
                it.append((Object)"\t\t\tserializer.serialize(object, appender, isFormatting());");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Resolves the pending types in the resource associated to the associated Ecore element.");
                it.newLine();
                it.append((Object)"\t * @param object the object to resolve");
                it.newLine();
                it.append((Object)"\t * @since 0.15");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tprotected void resolvesTypes(");
                it.append(EObject.class);
                it.append((Object)" object) {");
                it.newLine();
                it.append((Object)"\t\tif (object != null) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(Resource.class);
                it.append((Object)" resource = object.eResource();");
                it.newLine();
                it.append((Object)"\t\t\tif (resource != null) {");
                it.newLine();
                it.append((Object)"\t\t\t\t");
                it.append(EcoreUtil2.class);
                it.append((Object)".resolveLazyCrossReferences(resource, ");
                it.append(CancelIndicator.class);
                it.append((Object)".NullImpl);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t@");
                it.append(Singleton.class);
                it.newLine();
                it.append((Object)"\tpublic static class AppenderSerializer extends ");
                it.append(Serializer.class);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t\tpublic void serialize(");
                it.append(EObject.class);
                it.append((Object)" object, ");
                it.append(ISourceAppender.class);
                it.append((Object)" appender, boolean isFormatting) throws ");
                it.append(IOException.class);
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\t\tfinal AppenderBasedTokenStream stream = new AppenderBasedTokenStream(appender);");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(SaveOptions.class);
                it.append((Object)" options;");
                it.newLine();
                it.append((Object)"\t\t\tif (isFormatting) {");
                it.newLine();
                it.append((Object)"\t\t\t\toptions = ");
                it.append(SaveOptions.class);
                it.append((Object)".newBuilder().format().getOptions();");
                it.newLine();
                it.append((Object)"\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\toptions = ");
                it.append(SaveOptions.class);
                it.append((Object)".defaultOptions();");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tserialize(object, stream, options);");
                it.newLine();
                it.append((Object)"\t\t\tstream.flush();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static class AppenderBasedTokenStream extends ");
                it.append(AbstractTokenStream.class);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final ");
                it.append(ISourceAppender.class);
                it.append((Object)" appender;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic AppenderBasedTokenStream(");
                it.append(ISourceAppender.class);
                it.append((Object)" appender) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.appender = appender;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String toString() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.appender.toString();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic void writeHidden(");
                it.append(EObject.class);
                it.append((Object)" grammarElement, String value) throws ");
                it.append(IOException.class);
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\t\tif (!");
                it.append(Strings.class);
                it.append((Object)".isEmpty(value)) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.appender.append(value);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic void writeSemantic(");
                it.append(EObject.class);
                it.append((Object)" grammarElement, String value) throws ");
                it.append(IOException.class);
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\t\tif (!");
                it.append(Strings.class);
                it.append((Object)".isEmpty(value)) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.appender.append(value);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the type reference for the given name in the given context.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic abstract ");
                it.append(JvmTypeReference.class);
                it.append((Object)" newTypeRef(String typeName);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the type reference for the given name in the given context.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic abstract ");
                it.append(JvmTypeReference.class);
                it.append((Object)" newTypeRef(");
                it.append(Notifier.class);
                it.append((Object)" context, String typeName);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the type reference for the given type and type parameters.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic abstract ");
                it.append(JvmTypeReference.class);
                it.append((Object)" newTypeRef(");
                it.append(JvmType.class);
                it.append((Object)" typeName, ");
                it.append(JvmTypeReference.class);
                it.append((Object)"... args);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(abstractAppender, content);
        javaFile.writeTo(this.getSrcGen());
    }
}

