/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.Constants;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class AbstractBuilderBuilderFragment
extends AbstractSubCodeBuilderFragment {
    @Override
    public void generate() {
        this.generateAbstractBuilder();
    }

    protected void generateAbstractBuilder() {
        final TypeReference abstractBuilder = this.getAbstractBuilderImpl();
        final TypeReference expressionBuilder = this.getExpressionBuilderImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Abstract implementation of a builder for the " + AbstractBuilderBuilderFragment.this.getLanguageName() + " language."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public abstract class ");
                it.append((Object)abstractBuilder.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(IQualifiedNameProvider.class);
                it.append((Object)" qualifiedNameProvider;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(JvmModelAssociator.class);
                it.append((Object)" associations;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(CommonTypeComputationServices.class);
                it.append((Object)" services;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(ImportManager.class);
                it.append((Object)" importManager;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(JvmTypeReferenceBuilder.Factory.class);
                it.append((Object)" typeReferenceBuilderFactory;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append(JvmTypeReferenceBuilder.class);
                it.append((Object)" typeReferenceBuilder;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(TypeReferences.class);
                it.append((Object)" typeReferences;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(Primitives.class);
                it.append((Object)" primitives;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(IImportsConfiguration.class);
                it.append((Object)" importsConfiguration;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(IResourceFactory.class);
                it.append((Object)" resourceFactory;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String fileExtension;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" typeResolutionContext;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tpublic void setFileExtensions(@");
                it.append(Named.class);
                it.append((Object)"(");
                it.append(Constants.class);
                it.append((Object)".FILE_EXTENSIONS) String fileExtensions) {");
                it.newLine();
                it.append((Object)"\t\tthis.fileExtension = ");
                it.append(SarlUtils.class);
                it.append((Object)".getMajorFileExtension(fileExtensions);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected <T> T getAssociatedElement(Class<T> expectedType, ");
                it.append(EObject.class);
                it.append((Object)" dslObject, ");
                it.append(Resource.class);
                it.append((Object)" resource, boolean failIfNotFound) {");
                it.newLine();
                it.append((Object)"\t\tfor (final ");
                it.append(EObject.class);
                it.append((Object)" obj : this.associations.getJvmElements(dslObject)) {");
                it.newLine();
                it.append((Object)"\t\t\tif (expectedType.isInstance(obj)) {");
                it.newLine();
                it.append((Object)"\t\t\t\treturn expectedType.cast(obj);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tif (resource instanceof ");
                it.append(DerivedStateAwareResource.class);
                it.append((Object)" $c$value) {");
                it.newLine();
                it.append((Object)"\t\t\t$c$value.discardDerivedState();");
                it.newLine();
                it.append((Object)"\t\t\t$c$value.getContents();");
                it.newLine();
                it.append((Object)"\t\t\treturn getAssociatedElement(expectedType, dslObject, null, failIfNotFound);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tif (failIfNotFound) {");
                it.newLine();
                it.append((Object)"\t\t\tthrow new ");
                it.append(IllegalStateException.class);
                it.append((Object)"(\"No \" + expectedType.getSimpleName() + \" associated to \" + dslObject + \" in \" + dslObject.eContainer());");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn null;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected void setTypeResolutionContext(");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" context) {");
                it.newLine();
                it.append((Object)"\t\tthis.typeResolutionContext = context;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" getTypeResolutionContext() {");
                it.newLine();
                it.append((Object)"\t\treturn this.typeResolutionContext;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the script's file extension.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String getScriptFileExtension() {");
                it.newLine();
                it.append((Object)"\t\treturn this.fileExtension;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the builder of type references.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the type reference builder.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(JvmTypeReferenceBuilder.class);
                it.append((Object)" getTypeReferenceBuilder() {");
                it.newLine();
                it.append((Object)"\t\tif (this.typeReferenceBuilder == null) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.typeReferenceBuilder = this.typeReferenceBuilderFactory.create(eResource().getResourceSet());");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn this.typeReferenceBuilder;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected ");
                it.append(TypeReferences.class);
                it.append((Object)" getTypeReferences() {");
                it.newLine();
                it.append((Object)"\t\treturn this.typeReferences;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the primitive type tools.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the primitive type tools.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(Primitives.class);
                it.append((Object)" getPrimitiveTypes() {");
                it.newLine();
                it.append((Object)"\t\treturn this.primitives;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append(JvmTypeReference.class);
                it.append((Object)" innerFindType(");
                it.append(Notifier.class);
                it.append((Object)" context, String typeName) {");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" provider = getTypeResolutionContext();");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(JvmType.class);
                it.append((Object)" type = null;");
                it.newLine();
                it.append((Object)"\t\tif (provider != null) {");
                it.newLine();
                it.append((Object)"\t\t\ttype = provider.findTypeByName(typeName);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tif (type == null) {");
                it.newLine();
                it.append((Object)"\t\t\ttype = getTypeReferences().findDeclaredType(typeName, context);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tif (type == null) {");
                it.newLine();
                it.append((Object)"\t\t\treturn null;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn getTypeReferenceBuilder().typeRef(type);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected ");
                it.append(JvmTypeReference.class);
                it.append((Object)" findType(");
                it.append(Notifier.class);
                it.append((Object)" context, String typeName) {");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(JvmTypeReference.class);
                it.append((Object)" type = innerFindType(context, typeName);");
                it.newLine();
                it.append((Object)"\t\tif (!isTypeReference(type)) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(XtextResource.class);
                it.append((Object)" xtextResource = toResource(context);");
                it.newLine();
                it.append((Object)"\t\t\tfor (String packageName : getImportsConfiguration().getImplicitlyImportedPackages(xtextResource)) {");
                it.newLine();
                it.append((Object)"\t\t\t\t");
                it.append(JvmTypeReference.class);
                it.append((Object)" typeReference = innerFindType(context, packageName + \".\" + typeName);");
                it.newLine();
                it.append((Object)"\t\t\t\tif (isTypeReference(typeReference)) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\treturn typeReference;");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tthrow new ");
                it.append(TypeNotPresentException.class);
                it.append((Object)"(typeName, null);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn type;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected static ");
                it.append(XtextResource.class);
                it.append((Object)" toResource(");
                it.append(Notifier.class);
                it.append((Object)" context) {");
                it.newLine();
                it.append((Object)"\t\treturn (");
                it.append(XtextResource.class);
                it.append((Object)") (context instanceof ");
                it.append(Resource.class);
                it.append((Object)" ? context : ((");
                it.append(EObject.class);
                it.append((Object)") context).eResource());");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate void addImport(");
                it.append(JvmTypeReference.class);
                it.append((Object)" reference) {");
                it.newLine();
                it.append((Object)"\t\tif (reference != null) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(JvmType.class);
                it.append((Object)" type = reference.getType();");
                it.newLine();
                it.append((Object)"\t\t\tif (type instanceof ");
                it.append(JvmDeclaredType.class);
                it.append((Object)") {");
                it.newLine();
                it.append((Object)"\t\t\t\tgetImportManager().addImportFor(type);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the type reference for the given name in the given context.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(JvmTypeReference.class);
                it.append((Object)" newTypeRef(String typeName) {");
                it.newLine();
                it.append((Object)"\t\treturn newTypeRef(eResource(), typeName);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the type reference for the given name in the given context.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(JvmTypeReference.class);
                it.append((Object)" newTypeRef(");
                it.append(Notifier.class);
                it.append((Object)" context, String typeName) {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(JvmTypeReference.class);
                it.append((Object)" typeReference;");
                it.newLine();
                it.append((Object)"\t\ttry {");
                it.newLine();
                it.append((Object)"\t\t\ttypeReference = findType(context, typeName);");
                it.newLine();
                it.append((Object)"\t\t\taddImport(typeReference);");
                it.newLine();
                it.append((Object)"\t\t\treturn typeReference;");
                it.newLine();
                it.append((Object)"\t\t} catch (");
                it.append(TypeNotPresentException.class);
                it.append((Object)" exception) {");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(JvmTypeReference.class);
                it.append((Object)" pref = ");
                it.append((Object)expressionBuilder);
                it.append((Object)".parseType(context, typeName, this);");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(JvmTypeReference.class);
                it.append((Object)" baseType = findType(context, pref.getType().getIdentifier());");
                it.newLine();
                it.append((Object)"\t\tfinal JvmTypeReference result;");
                it.newLine();
                it.append((Object)"\t\tif (pref instanceof ");
                it.append(JvmParameterizedTypeReference.class);
                it.append((Object)" ppref) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal int len = ppref.getArguments().size();");
                it.newLine();
                it.append((Object)"\t\t\tif (len > 0) {");
                it.newLine();
                it.append((Object)"\t\t\t\tfinal ");
                it.append(JvmTypeReference.class);
                it.append((Object)"[] args = new ");
                it.append(JvmTypeReference.class);
                it.append((Object)"[len];");
                it.newLine();
                it.append((Object)"\t\t\t\tfor (int i = 0; i < len; ++i) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tfinal ");
                it.append(JvmTypeReference.class);
                it.append((Object)" original = ppref.getArguments().get(i);");
                it.newLine();
                it.append((Object)"\t\t\t\t\tif (original instanceof ");
                it.append(JvmAnyTypeReference.class);
                it.append((Object)") {");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\targs[i] = ");
                it.append(EcoreUtil.class);
                it.append((Object)".copy(original);");
                it.newLine();
                it.append((Object)"\t\t\t\t\t} else if (original instanceof ");
                it.append(JvmWildcardTypeReference.class);
                it.append((Object)" $c$value) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\tfinal ");
                it.append(JvmWildcardTypeReference.class);
                it.append((Object)" wc = EcoreUtil.copy($c$value);");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\tfor (final ");
                it.append(JvmTypeConstraint.class);
                it.append((Object)" c : wc.getConstraints()) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\t\tc.setTypeReference(newTypeRef(context, c.getTypeReference().getIdentifier()));");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\targs[i] = wc;");
                it.newLine();
                it.append((Object)"\t\t\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\targs[i] = newTypeRef(context, original.getIdentifier());");
                it.newLine();
                it.append((Object)"\t\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\tresult = getTypeReferenceBuilder().typeRef(baseType.getType(), args);");
                it.newLine();
                it.append((Object)"\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\tresult = getTypeReferenceBuilder().typeRef(baseType.getType());");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\tresult = getTypeReferenceBuilder().typeRef(baseType.getType());");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\taddImport(result);");
                it.newLine();
                it.append((Object)"\t\treturn result;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the type reference for the given type and type parameters.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(JvmTypeReference.class);
                it.append((Object)" newTypeRef(");
                it.append(JvmType.class);
                it.append((Object)" typeName, ");
                it.append(JvmTypeReference.class);
                it.append((Object)"... args) {");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(JvmTypeReference.class);
                it.append((Object)" ref;");
                it.newLine();
                it.append((Object)"\t\tif (args != null && args.length > 0) {");
                it.newLine();
                it.append((Object)"\t\t\tref = getTypeReferenceBuilder().typeRef(typeName, args);");
                it.newLine();
                it.append((Object)"\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\tref = getTypeReferenceBuilder().typeRef(typeName);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\taddImport(ref);");
                it.newLine();
                it.append((Object)"\t\treturn ref;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the type reference for the given type and type parameters.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(JvmTypeReference.class);
                it.append((Object)" newTypeRef(");
                it.append(Class.class);
                it.append((Object)" type, ");
                it.append(JvmTypeReference.class);
                it.append((Object)"... args) {");
                it.newLine();
                it.append((Object)"\t\treturn newTypeRef(eResource(), type, args);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the type reference for the given type and type parameters.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(JvmTypeReference.class);
                it.append((Object)" newTypeRef(");
                it.append(Notifier.class);
                it.append((Object)" context, ");
                it.append(Class.class);
                it.append((Object)" type, ");
                it.append(JvmTypeReference.class);
                it.append((Object)"... args) {");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(JvmType.class);
                it.append((Object)" type0 = getTypeReferences().findDeclaredType(type, context);");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(JvmTypeReference.class);
                it.append((Object)" ref;");
                it.newLine();
                it.append((Object)"\t\tif (args != null && args.length > 0) {");
                it.newLine();
                it.append((Object)"\t\t\tref = getTypeReferenceBuilder().typeRef(type0, args);");
                it.newLine();
                it.append((Object)"\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\tref = getTypeReferenceBuilder().typeRef(type0);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\taddImport(ref);");
                it.newLine();
                it.append((Object)"\t\treturn ref;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies if the first parameter is a subtype of the second parameter.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param context the context.");
                it.newLine();
                it.append((Object)"\t * @param subType the subtype to test.");
                it.newLine();
                it.append((Object)"\t * @param superType the expected super type.");
                it.newLine();
                it.append((Object)"\t * @return the type reference.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected boolean isSubTypeOf(");
                it.append(EObject.class);
                it.append((Object)" context, ");
                it.append(JvmTypeReference.class);
                it.append((Object)" subType, ");
                it.append(JvmTypeReference.class);
                it.append((Object)" superType) {");
                it.newLine();
                it.append((Object)"\t\tif (isTypeReference(superType) && isTypeReference(subType)) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(StandardTypeReferenceOwner.class);
                it.append((Object)" owner = new ");
                it.append(StandardTypeReferenceOwner.class);
                it.append((Object)"(services, context);");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(LightweightTypeReferenceFactory.class);
                it.append((Object)" factory = new ");
                it.append(LightweightTypeReferenceFactory.class);
                it.append((Object)"(owner, false);");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(LightweightTypeReference.class);
                it.append((Object)" reference = factory.toLightweightReference(subType);");
                it.newLine();
                it.append((Object)"\t\t\treturn reference.isSubtypeOf(superType.getType());");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn false;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies if the given object is a valid type reference.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected boolean isTypeReference(");
                it.append(JvmTypeReference.class);
                it.append((Object)" typeReference) {");
                it.newLine();
                it.append((Object)"\t\treturn (typeReference != null && !typeReference.eIsProxy()");
                it.newLine();
                it.append((Object)"\t\t\t&& typeReference.getType() != null && !typeReference.getType().eIsProxy());");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the import's configuration.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the import's configuration.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(IImportsConfiguration.class);
                it.append((Object)" getImportsConfiguration() {");
                it.newLine();
                it.append((Object)"\t\treturn this.importsConfiguration;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Compute a unused URI for a synthetic resource.");
                it.newLine();
                it.append((Object)"\t * @param resourceSet the resource set in which the resource should be located.");
                it.newLine();
                it.append((Object)"\t * @return the uri.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(URI.class);
                it.append((Object)" computeUnusedUri(");
                it.append(ResourceSet.class);
                it.append((Object)" resourceSet) {");
                it.newLine();
                it.append((Object)"\t\tString name = \"__synthetic\";");
                it.newLine();
                it.append((Object)"\t\tfor (int i = 0; i < Integer.MAX_VALUE; ++i) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(URI.class);
                it.append((Object)" syntheticUri = ");
                it.append(URI.class);
                it.append((Object)".createURI(name + i + \".\" + getScriptFileExtension());");
                it.newLine();
                it.append((Object)"\t\t\tif (resourceSet.getResource(syntheticUri, false) == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\treturn syntheticUri;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tthrow new IllegalStateException();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the resource factory.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the resource factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(IResourceFactory.class);
                it.append((Object)" getResourceFactory() {");
                it.newLine();
                it.append((Object)"\t\treturn this.resourceFactory;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies if the type could contains functions with a body.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected boolean isActionBodyAllowed(");
                it.append((Object)AbstractBuilderBuilderFragment.this.getCodeElementExtractor().getLanguageTopElementType());
                it.append((Object)" type) {");
                it.newLine();
                it.append((Object)"\t\treturn ");
                if (AbstractBuilderBuilderFragment.this.getCodeBuilderConfig().getNoActionBodyTypes().isEmpty()) {
                    it.append((Object)"true");
                } else {
                    it.append((Object)"!(");
                    boolean first = true;
                    for (String noBodyType : AbstractBuilderBuilderFragment.this.getCodeBuilderConfig().getNoActionBodyTypes()) {
                        if (first) {
                            first = false;
                        } else {
                            it.newLine();
                            it.append((Object)"\t\t\t|| ");
                        }
                        it.append((Object)"type instanceof ");
                        it.append((Object)new TypeReference(AbstractBuilderBuilderFragment.this.getCodeElementExtractor().getLanguageBasePackage() + "." + noBodyType));
                    }
                    it.append((Object)")");
                }
                it.append((Object)";");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the import manager that stores the imported types.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the import manager.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(ImportManager.class);
                it.append((Object)" getImportManager() {");
                it.newLine();
                it.append((Object)"\t\treturn this.importManager;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected String getQualifiedName(");
                it.append(EObject.class);
                it.append((Object)" object) {");
                it.newLine();
                it.append((Object)"\t\treturn this.qualifiedNameProvider.getFullyQualifiedName(object).toString();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic abstract ");
                it.append(Resource.class);
                it.append((Object)" eResource();");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic void dispose() {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(Resource.class);
                it.append((Object)" resource = eResource();");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(ResourceSet.class);
                it.append((Object)" resourceSet = resource.getResourceSet();");
                it.newLine();
                it.append((Object)"\t\tresourceSet.getResources().remove(resource);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the reference to the generated Ecore element.");
                it.newLine();
                it.append((Object)"\t * @param ecoreObject the object to get a reference to.");
                it.newLine();
                it.append((Object)"\t * @param args the generic type arguments to put inside the reference.");
                it.newLine();
                it.append((Object)"\t * @since 0.15");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(JvmTypeReference.class);
                it.append((Object)" getTypeReferenceFor(");
                it.append(EObject.class);
                it.append((Object)" ecoreObject, ");
                it.append(JvmTypeReference.class);
                it.append((Object)"... args) {");
                it.newLine();
                it.append((Object)"\t\tassert ecoreObject != null;");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(JvmType.class);
                it.append((Object)" jvmObject = getAssociatedElement(");
                it.append(JvmType.class);
                it.append((Object)".class, ecoreObject, ecoreObject.eResource(), false);");
                it.newLine();
                it.append((Object)"\t\tif (jvmObject == null) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal var qn = getQualifiedName(ecoreObject);");
                it.newLine();
                it.append((Object)"\t\t\tfinal var provider = getTypeResolutionContext();");
                it.newLine();
                it.append((Object)"\t\t\tif (provider != null) {");
                it.newLine();
                it.append((Object)"\t\t\t\tjvmObject = provider.findTypeByName(qn);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tif (jvmObject == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\tjvmObject = getTypeReferences().findDeclaredType(qn, ecoreObject);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tif (jvmObject == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\treturn null;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn newTypeRef(jvmObject, args);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the reference to the generated Ecore element.");
                it.newLine();
                it.append((Object)"\t * @param ecoreObject the object to get a reference to.");
                it.newLine();
                it.append((Object)"\t * @since 0.15");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(JvmExecutable.class);
                it.append((Object)" getExecutableReferenceFor(");
                it.append(EObject.class);
                it.append((Object)" ecoreObject) {");
                it.newLine();
                it.append((Object)"\t\tassert ecoreObject != null;");
                it.newLine();
                it.append((Object)"\t\treturn getAssociatedElement(");
                it.append(JvmExecutable.class);
                it.append((Object)".class, ecoreObject, ecoreObject.eResource(), true);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(abstractBuilder, content);
        javaFile.writeTo(this.getSrcGen());
    }
}

