/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsFactory;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public abstract class AbstractMemberBuilderFragment
extends AbstractSubCodeBuilderFragment {
    protected abstract Iterable<MemberDescription> getMembers();

    @Override
    public void generate() {
        Iterable<MemberDescription> members = this.getMembers();
        for (MemberDescription description : members) {
            this.generateIMemberBuilder(description);
        }
        boolean enableAppenders = this.getCodeBuilderConfig().isISourceAppendableEnable();
        for (MemberDescription description : members) {
            this.generateMemberBuilderImpl(description);
            if (!enableAppenders) continue;
            this.generateMemberAppender(description);
        }
        super.generate();
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        for (MemberDescription description : this.getMembers()) {
            if (description.isTopElement()) continue;
            this.bindElementDescription(factory, description.getElementDescription());
        }
    }

    protected void generateIMemberBuilder(final MemberDescription description) {
        if (description.isTopElement()) {
            return;
        }
        final TypeReference builder = description.getElementDescription().builderInterfaceType();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + AbstractMemberBuilderFragment.this.getLanguageName() + " " + description.getElementDescription().name() + "."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public interface ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)AbstractMemberBuilderFragment.this.generateMembers(description, true, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateMemberBuilderImpl(final MemberDescription description) {
        if (description.isTopElement()) {
            return;
        }
        final TypeReference builderInterface = description.getElementDescription().builderInterfaceType();
        final TypeReference builder = description.getElementDescription().builderImplementationType();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + AbstractMemberBuilderFragment.this.getLanguageName() + " " + description.getElementDescription().name() + "."));
                it.newLine();
                it.append((Object)" * ");
                it.append((Object)AbstractSubCodeBuilderFragment.getFileAndLineNumber(0));
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)AbstractMemberBuilderFragment.this.getAbstractBuilderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)AbstractMemberBuilderFragment.this.generateMembers(description, false, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateMemberAppender(final MemberDescription description) {
        if (description.isTopElement()) {
            return;
        }
        final TypeReference appender = description.getElementDescription().appenderType();
        final String generatedFieldAccessor = this.getGeneratedMemberAccessor(description);
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Source appender of a " + AbstractMemberBuilderFragment.this.getLanguageName() + " " + description.getElementDescription().name() + "."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)appender.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)AbstractMemberBuilderFragment.this.getCodeElementExtractor().getAbstractAppenderImpl());
                it.append((Object)" implements ");
                it.append((Object)description.getElementDescription().builderInterfaceType());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)AbstractMemberBuilderFragment.this.generateAppenderMembers(appender.getSimpleName(), description.getElementDescription().builderInterfaceType(), generatedFieldAccessor));
                it.append((Object)AbstractMemberBuilderFragment.this.generateMembers(description, false, true));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(appender, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected String getGeneratedMemberAccessor(MemberDescription description) {
        return "get" + Strings.toFirstUpper((String)description.getElementDescription().elementType().getSimpleName()) + "()";
    }

    protected boolean isFormalParameterFeature(TypeRef referenceType) {
        EClassifier eClassifier = referenceType.getClassifier();
        if (eClassifier instanceof EClass) {
            EClass clazz = (EClass)eClassifier;
            EClass superType = this.getCodeElementExtractor().getFormalParameterSuperEClass();
            return this.isAssignableFrom(superType, clazz);
        }
        return false;
    }

    protected StringConcatenationClient generateMembers(final MemberDescription description, final boolean forInterface, final boolean forAppender) {
        final TypeReference builderType = description.getElementDescription().builderInterfaceType();
        final TypeReference generatedType = description.getElementDescription().elementType();
        final String generatedFieldName = Strings.toFirstLower((String)generatedType.getSimpleName());
        final String generatedFieldAccessor = this.getGeneratedMemberAccessor(description);
        final AtomicBoolean hasName = new AtomicBoolean(false);
        final AtomicBoolean hasTypeName = new AtomicBoolean(false);
        final AtomicBoolean hasType = new AtomicBoolean(false);
        final AtomicBoolean hasFormalParameters = new AtomicBoolean(false);
        final AtomicBoolean hasReturnType = new AtomicBoolean(false);
        final AtomicBoolean hasThrows = new AtomicBoolean(false);
        final AtomicBoolean hasFires = new AtomicBoolean(false);
        final AtomicBoolean hasBlock = new AtomicBoolean(false);
        final AtomicBoolean isAnnotated = new AtomicBoolean(false);
        final AtomicBoolean hasModifiers = new AtomicBoolean(false);
        final AtomicBoolean hasTypeParameters = new AtomicBoolean(false);
        final HashSet<TypeReference> complexParameters = new HashSet<TypeReference>();
        final ArrayList<String> expressions = new ArrayList<String>();
        for (Assignment assignment : GrammarUtil.containedAssignments((EObject)description.getElementDescription().grammarComponent())) {
            if (Objects.equals(this.getCodeBuilderConfig().getModifierListGrammarName(), assignment.getFeature())) {
                hasModifiers.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getTypeParameterListGrammarName(), assignment.getFeature())) {
                hasTypeParameters.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getAnnotationListGrammarName(), assignment.getFeature())) {
                isAnnotated.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getMemberNameExtensionGrammarName(), assignment.getFeature())) {
                hasName.set(true);
                if (!AbstractMemberBuilderFragment.nameMatches((EObject)assignment.getTerminal(), this.getCodeBuilderConfig().getTypeReferenceGrammarPattern())) continue;
                hasTypeName.set(true);
                continue;
            }
            if (this.getCodeBuilderConfig().getIndirectlyNamedMemberExtensionGrammarNames().contains(assignment.getFeature())) {
                hasName.set(true);
                hasTypeName.set(false);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getMemberTypeExtensionGrammarName(), assignment.getFeature())) {
                hasType.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getParameterListGrammarName(), assignment.getFeature())) {
                AbstractElement abstractElement = assignment.getTerminal();
                if (!(abstractElement instanceof RuleCall)) continue;
                RuleCall ruleCall = (RuleCall)abstractElement;
                TypeRef type = ruleCall.getRule().getType();
                if (this.isFormalParameterFeature(type)) {
                    hasFormalParameters.set(true);
                    continue;
                }
                complexParameters.add(this.getCodeElementExtractor().newTypeReference(type.getClassifier()));
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getMemberThrowsExtensionGrammarName(), assignment.getFeature())) {
                hasThrows.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getMemberFiresExtensionGrammarName(), assignment.getFeature())) {
                hasFires.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName(), assignment.getFeature())) {
                hasReturnType.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getMemberBlockExpressionExtensionGrammarName(), assignment.getFeature())) {
                if (!AbstractMemberBuilderFragment.nameMatches((EObject)assignment.getTerminal(), this.getCodeBuilderConfig().getExpression().getBlockExpressionGrammarPattern())) continue;
                hasBlock.set(true);
                continue;
            }
            if (!AbstractMemberBuilderFragment.nameMatches((EObject)assignment.getTerminal(), this.getCodeBuilderConfig().getExpression().getExpressionGrammarPattern())) continue;
            expressions.add(assignment.getFeature());
        }
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                if (!forInterface && !forAppender) {
                    if (hasFormalParameters.get()) {
                        AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                        it.append((Object)"\t@");
                        it.append(Inject.class);
                        it.newLine();
                        it.append((Object)"\tprivate ");
                        it.append(Provider.class);
                        it.append((Object)"<");
                        it.append((Object)AbstractMemberBuilderFragment.this.getFormalParameterBuilderInterface());
                        it.append((Object)"> parameterProvider;");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                    if (hasBlock.get()) {
                        AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                        it.append((Object)"\t@");
                        it.append(Inject.class);
                        it.newLine();
                        it.append((Object)"\tprivate ");
                        it.append(Provider.class);
                        it.append((Object)"<");
                        it.append((Object)AbstractMemberBuilderFragment.this.getBlockExpressionBuilderInterface());
                        it.append((Object)"> blockExpressionProvider;");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                    if (!expressions.isEmpty()) {
                        AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                        it.append((Object)"\t@");
                        it.append(Inject.class);
                        it.newLine();
                        it.append((Object)"\tprivate ");
                        it.append(Provider.class);
                        it.append((Object)"<");
                        it.append((Object)AbstractMemberBuilderFragment.this.getExpressionBuilderInterface());
                        it.append((Object)"> expressionProvider;");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append(EObject.class);
                    it.append((Object)" container;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append((Object)generatedType);
                    it.append((Object)" ");
                    it.append((Object)generatedFieldName);
                    it.append((Object)";");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    if (hasBlock.get()) {
                        AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                        it.append((Object)"\tprivate ");
                        it.append((Object)AbstractMemberBuilderFragment.this.getBlockExpressionBuilderInterface());
                        it.append((Object)" internalBlockExpression");
                        it.append((Object)";");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                    for (Object complexParameter : complexParameters) {
                        AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                        it.append((Object)"\t@");
                        it.append(AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getInjectionAPI().getInjectType());
                        it.newLine();
                        it.append((Object)"\tprivate ");
                        it.append(Provider.class);
                        it.append((Object)"<");
                        it.append((Object)AbstractMemberBuilderFragment.this.getCodeElementExtractor().getComplexParameterBuilderInterface((TypeReference)complexParameter));
                        it.append((Object)"> ");
                        it.append((Object)Strings.toFirstLower((String)complexParameter.getSimpleName()));
                        it.append((Object)"BuilderProvider;");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                } else {
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for the type reference use");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type and type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type arguments to put in the reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(JvmType.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type and type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type arguments to put in the reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type and type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context in which the type is defined");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type arguments to put in the reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, ");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tvoid dispose();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic void dispose() {");
                    it.newLine();
                    it.append((Object)"\t\tthis.builder.dispose();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext() {");
                    it.newLine();
                    it.append((Object)"\t\treturn this.builder.getTypeResolutionContext();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Initialize the Ecore element.");
                it.newLine();
                it.append((Object)("\t * @param container the container of the " + description.getElementDescription().name() + "."));
                it.newLine();
                if (hasName.get()) {
                    it.append((Object)"\t * @param name the ");
                    if (hasTypeName.get()) {
                        it.append((Object)"type");
                    } else {
                        it.append((Object)"name");
                    }
                    it.append((Object)(" of the " + description.getElementDescription().name() + "."));
                    it.newLine();
                }
                if (description.getModifiers().size() > 1) {
                    it.append((Object)"\t * @param modifier the major/default modifier to be associated to the member.");
                    it.newLine();
                }
                it.append((Object)"\t * @param context the context in which type resolution must be applied.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void eInit(");
                it.append(EObject.class);
                it.append((Object)" container, ");
                if (hasName.get()) {
                    it.append((Object)"String name, ");
                }
                if (description.getModifiers().size() > 1) {
                    it.append((Object)"String modifier, ");
                }
                it.append(IJvmTypeProvider.class);
                it.append((Object)" context)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.eInit(container, ");
                        if (hasName.get()) {
                            it.append((Object)"name, ");
                        }
                        if (description.getModifiers().size() > 1) {
                            it.append((Object)"modifier, ");
                        }
                        it.append((Object)"context);");
                    } else if (hasName.get() && hasTypeName.get()) {
                        it.append((Object)"\t\t// Generator code: ");
                        it.append((Object)AbstractSubCodeBuilderFragment.getFileAndLineNumber(0));
                        it.newLine();
                        it.append((Object)"\t\tif (this.");
                        it.append((Object)generatedFieldName);
                        it.append((Object)" == null) {");
                        it.newLine();
                        it.append((Object)"\t\t\tthis.");
                        it.append((Object)generatedFieldName);
                        it.append((Object)" = ");
                        it.append((Object)AbstractMemberBuilderFragment.this.getXFactoryFor(generatedType));
                        it.append((Object)".eINSTANCE.create");
                        it.append((Object)Strings.toFirstUpper((String)generatedType.getSimpleName()));
                        it.append((Object)"();");
                        it.newLine();
                        it.append((Object)"\t\t\tinternalEInit(container, context);");
                        it.newLine();
                        if (hasName.get()) {
                            it.append((Object)"\t\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" ref = newTypeRef(container, name);");
                            it.newLine();
                            it.append((Object)"\t\t\tif (ref instanceof ");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)" pref) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".setName(pref);");
                            it.newLine();
                            it.append((Object)"\t\t\t} else {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tthrow new ");
                            it.append(IllegalArgumentException.class);
                            it.append((Object)"(name);");
                            it.newLine();
                            it.append((Object)"\t\t\t}");
                            it.newLine();
                        }
                        if (description.getModifiers().size() > 1) {
                            it.append((Object)"\t\t\tif (");
                            boolean first = true;
                            for (String mod : description.getModifiers()) {
                                if (first) {
                                    first = false;
                                } else {
                                    it.newLine();
                                    it.append((Object)"\t\t\t\t|| ");
                                }
                                it.append(Strings.class);
                                it.append((Object)".equal(modifier, \"");
                                it.append((Object)Strings.convertToJavaString((String)mod));
                                it.append((Object)"\")");
                            }
                            it.append((Object)") {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".getModifiers().add(modifier);");
                            it.newLine();
                            it.append((Object)"\t\t\t} else {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tthrow new IllegalStateException(\"Invalid modifier\");");
                            it.newLine();
                            it.append((Object)"\t\t\t}");
                            it.newLine();
                        } else if (description.getModifiers().size() == 1) {
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".getModifiers().add(\"");
                            it.append((Object)Strings.convertToJavaString((String)description.getModifiers().iterator().next()));
                            it.append((Object)"\");");
                            it.newLine();
                        }
                        it.append((Object)"\t\t}");
                    } else {
                        it.append((Object)"\t\t// Generator code: ");
                        it.append((Object)AbstractSubCodeBuilderFragment.getFileAndLineNumber(0));
                        it.newLine();
                        it.append((Object)"\t\tif (this.");
                        it.append((Object)generatedFieldName);
                        it.append((Object)" == null) {");
                        it.newLine();
                        it.append((Object)"\t\t\tthis.");
                        it.append((Object)generatedFieldName);
                        it.append((Object)" = ");
                        it.append((Object)AbstractMemberBuilderFragment.this.getXFactoryFor(generatedType));
                        it.append((Object)".eINSTANCE.create");
                        it.append((Object)Strings.toFirstUpper((String)generatedType.getSimpleName()));
                        it.append((Object)"();");
                        it.newLine();
                        it.append((Object)"\t\t\tinternalEInit(container, context);");
                        it.newLine();
                        if (hasName.get()) {
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".setName(name);");
                            it.newLine();
                        }
                        if (description.getModifiers().size() > 1) {
                            it.append((Object)"\t\t\tif (");
                            boolean first = true;
                            for (String mod : description.getModifiers()) {
                                if (first) {
                                    first = false;
                                } else {
                                    it.newLine();
                                    it.append((Object)"\t\t\t\t|| ");
                                }
                                it.append(Strings.class);
                                it.append((Object)".equal(modifier, \"");
                                it.append((Object)Strings.convertToJavaString((String)mod));
                                it.append((Object)"\")");
                            }
                            it.append((Object)") {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".getModifiers().add(modifier);");
                            it.newLine();
                            it.append((Object)"\t\t\t} else {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tthrow new IllegalStateException(\"Invalid modifier\");");
                            it.newLine();
                            it.append((Object)"\t\t\t}");
                            it.newLine();
                        } else if (description.getModifiers().size() == 1) {
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".getModifiers().add(\"");
                            it.append((Object)Strings.convertToJavaString((String)description.getModifiers().iterator().next()));
                            it.append((Object)"\");");
                            it.newLine();
                        }
                        it.append((Object)"\t\t}");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (hasName.get() && hasTypeName.get()) {
                    it.append((Object)"\t/** Initialize the Ecore element.");
                    it.newLine();
                    it.append((Object)("\t * @param container the container of the " + description.getElementDescription().name() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the type of the " + description.getElementDescription().name() + "."));
                    it.newLine();
                    it.append((Object)"\t * @param context the context in which type resolution must be applied.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)"void eInit(");
                    it.append(EObject.class);
                    it.append((Object)" container, ");
                    it.append(JvmParameterizedTypeReference.class);
                    it.append((Object)" name, ");
                    if (description.getModifiers().size() > 1) {
                        it.append((Object)"String modifier, ");
                    }
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" context)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.eInit(container, name, ");
                            if (description.getModifiers().size() > 1) {
                                it.append((Object)"modifier, ");
                            }
                            it.append((Object)"context);");
                        } else {
                            it.append((Object)"\t\t// Generator code: ");
                            it.append((Object)AbstractSubCodeBuilderFragment.getFileAndLineNumber(0));
                            it.newLine();
                            it.append((Object)"\t\tif (this.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)" == null) {");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)" = ");
                            it.append((Object)AbstractMemberBuilderFragment.this.getXFactoryFor(generatedType));
                            it.append((Object)".eINSTANCE.create");
                            it.append((Object)Strings.toFirstUpper((String)generatedType.getSimpleName()));
                            it.append((Object)"();");
                            it.newLine();
                            it.append((Object)"\t\t\tinternalEInit(container, context);");
                            it.newLine();
                            if (hasName.get()) {
                                it.append((Object)"\t\t\tthis.");
                                it.append((Object)generatedFieldName);
                                it.append((Object)".setName(name);");
                                it.newLine();
                            }
                            if (description.getModifiers().size() > 1) {
                                it.append((Object)"\t\t\tif (");
                                boolean first = true;
                                for (String mod : description.getModifiers()) {
                                    if (first) {
                                        first = false;
                                    } else {
                                        it.newLine();
                                        it.append((Object)"\t\t\t\t|| ");
                                    }
                                    it.append(Strings.class);
                                    it.append((Object)".equal(modifier, \"");
                                    it.append((Object)Strings.convertToJavaString((String)mod));
                                    it.append((Object)"\")");
                                }
                                it.append((Object)") {");
                                it.newLine();
                                it.append((Object)"\t\t\t\tthis.");
                                it.append((Object)generatedFieldName);
                                it.append((Object)".getModifiers().add(modifier);");
                                it.newLine();
                                it.append((Object)"\t\t\t} else {");
                                it.newLine();
                                it.append((Object)"\t\t\t\tthrow new IllegalStateException(\"Invalid modifier\");");
                                it.newLine();
                                it.append((Object)"\t\t\t}");
                                it.newLine();
                            } else if (description.getModifiers().size() == 1) {
                                it.append((Object)"\t\t\tthis.");
                                it.append((Object)generatedFieldName);
                                it.append((Object)".getModifiers().add(\"");
                                it.append((Object)Strings.convertToJavaString((String)description.getModifiers().iterator().next()));
                                it.append((Object)"\");");
                                it.newLine();
                            }
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (!forAppender && !forInterface) {
                    it.append((Object)"\tprivate void internalEInit(");
                    it.append(EObject.class);
                    it.append((Object)" container, ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" context) {");
                    it.newLine();
                    it.append((Object)"\t\t// Generator code: ");
                    it.append((Object)AbstractSubCodeBuilderFragment.getFileAndLineNumber(0));
                    it.newLine();
                    it.append((Object)"\t\tassert this.");
                    it.append((Object)generatedFieldName);
                    it.append((Object)" != null;");
                    it.newLine();
                    it.append((Object)"\t\tsetTypeResolutionContext(context);");
                    it.newLine();
                    it.append((Object)"\t\tthis.container = container;");
                    it.newLine();
                    if (description.isAnnotationInfo()) {
                        TypeReference commonSuperType = description.getElementDescription().commonSuperType();
                        it.append((Object)"\t\tthis.");
                        it.append((Object)generatedFieldName);
                        it.append((Object)".setAnnotationInfo(");
                        it.append((Object)AbstractMemberBuilderFragment.this.getXFactoryFor(commonSuperType));
                        it.append((Object)".eINSTANCE.create");
                        it.append((Object)Strings.toFirstUpper((String)commonSuperType.getSimpleName()));
                        it.append((Object)"());");
                        it.newLine();
                    }
                    it.append((Object)"\t\tif (container instanceof ");
                    it.append(XtendTypeDeclaration.class);
                    it.append((Object)" typeDeclaration) {");
                    it.newLine();
                    it.append((Object)"\t\t\ttypeDeclaration.get");
                    it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberCollectionExtensionGrammarName()));
                    it.append((Object)"().add(this.");
                    it.append((Object)generatedFieldName);
                    it.append((Object)");");
                    it.newLine();
                    it.append((Object)"\t\t\tthis.");
                    it.append((Object)generatedFieldName);
                    it.append((Object)".setDeclaringType(typeDeclaration);");
                    it.newLine();
                    it.append((Object)"\t\t}");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Replies the generated element.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)generatedType);
                it.append((Object)" ");
                it.append((Object)generatedFieldAccessor);
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.");
                        it.append((Object)generatedFieldAccessor);
                        it.append((Object)";");
                    } else {
                        it.append((Object)"\t\treturn this.");
                        it.append((Object)generatedFieldName);
                        it.append((Object)";");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the resource.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(Resource.class);
                it.append((Object)" eResource()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    it.append((Object)generatedFieldAccessor);
                    it.append((Object)".eResource();");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)AbstractMemberBuilderFragment.this.generateStandardCommentFunctions(forInterface, forAppender, generatedFieldAccessor, description.getElementDescription().builderInterfaceType()));
                if (hasType.get()) {
                    it.append((Object)"\t/** Change the type.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type of the member.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)description.getElementDescription().builderInterfaceType());
                    it.append((Object)" set");
                    it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberTypeExtensionGrammarName()));
                    it.append((Object)"(String type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.set");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberTypeExtensionGrammarName()));
                            it.append((Object)"(type);");
                        } else {
                            it.append((Object)"\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" ref = newTypeRef(this.container, type);");
                            it.newLine();
                            it.append((Object)"\t\tset");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberTypeExtensionGrammarName()));
                            it.append((Object)"(ref);");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Change the type.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type of the member.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)description.getElementDescription().builderInterfaceType());
                    it.append((Object)" set");
                    it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberTypeExtensionGrammarName()));
                    it.append((Object)"(");
                    it.append(JvmTypeReference.class);
                    it.append((Object)" type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.set");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberTypeExtensionGrammarName()));
                            it.append((Object)"(type);");
                        } else {
                            it.append((Object)"\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".set");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberTypeExtensionGrammarName()));
                            it.append((Object)"(type);");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasFormalParameters.get()) {
                    it.append((Object)"\t/** Add a formal parameter.");
                    it.newLine();
                    it.append((Object)"\t * @param name the name of the formal parameter.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)AbstractMemberBuilderFragment.this.getFormalParameterBuilderInterface());
                    it.append((Object)" add");
                    it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getParameterListGrammarName())));
                    it.append((Object)"(String name)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\treturn this.builder.add");
                            it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getParameterListGrammarName())));
                            it.append((Object)"(name);");
                        } else {
                            it.append((Object)"\t\t");
                            it.append((Object)AbstractMemberBuilderFragment.this.getFormalParameterBuilderInterface());
                            it.append((Object)" builder = this.parameterProvider.get();");
                            it.newLine();
                            it.append((Object)"\t\tbuilder.eInit(this.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)", name, getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\treturn builder;");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasThrows.get()) {
                    it.append((Object)"\t/** Add a throwable exception.");
                    it.newLine();
                    it.append((Object)"\t * @param type the fully qualified name of the exception.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" add");
                    it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberThrowsExtensionGrammarName())));
                    it.append((Object)"(String type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.add");
                            it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberThrowsExtensionGrammarName())));
                            it.append((Object)"(type);");
                        } else {
                            it.append((Object)"\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" ref = newTypeRef(this.container, type);");
                            it.newLine();
                            it.append((Object)"\t\tadd");
                            it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberThrowsExtensionGrammarName())));
                            it.append((Object)"(ref);");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Add a throwable exception.");
                    it.newLine();
                    it.append((Object)"\t * @param type the exception.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" add");
                    it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberThrowsExtensionGrammarName())));
                    it.append((Object)"(");
                    it.append(JvmTypeReference.class);
                    it.append((Object)" type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.add");
                            it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberThrowsExtensionGrammarName())));
                            it.append((Object)"(type);");
                        } else {
                            it.append((Object)"\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".get");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberThrowsExtensionGrammarName()));
                            it.append((Object)"().add(type);");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasFires.get()) {
                    it.append((Object)"\t/** Add a fired event.");
                    it.newLine();
                    it.append((Object)"\t * @param type the fully qualified name of the event.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" add");
                    it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberFiresExtensionGrammarName())));
                    it.append((Object)"(String type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.add");
                            it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberFiresExtensionGrammarName())));
                            it.append((Object)"(type);");
                        } else {
                            it.append((Object)"\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" ref = newTypeRef(this.container, type);");
                            it.newLine();
                            it.append((Object)"\t\tadd");
                            it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberFiresExtensionGrammarName())));
                            it.append((Object)"(ref);");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Add a fired event.");
                    it.newLine();
                    it.append((Object)"\t * @param type the event.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)"void add");
                    it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberFiresExtensionGrammarName())));
                    it.append((Object)"(");
                    it.append(JvmTypeReference.class);
                    it.append((Object)" type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.add");
                            it.append((Object)AbstractSubCodeBuilderFragment.toSingular(Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberFiresExtensionGrammarName())));
                            it.append((Object)"(type);");
                        } else {
                            it.append((Object)"\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".get");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberFiresExtensionGrammarName()));
                            it.append((Object)"().add(type);");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasReturnType.get()) {
                    it.append((Object)"\t/** Change the return type.");
                    it.newLine();
                    it.append((Object)"\t @param type the return type of the member.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" set");
                    it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName()));
                    it.append((Object)"(String type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.set");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName()));
                            it.append((Object)"(type);");
                        } else {
                            it.append((Object)"\t\tif (!");
                            it.append(Strings.class);
                            it.append((Object)".isEmpty(type)) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" ref = newTypeRef(container, type);");
                            it.newLine();
                            it.append((Object)"\t\t\tset");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName()));
                            it.append((Object)"(ref);");
                            it.newLine();
                            it.append((Object)"\t\t} else {");
                            it.newLine();
                            it.append((Object)"\t\t\tset");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName()));
                            it.append((Object)"((");
                            it.append(JvmTypeReference.class);
                            it.append((Object)") null);");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Change the return type.");
                    it.newLine();
                    it.append((Object)"\t @param type the return type of the member.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" set");
                    it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName()));
                    it.append((Object)"(");
                    it.append(JvmTypeReference.class);
                    it.append((Object)" type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.set");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName()));
                            it.append((Object)"(type);");
                        } else {
                            it.append((Object)"\t\tif (type != null && !");
                            it.append(Objects.class);
                            it.append((Object)".equals(\"void\", type.getType().getIdentifier())");
                            it.newLine();
                            it.append((Object)"\t\t\t\t&& !");
                            it.append(Objects.class);
                            it.append((Object)".equals(Void.class.getName(), type.getType().getIdentifier())) {");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".set");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName()));
                            it.append((Object)"(type);");
                            it.newLine();
                            it.append((Object)"\t\t} else {");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".set");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberReturnTypeExtensionGrammarName()));
                            it.append((Object)"(null);");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasBlock.get()) {
                    it.append((Object)"\t/** Create the block of code.");
                    it.newLine();
                    it.append((Object)"\t * @return the block builder.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)AbstractMemberBuilderFragment.this.getBlockExpressionBuilderInterface());
                    it.append((Object)" get");
                    it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberBlockExpressionExtensionGrammarName()));
                    it.append((Object)"()");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\treturn this.builder.get");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberBlockExpressionExtensionGrammarName()));
                            it.append((Object)"();");
                        } else {
                            it.append((Object)"\t\t");
                            it.append((Object)AbstractMemberBuilderFragment.this.getBlockExpressionBuilderInterface());
                            it.append((Object)" block = this.internalBlockExpression;");
                            it.newLine();
                            it.append((Object)"\t\tif (block == null) {");
                            it.newLine();
                            it.append((Object)"\t\t\tblock = this.blockExpressionProvider.get();");
                            it.newLine();
                            it.append((Object)"\t\t\tblock.eInit(getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append(XBlockExpression.class);
                            it.append((Object)" expr = block.getXBlockExpression();");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".set");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getMemberBlockExpressionExtensionGrammarName()));
                            it.append((Object)"(expr);");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.internalBlockExpression = block;");
                            it.newLine();
                            it.append((Object)"\t\t}");
                            it.newLine();
                            it.append((Object)"\t\treturn block;");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (isAnnotated.get()) {
                    it.append((Object)"\t/** Add an annotation.");
                    it.newLine();
                    it.append((Object)"\t * @param type the qualified name of the annotation");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" addAnnotation(String type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.addAnnotation(type);");
                        } else {
                            it.append((Object)"\t\tif (!");
                            it.append(Strings.class);
                            it.append((Object)".isEmpty(type)) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" ref = newTypeRef(");
                            it.append((Object)generatedFieldAccessor);
                            it.append((Object)", type);");
                            it.newLine();
                            it.append((Object)"\t\t\taddAnnotation(ref);");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Add an annotation.");
                    it.newLine();
                    it.append((Object)"\t * @param type the annotation type");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" addAnnotation(");
                    it.append(JvmTypeReference.class);
                    it.append((Object)" type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.addAnnotation(type);");
                        } else {
                            it.append((Object)"\t\tif (type != null) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append(XAnnotation.class);
                            it.append((Object)" annotation = ");
                            it.append(XAnnotationsFactory.class);
                            it.append((Object)".eINSTANCE.createXAnnotation();");
                            it.newLine();
                            it.append((Object)"\t\t\tannotation.setAnnotationType(type.getType());");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append((Object)generatedFieldAccessor);
                            it.append((Object)".getAnnotations().add(annotation);");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasModifiers.get()) {
                    it.append((Object)"\t/** Add a modifier.");
                    it.newLine();
                    it.append((Object)"\t * @param modifier the modifier to add.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" addModifier(String modifier)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.addModifier(modifier);");
                        } else {
                            it.append((Object)"\t\tif (!");
                            it.append(Strings.class);
                            it.append((Object)".isEmpty(modifier)) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append((Object)generatedFieldAccessor);
                            it.append((Object)".getModifiers().add(modifier);");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (!forInterface) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Override.class);
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(String.class);
                    it.append((Object)" toString() {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    if (forAppender) {
                        it.append((Object)"this.builder.toString();");
                    } else {
                        it.append(EmfFormatter.class);
                        it.append((Object)".objToStr(");
                        it.append((Object)generatedFieldAccessor);
                        it.append((Object)");");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasTypeParameters.get()) {
                    if (!forInterface && !forAppender) {
                        AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                        it.append((Object)"\t@");
                        it.append(Inject.class);
                        it.newLine();
                        it.append((Object)"\tprivate ");
                        it.append(Provider.class);
                        it.append((Object)"<");
                        it.append((Object)AbstractMemberBuilderFragment.this.getTypeParameterBuilderInterface());
                        it.append((Object)"> iTypeParameterBuilderProvider;");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                    it.append((Object)"\t/** Add a type parameter.");
                    it.newLine();
                    it.append((Object)"\t * @param name the simple name of the type parameter.");
                    it.newLine();
                    it.append((Object)"\t * @return the builder of type parameter.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)AbstractMemberBuilderFragment.this.getTypeParameterBuilderInterface());
                    it.append((Object)" addTypeParameter(String name)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\treturn this.builder.addTypeParameter(name);");
                        } else {
                            it.append((Object)"\t\t");
                            it.append((Object)AbstractMemberBuilderFragment.this.getTypeParameterBuilderInterface());
                            it.append((Object)" builder = this.iTypeParameterBuilderProvider.get();");
                            it.newLine();
                            it.append((Object)"\t\tfinal ");
                            it.append((Object)generatedType);
                            it.append((Object)" object = ");
                            it.append((Object)generatedFieldAccessor);
                            it.append((Object)";");
                            it.newLine();
                            it.append((Object)"\t\tbuilder.eInit(object, getExecutableReferenceFor(object), name, getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\tobject.getTypeParameters().add(builder.getJvmTypeParameter());");
                            it.newLine();
                            it.append((Object)"\t\treturn builder;");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                for (String expressionName : expressions) {
                    it.append((Object)("\t/** Replies the " + expressionName + "."));
                    it.newLine();
                    it.append((Object)"\t * @return the value of the ");
                    it.append((Object)expressionName);
                    it.append((Object)". It may be {@code null}.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)AbstractMemberBuilderFragment.this.getExpressionBuilderInterface());
                    it.append((Object)" get");
                    it.append((Object)Strings.toFirstUpper((String)expressionName));
                    it.append((Object)"()");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\treturn this.builder.get");
                            it.append((Object)Strings.toFirstUpper((String)expressionName));
                            it.append((Object)"();");
                        } else {
                            it.append((Object)"\t\t");
                            it.append((Object)AbstractMemberBuilderFragment.this.getExpressionBuilderInterface());
                            it.append((Object)" exprBuilder = this.expressionProvider.get();");
                            it.newLine();
                            it.append((Object)"\t\texprBuilder.eInit(");
                            it.append((Object)generatedFieldAccessor);
                            it.append((Object)", new ");
                            it.append(Procedures.class);
                            it.append((Object)".Procedure1<");
                            it.append(XExpression.class);
                            it.append((Object)">() {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tpublic void apply(");
                            it.append(XExpression.class);
                            it.append((Object)" expr) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\t");
                            it.append((Object)generatedFieldAccessor);
                            it.append((Object)".set");
                            it.append((Object)Strings.toFirstUpper((String)expressionName));
                            it.append((Object)"(expr);");
                            it.newLine();
                            it.append((Object)"\t\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t\t}, getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\treturn exprBuilder;");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                for (Object complexParameter : complexParameters) {
                    it.append((Object)("\t/** Add a parameter of type {@code " + complexParameter.getName() + "}."));
                    it.newLine();
                    it.append((Object)"\t * @param name the name of the parameter");
                    it.newLine();
                    it.append((Object)"\t * @return the builder for the parameter, never {@code null}.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)AbstractMemberBuilderFragment.this.getCodeElementExtractor().getComplexParameterBuilderInterface((TypeReference)complexParameter));
                    it.append((Object)" addParameter(");
                    it.append(String.class);
                    it.append((Object)" name)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\treturn this.builder.addParameter(name);");
                        } else {
                            it.append((Object)"\t\t");
                            it.append((Object)AbstractMemberBuilderFragment.this.getCodeElementExtractor().getComplexParameterBuilderInterface((TypeReference)complexParameter));
                            it.append((Object)" builder = this.");
                            it.append((Object)Strings.toFirstLower((String)complexParameter.getSimpleName()));
                            it.append((Object)"BuilderProvider.get();");
                            it.newLine();
                            it.append((Object)"\t\tbuilder.eInit(this.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)", name, getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\tif (!(this.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)" instanceof ");
                            it.append(XtendTypeDeclaration.class);
                            it.append((Object)")) {");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedFieldName);
                            it.append((Object)".get");
                            it.append((Object)Strings.toFirstUpper((String)AbstractMemberBuilderFragment.this.getCodeBuilderConfig().getParameterListGrammarName()));
                            it.append((Object)"().add(builder.get");
                            it.append((Object)Strings.toFirstUpper((String)complexParameter.getSimpleName()));
                            it.append((Object)"());");
                            it.newLine();
                            it.append((Object)"\t\t}");
                            it.newLine();
                            it.append((Object)"\t\treturn builder;");
                            it.newLine();
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            }
        };
    }

    public static class MemberDescription {
        private final CodeElementExtractor.ElementDescription element;
        private final CodeElementExtractor.ElementDescription container;
        private final List<String> modifiers;
        private final Set<String> containers = new HashSet<String>();
        private final Set<String> noBodyContainers = new HashSet<String>();
        private final boolean isTopElement;
        private final boolean isAnnotationInfo;

        public MemberDescription(CodeElementExtractor.ElementDescription element, CodeElementExtractor.ElementDescription container, boolean isTopElement, boolean annotationInfo, List<String> modifiers) {
            this.element = element;
            this.container = container;
            this.isTopElement = isTopElement;
            this.isAnnotationInfo = annotationInfo;
            this.modifiers = modifiers;
        }

        public CodeElementExtractor.ElementDescription getElementDescription() {
            return this.element;
        }

        public CodeElementExtractor.ElementDescription getContainerDescription() {
            return this.container;
        }

        public String toString() {
            return this.element.name();
        }

        public boolean isTopElement() {
            return this.isTopElement;
        }

        public boolean isAnnotationInfo() {
            return this.isAnnotationInfo;
        }

        @Pure
        public List<String> getModifiers() {
            if (this.modifiers == null) {
                return Collections.emptyList();
            }
            return this.modifiers;
        }

        @Pure
        public Set<String> getStandardContainers() {
            return this.containers;
        }

        @Pure
        public Set<String> getNoBodyContainers() {
            return this.noBodyContainers;
        }
    }
}

