/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.mwe2.codebuilder.config.CodeBuilderConfig;
import io.sarl.lang.mwe2.codebuilder.config.ExpressionConfig;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ecore.EcoreQualifiedNameProvider;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractStubGeneratingFragment;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public abstract class AbstractSubCodeBuilderFragment
extends AbstractStubGeneratingFragment {
    @Inject
    private FileAccessFactory fileAccessFactory;
    @Inject
    private CodeBuilderConfig configuration;
    private Collection<AbstractSubCodeBuilderFragment> subFragments;
    @Inject
    private CodeElementExtractor grammarExtractor;
    @Inject
    private XtextGeneratorNaming naming;
    @Inject
    private EcoreQualifiedNameProvider nameProvider;

    protected boolean isAssignableFrom(EClass left, EClass right) {
        QualifiedName rightName;
        QualifiedName leftName = this.nameProvider.getFullyQualifiedName((EObject)left);
        if (leftName.equals((Object)(rightName = this.nameProvider.getFullyQualifiedName((EObject)right)))) {
            return true;
        }
        return right.getEAllSuperTypes().parallelStream().anyMatch(it -> {
            QualifiedName candidate = this.nameProvider.getFullyQualifiedName((EObject)it);
            return leftName.equals((Object)candidate);
        });
    }

    protected static void appendEmptyComment(StringConcatenationClient.TargetStringConcatenation it) {
        it.append((Object)"\t/**");
        it.newLine();
        AbstractSubCodeBuilderFragment.appendFileLineComment(it, 2);
        it.append((Object)"\t */");
        it.newLine();
    }

    protected static void appendFileLineComment(StringConcatenationClient.TargetStringConcatenation it) {
        AbstractSubCodeBuilderFragment.appendFileLineComment(it, 2);
    }

    protected static void appendFileLineComment(StringConcatenationClient.TargetStringConcatenation it, int shift) {
        it.append((Object)"\t * @see \"");
        it.append((Object)AbstractSubCodeBuilderFragment.getFileAndLineNumber(shift));
        it.append((Object)"\"");
        it.newLine();
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.getCodeBuilderConfig().initialize(injector);
        this.getCodeElementExtractor().initialize(this.getGrammar());
        this.subFragments = this.initializeSubGenerators(injector);
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.initialize(injector);
        }
    }

    protected Class<?> getInjectType() {
        return this.getCodeBuilderConfig().getInjectionAPI().getInjectType();
    }

    protected XtextGeneratorNaming getNaming() {
        return this.naming;
    }

    protected CodeElementExtractor getCodeElementExtractor() {
        return this.grammarExtractor;
    }

    protected Collection<AbstractSubCodeBuilderFragment> initializeSubGenerators(Injector injector) {
        return Collections.emptyList();
    }

    @Pure
    private void checkNoEmpty(String name, String value, Issues issues) {
        if (Strings.isEmpty((String)value)) {
            issues.addError(MessageFormat.format("the configuration entry ''{0}'' is not set", name), (Object)this);
        }
    }

    @Pure
    private void checkNoNull(String name, Object value, Issues issues) {
        if (value == null) {
            issues.addError(MessageFormat.format("the configuration entry ''{0}'' is not set", name), (Object)this);
        }
    }

    @Pure
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        CodeBuilderConfig config = this.getCodeBuilderConfig();
        if (config == null) {
            issues.addError("No code builder configuration", (Object)this);
        } else {
            this.checkNoEmpty("scriptRuleName", config.getScriptRuleName(), issues);
            this.checkNoEmpty("topElementRuleName", config.getTopElementRuleName(), issues);
            this.checkNoNull("formalParameterContainerType", config.getFormalParameterContainerType(), issues);
            this.checkNoNull("formalParameterSuperType", config.getFormalParameterSuperType(), issues);
        }
        if (this.subFragments == null) {
            issues.addError("Sub generators are not created");
        } else {
            for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
                subFragment.checkConfiguration(issues);
            }
        }
    }

    public void getExportedPackages(Set<String> exportedPackages) {
        if (exportedPackages != null) {
            exportedPackages.add(this.getCodeElementExtractor().getBasePackage());
            exportedPackages.add(this.getCodeElementExtractor().getBuilderPackage());
            if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
                exportedPackages.add(this.getCodeElementExtractor().getAppenderPackage());
            }
        }
    }

    public void generate() {
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generate();
        }
    }

    public void generateXtendStubs() {
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateXtendStubs();
        }
    }

    public void generateJavaStubs() {
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateJavaStubs();
        }
    }

    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateRuntimeBindings(factory);
        }
    }

    public void generateEclipseBindings(GuiceModuleAccess.BindingFactory factory) {
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateEclipseBindings(factory);
        }
    }

    public void generateIdeaBindings(GuiceModuleAccess.BindingFactory factory) {
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateIdeaBindings(factory);
        }
    }

    public void generateWebBindings(GuiceModuleAccess.BindingFactory factory) {
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateWebBindings(factory);
        }
    }

    @Pure
    protected CodeBuilderConfig getCodeBuilderConfig() {
        return this.configuration;
    }

    @Pure
    protected ExpressionConfig getExpressionConfig() {
        return this.configuration.getExpression();
    }

    @Pure
    protected FileAccessFactory getFileAccessFactory() {
        return this.fileAccessFactory;
    }

    @Pure
    protected IFileSystemAccess2 getSrcGen() {
        return this.getProjectConfig().getRuntime().getSrcGen();
    }

    @Pure
    protected IFileSystemAccess2 getSrc() {
        return this.getProjectConfig().getRuntime().getSrc();
    }

    @Pure
    protected String getLanguageName() {
        return Strings.toFirstUpper((String)GrammarUtil.getSimpleName((Grammar)this.getGrammar()).toLowerCase());
    }

    @Pure
    protected TypeReference getBuilderFactoryImpl() {
        return new TypeReference(this.getCodeElementExtractor().getBasePackage() + ".CodeBuilderFactory");
    }

    @Pure
    protected TypeReference getScriptBuilderInterface() {
        return this.getCodeElementExtractor().getElementBuilderInterface("Script");
    }

    @Pure
    protected TypeReference getExpressionBuilderInterface() {
        return this.getCodeElementExtractor().getElementBuilderInterface("Expression");
    }

    @Pure
    public TypeReference getExpressionBuilderImpl() {
        return this.getCodeElementExtractor().getElementBuilderImpl("Expression");
    }

    @Pure
    protected TypeReference getBlockExpressionBuilderInterface() {
        return this.getCodeElementExtractor().getElementBuilderInterface("BlockExpression");
    }

    @Pure
    protected TypeReference getFormalParameterBuilderInterface() {
        return this.getCodeElementExtractor().getElementBuilderInterface("FormalParameter");
    }

    @Pure
    protected TypeReference getTypeParameterBuilderInterface() {
        return this.getCodeElementExtractor().getElementBuilderInterface("TypeParameter");
    }

    @Pure
    protected TypeReference getPreDocumentationAdapter() {
        return new TypeReference(DocumentationAdapter.class);
    }

    @Pure
    protected TypeReference getAbstractBuilderImpl() {
        return new TypeReference(this.getCodeElementExtractor().getBuilderPackage() + ".AbstractBuilder");
    }

    @Pure
    protected String getLanguageScriptMemberGetter() {
        Grammar grammar = this.getGrammar();
        AbstractRule scriptRule = GrammarUtil.findRuleForName((Grammar)grammar, (String)this.getCodeBuilderConfig().getScriptRuleName());
        for (Assignment assignment : GrammarUtil.containedAssignments((EObject)scriptRule)) {
            RuleCall cvalue;
            AbstractElement abstractElement = assignment.getTerminal();
            if (!(abstractElement instanceof RuleCall) || !Objects.equals((cvalue = (RuleCall)abstractElement).getRule().getName(), this.getCodeBuilderConfig().getTopElementRuleName())) continue;
            return "get" + Strings.toFirstUpper((String)assignment.getFeature());
        }
        throw new IllegalStateException("member not found");
    }

    @Pure
    protected String getLanguageContainerMemberGetter() {
        return "get" + Strings.toFirstUpper((String)this.getCodeBuilderConfig().getMemberCollectionExtensionGrammarName());
    }

    @Pure
    protected TypeReference getXFactoryFor(TypeReference type) {
        Grammar grammar;
        String packageName = type.getPackageName();
        TypeReference reference = this.getXFactoryFor(packageName, grammar = this.getGrammar());
        if (reference != null) {
            return reference;
        }
        for (Grammar usedGrammar : GrammarUtil.allUsedGrammars((Grammar)grammar)) {
            reference = this.getXFactoryFor(packageName, usedGrammar);
            if (reference == null) continue;
            return reference;
        }
        throw new IllegalStateException("Cannot find the XFactory for " + String.valueOf(type));
    }

    @Pure
    protected TypeReference getXFactoryFor(Class<?> type) {
        return this.getXFactoryFor(new TypeReference(type));
    }

    private TypeReference getXFactoryFor(String packageName, Grammar grammar) {
        String languageName = GrammarUtil.getSimpleName((Grammar)grammar).toLowerCase();
        String basePackage = this.naming.getRuntimeBasePackage(grammar) + "." + languageName;
        if (basePackage.equals(packageName)) {
            return new TypeReference(basePackage + "." + Strings.toFirstUpper((String)languageName) + "Factory");
        }
        return null;
    }

    protected StringConcatenationClient generateAppenderMembers(final String appenderSimpleName, final TypeReference builderInterface, final String elementAccessor) {
        return new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"\tprivate final ");
                it.append((Object)builderInterface);
                it.append((Object)" builder;");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)appenderSimpleName);
                it.append((Object)"(");
                it.append((Object)builderInterface);
                it.append((Object)" builder) {");
                it.newLine();
                it.append((Object)"\t\tthis.builder = builder;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Fill the given receiver with the serialization of the element that is associated to this appender.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param appender the receiver of the source code.");
                it.newLine();
                it.append((Object)"\t * @throws IOException if there is error during the serialization.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic void build(");
                it.append(ISourceAppender.class);
                it.append((Object)" appender) throws ");
                it.append(IOException.class);
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\tbuild(this.builder.");
                it.append((Object)elementAccessor);
                it.append((Object)", appender);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
    }

    protected StringConcatenationClient generateCommentFunction(final boolean forInterface, final boolean forAppender, final String elementAccessor, final String functionName, final String comment, final TypeReference documentationAdapterType, final TypeReference builderType) {
        return new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"\t/** Change the documentation of the element.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * <p>");
                it.append((Object)comment);
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)builderType);
                it.append((Object)" ");
                it.append((Object)functionName);
                it.append((Object)"(String doc)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.setDocumentation(doc);");
                    } else {
                        it.append((Object)"\t\tif (");
                        it.append(Strings.class);
                        it.append((Object)".isEmpty(doc)) {");
                        it.newLine();
                        it.append((Object)"\t\t\t");
                        it.append((Object)elementAccessor);
                        it.append((Object)".eAdapters().removeIf(new ");
                        it.append(Predicate.class);
                        it.append((Object)"<");
                        it.append(Adapter.class);
                        it.append((Object)">() {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tpublic boolean test(");
                        it.append(Adapter.class);
                        it.append((Object)" adapter) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\treturn adapter.isAdapterForType(");
                        it.append((Object)documentationAdapterType);
                        it.append((Object)".class);");
                        it.newLine();
                        it.append((Object)"\t\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t\t});");
                        it.newLine();
                        it.append((Object)"\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\t");
                        it.append((Object)documentationAdapterType);
                        it.append((Object)" adapter = (");
                        it.append((Object)documentationAdapterType);
                        it.append((Object)") ");
                        it.append(EcoreUtil.class);
                        it.append((Object)".getExistingAdapter(");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\t");
                        it.append((Object)elementAccessor);
                        it.append((Object)", ");
                        it.append((Object)documentationAdapterType);
                        it.append((Object)".class);");
                        it.newLine();
                        it.append((Object)"\t\t\tif (adapter == null) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tadapter = new ");
                        it.append((Object)documentationAdapterType);
                        it.append((Object)"();");
                        it.newLine();
                        it.append((Object)"\t\t\t\t");
                        it.append((Object)elementAccessor);
                        it.append((Object)".eAdapters().add(adapter);");
                        it.newLine();
                        it.append((Object)"\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t\tadapter.setDocumentation(doc);");
                        it.newLine();
                        it.append((Object)"\t\t}");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
    }

    protected StringConcatenationClient generateStandardCommentFunctions(final boolean forInterface, final boolean forAppender, final String elementAccessor, final TypeReference builderType) {
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)AbstractSubCodeBuilderFragment.this.generateCommentFunction(forInterface, forAppender, elementAccessor, "setDocumentation", "The documentation will be displayed just before the element.", AbstractSubCodeBuilderFragment.this.getPreDocumentationAdapter(), builderType));
            }
        };
    }

    @Deprecated(since="0.10", forRemoval=true)
    protected TypeReference newTypeReference(EClassifier classifier) {
        return this.getCodeElementExtractor().newTypeReference(classifier);
    }

    protected static String getAorAnArticle(String word) {
        if (Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u'), Character.valueOf('y')).contains(Character.valueOf(Character.toLowerCase(word.charAt(0))))) {
            return "an";
        }
        return "a";
    }

    protected static String toSingular(String word) {
        if (word.endsWith("ies")) {
            return word.substring(0, word.length() - 3) + "y";
        }
        if (word.endsWith("s")) {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }

    protected static boolean nameMatches(EObject element, String pattern) {
        if (element instanceof RuleCall) {
            RuleCall cvalue = (RuleCall)element;
            return AbstractSubCodeBuilderFragment.nameMatches((EObject)cvalue.getRule(), pattern);
        }
        if (element instanceof AbstractRule) {
            AbstractRule cvalue = (AbstractRule)element;
            String name = cvalue.getName();
            Pattern compilerPattern = Pattern.compile(pattern);
            Matcher matcher = compilerPattern.matcher(name);
            if (matcher.find()) {
                return true;
            }
        }
        return false;
    }

    protected static Assignment findAssignmentFromFeatureName(EObject rule, String name) {
        return (Assignment)IterableExtensions.findFirst((Iterable)GrammarUtil.containedAssignments((EObject)rule), assignment -> name.equals(assignment.getFeature()));
    }

    protected static Assignment findAssignmentFromTerminalPattern(EObject rule, String pattern) {
        return (Assignment)IterableExtensions.findFirst((Iterable)GrammarUtil.containedAssignments((EObject)rule), assignment -> AbstractSubCodeBuilderFragment.nameMatches((EObject)assignment.getTerminal(), pattern));
    }

    protected void bindElementDescription(GuiceModuleAccess.BindingFactory factory, CodeElementExtractor.ElementDescription ... descriptions) {
        for (CodeElementExtractor.ElementDescription description : descriptions) {
            this.bindTypeReferences(factory, description.builderInterfaceType(), description.builderImplementationType(), description.builderCustomImplementationType());
        }
    }

    protected void bindTypeReferences(GuiceModuleAccess.BindingFactory factory, TypeReference interfaceType, TypeReference implementationType, TypeReference customImplementationType) {
        IFileSystemAccess2 fileSystem = this.getSrc();
        TypeReference type = fileSystem.isFile(implementationType.getJavaPath()) || fileSystem.isFile(customImplementationType.getXtendPath()) ? customImplementationType : implementationType;
        factory.addfinalTypeToType(interfaceType, type);
    }

    protected AbstractRule getMemberRule(CodeElementExtractor.ElementDescription description) {
        for (Assignment assignment : GrammarUtil.containedAssignments((EObject)description.grammarComponent())) {
            AbstractElement abstractElement;
            if (!Objects.equals(this.getCodeBuilderConfig().getMemberCollectionExtensionGrammarName(), assignment.getFeature()) || !((abstractElement = assignment.getTerminal()) instanceof RuleCall)) continue;
            RuleCall cvalue = (RuleCall)abstractElement;
            return cvalue.getRule();
        }
        return null;
    }

    protected static String getFileAndLineNumber(int shift) {
        StackTraceElement trace = Thread.currentThread().getStackTrace()[2 + shift];
        return trace.getFileName() + " : " + trace.getMethodName() + " : " + trace.getLineNumber();
    }
}

