/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BuilderFactoryContributions;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.tasks.ITaskTagProvider;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class BlockExpressionBuilderFragment
extends AbstractSubCodeBuilderFragment {
    @Inject
    private BuilderFactoryContributions builderFactoryContributions;

    @Pure
    public TypeReference getBlockExpressionBuilderImpl() {
        return this.getCodeElementExtractor().getElementBuilderImpl("BlockExpression");
    }

    @Pure
    public TypeReference getBlockExpressionBuilderImplCustom() {
        return this.getCodeElementExtractor().getElementBuilderImplCustom("BlockExpression");
    }

    @Override
    public void generate() {
        this.generateIBlockExpressionBuilder();
        this.generateBlockExpressionBuilderImpl();
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            this.generateBlockExpressionAppender();
        }
        this.generateBuilderFactoryContributions();
        super.generate();
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        this.bindTypeReferences(factory, this.getBlockExpressionBuilderInterface(), this.getBlockExpressionBuilderImpl(), this.getBlockExpressionBuilderImplCustom());
    }

    protected void generateIBlockExpressionBuilder() {
        final TypeReference builder = this.getBlockExpressionBuilderInterface();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + BlockExpressionBuilderFragment.this.getLanguageName() + " XBlockExpression."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public interface ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)BlockExpressionBuilderFragment.this.generateMembers(true, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateBlockExpressionBuilderImpl() {
        final TypeReference builderInterface = this.getBlockExpressionBuilderInterface();
        final TypeReference builder = this.getBlockExpressionBuilderImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + BlockExpressionBuilderFragment.this.getLanguageName() + " XBlockExpression."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)BlockExpressionBuilderFragment.this.getAbstractBuilderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)BlockExpressionBuilderFragment.this.generateMembers(false, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateBlockExpressionAppender() {
        final TypeReference builderInterface = this.getBlockExpressionBuilderInterface();
        final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl("BlockExpression");
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Appender of a " + BlockExpressionBuilderFragment.this.getLanguageName() + " XBlockExpression."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)appender.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)BlockExpressionBuilderFragment.this.getCodeElementExtractor().getAbstractAppenderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)BlockExpressionBuilderFragment.this.generateAppenderMembers(appender.getSimpleName(), builderInterface, "getXBlockExpression()"));
                it.append((Object)BlockExpressionBuilderFragment.this.generateMembers(false, true));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(appender, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected StringConcatenationClient generateMembers(final boolean forInterface, final boolean forAppender) {
        final TypeReference adapter = this.getCodeElementExtractor().getInnerBlockDocumentationAdapter();
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                if (!forInterface && !forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(BlockExpressionBuilderFragment.this.getInjectType());
                    it.newLine();
                    it.append((Object)"\tprivate ");
                    it.append(ITaskTagProvider.class);
                    it.append((Object)" taskTagProvider;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(BlockExpressionBuilderFragment.this.getInjectType());
                    it.newLine();
                    it.append((Object)"\tprivate ");
                    it.append(Provider.class);
                    it.append((Object)"<");
                    it.append((Object)BlockExpressionBuilderFragment.this.getExpressionBuilderInterface());
                    it.append((Object)"> expressionProvider;");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append(XBlockExpression.class);
                    it.append((Object)" block;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Replies the provider of task tags.");
                    it.newLine();
                    it.append((Object)"\t *");
                    it.newLine();
                    it.append((Object)"\t * @return the provider.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tprotected ");
                    it.append(ITaskTagProvider.class);
                    it.append((Object)" getTaskTagProvider() {");
                    it.newLine();
                    it.append((Object)"\t\treturn this.taskTagProvider;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else {
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for the type reference use");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(JvmType.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param context the contet in which the type is defined");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, ");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext() {");
                    it.newLine();
                    it.append((Object)"\t\treturn this.builder.getTypeResolutionContext();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Create the XBlockExpression.");
                it.newLine();
                it.append((Object)"\t * @param context the context for type resolution.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void eInit(");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" context)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.eInit(context);");
                    } else {
                        it.append((Object)"\t\tsetTypeResolutionContext(context);");
                        it.newLine();
                        it.append((Object)"\t\tif (this.block == null) {");
                        it.newLine();
                        it.append((Object)"\t\t\tthis.block = ");
                        it.append(XbaseFactory.class);
                        it.append((Object)".eINSTANCE.createXBlockExpression();");
                        it.newLine();
                        it.append((Object)"\t\t}");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the string for \"auto-generated\" comments.");
                it.newLine();
                it.append((Object)"\t * @return the comment text.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"String getAutoGeneratedActionString()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getAutoGeneratedActionString();");
                    } else {
                        it.append((Object)"\t\treturn getAutoGeneratedActionString(getXBlockExpression().eResource());");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the string for \"auto-generated\" comments.");
                it.newLine();
                it.append((Object)"\t * @param resource the resource for which the comment must be determined.");
                it.newLine();
                it.append((Object)"\t * @return the comment text.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"String getAutoGeneratedActionString(");
                it.append(Resource.class);
                it.append((Object)" resource)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getAutoGeneratedActionString(resource);");
                    } else {
                        it.append((Object)"\t\t");
                        it.append(TaskTags.class);
                        it.append((Object)" tags = getTaskTagProvider().getTaskTags(resource);");
                        it.newLine();
                        it.append((Object)"\t\tString taskTag;");
                        it.newLine();
                        it.append((Object)"\t\tif (tags != null && tags.getTaskTags() != null && !tags.getTaskTags().isEmpty()) {");
                        it.newLine();
                        it.append((Object)"\t\t\ttaskTag = tags.getTaskTags().get(0).getName();");
                        it.newLine();
                        it.append((Object)"\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\ttaskTag = \"TODO\";");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\treturn taskTag + \" ");
                        it.append((Object)Strings.convertToJavaString((String)BlockExpressionBuilderFragment.this.getCodeBuilderConfig().getAutoGeneratedComment()));
                        it.append((Object)"\";");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** An empty block expression.");
                it.newLine();
                it.append((Object)"\t * @return the block expression.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(XBlockExpression.class);
                it.append((Object)" getXBlockExpression()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getXBlockExpression();");
                    } else {
                        it.append((Object)"\t\treturn this.block;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the resource to which the XBlockExpression is attached.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(Resource.class);
                it.append((Object)" eResource()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\treturn getXBlockExpression().eResource();");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)BlockExpressionBuilderFragment.this.generateCommentFunction(forInterface, false, "getXBlockExpression()", "setInnerDocumentation", "getXBlockExpression()", adapter, BlockExpressionBuilderFragment.this.getBlockExpressionBuilderInterface()));
                it.append((Object)"\t/** Add an expression inside the block.");
                it.newLine();
                it.append((Object)"\t * @return the expression builder.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)BlockExpressionBuilderFragment.this.getExpressionBuilderInterface());
                it.append((Object)" addExpression()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.addExpression();");
                    } else {
                        it.append((Object)"\t\tfinal ");
                        it.append((Object)BlockExpressionBuilderFragment.this.getExpressionBuilderInterface());
                        it.append((Object)" builder = this.expressionProvider.get();");
                        it.newLine();
                        it.append((Object)"\t\tbuilder.eInit(getXBlockExpression(), new ");
                        it.append(Procedures.class);
                        it.append((Object)".Procedure1<");
                        it.append(XExpression.class);
                        it.append((Object)">() {");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\tprivate int index = -1;");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\tpublic void apply(");
                        it.append(XExpression.class);
                        it.append((Object)" it) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\t\tif (this.index >= 0) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\t\t\tgetXBlockExpression().getExpressions().set(index, it);");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\t\t\tgetXBlockExpression().getExpressions().add(it);");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\t\t\tthis.index = getXBlockExpression().getExpressions().size() - 1;");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t\t\t}, getTypeResolutionContext());");
                        it.newLine();
                        it.append((Object)"\t\treturn builder;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Fill the block with the standard \"auto-generated\" content.");
                it.newLine();
                it.append((Object)"\t * <p>Any previously added content is removed.");
                it.newLine();
                it.append((Object)"\t * @param type the expected type of the block (the last instruction), or");
                it.newLine();
                it.append((Object)"\t    {@code null} for no type.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)BlockExpressionBuilderFragment.this.getBlockExpressionBuilderInterface());
                it.append((Object)" setDefaultAutoGeneratedContent(String type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.setDefaultAutoGeneratedContent(type);");
                    } else {
                        it.append((Object)"\t\tgetXBlockExpression().getExpressions().clear();");
                        it.newLine();
                        it.append((Object)"\t\tif (");
                        it.append(Strings.class);
                        it.append((Object)".isEmpty(type)) {");
                        it.newLine();
                        it.append((Object)"\t\t\tsetInnerDocumentation(getAutoGeneratedActionString());");
                        it.newLine();
                        it.append((Object)"\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\t");
                        it.append((Object)BlockExpressionBuilderFragment.this.getExpressionBuilderInterface());
                        it.append((Object)" expr = addExpression();");
                        it.newLine();
                        it.append((Object)"\t\t\tString defaultValue = expr.getDefaultValueForType(type);");
                        it.newLine();
                        it.append((Object)"\t\t\tif (");
                        it.append(Strings.class);
                        it.append((Object)".isEmpty(defaultValue)) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tsetInnerDocumentation(getAutoGeneratedActionString());");
                        it.newLine();
                        it.append((Object)"\t\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\t\texpr.setExpression(defaultValue);");
                        it.newLine();
                        it.append((Object)"\t\t\t\texpr.setDocumentation(getAutoGeneratedActionString());");
                        it.newLine();
                        it.append((Object)"\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t}");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Fill the block with the standard \"auto-generated\" content.");
                it.newLine();
                it.append((Object)"\t * <p>Any previously added content is removed.");
                it.newLine();
                it.append((Object)"\t * @param type the expected type of the block (the last instruction), or");
                it.newLine();
                it.append((Object)"\t    {@code null} for no type.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)BlockExpressionBuilderFragment.this.getBlockExpressionBuilderInterface());
                it.append((Object)" setDefaultAutoGeneratedContent(");
                it.append(JvmTypeReference.class);
                it.append((Object)" type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.setDefaultAutoGeneratedContent(type);");
                    } else {
                        it.append((Object)"\t\tgetXBlockExpression().getExpressions().clear();");
                        it.newLine();
                        it.append((Object)"\t\tif (type == null || type.eIsProxy()) {");
                        it.newLine();
                        it.append((Object)"\t\t\tsetInnerDocumentation(getAutoGeneratedActionString());");
                        it.newLine();
                        it.append((Object)"\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\t");
                        it.append((Object)BlockExpressionBuilderFragment.this.getExpressionBuilderInterface());
                        it.append((Object)" expr = addExpression();");
                        it.newLine();
                        it.append((Object)"\t\t\tString defaultValue = expr.getDefaultValueForType(type);");
                        it.newLine();
                        it.append((Object)"\t\t\tif (");
                        it.append(Strings.class);
                        it.append((Object)".isEmpty(defaultValue)) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tsetInnerDocumentation(getAutoGeneratedActionString());");
                        it.newLine();
                        it.append((Object)"\t\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\t\texpr.setExpression(defaultValue);");
                        it.newLine();
                        it.append((Object)"\t\t\t\texpr.setDocumentation(getAutoGeneratedActionString());");
                        it.newLine();
                        it.append((Object)"\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t}");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Fill the block with the standard \"auto-generated\" content assuming that there is no value to return.");
                it.newLine();
                it.append((Object)"\t * <p>Any previously added content is removed.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)BlockExpressionBuilderFragment.this.getBlockExpressionBuilderInterface());
                it.append((Object)" setDefaultAutoGeneratedContent()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.setDefaultAutoGeneratedContent();");
                    } else {
                        it.append((Object)"\t\tsetDefaultAutoGeneratedContent((");
                        it.append(JvmTypeReference.class);
                        it.append((Object)") null);");
                        it.newLine();
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (!forInterface) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Override.class);
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(String.class);
                    it.append((Object)" toString() {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    if (forAppender) {
                        it.append((Object)"this.builder.toString();");
                    } else {
                        it.append(EmfFormatter.class);
                        it.append((Object)".objToStr(getXBlockExpression());");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tvoid dispose();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic void dispose() {");
                    it.newLine();
                    it.append((Object)"\t\tthis.builder.dispose();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            }
        };
    }

    protected void generateBuilderFactoryContributions() {
        final BlockExpressionContextDescription blockContext = this.getBlockExpressionContextDescription();
        String createFunctionName = "createXBlockExpression";
        this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("\t/** Create the factory for a " + BlockExpressionBuilderFragment.this.getLanguageName() + " block expression."));
                it.newLine();
                it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                it.newLine();
                it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)BlockExpressionBuilderFragment.this.getBlockExpressionBuilderInterface());
                it.append((Object)" ");
                it.append((Object)"createXBlockExpression");
                it.append((Object)"(");
                it.append(ResourceSet.class);
                it.append((Object)" resourceSet) {");
                it.newLine();
                it.append((Object)"\t\treturn ");
                it.append((Object)"createXBlockExpression");
                it.append((Object)"(createResource(resourceSet));");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)("\t/** Create the factory for a " + BlockExpressionBuilderFragment.this.getLanguageName() + " block expression."));
                it.newLine();
                it.append((Object)"\t * @param resource the resource that must be used for");
                it.newLine();
                it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)BlockExpressionBuilderFragment.this.getBlockExpressionBuilderInterface());
                it.append((Object)" ");
                it.append((Object)"createXBlockExpression");
                it.append((Object)"(");
                it.append(Resource.class);
                it.append((Object)" resource) {");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append((Object)BlockExpressionBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" script = createScript(getFooPackageName(), resource);");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append((Object)blockContext.getContainerDescription().builderInterfaceType());
                it.append((Object)" topElement = script.add");
                it.append((Object)Strings.toFirstUpper((String)blockContext.getContainerDescription().elementType().getSimpleName()));
                it.append((Object)"(getFooTypeName());");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append((Object)blockContext.getMemberDescription().builderInterfaceType());
                it.append((Object)" memberElement = topElement.add");
                it.append((Object)Strings.toFirstUpper((String)blockContext.getMemberDescription().elementType().getSimpleName()));
                it.append((Object)"(getFooMemberName());");
                it.newLine();
                it.append((Object)"\t\treturn memberElement.get");
                it.append((Object)Strings.toFirstUpper((String)blockContext.getExpressionAssignment().getFeature()));
                it.append((Object)"();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        });
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            String buildFunctionName = "buildXBlockExpression";
            final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl("BlockExpression");
            this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create the appender for a " + BlockExpressionBuilderFragment.this.getLanguageName() + " block expression."));
                    it.newLine();
                    it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)"buildXBlockExpression");
                    it.append((Object)"(");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet) {");
                    it.newLine();
                    it.append((Object)"\t\treturn new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)"createXBlockExpression");
                    it.append((Object)"(resourceSet));");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the appender for a " + BlockExpressionBuilderFragment.this.getLanguageName() + " block expression."));
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)"buildXBlockExpression");
                    it.append((Object)"(");
                    it.append(Resource.class);
                    it.append((Object)" resource) {");
                    it.newLine();
                    it.append((Object)"\t\treturn new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)"createXBlockExpression");
                    it.append((Object)"(resource));");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
    }

    protected String ensureContainerKeyword(EObject grammarContainer) {
        UnmodifiableIterator iterator = Iterators.filter((Iterator)grammarContainer.eContents().iterator(), Keyword.class);
        if (iterator.hasNext()) {
            return ((Keyword)iterator.next()).getValue();
        }
        return this.getExpressionConfig().getBlockMemberContainerDeclarationKeyword();
    }

    protected String ensureMemberDeclarationKeyword(CodeElementExtractor.ElementDescription memberDescription) {
        List<String> modifiers = this.getCodeBuilderConfig().getModifiers().get(memberDescription.name());
        if (modifiers != null && !modifiers.isEmpty()) {
            return modifiers.get(0);
        }
        return null;
    }

    protected BlockExpressionContextDescription getBlockExpressionContextDescription() {
        for (CodeElementExtractor.ElementDescription containerDescription : this.getCodeElementExtractor().getTopElements(this.getGrammar(), this.getCodeBuilderConfig())) {
            BlockExpressionContextDescription description;
            AbstractRule rule;
            if (this.getCodeBuilderConfig().getNoActionBodyTypes().contains(containerDescription.name()) || (rule = this.getMemberRule(containerDescription)) == null || (description = (BlockExpressionContextDescription)this.getCodeElementExtractor().visitMemberElements(containerDescription, (EObject)rule, null, (it, grammarContainer, memberContainer, classifier) -> {
                Assignment expressionAssignment = BlockExpressionBuilderFragment.findAssignmentFromTerminalPattern(memberContainer, this.getExpressionConfig().getBlockExpressionGrammarPattern());
                CodeElementExtractor.ElementDescription memberDescription = it.newElementDescription(classifier.getName(), (EObject)memberContainer, (EClassifier)classifier, XExpression.class);
                String keyword = this.ensureMemberDeclarationKeyword(memberDescription);
                if (expressionAssignment != null && keyword != null) {
                    return new BlockExpressionContextDescription(containerDescription, memberDescription, this.ensureContainerKeyword(containerDescription.grammarComponent()), keyword, expressionAssignment);
                }
                return null;
            }, null, null)) == null) continue;
            return description;
        }
        return null;
    }

    public static class BlockExpressionContextDescription {
        private final CodeElementExtractor.ElementDescription member;
        private final CodeElementExtractor.ElementDescription container;
        private final String containerKeyword;
        private final String fieldDeclarationKeyword;
        private final Assignment expressionAssignment;

        public BlockExpressionContextDescription(CodeElementExtractor.ElementDescription container, CodeElementExtractor.ElementDescription member, String containerKeyword, String fieldDeclarationKeyword, Assignment expressionAssignment) {
            this.container = container;
            this.member = member;
            this.containerKeyword = containerKeyword;
            this.fieldDeclarationKeyword = fieldDeclarationKeyword;
            this.expressionAssignment = expressionAssignment;
        }

        public CodeElementExtractor.ElementDescription getContainerDescription() {
            return this.container;
        }

        public CodeElementExtractor.ElementDescription getMemberDescription() {
            return this.member;
        }

        public Assignment getExpressionAssignment() {
            return this.expressionAssignment;
        }

        public String getContainerKeyword() {
            return this.containerKeyword;
        }

        public String getFieldDeclarationKeyword() {
            return this.fieldDeclarationKeyword;
        }
    }
}

