/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BuilderFactoryContributions;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.Constants;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.util.Modules2;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.XtendFileAccess;

public class BuilderFactoryFragment
extends AbstractSubCodeBuilderFragment {
    @Inject
    private BuilderFactoryContributions contributions;

    @Pure
    public TypeReference getBuilderFactoryImplCustom() {
        String runtimeBasePackage = this.getCodeElementExtractor().getBasePackage();
        return new TypeReference(runtimeBasePackage + ".CodeBuilderFactoryCustom");
    }

    protected BuilderFactoryContributions getContributions() {
        return this.contributions;
    }

    @Override
    public void generate() {
        super.generate();
        final TypeReference factory = this.getBuilderFactoryImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"/** Creates {@code ICodeBuilder} to insert SARL code snippets.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)factory.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static final String[] FORBIDDEN_INJECTION_PREFIXES = new String[] {");
                it.newLine();
                for (String forbiddenPackage : BuilderFactoryFragment.this.getCodeBuilderConfig().getForbiddenInjectionPrefixes()) {
                    it.append((Object)"\t\t\"");
                    it.append((Object)Strings.convertToJavaString((String)forbiddenPackage));
                    if (!forbiddenPackage.endsWith(".")) {
                        it.append((Object)".");
                    }
                    it.append((Object)"\",");
                    it.newLine();
                }
                it.append((Object)"\t};");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static final String[] FORBIDDEN_INJECTION_POSTFIXES = new String[] {");
                it.newLine();
                for (String forbiddenPostfix : BuilderFactoryFragment.this.getCodeBuilderConfig().getForbiddenInjectionPostfixes()) {
                    it.append((Object)"\t\t\"");
                    if (!forbiddenPostfix.startsWith(".")) {
                        it.append((Object)".");
                    }
                    it.append((Object)Strings.convertToJavaString((String)forbiddenPostfix));
                    it.append((Object)"\",");
                    it.newLine();
                }
                it.append((Object)"\t};");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(BuilderFactoryFragment.this.getInjectType());
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(IResourceFactory.class);
                it.append((Object)" resourceFactory;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String fileExtension;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(BuilderFactoryFragment.this.getInjectType());
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(Provider.class);
                it.append((Object)"<");
                it.append(ImportManager.class);
                it.append((Object)"> importManagerProvider;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(BuilderFactoryFragment.this.getInjectType());
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(Injector.class);
                it.append((Object)" originalInjector;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append(Injector.class);
                it.append((Object)" builderInjector;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(BuilderFactoryFragment.this.getInjectType());
                it.newLine();
                it.append((Object)"\tpublic void setFileExtensions(@");
                it.append(Named.class);
                it.append((Object)"(");
                it.append(Constants.class);
                it.append((Object)".FILE_EXTENSIONS) String fileExtensions) {");
                it.newLine();
                it.append((Object)"\t\tthis.fileExtension = ");
                it.append(SarlUtils.class);
                it.append((Object)".getMajorFileExtension(fileExtensions);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Compute a unused URI for a synthetic resource.");
                it.newLine();
                it.append((Object)"\t * @param resourceSet the resource set in which the resource should be located.");
                it.newLine();
                it.append((Object)"\t * @return the uri.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(URI.class);
                it.append((Object)" computeUnusedUri(");
                it.append(ResourceSet.class);
                it.append((Object)" resourceSet) {");
                it.newLine();
                it.append((Object)"\t\tString name = \"__synthetic\";");
                it.newLine();
                it.append((Object)"\t\tfor (int i = 0; i < Integer.MAX_VALUE; ++i) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(URI.class);
                it.append((Object)" syntheticUri = ");
                it.append(URI.class);
                it.append((Object)".createURI(name + i + \".\" + getScriptFileExtension());");
                it.newLine();
                it.append((Object)"\t\t\tif (resourceSet.getResource(syntheticUri, false) == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\treturn syntheticUri;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tthrow new IllegalStateException();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the script's file extension.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String getScriptFileExtension() {");
                it.newLine();
                it.append((Object)"\t\treturn this.fileExtension;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the resource factory.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the resource factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(IResourceFactory.class);
                it.append((Object)" getResourceFactory() {");
                it.newLine();
                it.append((Object)"\t\treturn this.resourceFactory;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the name of the foo package.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the name of the foo package.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected String getFooPackageName() {");
                it.newLine();
                it.append((Object)"\t\treturn \"");
                it.append((Object)Strings.convertToJavaString((String)GrammarUtil.getNamespace((Grammar)BuilderFactoryFragment.this.getGrammar())));
                it.append((Object)".foo\";");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the name of the foo type.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the name of the foo type.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected String getFooTypeName() {");
                it.newLine();
                it.append((Object)"\t\treturn \"FooType\";");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the name of the foo type member.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the name of the foo type member.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected String getFooMemberName() {");
                it.newLine();
                it.append((Object)"\t\treturn \"fooMember\";");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Create a synthetic resource.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param resourceSet the resourceSet.");
                it.newLine();
                it.append((Object)"\t * @return the resource.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(Resource.class);
                it.append((Object)" createResource(");
                it.append(ResourceSet.class);
                it.append((Object)"  resourceSet) {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(URI.class);
                it.append((Object)" uri = computeUnusedUri(resourceSet);");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(Resource.class);
                it.append((Object)" resource = getResourceFactory().createResource(uri);");
                it.newLine();
                it.append((Object)"\t\tresourceSet.getResources().add(resource);");
                it.newLine();
                it.append((Object)"\t\treturn resource;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the injector.");
                it.newLine();
                it.append((Object)"\t * @return the injector.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(Injector.class);
                it.append((Object)" getInjector() {");
                it.newLine();
                it.append((Object)"\t\tif (this.builderInjector == null) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(ImportManager.class);
                it.append((Object)" importManager = this.importManagerProvider.get();");
                it.newLine();
                it.append((Object)"\t\t\tthis.builderInjector = createOverridingInjector(this.originalInjector, new CodeBuilderModule(importManager));");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn builderInjector;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Create an injector that override the given injectors with the modules.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param originalInjector the original injector.");
                it.newLine();
                it.append((Object)"\t * @param module the overriding module.");
                it.newLine();
                it.append((Object)"\t * @return the new injector.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic static ");
                it.append(Injector.class);
                it.append((Object)" createOverridingInjector(");
                it.append(Injector.class);
                it.append((Object)" originalInjector, ");
                it.append(Module.class);
                it.append((Object)" module) {");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(Map.class);
                it.append((Object)"<");
                it.append(Key.class);
                it.append((Object)"<?>, ");
                it.append(Binding.class);
                it.append((Object)"<?>> bindings = originalInjector.getBindings();");
                it.newLine();
                it.append((Object)"\t\treturn ");
                it.append(Guice.class);
                it.append((Object)".createInjector(");
                it.append(Modules2.class);
                it.append((Object)".mixin((binder) -> {");
                it.newLine();
                it.append((Object)"\t\t\tfor(");
                it.append(Binding.class);
                it.append((Object)"<?> binding: bindings.values()) {");
                it.newLine();
                it.append((Object)"\t\t\t\tfinal ");
                it.append(Type.class);
                it.append((Object)" typeLiteral = binding.getKey().getTypeLiteral().getType();");
                it.newLine();
                it.append((Object)"\t\t\t\tif (typeLiteral != null) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tfinal String typeName = typeLiteral.getTypeName();");
                it.newLine();
                it.append((Object)"\t\t\t\t\tif (isValid(typeName)) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\tbinding.applyTo(binder);");
                it.newLine();
                it.append((Object)"\t\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}, module));");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static boolean isValid(String name) {");
                it.newLine();
                it.append((Object)"\t\tfor (final String prefix : FORBIDDEN_INJECTION_PREFIXES) {");
                it.newLine();
                it.append((Object)"\t\t\tif (name.startsWith(prefix)) {");
                it.newLine();
                it.append((Object)"\t\t\t\treturn false;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tfor (final String postfix : FORBIDDEN_INJECTION_POSTFIXES) {");
                it.newLine();
                it.append((Object)"\t\t\tif (name.endsWith(postfix)) {");
                it.newLine();
                it.append((Object)"\t\t\t\treturn false;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn true;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies a provider for the given type.");
                it.newLine();
                it.append((Object)"\t * <p>The provider uses a local context singleton of the import manager.");
                it.newLine();
                it.append((Object)"\t * @param type the type of the object to provide.");
                it.newLine();
                it.append((Object)"\t * @return the provider.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected <T> ");
                it.append(Provider.class);
                it.append((Object)"<T> getProvider(Class<T> type) {");
                it.newLine();
                it.append((Object)"\t\treturn getInjector().getProvider(type);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static class CodeBuilderModule extends ");
                it.append(AbstractModule.class);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final ");
                it.append(ImportManager.class);
                it.append((Object)" importManager;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic CodeBuilderModule(");
                it.append(ImportManager.class);
                it.append((Object)" importManager) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.importManager = importManager;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\t@Override");
                it.newLine();
                it.append((Object)"\t\tprotected void configure() {");
                it.newLine();
                it.append((Object)"\t\t\tbind(");
                it.append(ImportManager.class);
                it.append((Object)".class).toInstance(this.importManager);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                for (StringConcatenationClient client : BuilderFactoryFragment.this.generateMembers()) {
                    it.append((Object)client);
                }
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess createJavaFile = this.getFileAccessFactory().createJavaFile(factory, content);
        createJavaFile.writeTo(this.getSrcGen());
    }

    protected Iterable<StringConcatenationClient> generateMembers() {
        return this.getContributions().getContributions();
    }

    @Override
    public void generateXtendStubs() {
        super.generateXtendStubs();
        final TypeReference stub = this.getBuilderFactoryImplCustom();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** User-defined builder factory of the " + BuilderFactoryFragment.this.getLanguageName() + " scripts."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"class ");
                it.append((Object)stub);
                it.append((Object)" extends ");
                it.append((Object)BuilderFactoryFragment.this.getBuilderFactoryImpl());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLine();
            }
        };
        XtendFileAccess xtendFile = this.getFileAccessFactory().createXtendFile(stub, content);
        IFileSystemAccess2 fileSystem = this.getSrc();
        if (!fileSystem.isFile(xtendFile.getPath())) {
            xtendFile.writeTo(fileSystem);
        }
    }

    @Override
    public void generateJavaStubs() {
        super.generateJavaStubs();
        final TypeReference stub = this.getBuilderFactoryImplCustom();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** User-defined builder factory of the " + BuilderFactoryFragment.this.getLanguageName() + " scripts."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)stub);
                it.append((Object)" extends ");
                it.append((Object)BuilderFactoryFragment.this.getBuilderFactoryImpl());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(stub, content);
        IFileSystemAccess2 fileSystem = this.getSrc();
        if (!fileSystem.isFile(javaFile.getPath())) {
            javaFile.writeTo(fileSystem);
        }
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        IFileSystemAccess2 fileSystem = this.getSrc();
        TypeReference type = fileSystem.isFile(this.getBuilderFactoryImplCustom().getJavaPath()) || fileSystem.isFile(this.getBuilderFactoryImplCustom().getXtendPath()) ? this.getBuilderFactoryImplCustom() : this.getBuilderFactoryImpl();
        factory.addfinalTypeToType(this.getBuilderFactoryImpl(), type);
    }
}

