/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractMemberBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BuilderFactoryContributions;
import java.util.Collections;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class ConstructorBuilderFragment
extends AbstractMemberBuilderFragment {
    @Inject
    private BuilderFactoryContributions builderFactoryContributions;
    private AbstractMemberBuilderFragment.MemberDescription constructor;

    @Override
    protected Iterable<AbstractMemberBuilderFragment.MemberDescription> getMembers() {
        if (this.constructor == null) {
            for (CodeElementExtractor.ElementDescription containerDescription : this.getCodeElementExtractor().getTopElements(this.getGrammar(), this.getCodeBuilderConfig())) {
                AbstractRule rule = this.getMemberRule(containerDescription);
                if (rule == null) continue;
                EClassifier commonSuperType = this.getCodeElementExtractor().getGeneratedTypeFor(rule);
                this.constructor = (AbstractMemberBuilderFragment.MemberDescription)this.getCodeElementExtractor().visitMemberElements(containerDescription, (EObject)rule, (it, grammarContainer, memberContainer, classifier) -> {
                    CodeElementExtractor.ElementDescription memberDescription = it.newElementDescription(classifier.getName(), (EObject)memberContainer, (EClassifier)classifier, commonSuperType);
                    return new AbstractMemberBuilderFragment.MemberDescription(memberDescription, containerDescription, false, memberDescription.annotationInfo(), null);
                }, null, null, null);
                if (this.constructor == null) continue;
                break;
            }
            if (this.constructor == null) {
                throw new IllegalStateException("No grammar elements for a constructor");
            }
        }
        return Collections.singletonList(this.constructor);
    }

    @Override
    public void generate() {
        super.generate();
        this.generateBuilderFactoryContributions();
    }

    protected void generateBuilderFactoryContributions() {
        final String createFunctionName = "create" + Strings.toFirstUpper((String)this.constructor.getElementDescription().name());
        final String createContainerFunctionName = "add" + Strings.toFirstUpper((String)this.constructor.getContainerDescription().name());
        final TypeReference containerBuilder = this.constructor.getContainerDescription().builderInterfaceType();
        this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("\t/** Create the factory for a " + ConstructorBuilderFragment.this.getLanguageName() + " constructor."));
                it.newLine();
                it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                it.newLine();
                it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)ConstructorBuilderFragment.this.constructor.getElementDescription().builderInterfaceType());
                it.append((Object)" ");
                it.append((Object)createFunctionName);
                it.append((Object)"(");
                it.append(ResourceSet.class);
                it.append((Object)" resourceSet) {");
                it.newLine();
                it.append((Object)"\t\treturn ");
                it.append((Object)createFunctionName);
                it.append((Object)"(createResource(resourceSet));");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)("\t/** Create the factory for a " + ConstructorBuilderFragment.this.getLanguageName() + " constructor."));
                it.newLine();
                it.append((Object)"\t * @param resource the resource that must be used for");
                it.newLine();
                it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)ConstructorBuilderFragment.this.constructor.getElementDescription().builderInterfaceType());
                it.append((Object)" ");
                it.append((Object)createFunctionName);
                it.append((Object)"(");
                it.append(Resource.class);
                it.append((Object)" resource) {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append((Object)ConstructorBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" scriptBuilder = createScript(getFooPackageName(), resource);");
                it.newLine();
                it.append((Object)"\t\t");
                it.append((Object)containerBuilder);
                it.append((Object)" containerBuilder = scriptBuilder.");
                it.append((Object)createContainerFunctionName);
                it.append((Object)"(getFooTypeName());");
                it.newLine();
                it.append((Object)"\t\treturn containerBuilder.add");
                it.append((Object)ConstructorBuilderFragment.this.constructor.getElementDescription().name());
                it.append((Object)"();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        });
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            final String buildFunctionName = "build" + Strings.toFirstUpper((String)this.constructor.getElementDescription().name());
            final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl(this.constructor.getElementDescription().name());
            this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create the appender for a " + ConstructorBuilderFragment.this.getLanguageName() + " constructor."));
                    it.newLine();
                    it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)buildFunctionName);
                    it.append((Object)"(");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)appender);
                    it.append((Object)" a = new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(resourceSet));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the appender for a " + ConstructorBuilderFragment.this.getLanguageName() + " constructor."));
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)buildFunctionName);
                    it.append((Object)"(");
                    it.append(Resource.class);
                    it.append((Object)" resource) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)appender);
                    it.append((Object)" a = new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(resource));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
    }
}

