/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.impl.MultiLineCommentDocumentationProvider;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.HiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;
import org.eclipse.xtext.serializer.sequencer.RuleCallStack;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.output.FakeTreeAppendable;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.grammarAccess.GrammarAccessExtensions;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class DocumentationBuilderFragment
extends AbstractSubCodeBuilderFragment {
    @Inject
    private GrammarAccessExtensions grammarAccessExtensions;

    @Pure
    public TypeReference getIEcoreDocumentationBuilder() {
        return new TypeReference(this.getCodeElementExtractor().getDocumentationPackage() + ".IEcoreDocumentationBuilder");
    }

    @Pure
    public TypeReference getEcoreDocumentationBuilderImpl() {
        return new TypeReference(this.getCodeElementExtractor().getDocumentationPackage() + ".EcoreDocumentationBuilder");
    }

    @Pure
    public TypeReference getIDocumentationFormatter() {
        return new TypeReference(this.getCodeElementExtractor().getDocumentationPackage() + ".IDocumentationFormatter");
    }

    @Pure
    public TypeReference getDocumentationFormatterImpl() {
        return new TypeReference(this.getCodeElementExtractor().getDocumentationPackage() + ".DocumentationFormatter");
    }

    @Pure
    public TypeReference getEcoreDocumentationSyntacticSequencer() {
        return new TypeReference(this.getCodeElementExtractor().getSerializerPackage() + "." + this.getLanguageName().toUpperCase() + "EcoreDocumentationSyntacticSequencer");
    }

    @Pure
    public TypeReference getEcoreDocumentationSyntacticSequencerCustom() {
        return new TypeReference(this.getCodeElementExtractor().getSerializerPackage() + "." + this.getLanguageName().toUpperCase() + "EcoreDocumentationSyntacticSequencerCustom");
    }

    @Pure
    public TypeReference getSyntacticSequencer() {
        return new TypeReference(this.getCodeElementExtractor().getSerializerPackage() + "." + this.getLanguageName().toUpperCase() + "SyntacticSequencer");
    }

    @Pure
    public TypeReference getDocumentationProviderImpl() {
        return new TypeReference(this.getCodeElementExtractor().getDocumentationPackage() + "." + this.getLanguageName() + "DocumentationProvider");
    }

    @Pure
    public TypeReference getDocumentationProviderImplCustom() {
        return new TypeReference(this.getCodeElementExtractor().getDocumentationPackage() + "." + this.getLanguageName().toUpperCase() + "DocumentationProviderCustom");
    }

    @Override
    public void generate() {
        super.generate();
        this.generateInnerDocumentationAdapter();
        this.generateIDocumentationFormatter();
        this.generateIEcoreDocumentationBuilder();
        this.generateDocumentationFormatterImpl();
        this.generateEcoreDocumentationBuilderImpl();
        this.generateDocumentationProviderImpl();
        this.generateEcoreDocumentationSyntacticSequencer();
    }

    @Override
    public void getExportedPackages(Set<String> exportedPackages) {
        if (exportedPackages != null) {
            super.getExportedPackages(exportedPackages);
            exportedPackages.add(this.getCodeElementExtractor().getSerializerPackage());
            exportedPackages.add(this.getCodeElementExtractor().getDocumentationPackage());
        }
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        factory.addfinalTypeToType(this.getIDocumentationFormatter(), this.getDocumentationFormatterImpl());
        factory.addfinalTypeToTypeSingleton(this.getIEcoreDocumentationBuilder(), this.getEcoreDocumentationBuilderImpl());
        this.bindTypeReferences(factory, new TypeReference(IEObjectDocumentationProvider.class), this.getDocumentationProviderImpl(), this.getDocumentationProviderImplCustom());
        this.bindTypeReferences(factory, new TypeReference(IEObjectDocumentationProviderExtension.class), this.getDocumentationProviderImpl(), this.getDocumentationProviderImplCustom());
        this.bindTypeReferences(factory, new TypeReference(ISyntacticSequencer.class), this.getEcoreDocumentationSyntacticSequencer(), this.getEcoreDocumentationSyntacticSequencerCustom());
    }

    protected void generateInnerDocumentationAdapter() {
        final TypeReference adapter = this.getCodeElementExtractor().getInnerBlockDocumentationAdapter();
        StringConcatenationClient content = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"public class ");
                it.append((Object)adapter.getSimpleName());
                it.append((Object)" extends ");
                it.append(AdapterImpl.class);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String documentation;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String getDocumentation() {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t\treturn this.documentation;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic void setDocumentation(String documentation) {");
                it.newLine();
                it.append((Object)"\t\tthis.documentation = documentation;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic boolean isAdapterForType(Object type) {");
                it.newLine();
                it.append((Object)"\t\treturn type == ");
                it.append((Object)adapter.getSimpleName());
                it.append((Object)".class;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
            }
        };
        JavaFileAccess createJavaFile = this.getFileAccessFactory().createJavaFile(adapter, content);
        createJavaFile.writeTo(this.getSrcGen());
    }

    protected void generateIDocumentationFormatter() {
        final TypeReference formatter = this.getIDocumentationFormatter();
        StringConcatenationClient content = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"/** Format a documentation string.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"public interface ");
                it.append((Object)formatter.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the characters that must be used as prefix of each line in a multiline comment.");
                it.newLine();
                it.append((Object)"\t * @return the prefix.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString getMultilineCommentLinePrefix();");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the characters that must be used to start a comment.");
                it.newLine();
                it.append((Object)"\t * @return the symbols.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString getMultilineCommentStartSymbols();");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the characters that must be used to end a comment.");
                it.newLine();
                it.append((Object)"\t * @return the symbols.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString getMultilineCommentEndSymbols();");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the string that must be used as prefix of a singleline comment.");
                it.newLine();
                it.append((Object)"\t * @return the prefix.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString getSinglelineCommentPrefix();");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @return the formatted comment.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString formatMultilineComment(String doc);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @param indentation the string to put for indenting the comment.");
                it.newLine();
                it.append((Object)"\t * @return the formatted comment.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString formatMultilineComment(String doc, String indentation);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @param appendable the receiver of the formatted string.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tvoid formatMultilineComment(String doc, ");
                it.append(IAppendable.class);
                it.append((Object)" appendable);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @param indentation the string to put for indenting the comment.");
                it.newLine();
                it.append((Object)"\t * @param appendable the receiver of the formatted string.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tvoid formatMultilineComment(String doc, String indentation, ");
                it.append(IAppendable.class);
                it.append((Object)" appendable);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Format the given multiline documentation.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param context the formatting context.");
                it.newLine();
                it.append((Object)"\t * @param comment the comment to format out.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic void formatMultilineComment(");
                it.append(ITextReplacerContext.class);
                it.append((Object)" context, ");
                it.append(IComment.class);
                it.append((Object)" comment);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @return the formatted comment.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString formatSinglelineComment(String doc);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @param indentation the string to put for indenting the comment.");
                it.newLine();
                it.append((Object)"\t * @return the formatted comment.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString formatSinglelineComment(String doc, String indentation);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @param appendable the receiver of the formatted string.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tvoid formatSinglelineComment(String doc, ");
                it.append(IAppendable.class);
                it.append((Object)" appendable);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @param indentation the string to put for indenting the comment.");
                it.newLine();
                it.append((Object)"\t * @param appendable the receiver of the formatted string.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tvoid formatSinglelineComment(String doc, String indentation, ");
                it.append(IAppendable.class);
                it.append((Object)" appendable);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Format the given singleline documentation.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param context the formatting context.");
                it.newLine();
                it.append((Object)"\t * @param comment the comment to format out.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tvoid formatSinglelineComment(");
                it.append(ITextReplacerContext.class);
                it.append((Object)" context, ");
                it.append(IComment.class);
                it.append((Object)" comment);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess createJavaFile = this.getFileAccessFactory().createJavaFile(formatter, content);
        createJavaFile.writeTo(this.getSrcGen());
    }

    protected void generateIEcoreDocumentationBuilder() {
        final TypeReference builder = this.getIEcoreDocumentationBuilder();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"/** Build a documentation string for specific objects.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"public interface ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the grammar rule that corresponds to multiline comments.");
                it.newLine();
                it.append((Object)"\t * @return the ML grammar rule.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                it.append(AbstractRule.class);
                it.append((Object)" getMLCommentRule();");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the grammar rule that corresponds to singleline comments.");
                it.newLine();
                it.append((Object)"\t * @return the SL grammar rule.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                it.append(AbstractRule.class);
                it.append((Object)" getSLCommentRule();");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the documentation formatter used by this builder.");
                it.newLine();
                it.append((Object)"\t * @return documentation formatter.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                it.append((Object)DocumentationBuilderFragment.this.getIDocumentationFormatter());
                it.append((Object)" getDocumentationFormatter();");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the formatted string that corresponds to the given documentation.");
                it.newLine();
                it.append((Object)"\t * @param doc the documentation text. It may be on multiple lines.");
                it.newLine();
                it.append((Object)"\t * @param objectType the type of the object for which the document must be built.");
                it.newLine();
                it.append((Object)"\t * @return the formatted comment.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tString build(String doc, Class<?> objectType);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies if multiline comments are the default for the given type of objects.");
                it.newLine();
                it.append((Object)"\t * @param type the type of objects.");
                it.newLine();
                it.append((Object)"\t * @return {@code true} if multiline comment is the default.");
                it.newLine();
                it.append((Object)"\t *      Otherwise singleline comment is the default.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tboolean isMultilineCommentFor(Class<?> type);");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess createJavaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        createJavaFile.writeTo(this.getSrcGen());
    }

    protected void generateDocumentationFormatterImpl() {
        TypeReference formatter = this.getDocumentationFormatterImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"/** Formatter a documentation string.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"public class DocumentationFormatter implements ");
                it.append((Object)DocumentationBuilderFragment.this.getIDocumentationFormatter());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static final String SPACE_CHAR = \" \";");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static final String NL_CHAR = \"\\n\";");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static final String EMPTY_STR = \"\";");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String mlLinePrefix;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String mlStart;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String mlEnd;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String slPrefix;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected static boolean isNewLine(char character) {");
                it.newLine();
                it.append((Object)"\t\tif (character == '\\n' || character == '\\r' || character == '\\f') {");
                it.newLine();
                it.append((Object)"\t\t\treturn true;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\treturn ((((1 << Character.LINE_SEPARATOR)");
                it.newLine();
                it.append((Object)"\t\t\t| (1 << Character.PARAGRAPH_SEPARATOR)) >> Character.getType((int) character)) & 1) != 0;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String getMultilineCommentStartSymbols() {");
                it.newLine();
                it.append((Object)"\t\treturn this.mlStart;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic void setMultilineCommentStartSymbols(String symbols) {");
                it.newLine();
                it.append((Object)"\t\tthis.mlStart = symbols;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String getMultilineCommentEndSymbols() {");
                it.newLine();
                it.append((Object)"\t\treturn this.mlEnd;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic void setMultilineCommentEndSymbols(String symbols) {");
                it.newLine();
                it.append((Object)"\t\tthis.mlEnd = symbols;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String getMultilineCommentLinePrefix() {");
                it.newLine();
                it.append((Object)"\t\treturn this.mlLinePrefix;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic void setMultilineCommentLinePrefix(String prefix) {");
                it.newLine();
                it.append((Object)"\t\tthis.mlLinePrefix = prefix;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String getSinglelineCommentPrefix() {");
                it.newLine();
                it.append((Object)"\t\treturn this.slPrefix;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tprotected ");
                it.append(Set.class);
                it.append((Object)"<Character> getSinglelineCommentSpecialChars() {");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append(Set.class);
                it.append((Object)"<Character> set = new ");
                it.append(TreeSet.class);
                it.append((Object)"<>();");
                it.newLine();
                it.append((Object)"\t\tset.add('*');");
                it.newLine();
                it.append((Object)"\t\tset.add('+');");
                it.newLine();
                it.append((Object)"\t\tset.add('-');");
                it.newLine();
                it.append((Object)"\t\tset.add('=');");
                it.newLine();
                it.append((Object)"\t\treturn set;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic void setSinglelineCommentPrefix(String prefix) {");
                it.newLine();
                it.append((Object)"\t\tthis.slPrefix = prefix;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(DocumentationBuilderFragment.this.getInjectType());
                it.newLine();
                it.append((Object)"\tpublic void setGrammarAccess(");
                it.append((Object)DocumentationBuilderFragment.this.grammarAccessExtensions.getGrammarAccess(DocumentationBuilderFragment.this.getGrammar()));
                it.append((Object)" access) {");
                it.newLine();
                it.append((Object)"\t\tif (this.mlStart == null || this.mlEnd == null) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(AbstractRule.class);
                it.append((Object)" mlRule = access.getML_COMMENTRule();");
                it.newLine();
                it.append((Object)"\t\t\tfor (");
                it.append(AbstractElement.class);
                it.append((Object)" element : ((");
                it.append(Group.class);
                it.append((Object)") mlRule.getAlternatives()).getElements()) {");
                it.newLine();
                it.append((Object)"\t\t\t\tif (element instanceof ");
                it.append(Keyword.class);
                it.append((Object)" $c$value && this.mlStart == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tthis.mlStart = $c$value.getValue();");
                it.newLine();
                it.append((Object)"\t\t\t\t} else if (element instanceof ");
                it.append(UntilToken.class);
                it.append((Object)" $c$value && this.mlEnd == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tthis.mlEnd = ((");
                it.append(Keyword.class);
                it.append((Object)") $c$value.getTerminal()).getValue();");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tif (this.mlLinePrefix == null) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.mlLinePrefix = this.mlStart.substring(this.mlStart.length() - 1);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tif (this.slPrefix == null) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(AbstractRule.class);
                it.append((Object)" slRule = access.getSL_COMMENTRule();");
                it.newLine();
                it.append((Object)"\t\t\tfor (");
                it.append(AbstractElement.class);
                it.append((Object)" element : ((");
                it.append(Group.class);
                it.append((Object)") slRule.getAlternatives()).getElements()) {");
                it.newLine();
                it.append((Object)"\t\t\t\tif (element instanceof ");
                it.append(Keyword.class);
                it.append((Object)" $c$value) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tthis.slPrefix = $c$value.getValue().trim();");
                it.newLine();
                it.append((Object)"\t\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String formatMultilineComment(String doc) {");
                it.newLine();
                it.append((Object)"\t\treturn formatMultilineComment(doc, (String) null);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String formatMultilineComment(String doc, String indentation) {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(IAppendable.class);
                it.append((Object)" appendable = new ");
                it.append(StringBuilderBasedAppendable.class);
                it.append((Object)"();");
                it.newLine();
                it.append((Object)"\t\tformatMultilineComment(doc, indentation, appendable);");
                it.newLine();
                it.append((Object)"\t\treturn appendable.getContent();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic void formatMultilineComment(String doc, ");
                it.append(IAppendable.class);
                it.append((Object)" appendable) {");
                it.newLine();
                it.append((Object)"\t\tformatMultilineComment(doc, null, appendable);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic void formatMultilineComment(String doc, String indentation, ");
                it.append(IAppendable.class);
                it.append((Object)" appendable) {");
                it.newLine();
                it.append((Object)"\t\tif (!");
                it.append(Strings.class);
                it.append((Object)".isEmpty(doc)) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(SortedMap.class);
                it.append((Object)"<Integer, Replacement> replacements = new ");
                it.append(TreeMap.class);
                it.append((Object)"();");
                it.newLine();
                it.append((Object)"\t\t\tformatMultlineComment(indentation, Strings.newLine(), new AppendableAccessor(appendable, doc, replacements, 0, doc.length()));");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic void formatMultilineComment(");
                it.append(ITextReplacerContext.class);
                it.append((Object)" context, ");
                it.append(IComment.class);
                it.append((Object)" comment) {");
                it.newLine();
                it.append((Object)"\t\tformatMultlineComment(context.getIndentationString(), context.getNewLinesString(1), new RegionAccessor(context, comment));");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String formatSinglelineComment(String doc) {");
                it.newLine();
                it.append((Object)"\t\treturn formatSinglelineComment(doc, (String) null);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t\tpublic String formatSinglelineComment(String doc, String indentation) {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(StringBuilderBasedAppendable.class);
                it.append((Object)" appendable = new ");
                it.append(StringBuilderBasedAppendable.class);
                it.append((Object)"();");
                it.newLine();
                it.append((Object)"\t\tformatSinglelineComment(doc, indentation, appendable);");
                it.newLine();
                it.append((Object)"\t\treturn appendable.getContent();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic void formatSinglelineComment(String doc, ");
                it.append(IAppendable.class);
                it.append((Object)" appendable) {");
                it.newLine();
                it.append((Object)"\t\tformatSinglelineComment(doc, null, appendable);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic void formatSinglelineComment(String doc, String indentation, ");
                it.append(IAppendable.class);
                it.append((Object)" appendable) {");
                it.newLine();
                it.append((Object)"\t\tif (!");
                it.append(Strings.class);
                it.append((Object)".isEmpty(doc)) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(SortedMap.class);
                it.append((Object)"<Integer, Replacement> replacements = new ");
                it.append(TreeMap.class);
                it.append((Object)"<>();");
                it.newLine();
                it.append((Object)"\t\t\tint offset = doc.indexOf(getSinglelineCommentPrefix());");
                it.newLine();
                it.append((Object)"\t\t\tif (offset < 0) {");
                it.newLine();
                it.append((Object)"\t\t\t\toffset = 0;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tint endOffset = doc.indexOf(NL_CHAR, offset);");
                it.newLine();
                it.append((Object)"\t\t\tif (endOffset < 0) {");
                it.newLine();
                it.append((Object)"\t\t\t\tendOffset = doc.length();");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tformatSinglelineComment(");
                it.newLine();
                it.append((Object)"\t\t\t\tindentation,");
                it.newLine();
                it.append((Object)"\t\t\t\tnew AppendableAccessor(appendable, doc, replacements, offset, endOffset));");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic void formatSinglelineComment(");
                it.append(ITextReplacerContext.class);
                it.append((Object)" context, ");
                it.append(IComment.class);
                it.append((Object)" comment) {");
                it.newLine();
                it.append((Object)"\t\tformatSinglelineComment(context.getIndentationString(), new RegionAccessor(context, comment));");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate <T> void formatSinglelineComment(String indentationString, FormattedTextAccessor<T> backend) {");
                it.newLine();
                it.append((Object)"\t\tfinal String indent = ");
                it.append(Strings.class);
                it.append((Object)".emptyIfNull(indentationString);");
                it.newLine();
                it.append((Object)"\t\tfinal String comment = backend.getCommentText();");
                it.newLine();
                it.append((Object)"\t\t// Compute the starting offset of the text inside the comment");
                it.newLine();
                it.append((Object)"\t\tint offset = comment.indexOf(getSinglelineCommentPrefix());");
                it.newLine();
                it.append((Object)"\t\tif (offset < 0) {");
                it.newLine();
                it.append((Object)"\t\t\tbackend.replace(0, 0, getSinglelineCommentPrefix());");
                it.newLine();
                it.append((Object)"\t\t\toffset = 0;");
                it.newLine();
                it.append((Object)"\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\toffset += getSinglelineCommentPrefix().length();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tfinal int endOffset = comment.length();");
                it.newLine();
                it.append((Object)"\t\tT currentLine = backend.getFirstLine(backend.getCommentOffset());");
                it.newLine();
                it.append((Object)"\t\tboolean firstLine = true;");
                it.newLine();
                it.append((Object)"\t\twhile (currentLine != null) {");
                it.newLine();
                it.append((Object)"\t\t\tString lineText = backend.getLineText(currentLine);");
                it.newLine();
                it.append((Object)"\t\t\tint lineOffset = backend.getLineOffset(currentLine);");
                it.newLine();
                it.append((Object)"\t\t\tint lineLength = backend.getLineLength(currentLine);");
                it.newLine();
                it.append((Object)"\t\t\t// Clamp the line text to the comment area.");
                it.newLine();
                it.append((Object)"\t\t\tif (firstLine) {");
                it.newLine();
                it.append((Object)"\t\t\t\tif (lineOffset < offset) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tfinal int len = offset - lineOffset;");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineText = lineText.substring(len);");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineOffset += len;");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineLength -= len;");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t} else if (lineOffset >= endOffset) {");
                it.newLine();
                it.append((Object)"\t\t\t\t// After the end of comment");
                it.newLine();
                it.append((Object)"\t\t\t\tbackend.applyReplacements();");
                it.newLine();
                it.append((Object)"\t\t\t\treturn;");
                it.newLine();
                it.append((Object)"\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\tfinal String prefix;");
                it.newLine();
                it.append((Object)"\t\t\t\tif (!startsWith(lineText, 0, getSinglelineCommentPrefix())) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tprefix = indent + getSinglelineCommentPrefix();");
                it.newLine();
                it.append((Object)"\t\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tprefix = indent;");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\tbackend.replace(lineOffset, 0, prefix);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t// Skip the comment characters that corresponds to the Javadoc format: //[*-+=].");
                it.newLine();
                it.append((Object)"\t\t\tint realCommentStart = 0;");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(Set.class);
                it.append((Object)"<Character> specialChars = getSinglelineCommentSpecialChars();");
                it.newLine();
                it.append((Object)"\t\t\twhile (realCommentStart < lineLength && specialChars.contains(lineText.charAt(realCommentStart))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t++realCommentStart;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t// Search for the first non whitespace");
                it.newLine();
                it.append((Object)"\t\t\tint firstNonWhiteSpacePos = realCommentStart;");
                it.newLine();
                it.append((Object)"\t\t\twhile (firstNonWhiteSpacePos < lineLength && Character.isWhitespace(lineText.charAt(firstNonWhiteSpacePos))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t++firstNonWhiteSpacePos;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t// Add whitespace at the beginning.");
                it.newLine();
                it.append((Object)"\t\t\tif (firstNonWhiteSpacePos == lineLength) {");
                it.newLine();
                it.append((Object)"\t\t\t\t// Empty comment");
                it.newLine();
                it.append((Object)"\t\t\t\tif (realCommentStart < firstNonWhiteSpacePos) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tbackend.replace(realCommentStart + lineOffset, lineLength - realCommentStart, EMPTY_STR);");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\tfinal int expectedNbWhiteSpaces = getWhiteSpacesOnFirstLine();");
                it.newLine();
                it.append((Object)"\t\t\t\tfinal int nbWhiteSpaces = firstNonWhiteSpacePos - realCommentStart;");
                it.newLine();
                it.append((Object)"\t\t\t\tif (nbWhiteSpaces != expectedNbWhiteSpaces) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tbackend.replace(realCommentStart + lineOffset, nbWhiteSpaces, makeWhiteSpaces(expectedNbWhiteSpaces));");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\t// Format the comment text");
                it.newLine();
                it.append((Object)"\t\t\t\tformatLineText(");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineText.substring(firstNonWhiteSpacePos, lineLength), true,");
                it.newLine();
                it.append((Object)"\t\t\t\t\tnew SubAccessor<>(backend, lineOffset + firstNonWhiteSpacePos));");
                it.newLine();
                it.append((Object)"\t\t\t\t// Remove trailing whitespaces");
                it.newLine();
                it.append((Object)"\t\t\t\tint endOfText = lineLength;");
                it.newLine();
                it.append((Object)"\t\t\t\twhile ((endOfText - 1) > firstNonWhiteSpacePos && Character.isWhitespace(lineText.charAt(endOfText - 1))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\t--endOfText;");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\tif (endOfText < lineLength) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tbackend.replace(endOfText + lineOffset, lineLength - endOfText, EMPTY_STR);");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tfirstLine = false;");
                it.newLine();
                it.append((Object)"\t\t\tcurrentLine = backend.getNextLine(currentLine);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tbackend.applyReplacements();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static String safeSubstring(String text, int start, int length) {");
                it.newLine();
                it.append((Object)"\t\tif (text == null) {");
                it.newLine();
                it.append((Object)"\t\t\treturn EMPTY_STR;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tfinal int index = Math.max(0, start);");
                it.newLine();
                it.append((Object)"\t\tfinal int len = Math.max(0, Math.min(length, text.length()));");
                it.newLine();
                it.append((Object)"\t\treturn text.substring(index, index + len);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static boolean startsWith(String text, int start, String pattern) {");
                it.newLine();
                it.append((Object)"\t\treturn safeSubstring(text, start, pattern.length()).equals(pattern);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static String makeWhiteSpaces(int nb) {");
                it.newLine();
                it.append((Object)"\t\tfinal StringBuilder b = new StringBuilder();");
                it.newLine();
                it.append((Object)"\t\tfor (int i = 0; i < nb; ++i) {");
                it.newLine();
                it.append((Object)"\t\t\tb.append(SPACE_CHAR);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn b.toString();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected int getWhiteSpacesOnFirstLine() {");
                it.newLine();
                it.append((Object)"\t\treturn 1;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected int getWhiteSpacesOnOtherLines() {");
                it.newLine();
                it.append((Object)"\t\treturn 1;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected <T> void formatLineText(String lineText, boolean isMultlineComment, FormattedTextAccessor<T> backend) {");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate <T> boolean formatMultlineCommentFirstLine(String lineText, String indentationString, String newLineString, int endCommentOffset, FormattedTextAccessor<T> backend) {");
                it.newLine();
                it.append((Object)"\t\t// Skip the comment characters that corresponds to the Javadoc format: /**.");
                it.newLine();
                it.append((Object)"\t\tint realCommentStart = 0;");
                it.newLine();
                it.append((Object)"\t\twhile (realCommentStart < lineText.length() && startsWith(lineText, realCommentStart, getMultilineCommentLinePrefix())) {");
                it.newLine();
                it.append((Object)"\t\t\trealCommentStart += getMultilineCommentLinePrefix().length();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\t// Search for the first non whitespace");
                it.newLine();
                it.append((Object)"\t\tint firstNonWhiteSpacePos = realCommentStart;");
                it.newLine();
                it.append((Object)"\t\tboolean hasNonSpaceChar = false;");
                it.newLine();
                it.append((Object)"\t\twhile (firstNonWhiteSpacePos < lineText.length() && Character.isWhitespace(lineText.charAt(firstNonWhiteSpacePos))) {");
                it.newLine();
                it.append((Object)"\t\t\tif (!Character.isSpaceChar(lineText.charAt(firstNonWhiteSpacePos))) {");
                it.newLine();
                it.append((Object)"\t\t\t\thasNonSpaceChar = true;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t++firstNonWhiteSpacePos;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\t// Add whitespace at the beginning.");
                it.newLine();
                it.append((Object)"\t\tfinal int expectedNbWhiteSpaces = getWhiteSpacesOnFirstLine();");
                it.newLine();
                it.append((Object)"\t\tfinal int nbWhiteSpaces = firstNonWhiteSpacePos - realCommentStart;");
                it.newLine();
                it.append((Object)"\t\tif (hasNonSpaceChar || nbWhiteSpaces != expectedNbWhiteSpaces) {");
                it.newLine();
                it.append((Object)"\t\t\tbackend.replace(realCommentStart, nbWhiteSpaces, makeWhiteSpaces(expectedNbWhiteSpaces));");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\t// Treat the end of comment");
                it.newLine();
                it.append((Object)"\t\tif (endCommentOffset <= lineText.length()) {");
                it.newLine();
                it.append((Object)"\t\t\t// Comment end at the first line. Insert a newline character");
                it.newLine();
                it.append((Object)"\t\t\t// Search for the end of comment text.");
                it.newLine();
                it.append((Object)"\t\t\tint endPos = endCommentOffset;");
                it.newLine();
                it.append((Object)"\t\t\tfinal int end = endPos;");
                it.newLine();
                it.append((Object)"\t\t\twhile ((endPos - 1) > firstNonWhiteSpacePos && Character.isWhitespace(lineText.charAt(endPos - 1))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t--endPos;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t// Format the comment text");
                it.newLine();
                it.append((Object)"\t\t\tformatLineText(lineText.substring(firstNonWhiteSpacePos, endPos), true, new SubAccessor<>(backend, firstNonWhiteSpacePos));");
                it.newLine();
                it.append((Object)"\t\t\t// Do the replacement");
                it.newLine();
                it.append((Object)"\t\t\tbackend.replace(endPos, end - endPos, newLineString + indentationString + SPACE_CHAR);");
                it.newLine();
                it.append((Object)"\t\t\t// We don't need to treat more line");
                it.newLine();
                it.append((Object)"\t\t\treturn true;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\t// Format the comment text");
                it.newLine();
                it.append((Object)"\t\tformatLineText(lineText.substring(firstNonWhiteSpacePos, lineText.length()), true, new SubAccessor<>(backend, firstNonWhiteSpacePos));");
                it.newLine();
                it.append((Object)"\t\treturn false;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate <T> boolean formatMultlineCommentOtherLines(String lineText, String indentationString, String newLineString, int endCommentOffset, FormattedTextAccessor<T> backend) {");
                it.newLine();
                it.append((Object)"\t\t// Search for the comment prefix (usually \" * \"");
                it.newLine();
                it.append((Object)"\t\tint realCommentStart = 0;");
                it.newLine();
                it.append((Object)"\t\twhile (realCommentStart < lineText.length() && Character.isWhitespace(lineText.charAt(realCommentStart))) {");
                it.newLine();
                it.append((Object)"\t\t\t++realCommentStart;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tboolean foundStar = false;");
                it.newLine();
                it.append((Object)"\t\tif (realCommentStart < lineText.length() && startsWith(lineText, realCommentStart, getMultilineCommentLinePrefix())) {");
                it.newLine();
                it.append((Object)"\t\t\trealCommentStart += getMultilineCommentLinePrefix().length();");
                it.newLine();
                it.append((Object)"\t\t\tfoundStar = true;");
                it.newLine();
                it.append((Object)"\t\t\twhile (realCommentStart < lineText.length() && Character.isWhitespace(lineText.charAt(realCommentStart))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t++realCommentStart;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\t// Compute the standard prefix.");
                it.newLine();
                it.append((Object)"\t\tStringBuilder prefix = new StringBuilder(indentationString);");
                it.newLine();
                it.append((Object)"\t\tprefix.append(SPACE_CHAR);");
                it.newLine();
                it.append((Object)"\t\tprefix.append(getMultilineCommentLinePrefix());");
                it.newLine();
                it.append((Object)"\t\tprefix.append(makeWhiteSpaces(getWhiteSpacesOnOtherLines()));");
                it.newLine();
                it.append((Object)"\t\t// Force replacement by the line's prefix");
                it.newLine();
                it.append((Object)"\t\tint minBoundForEnd = 0;");
                it.newLine();
                it.append((Object)"\t\tif (endCommentOffset > lineText.length() || foundStar || realCommentStart < endCommentOffset) {");
                it.newLine();
                it.append((Object)"\t\t\tbackend.replace(0, realCommentStart, prefix.toString());");
                it.newLine();
                it.append((Object)"\t\t\tif (foundStar) {");
                it.newLine();
                it.append((Object)"\t\t\t\tminBoundForEnd = prefix.length();");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\t// Format the comment text");
                it.newLine();
                it.append((Object)"\t\tif (endCommentOffset <= lineText.length()) {");
                it.newLine();
                it.append((Object)"\t\t\t// End of comment on the current line.");
                it.newLine();
                it.append((Object)"\t\t\tint endPosition = endCommentOffset;");
                it.newLine();
                it.append((Object)"\t\t\tfinal int end = endPosition;");
                it.newLine();
                it.append((Object)"\t\t\twhile ((endPosition - 1) >= minBoundForEnd && Character.isWhitespace(lineText.charAt(endPosition - 1))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t--endPosition;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tif (endPosition > 0) {");
                it.newLine();
                it.append((Object)"\t\t\t\t// Comment end with a text before. Insert a newline character");
                it.newLine();
                it.append((Object)"\t\t\t\tbackend.replace(endPosition, end - endPosition, newLineString + indentationString + SPACE_CHAR);");
                it.newLine();
                it.append((Object)"\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\t// Replace spaces before end of comment if they exist");
                it.newLine();
                it.append((Object)"\t\t\t\tbackend.replace(endPosition, end - endPosition, indentationString + SPACE_CHAR);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t// We don't need to treat more line");
                it.newLine();
                it.append((Object)"\t\t\treturn true;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn false;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate <T> void formatMultlineComment(String indentationString, String newLineString, FormattedTextAccessor<T> backend) {");
                it.newLine();
                it.append((Object)"\t\tfinal String indent = Strings.emptyIfNull(indentationString);");
                it.newLine();
                it.append((Object)"\t\tfinal String comment = backend.getCommentText();");
                it.newLine();
                it.append((Object)"\t\t// Compute the starting offset of the text inside the comment");
                it.newLine();
                it.append((Object)"\t\tint offset = comment.indexOf(getMultilineCommentStartSymbols());");
                it.newLine();
                it.append((Object)"\t\tif (offset < 0) {");
                it.newLine();
                it.append((Object)"\t\t\tbackend.replace(0, 0, getMultilineCommentStartSymbols());");
                it.newLine();
                it.append((Object)"\t\t\toffset = 0;");
                it.newLine();
                it.append((Object)"\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\toffset += getMultilineCommentStartSymbols().length();");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t// Compute the ending offset of the text inside the comment");
                it.newLine();
                it.append((Object)"\t\t\tint endOffset = comment.indexOf(getMultilineCommentEndSymbols(), offset);");
                it.newLine();
                it.append((Object)"\t\t\tif (endOffset < 0) {");
                it.newLine();
                it.append((Object)"\t\t\t\tendOffset = comment.length();");
                it.newLine();
                it.append((Object)"\t\t\t\tbackend.replace(endOffset, 0, getMultilineCommentEndSymbols());");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t// Go through the lines");
                it.newLine();
                it.append((Object)"\t\t\tT currentLine = backend.getFirstLine(backend.getCommentOffset());");
                it.newLine();
                it.append((Object)"\t\t\tboolean firstLine = true;");
                it.newLine();
                it.append((Object)"\t\t\twhile (currentLine != null) {");
                it.newLine();
                it.append((Object)"\t\t\t\tString lineText = backend.getLineText(currentLine);");
                it.newLine();
                it.append((Object)"\t\t\t\tint lineOffset = backend.getLineOffset(currentLine);");
                it.newLine();
                it.append((Object)"\t\t\t\tint lineLength = backend.getLineLength(currentLine);");
                it.newLine();
                it.append((Object)"\t\t\t\t// Clamp the line text to the comment area.");
                it.newLine();
                it.append((Object)"\t\t\t\tif (lineOffset < offset) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tfinal int len = offset - lineOffset;");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineText = lineText.substring(len);");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineOffset += len;");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineLength -= len;");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\tif ((lineOffset + lineLength) > endOffset) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tfinal int len = lineOffset + lineLength - endOffset;");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineText = lineText.substring(0, lineText.length() - len);");
                it.newLine();
                it.append((Object)"\t\t\t\t\tlineLength -= len;");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\tif (firstLine) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tif (formatMultlineCommentFirstLine(lineText, indent, newLineString, endOffset - lineOffset, new SubAccessor(backend, lineOffset))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\tbackend.applyReplacements();");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\treturn;");
                it.newLine();
                it.append((Object)"\t\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\tif (formatMultlineCommentOtherLines(lineText, indent, newLineString, endOffset - lineOffset, new SubAccessor(backend, lineOffset))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tbackend.applyReplacements();");
                it.newLine();
                it.append((Object)"\t\t\t\t\treturn;");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tfirstLine = false;");
                it.newLine();
                it.append((Object)"\t\t\tcurrentLine = backend.getNextLine(currentLine);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tbackend.applyReplacements();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLine();
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic interface FormattedTextAccessor<T> {");
                it.newLine();
                it.append((Object)"\t\tT getFirstLine(int offset);");
                it.newLine();
                it.append((Object)"\t\tT getNextLine(T currentLine);");
                it.newLine();
                it.append((Object)"\t\tint getLineOffset(T currentLine);");
                it.newLine();
                it.append((Object)"\t\tint getLineLength(T currentLine);");
                it.newLine();
                it.append((Object)"\t\tString getLineText(T line);");
                it.newLine();
                it.append((Object)"\t\tString getCommentText();");
                it.newLine();
                it.append((Object)"\t\tint getCommentOffset();");
                it.newLine();
                it.append((Object)"\t\tint getCommentEndOffset();");
                it.newLine();
                it.append((Object)"\t\tReplacement replace(int offset, int length, String newText);");
                it.newLine();
                it.append((Object)"\t\tvoid applyReplacements();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic class SubAccessor<T> implements FormattedTextAccessor<T> {");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final FormattedTextAccessor<T> parent;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final int offsetInParent;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic SubAccessor(FormattedTextAccessor<T> parent, int offsetInParent) {");
                it.newLine();
                it.append((Object)"\t\t\tassert parent != null;");
                it.newLine();
                it.append((Object)"\t\t\tthis.parent = parent;");
                it.newLine();
                it.append((Object)"\t\t\tthis.offsetInParent = offsetInParent;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic T getFirstLine(int offset) {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.getFirstLine(offset);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic T getNextLine(T currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.getNextLine(currentLine);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getLineOffset(T currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.getLineOffset(currentLine);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getLineLength(T currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.getLineLength(currentLine);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String getLineText(T line) {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.getLineText(line);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String getCommentText() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.getCommentText();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getCommentOffset() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.getCommentOffset();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getCommentEndOffset() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.getCommentEndOffset();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic Replacement replace(int offset, int length, String newText) {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.parent.replace(this.offsetInParent + offset, length, newText);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic final void applyReplacements() {");
                it.newLine();
                it.append((Object)"\t\t\tthrow new UnsupportedOperationException();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic static class Line {");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final int offset;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final int length;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic static Line newInstance(String text, int offset) {");
                it.newLine();
                it.append((Object)"\t\t\tif (offset < 0 || offset >= text.length()) {");
                it.newLine();
                it.append((Object)"\t\t\t\treturn null;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tint soffset = offset;");
                it.newLine();
                it.append((Object)"\t\t\twhile (soffset >= 0 && !isNewLine(text.charAt(soffset))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t--soffset;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t++soffset;");
                it.newLine();
                it.append((Object)"\t\t\tint eoffset = soffset;");
                it.newLine();
                it.append((Object)"\t\t\twhile (eoffset < text.length() && !isNewLine(text.charAt(eoffset))) {");
                it.newLine();
                it.append((Object)"\t\t\t\t++eoffset;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tfinal int length = ");
                it.append(Math.class);
                it.append((Object)".max(0, eoffset - soffset);");
                it.newLine();
                it.append((Object)"\t\t\treturn new Line(soffset, length);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate Line(int offset, int length) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.offset = offset;");
                it.newLine();
                it.append((Object)"\t\t\tthis.length = length;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getOffset() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.offset;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getLength() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.length;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String toString() {");
                it.newLine();
                it.append((Object)"\t\t\treturn \"offset: \" + getOffset() + \"; length: \" + getLength();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic static abstract class AbstractReplacementAccessor<T> implements FormattedTextAccessor<T> {");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final String documentation;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate ");
                it.append(SortedMap.class);
                it.append((Object)"<Integer, Replacement> replacements;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate boolean applied;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic AbstractReplacementAccessor(String documentation, ");
                it.append(SortedMap.class);
                it.append((Object)"<Integer, Replacement> replacements) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.documentation = documentation;");
                it.newLine();
                it.append((Object)"\t\t\tthis.replacements = replacements;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprotected final void checkNotApplied() {");
                it.newLine();
                it.append((Object)"\t\t\tif (this.applied) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthrow new IllegalStateException(\"Changes are already applied\");");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tthis.applied = true;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String getCommentText() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.documentation;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprotected ");
                it.append(SortedMap.class);
                it.append((Object)"<Integer, Replacement> getReplacements() {");
                it.newLine();
                it.append((Object)"\t\t\tif (this.replacements == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.replacements = new ");
                it.append(TreeMap.class);
                it.append((Object)"<>();");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\treturn this.replacements;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic Replacement replace(int offset, int length, String newText) {");
                it.newLine();
                it.append((Object)"\t\t\tReplacement rep = getReplacements().remove(offset);");
                it.newLine();
                it.append((Object)"\t\t\tif (rep == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\trep = new Replacement(offset, length, newText);");
                it.newLine();
                it.append((Object)"\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\trep = new Replacement(offset, rep.getLength() + length, rep.getText() + newText);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tgetReplacements().put(offset, rep);");
                it.newLine();
                it.append((Object)"\t\t\treturn rep;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprotected static void applyReplacements(");
                it.append(IAppendable.class);
                it.append((Object)" appendable, String text, ");
                it.append(Map.class);
                it.append((Object)"<Integer, Replacement> replacements) {");
                it.newLine();
                it.append((Object)"\t\t\tint offset = 0;");
                it.newLine();
                it.append((Object)"\t\t\tfor (final Replacement replacement : replacements.values()) {");
                it.newLine();
                it.append((Object)"\t\t\t\tif (replacement.getOffset() < offset) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tappendable.append(\"<<<Conflicting replacements>>>\");");
                it.newLine();
                it.append((Object)"\t\t\t\t} else {");
                it.newLine();
                it.append((Object)"\t\t\t\t\tassert offset >= 0;");
                it.newLine();
                it.append((Object)"\t\t\t\t\tassert replacement.getOffset() <= text.length();");
                it.newLine();
                it.append((Object)"\t\t\t\t\tString notReplacedString = text.substring(offset, replacement.getOffset());");
                it.newLine();
                it.append((Object)"\t\t\t\t\tappendable.append(notReplacedString);");
                it.newLine();
                it.append((Object)"\t\t\t\t\toffset += notReplacedString.length();");
                it.newLine();
                it.append((Object)"\t\t\t\t\tappendable.append(replacement.getText());");
                it.newLine();
                it.append((Object)"\t\t\t\t\toffset += replacement.getLength();");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tif (offset < text.length()) {");
                it.newLine();
                it.append((Object)"\t\t\t\tString notReplacedString = text.substring(offset);");
                it.newLine();
                it.append((Object)"\t\t\t\tappendable.append(notReplacedString);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic static abstract class AbstractDebuggingAccessor<T> extends AbstractReplacementAccessor<T> {");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate String buffer;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic AbstractDebuggingAccessor(String text, ");
                it.append(SortedMap.class);
                it.append((Object)"<Integer, Replacement> replacements) {");
                it.newLine();
                it.append((Object)"\t\t\tsuper(text, replacements);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate String computeBuffer() {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(IAppendable.class);
                it.append((Object)" appendable = new ");
                it.append(FakeTreeAppendable.class);
                it.append((Object)"();");
                it.newLine();
                it.append((Object)"\t\t\tapplyReplacements(appendable, getCommentText(), getReplacements());");
                it.newLine();
                it.append((Object)"\t\t\treturn appendable.getContent();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String toString() {");
                it.newLine();
                it.append((Object)"\t\t\tif (this.buffer == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.buffer = computeBuffer();");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\treturn this.buffer;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic Replacement replace(int offset, int length, String newText) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal Replacement rep = super.replace(offset, length, newText);");
                it.newLine();
                it.append((Object)"\t\t\tthis.buffer = computeBuffer();");
                it.newLine();
                it.append((Object)"\t\t\treturn rep;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic static class RegionAccessor extends AbstractReplacementAccessor<");
                it.append(ILineRegion.class);
                it.append((Object)"> {");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final ");
                it.append(ITextReplacerContext.class);
                it.append((Object)" context;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final ");
                it.append(ITextRegionAccess.class);
                it.append((Object)" access;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final ");
                it.append(IComment.class);
                it.append((Object)" comment;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic RegionAccessor(");
                it.append(ITextReplacerContext.class);
                it.append((Object)" context, ");
                it.append(IComment.class);
                it.append((Object)" comment) {");
                it.newLine();
                it.append((Object)"\t\t\tsuper(comment.getText(), null);");
                it.newLine();
                it.append((Object)"\t\t\tthis.context = context;");
                it.newLine();
                it.append((Object)"\t\t\tthis.comment = comment;");
                it.newLine();
                it.append((Object)"\t\t\tthis.access = comment.getTextRegionAccess();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String getCommentText() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.comment.getText();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String getLineText(");
                it.append(ILineRegion.class);
                it.append((Object)" line) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(ITextSegment.class);
                it.append((Object)" segment = this.access.regionForOffset(line.getOffset(), line.getLength());");
                it.newLine();
                it.append((Object)"\t\t\treturn segment.getText();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getCommentOffset() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.comment.getOffset();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getCommentEndOffset() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.comment.getEndOffset();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic ");
                it.append(ILineRegion.class);
                it.append((Object)" getFirstLine(int offset) {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.access.regionForLineAtOffset(offset);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic ");
                it.append(ILineRegion.class);
                it.append((Object)" getNextLine(");
                it.append(ILineRegion.class);
                it.append((Object)" currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\treturn currentLine.getNextLine();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getLineOffset(");
                it.append(ILineRegion.class);
                it.append((Object)" currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\treturn currentLine.getOffset() - getCommentOffset();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getLineLength(");
                it.append(ILineRegion.class);
                it.append((Object)" currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\treturn currentLine.getLength();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic void applyReplacements() {");
                it.newLine();
                it.append((Object)"\t\t\tcheckNotApplied();");
                it.newLine();
                it.append((Object)"\t\t\tfor (Replacement replacement : getReplacements().values()) {");
                it.newLine();
                it.append((Object)"\t\t\t\t");
                it.append(ITextSegment.class);
                it.append((Object)" target = this.access.regionForOffset(replacement.getOffset() + getCommentOffset(), replacement.getLength());");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.context.addReplacement(target.replaceWith(replacement.getText()));");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static class AppendableAccessor extends AbstractReplacementAccessor<Line> {");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final ");
                it.append(IAppendable.class);
                it.append((Object)" target;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final int commentOffset;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final int commentEndOffset;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic AppendableAccessor(");
                it.append(IAppendable.class);
                it.append((Object)" target, String documentation, ");
                it.append(SortedMap.class);
                it.append((Object)"<Integer, Replacement> replacements, int commentOffset, int commentEndOffset) {");
                it.newLine();
                it.append((Object)"\t\t\tsuper(documentation, replacements);");
                it.newLine();
                it.append((Object)"\t\t\tthis.target = target;");
                it.newLine();
                it.append((Object)"\t\t\tthis.commentOffset = commentOffset;");
                it.newLine();
                it.append((Object)"\t\t\tthis.commentEndOffset = commentEndOffset;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic Line getFirstLine(int offset) {");
                it.newLine();
                it.append((Object)"\t\t\treturn Line.newInstance(getCommentText(), offset);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic Line getNextLine(Line currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\tint index = getCommentText().indexOf(NL_CHAR, currentLine.getOffset());");
                it.newLine();
                it.append((Object)"\t\t\tif (index < 0) {");
                it.newLine();
                it.append((Object)"\t\t\t\treturn null;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\treturn Line.newInstance(getCommentText(), index + 1);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getLineOffset(Line currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\treturn currentLine.getOffset();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getLineLength(Line currentLine) {");
                it.newLine();
                it.append((Object)"\t\t\treturn currentLine.getLength();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String getLineText(Line line) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal int offset = line.getOffset();");
                it.newLine();
                it.append((Object)"\t\t\treturn getCommentText().substring(offset, offset + line.getLength());");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getCommentOffset() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.commentOffset;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getCommentEndOffset() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.commentEndOffset;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic void applyReplacements() {");
                it.newLine();
                it.append((Object)"\t\t\tcheckNotApplied();");
                it.newLine();
                it.append((Object)"\t\t\tapplyReplacements(this.target, getCommentText(), getReplacements());");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic static class Replacement {");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final int offset;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final int length;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tprivate final String text;");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic Replacement(int offset, int length, String text) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.offset = offset;");
                it.newLine();
                it.append((Object)"\t\t\tthis.length = length;");
                it.newLine();
                it.append((Object)"\t\t\tthis.text = text;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getOffset() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.offset;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic int getLength() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.length;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String getText() {");
                it.newLine();
                it.append((Object)"\t\t\treturn this.text;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t\tpublic String toString() {");
                it.newLine();
                it.append((Object)"\t\t\treturn \"offset: \" + getOffset() + \"; length: \" + getLength() + \"; new text: \" + getText();");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess createJavaFile = this.getFileAccessFactory().createJavaFile(formatter, content);
        createJavaFile.writeTo(this.getSrcGen());
    }

    protected void generateEcoreDocumentationBuilderImpl() {
        final TypeReference builder = this.getEcoreDocumentationBuilderImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"/** Build a documentation string.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" implements ");
                it.append((Object)DocumentationBuilderFragment.this.getIEcoreDocumentationBuilder());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append(AbstractRule.class);
                it.append((Object)" mlRule;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append(AbstractRule.class);
                it.append((Object)" slRule;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String mlStartSymbols;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String mlEndTagSymbols;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate String slStartSymbols;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(DocumentationBuilderFragment.this.getInjectType());
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append((Object)DocumentationBuilderFragment.this.getIDocumentationFormatter());
                it.append((Object)" documentationFormatter;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(DocumentationBuilderFragment.this.getInjectType());
                it.newLine();
                it.append((Object)"\tpublic void setGrammarAccess(");
                it.append((Object)DocumentationBuilderFragment.this.grammarAccessExtensions.getGrammarAccess(DocumentationBuilderFragment.this.getGrammar()));
                it.append((Object)" access) {");
                it.newLine();
                it.append((Object)"\t\tthis.mlRule = access.getML_COMMENTRule();");
                it.newLine();
                it.append((Object)"\t\tthis.slRule = access.getSL_COMMENTRule();");
                it.newLine();
                it.append((Object)"\t\tfor (");
                it.append(AbstractElement.class);
                it.append((Object)" element : ((");
                it.append(Group.class);
                it.append((Object)") this.mlRule.getAlternatives()).getElements()) {");
                it.newLine();
                it.append((Object)"\t\t\tif (element instanceof ");
                it.append(Keyword.class);
                it.append((Object)" $c$value && ");
                it.append(Strings.class);
                it.append((Object)".isEmpty(this.mlStartSymbols)) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.mlStartSymbols = $c$value.getValue();");
                it.newLine();
                it.append((Object)"\t\t\t} else if (element instanceof ");
                it.append(UntilToken.class);
                it.append((Object)" $c$value && ");
                it.append(Strings.class);
                it.append((Object)".isEmpty(this.mlEndTagSymbols)) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.mlEndTagSymbols = ((");
                it.append(Keyword.class);
                it.append((Object)") $c$value.getTerminal()).getValue();");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(AbstractRule.class);
                it.append((Object)" slRule = access.getSL_COMMENTRule();");
                it.newLine();
                it.append((Object)"\t\tfor (");
                it.append(AbstractElement.class);
                it.append((Object)" element : ((");
                it.append(Group.class);
                it.append((Object)") slRule.getAlternatives()).getElements()) {");
                it.newLine();
                it.append((Object)"\t\t\tif (element instanceof ");
                it.append(Keyword.class);
                it.append((Object)" $c$value) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.slStartSymbols = $c$value.getValue().trim();");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(AbstractRule.class);
                it.append((Object)" getMLCommentRule() {");
                it.newLine();
                it.append((Object)"\t\treturn this.mlRule;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(AbstractRule.class);
                it.append((Object)" getSLCommentRule() {");
                it.newLine();
                it.append((Object)"\t\treturn this.slRule;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)DocumentationBuilderFragment.this.getIDocumentationFormatter());
                it.append((Object)" getDocumentationFormatter() {");
                it.newLine();
                it.append((Object)"\t\treturn this.documentationFormatter;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic boolean isMultilineCommentFor(Class<?> type) {");
                it.newLine();
                it.append((Object)"\t\treturn ");
                Set<String> multilineCommentedTypes = DocumentationBuilderFragment.this.getCodeBuilderConfig().getMultilineCommentedTypes();
                if (multilineCommentedTypes.isEmpty()) {
                    it.append((Object)"false");
                } else {
                    boolean firstTest = true;
                    for (String typeName : multilineCommentedTypes) {
                        if (firstTest) {
                            firstTest = false;
                        } else {
                            it.newLine();
                            it.append((Object)"\t\t\t\t|| ");
                        }
                        TypeReference reference = new TypeReference(typeName);
                        it.append((Object)reference);
                        it.append((Object)".class.isAssignableFrom(type)");
                    }
                }
                it.append((Object)";");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic String build(String doc, Class<?> objectType) {");
                it.newLine();
                it.append((Object)"\t\tString givenDocumentation = ");
                it.append(Strings.class);
                it.append((Object)".emptyIfNull(doc).trim();");
                it.newLine();
                it.append((Object)"\t\tStringBuilder documentation = new StringBuilder();");
                it.newLine();
                it.append((Object)"\t\t");
                it.append((Object)DocumentationBuilderFragment.this.getIDocumentationFormatter());
                it.append((Object)" formatter = getDocumentationFormatter();");
                it.newLine();
                it.append((Object)"\t\tif (isMultilineCommentFor(objectType)) {");
                it.newLine();
                it.append((Object)"\t\t\tif (!givenDocumentation.startsWith(this.mlStartSymbols)) {");
                it.newLine();
                it.append((Object)"\t\t\t\tdocumentation.append(this.mlStartSymbols);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tdocumentation.append(givenDocumentation);");
                it.newLine();
                it.append((Object)"\t\t\tif (!givenDocumentation.endsWith(this.mlEndTagSymbols)) {");
                it.newLine();
                it.append((Object)"\t\t\t\tdocumentation.append(this.mlEndTagSymbols);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\treturn formatter.formatMultilineComment(documentation.toString());");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tdocumentation.append(\"\\n\");");
                it.newLine();
                it.append((Object)"\t\tif (!givenDocumentation.startsWith(this.slStartSymbols)) {");
                it.newLine();
                it.append((Object)"\t\t\tdocumentation.append(this.slStartSymbols);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tdocumentation.append(givenDocumentation);");
                it.newLine();
                it.append((Object)"\t\tif (!givenDocumentation.isEmpty() && !isNewLine(givenDocumentation.charAt(givenDocumentation.length() - 1))) {");
                it.newLine();
                it.append((Object)"\t\t\tdocumentation.append(\"\\n\");");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn formatter.formatSinglelineComment(documentation.toString());");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate static boolean isNewLine(char character) {");
                it.newLine();
                it.append((Object)"\t\tif (character == '\\n' || character == '\\r' || character == '\\f') {");
                it.newLine();
                it.append((Object)"\t\t\treturn true;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn ((((1 << ");
                it.append(Character.class);
                it.append((Object)".LINE_SEPARATOR)");
                it.newLine();
                it.append((Object)"\t\t\t\t| (1 << ");
                it.append(Character.class);
                it.append((Object)".PARAGRAPH_SEPARATOR)) >> ");
                it.append(Character.class);
                it.append((Object)".getType((int) character)) & 1) != 0;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess createJavaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        createJavaFile.writeTo(this.getSrcGen());
    }

    protected void generateDocumentationProviderImpl() {
        TypeReference etype = null;
        LinkedList grammars = new LinkedList();
        grammars.addAll(this.getGrammar().getUsedGrammars());
        while (etype == null && !grammars.isEmpty()) {
            Grammar grammar = (Grammar)grammars.removeFirst();
            grammars.addAll(grammar.getUsedGrammars());
            String gbase = this.getNaming().getRuntimeBasePackage(grammar);
            String providerClassname = gbase + ".documentation." + GrammarUtil.getSimpleName((Grammar)grammar) + "DocumentationProvider";
            try {
                ((Object)((Object)this)).getClass().getClassLoader().loadClass(providerClassname);
                etype = new TypeReference(providerClassname);
            }
            catch (Throwable throwable) {}
        }
        if (etype == null) {
            etype = new TypeReference(MultiLineCommentDocumentationProvider.class);
        }
        final TypeReference extendType = etype;
        final TypeReference provider = this.getDocumentationProviderImpl();
        StringConcatenationClient content = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"/** Provider a documentation string.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)provider.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)extendType);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic String getDocumentation(");
                it.append(EObject.class);
                it.append((Object)" o) {");
                it.newLine();
                it.append((Object)"\t\t// Get the documentation from the Xtext grammar hidden nodes.");
                it.newLine();
                it.append((Object)"\t\tString text = super.getDocumentation(o);");
                it.newLine();
                it.append((Object)"\t\tif (text == null) {");
                it.newLine();
                it.append((Object)"\t\t\t// Get the grammar from the Ecore model element.");
                it.newLine();
                it.append((Object)"\t\t\tif (o instanceof ");
                it.append(EModelElement.class);
                it.append((Object)" $c$value) {");
                it.newLine();
                it.append((Object)"\t\t\t\ttext = ");
                it.append(EcoreUtil.class);
                it.append((Object)".getDocumentation($c$value);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\tif (text == null) {");
                it.newLine();
                it.append((Object)"\t\t\t\t// Get the grammar from the code builder extension.");
                it.newLine();
                it.append((Object)"\t\t\t\t");
                it.append(DocumentationAdapter.class);
                it.append((Object)" adapter = (");
                it.append(DocumentationAdapter.class);
                it.append((Object)") ");
                it.append(EcoreUtil.class);
                it.append((Object)".getAdapter(");
                it.newLine();
                it.append((Object)"\t\t\t\t\t\to.eAdapters(), ");
                it.append(DocumentationAdapter.class);
                it.append((Object)".class);");
                it.newLine();
                it.append((Object)"\t\t\t\tif (adapter != null) {");
                it.newLine();
                it.append((Object)"\t\t\t\t\treturn adapter.getDocumentation();");
                it.newLine();
                it.append((Object)"\t\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn text;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess createJavaFile = this.getFileAccessFactory().createJavaFile(provider, content);
        createJavaFile.writeTo(this.getSrcGen());
    }

    protected void generateEcoreDocumentationSyntacticSequencer() {
        final TypeReference sequencer = this.getSyntacticSequencer();
        final TypeReference customSequencer = this.getEcoreDocumentationSyntacticSequencer();
        final TypeReference innerBlockComment = this.getCodeElementExtractor().getInnerBlockDocumentationAdapter();
        final TypeReference keywordAccessor = this.getCodeElementExtractor().getLanguageKeywordAccessor();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"/** Syntactic sequencer which supports documentations of Ecore elements.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)customSequencer.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)sequencer);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate final ");
                it.append(Set.class);
                it.append((Object)"<");
                it.append(EObject.class);
                it.append((Object)"> documentedSemanticObjects = new ");
                it.append(HashSet.class);
                it.append((Object)"<>();");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate final ");
                it.append(Set.class);
                it.append((Object)"<");
                it.append(EObject.class);
                it.append((Object)"> indocumentedSemanticObjects = new ");
                it.append(HashSet.class);
                it.append((Object)"<>();");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append((Object)innerBlockComment);
                it.append((Object)" lastInnerBlock;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(DocumentationBuilderFragment.this.getInjectType());
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append((Object)DocumentationBuilderFragment.this.getIEcoreDocumentationBuilder());
                it.append((Object)" documentationBuilder;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\t@");
                it.append(DocumentationBuilderFragment.this.getInjectType());
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append((Object)keywordAccessor);
                it.append((Object)" keywords;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append(ISequenceAcceptor.class);
                it.append((Object)" trailingSequenceAcceptor;");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tpublic void init(");
                it.append(ISerializationContext.class);
                it.append((Object)" context, ");
                it.append(EObject.class);
                it.append((Object)" semanticObject,");
                it.newLine();
                it.append((Object)"\t\t\t\t");
                it.append(ISyntacticSequenceAcceptor.class);
                it.append((Object)" sequenceAcceptor, ");
                it.append(ISerializationDiagnostic.Acceptor.class);
                it.append((Object)" errorAcceptor) {");
                it.newLine();
                it.append((Object)"\t\tsuper.init(context, semanticObject, sequenceAcceptor, errorAcceptor);");
                it.newLine();
                it.append((Object)"\t\tif (sequenceAcceptor instanceof ");
                it.append(ISequenceAcceptor.class);
                it.append((Object)" $c$value) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.trailingSequenceAcceptor = $c$value;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\tthis.documentedSemanticObjects.clear();");
                it.newLine();
                it.append((Object)"\t\tthis.indocumentedSemanticObjects.clear();");
                it.newLine();
                it.append((Object)"\t\tthis.lastInnerBlock = null;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected ");
                it.append(ISequenceAcceptor.class);
                it.append((Object)" getTrailingSequenceAcceptor() {");
                it.newLine();
                it.append((Object)"\t\tif (this.trailingSequenceAcceptor == null) {");
                it.newLine();
                it.append((Object)"\t\t\ttry {");
                it.newLine();
                it.append((Object)"\t\t\t\t");
                it.append(Field.class);
                it.append((Object)" delegateField = ");
                it.append(HiddenTokenSequencer.class);
                it.append((Object)".class.getDeclaredField(\"delegate\");");
                it.newLine();
                it.append((Object)"\t\t\t\tdelegateField.setAccessible(true);");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.trailingSequenceAcceptor = (");
                it.append(ISequenceAcceptor.class);
                it.append((Object)") delegateField.get(this.delegate);");
                it.newLine();
                it.append((Object)"\t\t\t} catch (Throwable exception) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthrow new RuntimeException(exception);");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn this.trailingSequenceAcceptor;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected void emitDocumentation(Class<?> semanticObjectType, String comment) {");
                it.newLine();
                it.append((Object)"\t\tfinal String fmtcomment = this.documentationBuilder.build(comment, semanticObjectType);");
                it.newLine();
                it.append((Object)"\t\tif (!");
                it.append(Strings.class);
                it.append((Object)".isEmpty(fmtcomment)) {");
                it.newLine();
                it.append((Object)"\t\t\tfinal ");
                it.append(AbstractRule.class);
                it.append((Object)" rule = this.documentationBuilder.isMultilineCommentFor(semanticObjectType) ? this.documentationBuilder.getMLCommentRule() : this.documentationBuilder.getSLCommentRule();");
                it.newLine();
                it.append((Object)"\t\t\tgetTrailingSequenceAcceptor().acceptComment(rule, fmtcomment, null);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected void emitDocumentation(");
                it.append(EObject.class);
                it.append((Object)" semanticObject) {");
                it.newLine();
                it.append((Object)"\t\tif (this.documentedSemanticObjects.add(semanticObject)) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(DocumentationAdapter.class);
                it.append((Object)" documentationAdapter = (");
                it.append(DocumentationAdapter.class);
                it.append((Object)") ");
                it.append(EcoreUtil.class);
                it.append((Object)".getAdapter(semanticObject.eAdapters(), ");
                it.append(DocumentationAdapter.class);
                it.append((Object)".class);");
                it.newLine();
                it.append((Object)"\t\t\tif (documentationAdapter != null) {");
                it.newLine();
                it.append((Object)"\t\t\t\temitDocumentation(semanticObject.getClass(), documentationAdapter.getDocumentation());");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected void emitInnerDocumentation(");
                it.append(EObject.class);
                it.append((Object)" semanticObject) {");
                it.newLine();
                it.append((Object)"\t\tif (this.indocumentedSemanticObjects.add(semanticObject)) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append((Object)innerBlockComment);
                it.append((Object)" documentationAdapter = (");
                it.append((Object)innerBlockComment);
                it.append((Object)") ");
                it.append(EcoreUtil.class);
                it.append((Object)".getAdapter(semanticObject.eAdapters(), ");
                it.append((Object)innerBlockComment);
                it.append((Object)".class);");
                it.newLine();
                it.append((Object)"\t\t\tif (documentationAdapter != null) {");
                it.newLine();
                it.append((Object)"\t\t\t\temitDocumentation(semanticObject.getClass(), documentationAdapter.getDocumentation());");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprivate ");
                it.append((Object)innerBlockComment);
                it.append((Object)" getInnerDocumentation(EObject semanticObject) {");
                it.newLine();
                it.append((Object)"\t\tif (this.indocumentedSemanticObjects.add(semanticObject)) {");
                it.newLine();
                it.append((Object)"\t\t\treturn (");
                it.append((Object)innerBlockComment);
                it.append((Object)") EcoreUtil.getAdapter(semanticObject.eAdapters(), ");
                it.append((Object)innerBlockComment);
                it.append((Object)".class);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn null;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected void emitUnassignedTokens(");
                it.append(EObject.class);
                it.append((Object)" semanticObject, ");
                it.append(ISyntacticSequencerPDAProvider.ISynTransition.class);
                it.append((Object)" transition,");
                it.newLine();
                it.append((Object)"\t\t\t\t");
                it.append(INode.class);
                it.append((Object)" fromNode, ");
                it.append(INode.class);
                it.append((Object)" toNode) {");
                it.newLine();
                it.append((Object)"\t\tsuper.emitUnassignedTokens(semanticObject, transition, fromNode, toNode);");
                it.newLine();
                it.append((Object)"\t\temitDocumentation(semanticObject);");
                it.newLine();
                it.append((Object)"\t\tif (semanticObject instanceof ");
                it.append(XBlockExpression.class);
                it.append((Object)" cblock) {");
                it.newLine();
                it.append((Object)"\t\t\tthis.lastInnerBlock = getInnerDocumentation(cblock);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"\tprotected void accept(");
                it.append(ISyntacticSequencerPDAProvider.ISynState.class);
                it.append((Object)" emitter, ");
                it.append(INode.class);
                it.append((Object)" node, ");
                it.append(RuleCallStack.class);
                it.append((Object)" stack) {");
                it.newLine();
                it.append((Object)"\t\tsuper.accept(emitter, node, stack);");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append((Object)innerBlockComment);
                it.append((Object)" documentation = this.lastInnerBlock;");
                it.newLine();
                it.append((Object)"\t\tif (documentation != null && emitter.getType() == ");
                it.append(ISyntacticSequencerPDAProvider.SynStateType.class);
                it.append((Object)".UNASSIGEND_KEYWORD) {");
                it.newLine();
                it.append((Object)"\t\t\t");
                it.append(Keyword.class);
                it.append((Object)" keyword = (");
                it.append(Keyword.class);
                it.append((Object)") emitter.getGrammarElement();");
                it.newLine();
                it.append((Object)"\t\t\tString token = node != null ? node.getText() : keyword.getValue();");
                it.newLine();
                it.append((Object)"\t\t\tif (");
                it.append(Strings.class);
                it.append((Object)".equal(token, this.keywords.getLeftCurlyBracketKeyword())) {");
                it.newLine();
                it.append((Object)"\t\t\t\tthis.lastInnerBlock = null;");
                it.newLine();
                it.append((Object)"\t\t\t\temitDocumentation(documentation.getTarget().getClass(), documentation.getDocumentation());");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess createJavaFile = this.getFileAccessFactory().createJavaFile(customSequencer, content);
        createJavaFile.writeTo(this.getSrcGen());
    }
}

