/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BuilderFactoryContributions;
import io.sarl.lang.mwe2.typesystem.TypeSystemToolsConfig;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class ExpressionBuilderFragment
extends AbstractSubCodeBuilderFragment {
    @Inject
    private BuilderFactoryContributions builderFactoryContributions;
    @Inject
    private TypeSystemToolsConfig typeSystemToolsConfig;

    @Pure
    public TypeReference getTypeDefaultValueProviderInterface() {
        return this.typeSystemToolsConfig.getDefaultValueProviderInterface(this.getGrammar());
    }

    @Pure
    public TypeReference getExpressionBuilderImplCustom() {
        return this.getCodeElementExtractor().getElementBuilderImplCustom("Expression");
    }

    @Override
    public void generate() {
        this.generateIExpressionBuilder();
        this.generateExpressionBuilderImpl();
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            this.generateExpressionAppender();
        }
        this.generateBuilderFactoryContributions();
        super.generate();
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        this.bindTypeReferences(factory, this.getExpressionBuilderInterface(), this.getExpressionBuilderImpl(), this.getExpressionBuilderImplCustom());
    }

    protected void generateIExpressionBuilder() {
        final TypeReference builder = this.getExpressionBuilderInterface();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + ExpressionBuilderFragment.this.getLanguageName() + " XExpression."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public interface ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)ExpressionBuilderFragment.this.generateMembers(true, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateExpressionBuilderImpl() {
        final TypeReference builderInterface = this.getExpressionBuilderInterface();
        final TypeReference builder = this.getExpressionBuilderImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + ExpressionBuilderFragment.this.getLanguageName() + " XExpression."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)ExpressionBuilderFragment.this.getAbstractBuilderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)ExpressionBuilderFragment.this.generateMembers(false, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateExpressionAppender() {
        final TypeReference builderInterface = this.getExpressionBuilderInterface();
        final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl("Expression");
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + ExpressionBuilderFragment.this.getLanguageName() + " XExpression."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)appender.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)ExpressionBuilderFragment.this.getCodeElementExtractor().getAbstractAppenderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)ExpressionBuilderFragment.this.generateAppenderMembers(appender.getSimpleName(), builderInterface, "getXExpression()"));
                it.append((Object)ExpressionBuilderFragment.this.generateMembers(false, true));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(appender, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected StringConcatenationClient generateMembers(final boolean forInterface, final boolean forAppender) {
        final ExpressionContextDescription expressionContext = this.getExpressionContextDescription();
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                if (!forInterface && !forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append(EObject.class);
                    it.append((Object)" context;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append(Procedures.Procedure1.class);
                    it.append((Object)"<? super ");
                    it.append(XExpression.class);
                    it.append((Object)"> setter;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append(XExpression.class);
                    it.append((Object)" expr;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Inject.class);
                    it.newLine();
                    it.append((Object)"\tprivate ");
                    it.append((Object)ExpressionBuilderFragment.this.getTypeDefaultValueProviderInterface());
                    it.append((Object)" defaultValueProvider;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else {
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for the type reference use");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(JvmType.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context in which the type is defined");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, ");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext() {");
                    it.newLine();
                    it.append((Object)"\t\treturn this.builder.getTypeResolutionContext();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Initialize the expression.");
                it.newLine();
                it.append((Object)"\t * @param context the context of the expressions.");
                it.newLine();
                it.append((Object)"\t * @param setter the object that permits to assign the expression to the context.");
                it.newLine();
                it.append((Object)"\t * @param typeContext the context for type resolution.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void eInit(");
                it.append(EObject.class);
                it.append((Object)" context, ");
                it.append(Procedures.Procedure1.class);
                it.append((Object)"<? super ");
                it.append(XExpression.class);
                it.append((Object)"> setter, ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" typeContext)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.eInit(context, setter, typeContext);");
                    } else {
                        it.append((Object)"\t\tsetTypeResolutionContext(typeContext);");
                        it.newLine();
                        it.append((Object)"\t\tthis.context = context;");
                        it.newLine();
                        it.append((Object)"\t\tthis.setter = setter;");
                        it.newLine();
                        it.append((Object)"\t\tthis.expr = null;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the last created expression.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the last created expression.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(XExpression.class);
                it.append((Object)" getXExpression()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getXExpression();");
                    } else {
                        it.append((Object)"\t\treturn this.expr;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the resource to which the XExpression is attached.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(Resource.class);
                it.append((Object)" eResource()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.eResource();");
                    } else {
                        it.append((Object)"\t\tfinal var expr = getXExpression();");
                        it.newLine();
                        it.append((Object)"\t\tif (expr != null) {");
                        it.newLine();
                        it.append((Object)"\t\t\treturn expr.eResource();");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\treturn this.context.eResource();");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Change the expression in the container.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param expression the textual representation of the expression.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)ExpressionBuilderFragment.this.getExpressionBuilderInterface());
                it.append((Object)" setExpression(String expression)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.setExpression(expression);");
                    } else {
                        it.append((Object)"\t\tthis.expr = fromString(expression);");
                        it.newLine();
                        it.append((Object)"\t\tthis.setter.apply(this.expr);");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Change the expression in the container.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param expression the expression.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)ExpressionBuilderFragment.this.getExpressionBuilderInterface());
                it.append((Object)" setXExpression(");
                it.append(XExpression.class);
                it.append((Object)" expression)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.setXExpression(expression);");
                    } else {
                        it.append((Object)"\t\tthis.expr = expression;");
                        it.newLine();
                        it.append((Object)"\t\tthis.setter.apply(this.expr);");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (!forInterface && !forAppender) {
                    it.append((Object)"\t/** Generate a piece of ");
                    it.append((Object)ExpressionBuilderFragment.this.getLanguageName());
                    it.append((Object)" code that permits to compile an XExpression.");
                    it.newLine();
                    it.append((Object)"\t *");
                    it.newLine();
                    it.append((Object)"\t * @param expression the expression to compile.");
                    it.newLine();
                    it.append((Object)"\t * @return the ");
                    it.append((Object)ExpressionBuilderFragment.this.getLanguageName());
                    it.append((Object)" code.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tstatic String generateExpressionCode(String expression) {");
                    it.newLine();
                    it.append((Object)"\t\treturn \"");
                    it.append((Object)expressionContext.getContainerKeyword());
                    it.append((Object)" ____synthesis { ");
                    it.append((Object)expressionContext.getFieldDeclarationKeyword());
                    it.append((Object)" ____fakefield = \" + expression + \" }\";");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tstatic String generateTypenameCode(String typeName) {");
                    it.newLine();
                    it.append((Object)"\t\treturn \"");
                    it.append((Object)expressionContext.getContainerKeyword());
                    it.append((Object)" ____synthesis { ");
                    it.append((Object)expressionContext.getFieldDeclarationKeyword());
                    it.append((Object)" ____fakefield : \" + typeName + \" }\";");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tstatic ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)" parseType(");
                    it.append(Notifier.class);
                    it.append((Object)" context, String typeName, ");
                    it.append((Object)ExpressionBuilderFragment.this.getAbstractBuilderImpl());
                    it.append((Object)" caller) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet = toResource(context).getResourceSet();");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append(URI.class);
                    it.append((Object)" uri = caller.computeUnusedUri(resourceSet);");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append(Resource.class);
                    it.append((Object)" resource = caller.getResourceFactory().createResource(uri);");
                    it.newLine();
                    it.append((Object)"\t\tresourceSet.getResources().add(resource);");
                    it.newLine();
                    it.append((Object)"\t\ttry (");
                    it.append(StringInputStream.class);
                    it.append((Object)" is = new ");
                    it.append(StringInputStream.class);
                    it.append((Object)"(generateTypenameCode(typeName))) {");
                    it.newLine();
                    it.append((Object)"\t\t\tresource.load(is, null);");
                    it.newLine();
                    it.append((Object)"\t\t\t");
                    it.append((Object)ExpressionBuilderFragment.this.getCodeElementExtractor().getLanguageScriptInterface());
                    it.append((Object)" script = resource.getContents().isEmpty() ? null : (");
                    it.append((Object)ExpressionBuilderFragment.this.getCodeElementExtractor().getLanguageScriptInterface());
                    it.append((Object)") resource.getContents().get(0);");
                    it.newLine();
                    it.append((Object)"\t\t\t");
                    it.append((Object)expressionContext.getContainerDescription().elementType());
                    it.append((Object)" topElement = (");
                    it.append((Object)expressionContext.getContainerDescription().elementType());
                    it.append((Object)") script.");
                    it.append((Object)ExpressionBuilderFragment.this.getLanguageScriptMemberGetter());
                    it.append((Object)"().get(0);");
                    it.newLine();
                    it.append((Object)"\t\t\t");
                    it.append((Object)expressionContext.getMemberDescription().elementType());
                    it.append((Object)" member = (");
                    it.append((Object)expressionContext.getMemberDescription().elementType());
                    it.append((Object)") topElement.get");
                    it.append((Object)Strings.toFirstUpper((String)ExpressionBuilderFragment.this.getCodeBuilderConfig().getMemberCollectionExtensionGrammarName()));
                    it.append((Object)"().get(0);");
                    it.newLine();
                    it.append((Object)"\t\t\t");
                    it.append(JvmTypeReference.class);
                    it.append((Object)" reference = member.getType();");
                    it.newLine();
                    it.append((Object)"\t\t\tif (reference instanceof ");
                    it.append(JvmParameterizedTypeReference.class);
                    it.append((Object)" pref) {");
                    it.newLine();
                    it.append((Object)"\t\t\t\tif (!pref.getArguments().isEmpty()) {");
                    it.newLine();
                    it.append((Object)"\t\t\t\t\t");
                    it.append(EcoreUtil2.class);
                    it.append((Object)".resolveAll(resource);");
                    it.newLine();
                    it.append((Object)"\t\t\t\t}");
                    it.newLine();
                    it.append((Object)"\t\t\t}");
                    it.newLine();
                    it.append((Object)"\t\t\treturn reference;");
                    it.newLine();
                    it.append((Object)"\t\t} catch (");
                    it.append(Exception.class);
                    it.append((Object)" exception) {");
                    it.newLine();
                    it.append((Object)"\t\t\tthrow new ");
                    it.append(TypeNotPresentException.class);
                    it.append((Object)"(typeName, exception);");
                    it.newLine();
                    it.append((Object)"\t\t} finally {");
                    it.newLine();
                    it.append((Object)"\t\t\tresourceSet.getResources().remove(resource);");
                    it.newLine();
                    it.append((Object)"\t\t}");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Create an expression but does not change the container.");
                    it.newLine();
                    it.append((Object)"\t *");
                    it.newLine();
                    it.append((Object)"\t * @param expression the textual representation of the expression.");
                    it.newLine();
                    it.append((Object)"\t * @return the expression.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tprotected ");
                    it.append(XExpression.class);
                    it.append((Object)" fromString(String expression)");
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\tif (!");
                    it.append(Strings.class);
                    it.append((Object)".isEmpty(expression)) {");
                    it.newLine();
                    it.append((Object)"\t\t\t");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet = this.context.eResource().getResourceSet();");
                    it.newLine();
                    it.append((Object)"\t\t\t");
                    it.append(URI.class);
                    it.append((Object)" uri = computeUnusedUri(resourceSet);");
                    it.newLine();
                    it.append((Object)"\t\t\t");
                    it.append(Resource.class);
                    it.append((Object)" resource = getResourceFactory().createResource(uri);");
                    it.newLine();
                    it.append((Object)"\t\t\tresourceSet.getResources().add(resource);");
                    it.newLine();
                    it.append((Object)"\t\t\ttry (");
                    it.append(StringInputStream.class);
                    it.append((Object)" is = new ");
                    it.append(StringInputStream.class);
                    it.append((Object)"(generateExpressionCode(expression))) {");
                    it.newLine();
                    it.append((Object)"\t\t\t\tresource.load(is, null);");
                    it.newLine();
                    it.append((Object)"\t\t\t\t");
                    it.append((Object)ExpressionBuilderFragment.this.getCodeElementExtractor().getLanguageScriptInterface());
                    it.append((Object)" script = resource.getContents().isEmpty() ? null : (");
                    it.append((Object)ExpressionBuilderFragment.this.getCodeElementExtractor().getLanguageScriptInterface());
                    it.append((Object)") resource.getContents().get(0);");
                    it.newLine();
                    it.append((Object)"\t\t\t\t");
                    it.append((Object)expressionContext.getContainerDescription().elementType());
                    it.append((Object)" topElement = (");
                    it.append((Object)expressionContext.getContainerDescription().elementType());
                    it.append((Object)") script.");
                    it.append((Object)ExpressionBuilderFragment.this.getLanguageScriptMemberGetter());
                    it.append((Object)"().get(0);");
                    it.newLine();
                    it.append((Object)"\t\t\t\t");
                    it.append((Object)expressionContext.getMemberDescription().elementType());
                    it.append((Object)" member = (");
                    it.append((Object)expressionContext.getMemberDescription().elementType());
                    it.append((Object)") topElement.get");
                    it.append((Object)Strings.toFirstUpper((String)ExpressionBuilderFragment.this.getCodeBuilderConfig().getMemberCollectionExtensionGrammarName()));
                    it.append((Object)"().get(0);");
                    it.newLine();
                    it.append((Object)"\t\t\t\treturn member.get");
                    it.append((Object)Strings.toFirstUpper((String)expressionContext.getExpressionAssignment().getFeature()));
                    it.append((Object)"();");
                    it.newLine();
                    it.append((Object)"\t\t\t} catch (Throwable exception) {");
                    it.newLine();
                    it.append((Object)"\t\t\t\tthrow new RuntimeException(exception);");
                    it.newLine();
                    it.append((Object)"\t\t\t} finally {");
                    it.newLine();
                    it.append((Object)"\t\t\t\tresourceSet.getResources().remove(resource);");
                    it.newLine();
                    it.append((Object)"\t\t\t}");
                    it.newLine();
                    it.append((Object)"\t\t}");
                    it.newLine();
                    it.append((Object)"\t\tthrow new IllegalArgumentException(\"not a valid expression\");");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the XExpression for the default value associated to the given type.");
                it.newLine();
                it.append((Object)"\t * @param type the type for which the default value should be determined.");
                it.newLine();
                it.append((Object)"\t * @return the default value.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(XExpression.class);
                it.append((Object)" getDefaultXExpressionForType(String type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getDefaultXExpressionForType(type);");
                    } else {
                        it.append((Object)"\t\treturn this.defaultValueProvider.getDefaultValueXExpression(type, this.context);");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the XExpression for the default value associated to the given type.");
                it.newLine();
                it.append((Object)"\t * @param type the type for which the default value should be determined.");
                it.newLine();
                it.append((Object)"\t * @return the default value.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(XExpression.class);
                it.append((Object)" getDefaultXExpressionForType(");
                it.append(JvmTypeReference.class);
                it.append((Object)" type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getDefaultXExpressionForType(type);");
                    } else {
                        it.append((Object)"\t\treturn getDefaultXExpressionForType(type.getType().getIdentifier());");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the default value for the given type.");
                it.newLine();
                it.append((Object)"\t * @param type the type for which the default value should be determined.");
                it.newLine();
                it.append((Object)"\t * @return the default value.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"String getDefaultValueForType(String type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getDefaultValueForType(type);");
                    } else {
                        it.append((Object)"\t\treturn this.defaultValueProvider.getDefaultValueInSarlSyntax(type);");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the default value for the given type.");
                it.newLine();
                it.append((Object)"\t * @param type the type for which the default value should be determined.");
                it.newLine();
                it.append((Object)"\t * @return the default value.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"String getDefaultValueForType(");
                it.append(JvmTypeReference.class);
                it.append((Object)" type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getDefaultValueForType(type);");
                    } else {
                        it.append((Object)"\t\treturn getDefaultValueForType(type.getType().getIdentifier());");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)ExpressionBuilderFragment.this.generateStandardCommentFunctions(forInterface, forAppender, "getXExpression()", ExpressionBuilderFragment.this.getExpressionBuilderInterface()));
                if (!forInterface) {
                    it.append((Object)"\t@");
                    it.append(Override.class);
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(String.class);
                    it.append((Object)" toString() {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    if (forAppender) {
                        it.append((Object)"this.builder.toString();");
                    } else {
                        it.append(EmfFormatter.class);
                        it.append((Object)".objToStr(getXExpression());");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Create a reference to \"this\" object or to the current type.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the reference.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(XFeatureCall.class);
                it.append((Object)" createReferenceToThis()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    if (forAppender) {
                        it.append((Object)"return this.builder.createReferenceToThis();");
                    } else {
                        it.append((Object)"final ");
                        it.append(XExpression.class);
                        it.append((Object)" expr = getXExpression();");
                        it.newLine();
                        it.append((Object)"\t\t");
                        it.append(XtendTypeDeclaration.class);
                        it.append((Object)" type = ");
                        it.append(EcoreUtil2.class);
                        it.append((Object)".getContainerOfType(expr, ");
                        it.append(XtendTypeDeclaration.class);
                        it.append((Object)".class);");
                        it.newLine();
                        it.append((Object)"\t\t");
                        it.append(JvmType.class);
                        it.append((Object)" jvmObject = getAssociatedElement(");
                        it.append(JvmType.class);
                        it.append((Object)".class, type, expr.eResource(), true);");
                        it.newLine();
                        it.append((Object)"\t\tfinal ");
                        it.append(XFeatureCall.class);
                        it.append((Object)" thisFeature = ");
                        it.append(XbaseFactory.class);
                        it.append((Object)".eINSTANCE.createXFeatureCall();");
                        it.newLine();
                        it.append((Object)"\t\tthisFeature.setFeature(jvmObject);");
                        it.newLine();
                        it.append((Object)"\t\treturn thisFeature;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Create a reference to \"super\" object or to the super type.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the reference.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(XFeatureCall.class);
                it.append((Object)" createReferenceToSuper()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    if (forAppender) {
                        it.append((Object)"return this.builder.createReferenceToSuper();");
                    } else {
                        it.append((Object)"final ");
                        it.append(XExpression.class);
                        it.append((Object)" expr = getXExpression();");
                        it.newLine();
                        it.append((Object)"\t\t");
                        it.append(XtendTypeDeclaration.class);
                        it.append((Object)" type = ");
                        it.append(EcoreUtil2.class);
                        it.append((Object)".getContainerOfType(expr, ");
                        it.append(XtendTypeDeclaration.class);
                        it.append((Object)".class);");
                        it.newLine();
                        it.append((Object)"\t\t");
                        it.append(JvmType.class);
                        it.append((Object)" jvmObject = getAssociatedElement(");
                        it.append(JvmType.class);
                        it.append((Object)".class, type, expr.eResource(), true);");
                        it.newLine();
                        it.append((Object)"\t\tfinal ");
                        it.append(XFeatureCall.class);
                        it.append((Object)" superFeature = ");
                        it.append(XbaseFactory.class);
                        it.append((Object)".eINSTANCE.createXFeatureCall();");
                        it.newLine();
                        it.append((Object)"\t\t");
                        it.append(JvmIdentifiableElement.class);
                        it.append((Object)" feature;");
                        it.newLine();
                        it.append((Object)"\t\tif (jvmObject instanceof ");
                        it.append(JvmDeclaredType.class);
                        it.append((Object)" $c$value) {");
                        it.newLine();
                        it.append((Object)"\t\t\tfeature = $c$value.getExtendedClass().getType();");
                        it.newLine();
                        it.append((Object)"\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\tfeature = findType(expr, getQualifiedName(type)).getType();");
                        it.newLine();
                        it.append((Object)"\t\t\tif (feature instanceof ");
                        it.append(JvmDeclaredType.class);
                        it.append((Object)" $c$value) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tfeature = $c$value.getExtendedClass().getType();");
                        it.newLine();
                        it.append((Object)"\t\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tfeature = null;");
                        it.newLine();
                        it.append((Object)"\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\tif (feature == null) {");
                        it.newLine();
                        it.append((Object)"\t\t\treturn null;");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\tsuperFeature.setFeature(feature);");
                        it.newLine();
                        it.append((Object)"\t\treturn superFeature;");
                    }
                    it.newLine();
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (forInterface) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tvoid dispose();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic void dispose() {");
                    it.newLine();
                    it.append((Object)"\t\tthis.builder.dispose();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            }
        };
    }

    protected String ensureContainerKeyword(EObject grammarContainer) {
        UnmodifiableIterator iterator = Iterators.filter((Iterator)grammarContainer.eContents().iterator(), Keyword.class);
        if (iterator.hasNext()) {
            return ((Keyword)iterator.next()).getValue();
        }
        return this.getExpressionConfig().getFieldContainerDeclarationKeyword();
    }

    protected String ensureFieldDeclarationKeyword(CodeElementExtractor.ElementDescription memberDescription) {
        List<String> modifiers = this.getCodeBuilderConfig().getModifiers().get(memberDescription.name());
        if (modifiers != null && !modifiers.isEmpty()) {
            return modifiers.get(0);
        }
        return this.getExpressionConfig().getFieldDeclarationKeyword();
    }

    protected ExpressionContextDescription getExpressionContextDescription() {
        for (CodeElementExtractor.ElementDescription containerDescription : this.getCodeElementExtractor().getTopElements(this.getGrammar(), this.getCodeBuilderConfig())) {
            AbstractRule rule = this.getMemberRule(containerDescription);
            if (rule == null) continue;
            Pattern fieldTypePattern = Pattern.compile(this.getExpressionConfig().getExpressionFieldTypenamePattern());
            ExpressionContextDescription description = (ExpressionContextDescription)this.getCodeElementExtractor().visitMemberElements(containerDescription, (EObject)rule, null, (it, grammarContainer, memberContainer, classifier) -> {
                if (fieldTypePattern.matcher(classifier.getName()).find()) {
                    Assignment expressionAssignment = ExpressionBuilderFragment.findAssignmentFromTerminalPattern(memberContainer, this.getExpressionConfig().getExpressionGrammarPattern());
                    CodeElementExtractor.ElementDescription memberDescription = it.newElementDescription(classifier.getName(), (EObject)memberContainer, (EClassifier)classifier, XExpression.class);
                    return new ExpressionContextDescription(containerDescription, memberDescription, this.ensureContainerKeyword(containerDescription.grammarComponent()), this.ensureFieldDeclarationKeyword(memberDescription), expressionAssignment);
                }
                return null;
            }, null, null);
            if (description == null) continue;
            return description;
        }
        return null;
    }

    protected void generateBuilderFactoryContributions() {
        final ExpressionContextDescription expressionContext = this.getExpressionContextDescription();
        String createFunctionName = "createXExpression";
        this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("\t/** Create the factory for a " + ExpressionBuilderFragment.this.getLanguageName() + " XExpression."));
                it.newLine();
                it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                it.newLine();
                it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)ExpressionBuilderFragment.this.getExpressionBuilderInterface());
                it.append((Object)" ");
                it.append((Object)"createXExpression");
                it.append((Object)"(");
                it.append(ResourceSet.class);
                it.append((Object)" resourceSet) {");
                it.newLine();
                it.append((Object)"\t\treturn ");
                it.append((Object)"createXExpression");
                it.append((Object)"(createResource(resourceSet));");
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)("\t/** Create the factory for a " + ExpressionBuilderFragment.this.getLanguageName() + " XExpression."));
                it.newLine();
                it.append((Object)"\t * @param resource the resource that must be used for");
                it.newLine();
                it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)ExpressionBuilderFragment.this.getExpressionBuilderInterface());
                it.append((Object)" ");
                it.append((Object)"createXExpression");
                it.append((Object)"(");
                it.append(Resource.class);
                it.append((Object)" resource) {");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append((Object)ExpressionBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" script = createScript(getFooPackageName(), resource);");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append((Object)expressionContext.getContainerDescription().builderInterfaceType());
                it.append((Object)" topElement = script.add");
                it.append((Object)Strings.toFirstUpper((String)expressionContext.getContainerDescription().elementType().getSimpleName()));
                it.append((Object)"(getFooTypeName());");
                it.newLine();
                it.append((Object)"\t\tfinal ");
                it.append((Object)expressionContext.getMemberDescription().builderInterfaceType());
                it.append((Object)" memberElement = topElement.add");
                it.append((Object)Strings.toFirstUpper((String)expressionContext.getMemberDescription().elementType().getSimpleName()));
                it.append((Object)"(getFooMemberName());");
                it.newLine();
                it.append((Object)"\t\treturn memberElement.get");
                it.append((Object)Strings.toFirstUpper((String)expressionContext.getExpressionAssignment().getFeature()));
                it.append((Object)"();");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        });
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            String buildFunctionName = "buildXExpression";
            final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl("Expression");
            this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create the appender for a " + ExpressionBuilderFragment.this.getLanguageName() + " XExpression."));
                    it.newLine();
                    it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)"buildXExpression");
                    it.append((Object)"(");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet) {");
                    it.newLine();
                    it.append((Object)"\t\treturn new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)"createXExpression");
                    it.append((Object)"(resourceSet));");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the appender for a " + ExpressionBuilderFragment.this.getLanguageName() + " XExpression."));
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)"buildXExpression");
                    it.append((Object)"(");
                    it.append(Resource.class);
                    it.append((Object)" resource) {");
                    it.newLine();
                    it.append((Object)"\t\treturn new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)"createXExpression");
                    it.append((Object)"(resource));");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
    }

    public static class ExpressionContextDescription {
        private final CodeElementExtractor.ElementDescription member;
        private final CodeElementExtractor.ElementDescription container;
        private final String containerKeyword;
        private final String fieldDeclarationKeyword;
        private final Assignment expressionAssignment;

        public ExpressionContextDescription(CodeElementExtractor.ElementDescription container, CodeElementExtractor.ElementDescription member, String containerKeyword, String fieldDeclarationKeyword, Assignment expressionAssignment) {
            this.container = container;
            this.member = member;
            this.containerKeyword = containerKeyword;
            this.fieldDeclarationKeyword = fieldDeclarationKeyword;
            this.expressionAssignment = expressionAssignment;
        }

        public CodeElementExtractor.ElementDescription getContainerDescription() {
            return this.container;
        }

        public CodeElementExtractor.ElementDescription getMemberDescription() {
            return this.member;
        }

        public Assignment getExpressionAssignment() {
            return this.expressionAssignment;
        }

        public String getContainerKeyword() {
            return this.containerKeyword;
        }

        public String getFieldDeclarationKeyword() {
            return this.fieldDeclarationKeyword;
        }
    }
}

