/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class FormalParameterBuilderFragment
extends AbstractSubCodeBuilderFragment {
    @Pure
    public TypeReference getFormalParameterBuilderImpl() {
        return this.getCodeElementExtractor().getElementBuilderImpl("FormalParameter");
    }

    @Pure
    public TypeReference getFormalParameterBuilderImplCustom() {
        return this.getCodeElementExtractor().getElementBuilderImplCustom("FormalParameter");
    }

    @Override
    public void generate() {
        this.generateIFormalParameterBuilder();
        this.generateFormalParameterBuilderImpl();
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            this.generateFormalParameterAppender();
        }
        super.generate();
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        this.bindTypeReferences(factory, this.getFormalParameterBuilderInterface(), this.getFormalParameterBuilderImpl(), this.getFormalParameterBuilderImplCustom());
    }

    protected void generateIFormalParameterBuilder() {
        final TypeReference builder = this.getFormalParameterBuilderInterface();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + FormalParameterBuilderFragment.this.getLanguageName() + " formal parameter."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public interface ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)FormalParameterBuilderFragment.this.generateMembers(true, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateFormalParameterBuilderImpl() {
        final TypeReference builderInterface = this.getFormalParameterBuilderInterface();
        final TypeReference builder = this.getFormalParameterBuilderImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + FormalParameterBuilderFragment.this.getLanguageName() + " formal parameter."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)FormalParameterBuilderFragment.this.getAbstractBuilderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)FormalParameterBuilderFragment.this.generateMembers(false, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateFormalParameterAppender() {
        CodeElementExtractor.ElementDescription parameter = this.getCodeElementExtractor().getFormalParameter();
        final String accessor = "get" + Strings.toFirstUpper((String)parameter.elementType().getSimpleName()) + "()";
        final TypeReference builderInterface = this.getFormalParameterBuilderInterface();
        final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl("FormalParameter");
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Appender of a " + FormalParameterBuilderFragment.this.getLanguageName() + " formal parameter."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)appender.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)FormalParameterBuilderFragment.this.getCodeElementExtractor().getAbstractAppenderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)FormalParameterBuilderFragment.this.generateAppenderMembers(appender.getSimpleName(), builderInterface, accessor));
                it.append((Object)FormalParameterBuilderFragment.this.generateMembers(false, true));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(appender, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected StringConcatenationClient generateMembers(final boolean forInterface, final boolean forAppender) {
        final CodeElementExtractor.ElementDescription parameter = this.getCodeElementExtractor().getFormalParameter();
        final FormalParameterDescription exparameter = new FormalParameterDescription(parameter, FormalParameterBuilderFragment.findAssignmentFromFeatureName(parameter.grammarComponent(), this.getCodeBuilderConfig().getParameterDefaultValueGrammarName()));
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                if (!forInterface && !forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Inject.class);
                    it.newLine();
                    it.append((Object)"\tprivate ");
                    it.append(Provider.class);
                    it.append((Object)"<");
                    it.append((Object)FormalParameterBuilderFragment.this.getExpressionBuilderInterface());
                    it.append((Object)"> expressionProvider;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append((Object)FormalParameterBuilderFragment.this.getCodeElementExtractor().getFormalParameterContainerType());
                    it.append((Object)" context;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append((Object)parameter.elementType());
                    it.append((Object)" parameter;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append((Object)FormalParameterBuilderFragment.this.getExpressionBuilderInterface());
                    it.append((Object)" defaultValue;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Inject.class);
                    it.newLine();
                    it.append((Object)"\t\tprivate ");
                    it.append(TypesFactory.class);
                    it.append((Object)" jvmTypesFactory;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Inject.class);
                    it.newLine();
                    it.append((Object)" private ");
                    it.append(IFragmentProvider.class);
                    it.append((Object)" fragmentProvider;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else {
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for the type reference use");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(JvmType.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context in which the type is defined");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, ");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext() {");
                    it.newLine();
                    it.append((Object)"\t\treturn this.builder.getTypeResolutionContext();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Initialize the formal parameter.");
                it.newLine();
                it.append((Object)"\t * @param context the context of the formal parameter.");
                it.newLine();
                it.append((Object)"\t * @param name the name of the formal parameter.");
                it.newLine();
                it.append((Object)"\t * @param typeContext the context for type resolution.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void eInit(");
                it.append((Object)FormalParameterBuilderFragment.this.getCodeElementExtractor().getFormalParameterContainerType());
                it.append((Object)" context, String name, ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" typeContext)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.eInit(context, name, typeContext);");
                    } else {
                        it.append((Object)"\t\tsetTypeResolutionContext(typeContext);");
                        it.newLine();
                        it.append((Object)"\t\tthis.context = context;");
                        it.newLine();
                        it.append((Object)"\t\tthis.parameter = ");
                        it.append((Object)FormalParameterBuilderFragment.this.getXFactoryFor(parameter.elementType()));
                        it.append((Object)".eINSTANCE.create");
                        it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                        it.append((Object)"();");
                        it.newLine();
                        it.append((Object)"\t\tthis.parameter.set");
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterNameGrammarName()));
                        it.append((Object)"(name);");
                        it.newLine();
                        it.append((Object)"\t\tthis.context.get");
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterListGrammarName()));
                        it.append((Object)"().add(this.parameter);");
                        it.newLine();
                        it.append((Object)"\t\tthis.parameter.set");
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterTypeGrammarName()));
                        it.append((Object)"(newTypeRef(this.context, Object.class.getName()));");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the created parameter.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the parameter.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)parameter.elementType());
                it.append((Object)" get");
                it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                it.append((Object)"()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.get");
                        it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                        it.append((Object)"();");
                    } else {
                        it.append((Object)"\t\treturn this.parameter;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Add a reference to this formal parameter in the given container.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param container the feature call that is supposed to contains the replied identifiable element.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)FormalParameterBuilderFragment.this.getFormalParameterBuilderInterface());
                it.append((Object)" setReferenceInto(");
                it.append(XFeatureCall.class);
                it.append((Object)" container) ");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)"{");
                    it.newLine();
                    it.append((Object)"\t\t");
                    if (forAppender) {
                        it.append((Object)"this.builder.setReferenceInto(container);");
                    } else {
                        it.append(JvmVoid.class);
                        it.append((Object)" jvmVoid = this.jvmTypesFactory.createJvmVoid();");
                        it.newLine();
                        it.append((Object)"\t\tif (jvmVoid instanceof ");
                        it.append(InternalEObject.class);
                        it.append((Object)" jvmVoidProxy) {");
                        it.newLine();
                        it.append((Object)"\t\t\tfinal ");
                        it.append(EObject.class);
                        it.append((Object)" param = getSarlFormalParameter();");
                        it.newLine();
                        it.append((Object)"\t\t\tfinal ");
                        it.append(Resource.class);
                        it.append((Object)" resource = param.eResource();");
                        it.newLine();
                        it.append((Object)"\t\t\t// Get the derived object");
                        it.newLine();
                        it.append((Object)"\t\t\tfinal ");
                        it.append((Object)parameter.elementType());
                        it.append((Object)" jvmParam = getAssociatedElement(");
                        it.append((Object)parameter.elementType());
                        it.append((Object)".class, param, resource, true);");
                        it.newLine();
                        it.append((Object)"\t\t\t// Set the proxy URI");
                        it.newLine();
                        it.append((Object)"\t\t\tfinal ");
                        it.append(URI.class);
                        it.append((Object)" uri = ");
                        it.append(EcoreUtil2.class);
                        it.append((Object)".getNormalizedURI(jvmParam);");
                        it.newLine();
                        it.append((Object)"\t\t\tjvmVoidProxy.eSetProxyURI(uri);");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\tcontainer.setFeature(jvmVoid);");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the resource to which the formal parameter is attached.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(Resource.class);
                it.append((Object)" eResource()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\treturn get");
                    it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                    it.append((Object)"().eResource();");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Change the type.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param type the formal parameter type.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)FormalParameterBuilderFragment.this.getFormalParameterBuilderInterface());
                it.append((Object)" set");
                it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterTypeGrammarName()));
                it.append((Object)"(String type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.set");
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterTypeGrammarName()));
                        it.append((Object)"(type);");
                    } else {
                        it.append((Object)"\t\tString typeName;");
                        it.newLine();
                        it.append((Object)"\t\tif (");
                        it.append(Strings.class);
                        it.append((Object)".isEmpty(type)) {");
                        it.newLine();
                        it.append((Object)"\t\t\ttypeName = Object.class.getName();");
                        it.newLine();
                        it.append((Object)"\t\t} else {");
                        it.newLine();
                        it.append((Object)"\t\t\ttypeName = type;");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\tthis.parameter.set");
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterTypeGrammarName()));
                        it.append((Object)"(newTypeRef(this.context, typeName));");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Change the type.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @param type the formal parameter type.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)FormalParameterBuilderFragment.this.getFormalParameterBuilderInterface());
                it.append((Object)" set");
                it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterTypeGrammarName()));
                it.append((Object)"(");
                it.append(JvmTypeReference.class);
                it.append((Object)" type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.set");
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterTypeGrammarName()));
                        it.append((Object)"(type);");
                    } else {
                        it.append((Object)"\t\tthis.parameter.set");
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterTypeGrammarName()));
                        it.append((Object)"(type);");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (!Strings.isEmpty((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterVarArgGrammarName())) {
                    it.append((Object)"\t/** Change the variadic property of the parameter.");
                    it.newLine();
                    it.append((Object)"\t *");
                    it.newLine();
                    it.append((Object)"\t * @param isVariadic indicates if the parameter is variadic.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)FormalParameterBuilderFragment.this.getFormalParameterBuilderInterface());
                    it.append((Object)" set");
                    it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterVarArgGrammarName()));
                    it.append((Object)"(boolean isVariadic)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.set");
                        } else {
                            it.append((Object)"\t\tthis.parameter.set");
                        }
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterVarArgGrammarName()));
                        it.append((Object)"(isVariadic);");
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (!Strings.isEmpty((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterExtensionGrammarName())) {
                    it.append((Object)"\t/** Change the extension flag of the parameter.");
                    it.newLine();
                    it.append((Object)"\t *");
                    it.newLine();
                    it.append((Object)"\t * @param isExtension indicates if the parameter is defined as an extension.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)FormalParameterBuilderFragment.this.getFormalParameterBuilderInterface());
                    it.append((Object)" set");
                    it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterExtensionGrammarName()));
                    it.append((Object)"(boolean isExtension)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.set");
                        } else {
                            it.append((Object)"\t\tthis.parameter.set");
                        }
                        it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterExtensionGrammarName()));
                        it.append((Object)"(isExtension);");
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (exparameter.getDefaultValueAssignment() != null) {
                    it.append((Object)"\t/** Replies the default value of the parameter.");
                    it.newLine();
                    it.append((Object)"\t * @return the default value builder.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)FormalParameterBuilderFragment.this.getExpressionBuilderInterface());
                    String accessor = "get" + Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterDefaultValueGrammarName()) + "()";
                    it.append((Object)" ");
                    it.append((Object)accessor);
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\treturn this.builder.get");
                            it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterDefaultValueGrammarName()));
                            it.append((Object)"();");
                        } else {
                            it.append((Object)"\t\tif (this.defaultValue == null) {");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.defaultValue = this.expressionProvider.get();");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.defaultValue.eInit(this.parameter, new ");
                            it.append(Procedures.class);
                            it.append((Object)".Procedure1<");
                            it.append(XExpression.class);
                            it.append((Object)">() {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\tpublic void apply(");
                            it.append(XExpression.class);
                            it.append((Object)" it) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\t\tget");
                            it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                            it.append((Object)"().set");
                            it.append((Object)Strings.toFirstUpper((String)FormalParameterBuilderFragment.this.getCodeBuilderConfig().getParameterDefaultValueGrammarName()));
                            it.append((Object)"(it);");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t\t\t}, getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\t}");
                            it.newLine();
                            it.append((Object)"\t\treturn this.defaultValue;");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    if (!forAppender && !forInterface) {
                        AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                        it.append((Object)"\t@");
                        it.append(Override.class);
                        it.newLine();
                        it.append((Object)"\t@");
                        it.append(Pure.class);
                        it.newLine();
                        it.append((Object)"\tpublic ");
                        it.append(String.class);
                        it.append((Object)" toString() {");
                        it.newLine();
                        it.append((Object)"\t\treturn ");
                        if (forAppender) {
                            it.append((Object)"this.builder.toString();");
                        } else {
                            it.append(EmfFormatter.class);
                            it.append((Object)".objToStr(");
                            it.append((Object)accessor);
                            it.append((Object)");");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                }
                if (forInterface) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tvoid dispose();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic void dispose() {");
                    it.newLine();
                    it.append((Object)"\t\tthis.builder.dispose();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            }
        };
    }

    public static class FormalParameterDescription {
        private final CodeElementExtractor.ElementDescription element;
        private final Assignment defaultValueAssignment;

        public FormalParameterDescription(CodeElementExtractor.ElementDescription element, Assignment defaultValueAssignment) {
            this.element = element;
            this.defaultValueAssignment = defaultValueAssignment;
        }

        public String toString() {
            return this.element.name();
        }

        public CodeElementExtractor.ElementDescription getElementDescription() {
            return this.element;
        }

        public Assignment getDefaultValueAssignment() {
            return this.defaultValueAssignment;
        }
    }
}

