/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractMemberBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BuilderFactoryContributions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class NamedMemberBuilderFragment
extends AbstractMemberBuilderFragment {
    @Inject
    private BuilderFactoryContributions builderFactoryContributions;
    private Map<String, AbstractMemberBuilderFragment.MemberDescription> members;

    @Override
    protected Iterable<AbstractMemberBuilderFragment.MemberDescription> getMembers() {
        if (this.members == null) {
            this.members = new HashMap<String, AbstractMemberBuilderFragment.MemberDescription>();
            ArrayList<CodeElementExtractor.ElementDescription> topElements = new ArrayList<CodeElementExtractor.ElementDescription>();
            for (CodeElementExtractor.ElementDescription topElement : this.getCodeElementExtractor().getTopElements(this.getGrammar(), this.getCodeBuilderConfig())) {
                topElements.add(topElement);
            }
            for (CodeElementExtractor.ElementDescription containerDescription : topElements) {
                AbstractRule rule = this.getMemberRule(containerDescription);
                if (rule == null) continue;
                EClassifier commonSuperType = this.getCodeElementExtractor().getGeneratedTypeFor(rule);
                Functions.Function4 callback = (it, grammarContainer, memberContainer, classifier) -> {
                    String memberName = Strings.toFirstUpper((String)classifier.getName());
                    AbstractMemberBuilderFragment.MemberDescription memberDescription = this.members.get(memberName);
                    if (memberDescription == null) {
                        CodeElementExtractor.ElementDescription elementDescription = it.newElementDescription(classifier.getName(), (EObject)memberContainer, (EClassifier)classifier, commonSuperType);
                        List<String> modifiers = this.getCodeBuilderConfig().getModifiers().get(elementDescription.elementType().getSimpleName());
                        memberDescription = new AbstractMemberBuilderFragment.MemberDescription(elementDescription, containerDescription, topElements.contains(elementDescription), elementDescription.annotationInfo(), modifiers);
                        this.members.put(memberName, memberDescription);
                    }
                    String containerName = memberDescription.getContainerDescription().elementType().getSimpleName();
                    boolean isNoBody = this.getCodeBuilderConfig().getNoActionBodyTypes().contains(containerName);
                    Set<String> containers = isNoBody ? memberDescription.getNoBodyContainers() : memberDescription.getStandardContainers();
                    containers.add(containerName);
                    return null;
                };
                this.getCodeElementExtractor().visitMemberElements(containerDescription, (EObject)rule, null, callback, null, callback);
            }
        }
        return this.members.values();
    }

    @Override
    public void generate() {
        super.generate();
        Iterable<AbstractMemberBuilderFragment.MemberDescription> members = this.getMembers();
        for (AbstractMemberBuilderFragment.MemberDescription description : members) {
            this.generateBuilderFactoryContributions(description);
        }
    }

    protected void generateBuilderFactoryContributions(final AbstractMemberBuilderFragment.MemberDescription description) {
        if (description.isTopElement()) {
            return;
        }
        if (description.getStandardContainers().isEmpty() && description.getNoBodyContainers().isEmpty()) {
            return;
        }
        List<String> modifiers = description.getModifiers();
        if (modifiers.size() <= 1) {
            modifiers = Collections.singletonList("");
        }
        boolean enableAppenders = this.getCodeBuilderConfig().isISourceAppendableEnable();
        for (final String modifier : modifiers) {
            final String createFunctionName = "create" + Strings.toFirstUpper((String)modifier) + Strings.toFirstUpper((String)description.getElementDescription().name());
            String container = null;
            container = !description.getStandardContainers().isEmpty() ? description.getStandardContainers().iterator().next() : description.getNoBodyContainers().iterator().next();
            final String createContainerFunctionName = "add" + Strings.toFirstUpper((String)container);
            final TypeReference containerBuilder = description.getContainerDescription().builderInterfaceType();
            this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create the factory for a " + NamedMemberBuilderFragment.this.getLanguageName() + " " + description.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the name of the " + description.getElementDescription().name()));
                    it.newLine();
                    it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the factory.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)description.getElementDescription().builderInterfaceType());
                    it.append((Object)" ");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(String name, ");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet) {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(name, createResource(resourceSet));");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the factory for a " + NamedMemberBuilderFragment.this.getLanguageName() + " " + description.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the name of the " + description.getElementDescription().name()));
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the factory.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)description.getElementDescription().builderInterfaceType());
                    it.append((Object)" ");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(String name, ");
                    it.append(Resource.class);
                    it.append((Object)" resource) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)NamedMemberBuilderFragment.this.getScriptBuilderInterface());
                    it.append((Object)" scriptBuilder = createScript(getFooPackageName(), resource);");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)containerBuilder);
                    it.append((Object)" containerBuilder = scriptBuilder.");
                    it.append((Object)createContainerFunctionName);
                    it.append((Object)"(getFooTypeName());");
                    it.newLine();
                    it.append((Object)"\t\treturn containerBuilder.add");
                    it.append((Object)Strings.toFirstUpper((String)modifier));
                    it.append((Object)Strings.toFirstUpper((String)description.getElementDescription().name()));
                    it.append((Object)"(name);");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
            if (!enableAppenders) continue;
            final String buildFunctionName = "build" + Strings.toFirstUpper((String)modifier) + Strings.toFirstUpper((String)description.getElementDescription().name());
            final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl(description.getElementDescription().name());
            this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create the appender for a " + NamedMemberBuilderFragment.this.getLanguageName() + " " + description.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the name of the " + description.getElementDescription().name()));
                    it.newLine();
                    it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)buildFunctionName);
                    it.append((Object)"(String name, ");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)appender);
                    it.append((Object)" a = new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(name, resourceSet));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the appender for a " + NamedMemberBuilderFragment.this.getLanguageName() + " " + description.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the name of the " + description.getElementDescription().name()));
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)buildFunctionName);
                    it.append((Object)"(String name, ");
                    it.append(Resource.class);
                    it.append((Object)" resource) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)appender);
                    it.append((Object)" a = new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(name, resource));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
    }
}

