/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BlockExpressionBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BuilderFactoryContributions;
import io.sarl.lang.mwe2.codebuilder.fragments.ExpressionBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.FormalParameterBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.SerializerScopeProviderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.TopElementBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.TypeParameterBuilderFragment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.XtendFileAccess;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypeFactory;

public class ScriptBuilderFragment
extends AbstractSubCodeBuilderFragment {
    @Inject
    private BuilderFactoryContributions builderFactoryContributions;

    @Pure
    public TypeReference getScriptBuilderImplCustom() {
        return new TypeReference(this.getCodeElementExtractor().getBuilderPackage() + ".ScriptBuilderImplCustom");
    }

    @Pure
    public TypeReference getScriptBuilderImpl() {
        return new TypeReference(this.getCodeElementExtractor().getBuilderPackage() + ".ScriptBuilderImpl");
    }

    public TypeReference getScriptAppender() {
        return this.getCodeElementExtractor().getElementAppenderImpl("Script");
    }

    @Override
    protected Collection<AbstractSubCodeBuilderFragment> initializeSubGenerators(Injector injector) {
        return Arrays.asList((AbstractSubCodeBuilderFragment)((Object)injector.getInstance(ExpressionBuilderFragment.class)), (AbstractSubCodeBuilderFragment)((Object)injector.getInstance(BlockExpressionBuilderFragment.class)), (AbstractSubCodeBuilderFragment)((Object)injector.getInstance(FormalParameterBuilderFragment.class)), (AbstractSubCodeBuilderFragment)((Object)injector.getInstance(TypeParameterBuilderFragment.class)), (AbstractSubCodeBuilderFragment)((Object)injector.getInstance(TopElementBuilderFragment.class)), (AbstractSubCodeBuilderFragment)((Object)injector.getInstance(SerializerScopeProviderFragment.class)));
    }

    @Override
    public void generate() {
        this.generateIScriptBuilder();
        this.generateScriptBuilderImpl();
        this.generateScriptSourceAppender();
        this.generateBuilderFactoryContributions();
        super.generate();
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        this.bindTypeReferences(factory, this.getScriptBuilderInterface(), this.getScriptBuilderImpl(), this.getScriptBuilderImplCustom());
    }

    protected void generateBuilderFactoryContributions() {
        boolean enableAppenders = this.getCodeBuilderConfig().isISourceAppendableEnable();
        this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("\t/** Create the factory for a " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                it.newLine();
                it.append((Object)"\t * @param packageName the name of the package of the script.");
                it.newLine();
                it.append((Object)"\t * @param resourceSet the resource set in which the script is created.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" createScript(String packageName, ");
                it.append(ResourceSet.class);
                it.append((Object)" resourceSet) {");
                it.newLine();
                it.append((Object)"\t\treturn createScript(packageName, createResource(resourceSet), null);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)("\t/** Create the factory for a " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                it.newLine();
                it.append((Object)"\t * @param packageName the name of the package of the script.");
                it.newLine();
                it.append((Object)"\t * @param resource the resource in which the script is created.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" createScript(String packageName, ");
                it.append(Resource.class);
                it.append((Object)" resource) {");
                it.newLine();
                it.append((Object)"\t\treturn createScript(packageName, resource, null);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)("\t/** Create the factory for a " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                it.newLine();
                it.append((Object)"\t * @param packageName the name of the package of the script.");
                it.newLine();
                it.append((Object)"\t * @param resource the resource in which the script is created.");
                it.newLine();
                it.append((Object)"\t * @param context the context for type resolution.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" createScript(String packageName, ");
                it.append(Resource.class);
                it.append((Object)" resource, ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" context) {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" builder = getProvider(");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)".class).get();");
                it.newLine();
                it.append((Object)"\t\tbuilder.eInit(resource, packageName, context);");
                it.newLine();
                it.append((Object)"\t\treturn builder;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)("\t/** Create the factory for a " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                it.newLine();
                it.append((Object)"\t * <p>The resource set is provided by the context.");
                it.newLine();
                it.append((Object)"\t * @param packageName the name of the package of the script.");
                it.newLine();
                it.append((Object)"\t * @param context the context for type resolution.");
                it.newLine();
                it.append((Object)"\t * @return the factory.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" createScript(String packageName, ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" context) {");
                it.newLine();
                it.append((Object)"\t\treturn createScript(packageName, createResource(context.getResourceSet()), context);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        });
        if (enableAppenders) {
            this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create the appender for a " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                    it.newLine();
                    it.append((Object)"\t * @param packageName the name of the package of the script.");
                    it.newLine();
                    it.append((Object)"\t * @param resourceSet the resource set in which the script is created.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)" buildScript(String packageName, ");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)" a = new ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)"(createScript(packageName, resourceSet));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the appender for a " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                    it.newLine();
                    it.append((Object)"\t * @param packageName the name of the package of the script.");
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource in which the script is created.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)" buildScript(String packageName, ");
                    it.append(Resource.class);
                    it.append((Object)" resource) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)" a = new ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)"(createScript(packageName, resource));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the appender for a " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                    it.newLine();
                    it.append((Object)"\t * @param packageName the name of the package of the script.");
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource in which the script is created.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)" buildScript(String packageName, ");
                    it.append(Resource.class);
                    it.append((Object)" resource, ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" context) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)" a = new ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)"(createScript(packageName, resource, context));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the appender for a " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                    it.newLine();
                    it.append((Object)"\t * <p>The resource set is provided by the context.");
                    it.newLine();
                    it.append((Object)"\t * @param packageName the name of the package of the script.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)" buildScript(String packageName, ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" context) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)" a = new ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender());
                    it.append((Object)"(createScript(packageName, context));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
    }

    @Override
    public void generateXtendStubs() {
        super.generateXtendStubs();
        final TypeReference stub = this.getScriptBuilderImplCustom();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** User-defined builder of the " + ScriptBuilderFragment.this.getLanguageName() + " scripts."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"class ");
                it.append((Object)stub);
                it.append((Object)" extends ");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderImpl());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLine();
            }
        };
        XtendFileAccess xtendFile = this.getFileAccessFactory().createXtendFile(stub, content);
        IFileSystemAccess2 fileSystem = this.getSrc();
        if (!fileSystem.isFile(xtendFile.getPath())) {
            xtendFile.writeTo(fileSystem);
        }
    }

    @Override
    public void generateJavaStubs() {
        super.generateJavaStubs();
        final TypeReference stub = this.getScriptBuilderImplCustom();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** User-defined builder of the " + ScriptBuilderFragment.this.getLanguageName() + " scripts."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)stub);
                it.append((Object)" extends ");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderImpl());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"}");
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(stub, content);
        IFileSystemAccess2 fileSystem = this.getSrc();
        if (!fileSystem.isFile(javaFile.getPath())) {
            javaFile.writeTo(fileSystem);
        }
    }

    protected StringConcatenationClient generateTopElement(CodeElementExtractor.ElementDescription description, final boolean forInterface, final boolean forAppender) {
        final String topElementName = Strings.toFirstUpper((String)description.name());
        final TypeReference builderType = this.getCodeElementExtractor().getElementBuilderInterface(topElementName);
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                if (!forInterface && !forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(ScriptBuilderFragment.this.getInjectType());
                    it.newLine();
                    it.append((Object)"\tprivate ");
                    it.append(Provider.class);
                    it.append((Object)"<");
                    it.append((Object)builderType);
                    it.append((Object)"> ");
                    it.append((Object)Strings.toFirstLower((String)topElementName));
                    it.append((Object)"Provider;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(topElementName) + " " + topElementName + " builder."));
                it.newLine();
                it.append((Object)("\t * @param name the name of the " + topElementName + "."));
                it.newLine();
                it.append((Object)"\t * @return the builder.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)builderType);
                it.append((Object)" add");
                it.append((Object)topElementName);
                it.append((Object)"(String name)");
                if (forInterface) {
                    it.append((Object)";");
                    it.newLineIfNotEmpty();
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\t return this.builder.add");
                        it.append((Object)topElementName);
                        it.append((Object)"(name);");
                    } else {
                        it.append((Object)"\t\t");
                        it.append((Object)builderType);
                        it.append((Object)" builder = this.");
                        it.append((Object)Strings.toFirstLower((String)topElementName));
                        it.append((Object)"Provider.get();");
                        it.newLine();
                        it.append((Object)"\t\tbuilder.eInit(getScript(), name, getTypeResolutionContext());");
                        it.newLine();
                        it.append((Object)"\t\treturn builder;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                }
                it.newLine();
            }
        };
    }

    protected List<StringConcatenationClient> generateTopElements(boolean forInterface, boolean forAppender) {
        ArrayList<StringConcatenationClient> topElements = new ArrayList<StringConcatenationClient>();
        for (CodeElementExtractor.ElementDescription description : this.getCodeElementExtractor().getTopElements(this.getGrammar(), this.getCodeBuilderConfig())) {
            topElements.add(this.generateTopElement(description, forInterface, forAppender));
        }
        return topElements;
    }

    protected void generateIScriptBuilder() {
        final List<StringConcatenationClient> topElements = this.generateTopElements(true, false);
        final TypeReference builder = this.getScriptBuilderInterface();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of " + ScriptBuilderFragment.this.getLanguageName() + " scripts."));
                it.newLine();
                it.append((Object)" *");
                it.newLine();
                it.append((Object)(" * <p>This builder is provided for helping to create " + ScriptBuilderFragment.this.getLanguageName() + " Ecore elements."));
                it.newLine();
                it.append((Object)" *");
                it.newLine();
                it.append((Object)" * <p>Do not forget to invoke {@link #finalizeScript()} for creating imports, etc.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public interface ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)ScriptBuilderFragment.this.generateFieldsAndMethods(true, false));
                for (StringConcatenationClient element : topElements) {
                    it.append((Object)element);
                }
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateScriptSourceAppender() {
        final List<StringConcatenationClient> topElements = this.generateTopElements(false, true);
        TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl("Script");
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Appender of " + ScriptBuilderFragment.this.getLanguageName() + " scripts."));
                it.newLine();
                it.append((Object)" *");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)ScriptBuilderFragment.this.getScriptAppender().getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)ScriptBuilderFragment.this.getCodeElementExtractor().getAbstractAppenderImpl());
                it.append((Object)" implements ");
                it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)ScriptBuilderFragment.this.generateFieldsAndMethods(false, true));
                for (StringConcatenationClient element : topElements) {
                    it.append((Object)element);
                }
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(appender, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateScriptBuilderImpl() {
        final List<StringConcatenationClient> topElements = this.generateTopElements(false, false);
        final TypeReference script = this.getScriptBuilderImpl();
        final TypeReference scriptInterface = this.getScriptBuilderInterface();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)script.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)ScriptBuilderFragment.this.getAbstractBuilderImpl());
                it.append((Object)" implements ");
                it.append((Object)scriptInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)ScriptBuilderFragment.this.generateFieldsAndMethods(false, false));
                for (StringConcatenationClient element : topElements) {
                    it.append((Object)element);
                }
                it.append((Object)"}");
                it.newLineIfNotEmpty();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(script, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected StringConcatenationClient generateFieldsAndMethods(final boolean forInterface, final boolean forAppender) {
        final TypeReference scriptInterface = this.getCodeElementExtractor().getLanguageScriptInterface();
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                if (!forInterface && !forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append((Object)scriptInterface);
                    it.append((Object)" script;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate boolean isFinalized;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                    it.append((Object)" builder;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface || forAppender) {
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for the type reference use");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(JvmType.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context in which the type is defined");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, ");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext() {");
                    it.newLine();
                    it.append((Object)"\t\treturn this.builder.getTypeResolutionContext();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tpublic ");
                    it.append((Object)ScriptBuilderFragment.this.getScriptAppender().getSimpleName());
                    it.append((Object)"(");
                    it.append((Object)ScriptBuilderFragment.this.getScriptBuilderInterface());
                    it.append((Object)" builder) {");
                    it.newLine();
                    it.append((Object)"\t\tthis.builder = builder;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tpublic void build(");
                    it.append(ISourceAppender.class);
                    it.append((Object)" appender) throws ");
                    it.append(IOException.class);
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\tif (!isFinalized()) {");
                    it.newLine();
                    it.append((Object)"\t\t\tfinalizeScript();");
                    it.newLine();
                    it.append((Object)"\t\t}");
                    it.newLine();
                    it.append((Object)"\t\tbuild(this.builder.getScript(), appender);");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)("\t/** Create the internal " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                it.newLine();
                it.append((Object)"\t * @param resource the Ecore resource in which the SARL script is located.");
                it.newLine();
                it.append((Object)"\t * @param packageName the fully-qualified name of the package of the script.");
                it.newLine();
                it.append((Object)"\t * @param context the context in which all the type resolutions must be done.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void eInit(");
                it.append(Resource.class);
                it.append((Object)" resource, String packageName, ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" context)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.eInit(resource, packageName, context);");
                    } else {
                        it.append((Object)"\t\tsetTypeResolutionContext(context);");
                        it.newLine();
                        it.append((Object)"\t\tif (this.script == null) {");
                        it.newLine();
                        it.append((Object)"\t\t\tthis.script = ");
                        it.append((Object)ScriptBuilderFragment.this.getXFactoryFor(scriptInterface));
                        it.append((Object)".eINSTANCE.create");
                        it.append((Object)Strings.toFirstUpper((String)scriptInterface.getSimpleName()));
                        it.append((Object)"();");
                        it.newLine();
                        it.append((Object)"\t\t\t");
                        it.append(EList.class);
                        it.append((Object)"<");
                        it.append(EObject.class);
                        it.append((Object)"> content = resource.getContents();");
                        it.newLine();
                        it.append((Object)"\t\t\tif (!content.isEmpty()) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tcontent.clear();");
                        it.newLine();
                        it.append((Object)"\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t\tcontent.add(this.script);");
                        it.newLine();
                        it.append((Object)"\t\t\tif (!");
                        it.append(Strings.class);
                        it.append((Object)".isEmpty(packageName)) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tscript.setPackage(packageName);");
                        it.newLine();
                        it.append((Object)"\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t}");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)("\t/** Replies the " + ScriptBuilderFragment.this.getLanguageName() + " script."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)scriptInterface);
                it.append((Object)" getScript()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.getScript();");
                    } else {
                        it.append((Object)"\t\treturn this.script;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the resource to which the script is attached.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(Resource.class);
                it.append((Object)" eResource()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\treturn getScript().eResource();");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Finalize the script.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * <p>The finalization includes: <ul>");
                it.newLine();
                it.append((Object)"\t * <li>The import section is created.</li>");
                it.newLine();
                it.append((Object)"\t * </ul>");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void finalizeScript()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.finalizeScript();");
                    } else {
                        it.append((Object)"\t\tif (this.isFinalized) {");
                        it.newLine();
                        it.append((Object)"\t\t\tthrow new ");
                        it.append(IllegalStateException.class);
                        it.append((Object)"(\"already finalized\");");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\tthis.isFinalized = true;");
                        it.newLine();
                        it.append((Object)"\t\t");
                        it.append(ImportManager.class);
                        it.append((Object)" concreteImports = new ");
                        it.append(ImportManager.class);
                        it.append((Object)"(true);");
                        it.newLine();
                        it.append((Object)"\t\t");
                        it.append(XImportSection.class);
                        it.append((Object)" importSection = getScript().getImportSection();");
                        it.newLine();
                        it.append((Object)"\t\tif (importSection != null) {");
                        it.newLine();
                        it.append((Object)"\t\t\tfor (");
                        it.append(XImportDeclaration.class);
                        it.append((Object)" decl : importSection.getImportDeclarations()) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\tconcreteImports.addImportFor(decl.getImportedType());");
                        it.newLine();
                        it.append((Object)"\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\tfor (String importName : getImportManager().getImports()) {");
                        it.newLine();
                        it.append((Object)"\t\t\t");
                        it.append(JvmType.class);
                        it.append((Object)" type = findType(getScript(), importName).getType();");
                        it.newLine();
                        it.append((Object)"\t\t\tif (type instanceof ");
                        it.append(JvmDeclaredType.class);
                        it.append((Object)" ctype && concreteImports.addImportFor(ctype)) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\t");
                        it.append(XImportDeclaration.class);
                        it.append((Object)" declaration = ");
                        it.append(XtypeFactory.class);
                        it.append((Object)".eINSTANCE.createXImportDeclaration();");
                        it.newLine();
                        it.append((Object)"\t\t\t\tdeclaration.setImportedType(ctype);");
                        it.newLine();
                        it.append((Object)"\t\t\t\tif (importSection == null) {");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\timportSection = ");
                        it.append(XtypeFactory.class);
                        it.append((Object)".eINSTANCE.createXImportSection();");
                        it.newLine();
                        it.append((Object)"\t\t\t\t\tgetScript().setImportSection(importSection);");
                        it.newLine();
                        it.append((Object)"\t\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t\t\timportSection.getImportDeclarations().add(declaration);");
                        it.newLine();
                        it.append((Object)"\t\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\t");
                        it.append(Resource.class);
                        it.append((Object)" resource = getScript().eResource();");
                        it.newLine();
                        it.append((Object)"\t\tif (resource instanceof ");
                        it.append(DerivedStateAwareResource.class);
                        it.append((Object)" cresource) {");
                        it.newLine();
                        it.append((Object)"\t\t\tcresource.discardDerivedState();");
                        it.newLine();
                        it.append((Object)"\t\t}");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies if the script was finalized.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"boolean isFinalized()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.isFinalized();");
                    } else {
                        it.append((Object)"\t\treturn this.isFinalized;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (!forInterface) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Override.class);
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(String.class);
                    it.append((Object)" toString() {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    if (forAppender) {
                        it.append((Object)"this.builder.toString();");
                    } else {
                        it.append(EmfFormatter.class);
                        it.append((Object)".objToStr(this.script);");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            }
        };
    }
}

