/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BuilderFactoryContributions;
import io.sarl.lang.mwe2.codebuilder.fragments.ConstructorBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.NamedMemberBuilderFragment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsFactory;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class TopElementBuilderFragment
extends AbstractSubCodeBuilderFragment {
    @Inject
    private BuilderFactoryContributions builderFactoryContributions;

    @Pure
    protected String getGeneratedTypeAccessor(TypeReference generatedType) {
        return "get" + Strings.toFirstUpper((String)generatedType.getSimpleName()) + "()";
    }

    @Override
    protected Collection<AbstractSubCodeBuilderFragment> initializeSubGenerators(Injector injector) {
        ConstructorBuilderFragment fg1 = (ConstructorBuilderFragment)((Object)injector.getInstance(ConstructorBuilderFragment.class));
        NamedMemberBuilderFragment fg2 = (NamedMemberBuilderFragment)((Object)injector.getInstance(NamedMemberBuilderFragment.class));
        return Arrays.asList(new AbstractSubCodeBuilderFragment[]{fg1, fg2});
    }

    @Override
    public void generate() {
        this.generateIElementBuilder();
        this.generateElementBuilderImplementation();
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            this.generateElementSourceAppender();
        }
        this.generateBuilderFactoryContributions();
        super.generate();
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        for (TopElementDescription description : this.generateTopElements(false, false)) {
            this.bindElementDescription(factory, description.getElementDescription());
        }
    }

    protected void generateBuilderFactoryContributions() {
        List<TopElementDescription> topElements = this.generateTopElements(true, false);
        boolean enableAppenders = this.getCodeBuilderConfig().isISourceAppendableEnable();
        for (final TopElementDescription element : topElements) {
            final String createFunctionName = "create" + Strings.toFirstUpper((String)element.getElementDescription().name());
            this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create the factory for a " + TopElementBuilderFragment.this.getLanguageName() + " " + element.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the name of the " + element.getElementDescription().name()));
                    it.newLine();
                    it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the factory.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)element.getElementDescription().builderInterfaceType());
                    it.append((Object)" ");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(String name, ");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet) {");
                    it.newLine();
                    it.append((Object)"\t\t return ");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(name, createResource(resourceSet));");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the factory for a " + TopElementBuilderFragment.this.getLanguageName() + " " + element.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the name of the " + element.getElementDescription().name()));
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated element, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the factory.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)element.getElementDescription().builderInterfaceType());
                    it.append((Object)" ");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(String name, ");
                    it.append(Resource.class);
                    it.append((Object)" resource) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)TopElementBuilderFragment.this.getScriptBuilderInterface());
                    it.append((Object)" scriptBuilder = createScript(getFooPackageName(), resource);");
                    it.newLine();
                    it.append((Object)"\t\treturn scriptBuilder.add");
                    it.append((Object)Strings.toFirstUpper((String)element.getElementDescription().name()));
                    it.append((Object)"(name);");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
            if (!enableAppenders) continue;
            final String buildFunctionName = "build" + Strings.toFirstUpper((String)element.getElementDescription().name());
            final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl(element.getElementDescription().name());
            this.builderFactoryContributions.addContribution(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create the appender for a " + TopElementBuilderFragment.this.getLanguageName() + " " + element.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the name of the " + element.getElementDescription().name()));
                    it.newLine();
                    it.append((Object)"\t * @param resourceSet the set of the resources that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)buildFunctionName);
                    it.append((Object)"(String name, ");
                    it.append(ResourceSet.class);
                    it.append((Object)" resourceSet) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)appender);
                    it.append((Object)" a = new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(name, resourceSet));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create the appender for a " + TopElementBuilderFragment.this.getLanguageName() + " " + element.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the name of the " + element.getElementDescription().name()));
                    it.newLine();
                    it.append((Object)"\t * @param resource the resource that must be used for");
                    it.newLine();
                    it.append((Object)"\t *    containing the generated resource, and resolving types from names.");
                    it.newLine();
                    it.append((Object)"\t * @return the appender.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append((Object)appender);
                    it.append((Object)" ");
                    it.append((Object)buildFunctionName);
                    it.append((Object)"(String name, ");
                    it.append(Resource.class);
                    it.append((Object)" resource) {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    it.append((Object)appender);
                    it.append((Object)" a = new ");
                    it.append((Object)appender);
                    it.append((Object)"(");
                    it.append((Object)createFunctionName);
                    it.append((Object)"(name, resource));");
                    it.newLine();
                    it.append((Object)"\t\tgetInjector().injectMembers(a);");
                    it.newLine();
                    it.append((Object)"\t\treturn a;");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
    }

    protected void generateIElementBuilder() {
        List<TopElementDescription> topElements = this.generateTopElements(true, false);
        for (final TopElementDescription element : topElements) {
            StringConcatenationClient content = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("/** Builder of a " + TopElementBuilderFragment.this.getLanguageName() + " " + element.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)" */");
                    it.newLine();
                    it.append((Object)"@SuppressWarnings(\"all\")");
                    it.newLine();
                    it.append((Object)"public interface ");
                    it.append((Object)element.getElementDescription().builderInterfaceType().getSimpleName());
                    it.append((Object)" {");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)element.getContent());
                    for (StringConcatenationClient cons : TopElementBuilderFragment.this.generateMembers(element.getConstructors(), element, true, false, true, false)) {
                        it.append((Object)cons);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getNamedMembers(), element, true, false, true, false)) {
                        it.append((Object)mbr);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getUnnamedMembers(), element, true, false, false, false)) {
                        it.append((Object)mbr);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getImplicitlyNamedMembers(), element, true, false, false, true)) {
                        it.append((Object)mbr);
                    }
                    it.append((Object)"}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            };
            JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(element.getElementDescription().builderInterfaceType(), content);
            javaFile.writeTo(this.getSrcGen());
        }
    }

    protected void generateElementSourceAppender() {
        List<TopElementDescription> topElements = this.generateTopElements(false, true);
        for (final TopElementDescription element : topElements) {
            final TypeReference appender = element.getElementDescription().appenderType();
            StringConcatenationClient content = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("/** Source adapter of a " + TopElementBuilderFragment.this.getLanguageName() + " " + element.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)" */");
                    it.newLine();
                    it.append((Object)"@SuppressWarnings(\"all\")");
                    it.newLine();
                    it.append((Object)"public class ");
                    it.append((Object)appender.getSimpleName());
                    it.append((Object)" extends ");
                    it.append((Object)TopElementBuilderFragment.this.getCodeElementExtractor().getAbstractAppenderImpl());
                    it.append((Object)" implements ");
                    it.append((Object)element.getElementDescription().builderInterfaceType());
                    it.append((Object)" {");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)TopElementBuilderFragment.this.generateAppenderMembers(appender.getSimpleName(), element.getElementDescription().builderInterfaceType(), TopElementBuilderFragment.this.getGeneratedTypeAccessor(element.getElementDescription().elementType())));
                    it.append((Object)element.getContent());
                    for (StringConcatenationClient cons : TopElementBuilderFragment.this.generateMembers(element.getConstructors(), element, false, true, true, false)) {
                        it.append((Object)cons);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getNamedMembers(), element, false, true, true, false)) {
                        it.append((Object)mbr);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getUnnamedMembers(), element, false, true, false, false)) {
                        it.append((Object)mbr);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getImplicitlyNamedMembers(), element, false, true, false, true)) {
                        it.append((Object)mbr);
                    }
                    it.append((Object)"}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            };
            JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(appender, content);
            javaFile.writeTo(this.getSrcGen());
        }
    }

    protected void generateElementBuilderImplementation() {
        List<TopElementDescription> topElements = this.generateTopElements(false, false);
        for (final TopElementDescription element : topElements) {
            StringConcatenationClient content = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("/** Builder of a " + TopElementBuilderFragment.this.getLanguageName() + " " + element.getElementDescription().elementType().getSimpleName() + "."));
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)" */");
                    it.newLine();
                    it.append((Object)"@SuppressWarnings(\"all\")");
                    it.newLine();
                    it.append((Object)"public class ");
                    it.append((Object)element.getElementDescription().builderImplementationType().getSimpleName());
                    it.append((Object)" extends ");
                    it.append((Object)TopElementBuilderFragment.this.getAbstractBuilderImpl());
                    it.append((Object)" implements ");
                    it.append((Object)element.getElementDescription().builderInterfaceType());
                    it.append((Object)" {");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)element.getContent());
                    for (StringConcatenationClient cons : TopElementBuilderFragment.this.generateMembers(element.getConstructors(), element, false, false, true, false)) {
                        it.append((Object)cons);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getNamedMembers(), element, false, false, true, false)) {
                        it.append((Object)mbr);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getUnnamedMembers(), element, false, false, false, false)) {
                        it.append((Object)mbr);
                    }
                    for (StringConcatenationClient mbr : TopElementBuilderFragment.this.generateMembers(element.getImplicitlyNamedMembers(), element, false, false, false, true)) {
                        it.append((Object)mbr);
                    }
                    it.append((Object)"}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            };
            JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(element.getElementDescription().builderImplementationType(), content);
            javaFile.writeTo(this.getSrcGen());
        }
    }

    protected List<StringConcatenationClient> generateMembers(Collection<CodeElementExtractor.ElementDescription> grammarContainers, TopElementDescription description, boolean forInterface, boolean forAppender, boolean namedMembers, boolean implicitlyNamedMembers) {
        ArrayList<StringConcatenationClient> clients = new ArrayList<StringConcatenationClient>();
        for (CodeElementExtractor.ElementDescription elementDescription : grammarContainers) {
            clients.addAll(this.generateMember(elementDescription, description, forInterface, forAppender, namedMembers, implicitlyNamedMembers));
        }
        return clients;
    }

    protected List<StringConcatenationClient> generateMember(CodeElementExtractor.ElementDescription memberDescription, TopElementDescription topElementDescription, boolean forInterface, boolean forAppender, boolean namedMember, boolean implicitlyNamedMember) {
        if (namedMember) {
            return this.generateNamedMember(memberDescription, topElementDescription, forInterface, forAppender);
        }
        if (implicitlyNamedMember) {
            return this.generateImplicitlyNamedMember(memberDescription, topElementDescription, forInterface, forAppender);
        }
        return this.generateUnnamedMember(memberDescription, topElementDescription, forInterface, forAppender);
    }

    private List<StringConcatenationClient> generateNamedMember(CodeElementExtractor.ElementDescription memberDescription, final TopElementDescription topElementDescription, final boolean forInterface, final boolean forAppender) {
        final String memberName = Strings.toFirstUpper((String)memberDescription.name());
        TypeReference classifier = memberDescription.elementType();
        ArrayList<StringConcatenationClient> clients = new ArrayList<StringConcatenationClient>();
        final AtomicBoolean hasName = new AtomicBoolean(false);
        final AtomicBoolean hasTypeName = new AtomicBoolean(false);
        for (Assignment assignment : GrammarUtil.containedAssignments((EObject)memberDescription.grammarComponent())) {
            if (!Objects.equals(this.getCodeBuilderConfig().getMemberNameExtensionGrammarName(), assignment.getFeature())) continue;
            hasName.set(true);
            if (!TopElementBuilderFragment.nameMatches((EObject)assignment.getTerminal(), this.getCodeBuilderConfig().getTypeReferenceGrammarPattern())) continue;
            hasTypeName.set(true);
        }
        List<String> tmpModifiers = this.getCodeBuilderConfig().getModifiers().get(classifier.getSimpleName());
        if (tmpModifiers == null || tmpModifiers.isEmpty()) {
            tmpModifiers = Collections.singletonList("");
        }
        final List<String> modifiers = tmpModifiers;
        final TypeReference builderType = memberDescription.builderInterfaceType();
        if (!forInterface && !forAppender) {
            clients.add(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(TopElementBuilderFragment.this.getInjectType());
                    it.newLine();
                    it.append((Object)"\tprivate ");
                    it.append(Provider.class);
                    it.append((Object)"<");
                    it.append((Object)builderType);
                    it.append((Object)"> ");
                    it.append((Object)Strings.toFirstLower((String)builderType.getSimpleName()));
                    it.append((Object)"Provider;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
        for (final String modifier : modifiers) {
            final String functionName = modifiers.size() > 1 ? "add" + Strings.toFirstUpper((String)modifier) + memberName : "add" + memberName;
            clients.add(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                    it.newLine();
                    if (hasName.get()) {
                        it.append((Object)"\t * @param name the ");
                        if (hasTypeName.get()) {
                            it.append((Object)"type");
                        } else {
                            it.append((Object)"name");
                        }
                        it.append((Object)(" of the " + memberName + "."));
                        it.newLine();
                    }
                    it.append((Object)"\t * @return the builder.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" ");
                    it.append((Object)functionName);
                    it.append((Object)"(");
                    if (hasName.get()) {
                        it.append((Object)"String name");
                    }
                    it.append((Object)")");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\t");
                        if (forAppender) {
                            it.append((Object)"return this.builder.");
                            it.append((Object)functionName);
                            it.append((Object)"(");
                            if (hasName.get()) {
                                it.append((Object)"name");
                            }
                            it.append((Object)");");
                        } else {
                            it.append((Object)builderType);
                            it.append((Object)" builder = this.");
                            it.append((Object)Strings.toFirstLower((String)builderType.getSimpleName()));
                            it.append((Object)"Provider.get();");
                            it.newLine();
                            it.append((Object)"\t\tbuilder.eInit(");
                            it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(topElementDescription.getElementDescription().elementType()));
                            if (hasName.get()) {
                                it.append((Object)", name");
                            }
                            if (!Strings.isEmpty((String)modifier) && modifiers.size() > 1) {
                                it.append((Object)", \"");
                                it.append((Object)Strings.convertToJavaString((String)modifier));
                                it.append((Object)"\"");
                            }
                            it.append((Object)", getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\treturn builder;");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    if (hasName.get() && hasTypeName.get()) {
                        it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                        it.newLine();
                        it.append((Object)("\t * @param name the type of the " + memberName + "."));
                        it.newLine();
                        it.append((Object)"\t * @return the builder.");
                        it.newLine();
                        AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                        it.append((Object)"\t */");
                        it.newLine();
                        it.append((Object)"\t");
                        if (!forInterface) {
                            it.append((Object)"public ");
                        }
                        it.append((Object)builderType);
                        it.append((Object)" ");
                        it.append((Object)functionName);
                        it.append((Object)"(");
                        it.append(JvmParameterizedTypeReference.class);
                        it.append((Object)" name");
                        it.append((Object)")");
                        if (forInterface) {
                            it.append((Object)";");
                        } else {
                            it.append((Object)" {");
                            it.newLine();
                            it.append((Object)"\t\t");
                            if (forAppender) {
                                it.append((Object)"return this.builder.");
                                it.append((Object)functionName);
                                it.append((Object)"(");
                                it.append((Object)"name");
                                it.append((Object)");");
                            } else {
                                it.append((Object)builderType);
                                it.append((Object)" builder = this.");
                                it.append((Object)Strings.toFirstLower((String)builderType.getSimpleName()));
                                it.append((Object)"Provider.get();");
                                it.newLine();
                                it.append((Object)"\t\tbuilder.eInit(");
                                it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(topElementDescription.getElementDescription().elementType()));
                                it.append((Object)", name");
                                if (!Strings.isEmpty((String)modifier) && modifiers.size() > 1) {
                                    it.append((Object)", \"");
                                    it.append((Object)Strings.convertToJavaString((String)modifier));
                                    it.append((Object)"\"");
                                }
                                it.append((Object)", getTypeResolutionContext());");
                                it.newLine();
                                it.append((Object)"\t\treturn builder;");
                            }
                            it.newLine();
                            it.append((Object)"\t}");
                        }
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                }
            });
        }
        if (modifiers.size() > 1) {
            String firstModifier = Strings.toFirstUpper((String)modifiers.get(0));
            final String functionName = "add" + memberName;
            final String callFunctionName = "add" + firstModifier + memberName;
            clients.add(new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                    it.append((Object)"\t *");
                    it.newLine();
                    it.append((Object)"\t * <p>This function is equivalent to {@link #");
                    it.append((Object)callFunctionName);
                    it.append((Object)"}.");
                    it.newLine();
                    if (hasName.get()) {
                        it.append((Object)"\t * @param name the ");
                        if (hasTypeName.get()) {
                            it.append((Object)"type");
                        } else {
                            it.append((Object)"name");
                        }
                        it.append((Object)(" of the " + memberName + "."));
                        it.newLine();
                    }
                    it.append((Object)"\t * @return the builder.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" ");
                    it.append((Object)functionName);
                    it.append((Object)"(");
                    if (hasName.get()) {
                        it.append((Object)"String name");
                    }
                    it.append((Object)")");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn ");
                        if (forAppender) {
                            it.append((Object)"this.builder.");
                            it.append((Object)functionName);
                            it.append((Object)"(");
                            if (hasName.get()) {
                                it.append((Object)"name");
                            }
                            it.append((Object)");");
                        } else {
                            it.append((Object)"this.");
                            it.append((Object)callFunctionName);
                            it.append((Object)"(");
                            if (hasName.get()) {
                                it.append((Object)"name");
                            }
                            it.append((Object)");");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
        return clients;
    }

    private List<StringConcatenationClient> generateImplicitlyNamedMember(CodeElementExtractor.ElementDescription memberDescription, final TopElementDescription topElementDescription, final boolean forInterface, final boolean forAppender) {
        final String memberName = Strings.toFirstUpper((String)memberDescription.name());
        TypeReference classifier = memberDescription.elementType();
        ArrayList<StringConcatenationClient> clients = new ArrayList<StringConcatenationClient>();
        final AtomicBoolean hasName = new AtomicBoolean(false);
        final AtomicBoolean hasTypeName = new AtomicBoolean(false);
        for (Assignment assignment : GrammarUtil.containedAssignments((EObject)memberDescription.grammarComponent())) {
            if (!this.getCodeBuilderConfig().getIndirectlyNamedMemberExtensionGrammarNames().contains(assignment.getFeature())) continue;
            hasName.set(true);
            if (!TopElementBuilderFragment.nameMatches((EObject)assignment.getTerminal(), this.getCodeBuilderConfig().getTypeReferenceGrammarPattern())) continue;
            hasTypeName.set(true);
        }
        List<String> tmpModifiers = this.getCodeBuilderConfig().getModifiers().get(classifier.getSimpleName());
        if (tmpModifiers == null || tmpModifiers.isEmpty()) {
            tmpModifiers = Collections.singletonList("");
        }
        final List<String> modifiers = tmpModifiers;
        final TypeReference builderType = memberDescription.builderInterfaceType();
        if (!forInterface && !forAppender) {
            clients.add(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(TopElementBuilderFragment.this.getInjectType());
                    it.newLine();
                    it.append((Object)"\tprivate ");
                    it.append(Provider.class);
                    it.append((Object)"<");
                    it.append((Object)builderType);
                    it.append((Object)"> ");
                    it.append((Object)Strings.toFirstLower((String)builderType.getSimpleName()));
                    it.append((Object)"Provider;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
        for (final String modifier : modifiers) {
            final String functionName = modifiers.size() > 1 ? "add" + Strings.toFirstUpper((String)modifier) + memberName : "add" + memberName;
            clients.add(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                    it.newLine();
                    if (hasName.get()) {
                        it.append((Object)"\t * @param name the ");
                        if (hasTypeName.get()) {
                            it.append((Object)"type");
                        } else {
                            it.append((Object)"name");
                        }
                        it.append((Object)(" of the " + memberName + "."));
                        it.newLine();
                    }
                    it.append((Object)"\t * @return the builder.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" ");
                    it.append((Object)functionName);
                    it.append((Object)"(");
                    if (hasName.get()) {
                        it.append((Object)"String name");
                    }
                    it.append((Object)")");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\t");
                        if (forAppender) {
                            it.append((Object)"return this.builder.");
                            it.append((Object)functionName);
                            it.append((Object)"(");
                            if (hasName.get()) {
                                it.append((Object)"name");
                            }
                            it.append((Object)");");
                        } else {
                            it.append((Object)builderType);
                            it.append((Object)" builder = this.");
                            it.append((Object)Strings.toFirstLower((String)builderType.getSimpleName()));
                            it.append((Object)"Provider.get();");
                            it.newLine();
                            it.append((Object)"\t\tbuilder.eInit(");
                            it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(topElementDescription.getElementDescription().elementType()));
                            if (hasName.get()) {
                                it.append((Object)", name");
                            }
                            if (!Strings.isEmpty((String)modifier) && modifiers.size() > 1) {
                                it.append((Object)", \"");
                                it.append((Object)Strings.convertToJavaString((String)modifier));
                                it.append((Object)"\"");
                            }
                            it.append((Object)", getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\treturn builder;");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    if (hasName.get() && hasTypeName.get()) {
                        it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                        it.newLine();
                        it.append((Object)("\t * @param name the type of the " + memberName + "."));
                        it.newLine();
                        it.append((Object)"\t * @return the builder.");
                        it.newLine();
                        AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                        it.append((Object)"\t */");
                        it.newLine();
                        it.append((Object)"\t");
                        if (!forInterface) {
                            it.append((Object)"public ");
                        }
                        it.append((Object)builderType);
                        it.append((Object)" ");
                        it.append((Object)functionName);
                        it.append((Object)"(");
                        it.append(JvmParameterizedTypeReference.class);
                        it.append((Object)" name");
                        it.append((Object)")");
                        if (forInterface) {
                            it.append((Object)";");
                        } else {
                            it.append((Object)" {");
                            it.newLine();
                            it.append((Object)"\t\t");
                            if (forAppender) {
                                it.append((Object)"return this.builder.");
                                it.append((Object)functionName);
                                it.append((Object)"(");
                                it.append((Object)"name");
                                it.append((Object)");");
                            } else {
                                it.append((Object)builderType);
                                it.append((Object)" builder = this.");
                                it.append((Object)Strings.toFirstLower((String)builderType.getSimpleName()));
                                it.append((Object)"Provider.get();");
                                it.newLine();
                                it.append((Object)"\t\tbuilder.eInit(");
                                it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(topElementDescription.getElementDescription().elementType()));
                                it.append((Object)", name");
                                if (!Strings.isEmpty((String)modifier) && modifiers.size() > 1) {
                                    it.append((Object)", \"");
                                    it.append((Object)Strings.convertToJavaString((String)modifier));
                                    it.append((Object)"\"");
                                }
                                it.append((Object)", getTypeResolutionContext());");
                                it.newLine();
                                it.append((Object)"\t\treturn builder;");
                            }
                            it.newLine();
                            it.append((Object)"\t}");
                        }
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                }
            });
        }
        if (modifiers.size() > 1) {
            String firstModifier = Strings.toFirstUpper((String)modifiers.get(0));
            final String functionName = "add" + memberName;
            final String callFunctionName = "add" + firstModifier + memberName;
            clients.add(new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                    it.append((Object)"\t *");
                    it.newLine();
                    it.append((Object)"\t * <p>This function is equivalent to {@link #");
                    it.append((Object)callFunctionName);
                    it.append((Object)"}.");
                    it.newLine();
                    if (hasName.get()) {
                        it.append((Object)"\t * @param name the ");
                        if (hasTypeName.get()) {
                            it.append((Object)"type");
                        } else {
                            it.append((Object)"name");
                        }
                        it.append((Object)(" of the " + memberName + "."));
                        it.newLine();
                    }
                    it.append((Object)"\t * @return the builder.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)builderType);
                    it.append((Object)" ");
                    it.append((Object)functionName);
                    it.append((Object)"(");
                    if (hasName.get()) {
                        it.append((Object)"String name");
                    }
                    it.append((Object)")");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn ");
                        if (forAppender) {
                            it.append((Object)"this.builder.");
                            it.append((Object)functionName);
                            it.append((Object)"(");
                            if (hasName.get()) {
                                it.append((Object)"name");
                            }
                            it.append((Object)");");
                        } else {
                            it.append((Object)"this.");
                            it.append((Object)callFunctionName);
                            it.append((Object)"(");
                            if (hasName.get()) {
                                it.append((Object)"name");
                            }
                            it.append((Object)");");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
        return clients;
    }

    private List<StringConcatenationClient> generateUnnamedMember(final CodeElementExtractor.ElementDescription memberDescription, final TopElementDescription topElementDescription, final boolean forInterface, final boolean forAppender) {
        final String generatedObjectFieldName = Strings.toFirstLower((String)topElementDescription.getElementDescription().elementType().getSimpleName());
        final String memberName = Strings.toFirstUpper((String)memberDescription.name());
        final TypeReference classifier = memberDescription.elementType();
        ArrayList<StringConcatenationClient> clients = new ArrayList<StringConcatenationClient>();
        List<String> tmpModifiers = this.getCodeBuilderConfig().getModifiers().get(classifier.getSimpleName());
        if (tmpModifiers == null || tmpModifiers.isEmpty()) {
            tmpModifiers = Collections.singletonList("");
        }
        List<String> modifiers = tmpModifiers;
        for (String modifier : modifiers) {
            final String functionName = modifiers.size() > 1 ? "add" + Strings.toFirstUpper((String)modifier) + memberName : "add" + memberName;
            clients.add(new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    String field;
                    TypeReference commonType;
                    it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the types referenced by the " + memberName + "."));
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)topElementDescription.getElementDescription().builderInterfaceType());
                    it.append((Object)" ");
                    it.append((Object)functionName);
                    it.append((Object)"(String... name)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\t");
                        if (forAppender) {
                            it.append((Object)"this.builder.");
                            it.append((Object)functionName);
                            it.append((Object)"(name);");
                        } else {
                            it.append((Object)"if (name != null && name.length > 0) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append((Object)classifier);
                            it.append((Object)" member = ");
                            it.append((Object)TopElementBuilderFragment.this.getXFactoryFor(topElementDescription.getElementDescription().elementType()));
                            it.append((Object)".eINSTANCE.create");
                            it.append((Object)Strings.toFirstUpper((String)memberDescription.elementType().getSimpleName()));
                            it.append((Object)"();");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)".getMembers().add(member);");
                            it.newLine();
                            if (memberDescription.annotationInfo()) {
                                commonType = memberDescription.commonSuperType();
                                it.append((Object)"\t\t\tmember.setAnnotationInfo(");
                                it.append((Object)TopElementBuilderFragment.this.getXFactoryFor(commonType));
                                it.append((Object)".eINSTANCE.create");
                                it.append((Object)Strings.toFirstUpper((String)commonType.getSimpleName()));
                                it.append((Object)"());");
                                it.newLine();
                            }
                            field = (String)Iterables.find(TopElementBuilderFragment.this.getCodeBuilderConfig().getJvmTypeNamedMemberExtensionGrammarNames(), it2 -> AbstractSubCodeBuilderFragment.findAssignmentFromFeatureName(memberDescription.grammarComponent(), it2) != null, null);
                            it.append((Object)"\t\t\t");
                            it.append(Collection.class);
                            it.append((Object)"<");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)"> thecollection = member.get");
                            it.append((Object)Strings.toFirstUpper((String)field));
                            it.append((Object)"();");
                            it.newLine();
                            it.append((Object)"\t\t\tfor (final String aname : name) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tif (!");
                            it.append(Strings.class);
                            it.append((Object)".isEmpty(aname)) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" ref = newTypeRef(this.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)", aname);");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\tif (ref instanceof ");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)" pref) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\t\tthecollection.add(pref);");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\t} else {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\t\tthrow new ");
                            it.append(TypeNotPresentException.class);
                            it.append((Object)"(aname, null);");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                    it.newLine();
                    it.append((Object)("\t * @param name the types referenced by the " + memberName + "."));
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)topElementDescription.getElementDescription().builderInterfaceType());
                    it.append((Object)" ");
                    it.append((Object)functionName);
                    it.append((Object)"(");
                    it.append(JvmParameterizedTypeReference.class);
                    it.append((Object)"... name)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\t");
                        if (forAppender) {
                            it.append((Object)"this.builder.");
                            it.append((Object)functionName);
                            it.append((Object)"(name);");
                        } else {
                            it.append((Object)"if (name != null) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append((Object)classifier);
                            it.append((Object)" member = ");
                            it.append((Object)TopElementBuilderFragment.this.getXFactoryFor(topElementDescription.getElementDescription().elementType()));
                            it.append((Object)".eINSTANCE.create");
                            it.append((Object)Strings.toFirstUpper((String)memberDescription.elementType().getSimpleName()));
                            it.append((Object)"();");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)".getMembers().add(member);");
                            it.newLine();
                            if (memberDescription.annotationInfo()) {
                                commonType = memberDescription.commonSuperType();
                                it.append((Object)"\t\t\tmember.setAnnotationInfo(");
                                it.append((Object)TopElementBuilderFragment.this.getXFactoryFor(commonType));
                                it.append((Object)".eINSTANCE.create");
                                it.append((Object)Strings.toFirstUpper((String)commonType.getSimpleName()));
                                it.append((Object)"());");
                                it.newLine();
                            }
                            field = (String)Iterables.find(TopElementBuilderFragment.this.getCodeBuilderConfig().getJvmTypeNamedMemberExtensionGrammarNames(), it2 -> AbstractSubCodeBuilderFragment.findAssignmentFromFeatureName(memberDescription.grammarComponent(), it2) != null, null);
                            it.append((Object)"\t\t\t");
                            it.append(Collection.class);
                            it.append((Object)"<");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)"> thecollection = member.get");
                            it.append((Object)Strings.toFirstUpper((String)field));
                            it.append((Object)"();");
                            it.newLine();
                            it.append((Object)"\t\t\tfor (final ");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)" aname : name) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tif (aname != null) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t\tthecollection.add(aname);");
                            it.newLine();
                            it.append((Object)"\t\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
        if (modifiers.size() > 1) {
            String firstModifier = Strings.toFirstUpper((String)modifiers.get(0));
            final String functionName = "add" + memberName;
            final String callFunctionName = "add" + firstModifier + memberName;
            clients.add(new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    it.append((Object)("\t/** Create " + AbstractSubCodeBuilderFragment.getAorAnArticle(memberName) + " " + memberName + "."));
                    it.append((Object)"\t *");
                    it.newLine();
                    it.append((Object)"\t * <p>This function is equivalent to {@link #");
                    it.append((Object)callFunctionName);
                    it.append((Object)"}.");
                    it.newLine();
                    it.append((Object)("\t * @param name the type referenced by the " + memberName + "."));
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)"void ");
                    it.append((Object)functionName);
                    it.append((Object)"(String name)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"this.builder.");
                            it.append((Object)functionName);
                            it.append((Object)"(name);");
                        } else {
                            it.append((Object)"this.");
                            it.append((Object)callFunctionName);
                            it.append((Object)"(name);");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            });
        }
        return clients;
    }

    private Set<String> determineMemberElements() {
        HashSet<String> memberElements = new HashSet<String>();
        HashSet<String> topElements = new HashSet<String>();
        for (CodeElementExtractor.ElementDescription containerDescription : this.getCodeElementExtractor().getTopElements(this.getGrammar(), this.getCodeBuilderConfig())) {
            topElements.add(containerDescription.elementType().getName());
            AbstractRule rule = this.getMemberRule(containerDescription);
            if (rule == null) continue;
            Functions.Function4 callback = (it, grammarContainer, memberContainer, classifier) -> {
                memberElements.add(this.getCodeElementExtractor().newTypeReference((EClassifier)classifier).getName());
                return null;
            };
            this.getCodeElementExtractor().visitMemberElements(containerDescription, (EObject)rule, null, callback, callback, callback);
        }
        memberElements.retainAll(topElements);
        return memberElements;
    }

    protected List<TopElementDescription> generateTopElements(boolean forInterface, boolean forAppender) {
        Set<String> memberElements = this.determineMemberElements();
        ArrayList<EObject> topElementContainers = new ArrayList<EObject>();
        ArrayList<TopElementDescription> topElements = new ArrayList<TopElementDescription>();
        for (CodeElementExtractor.ElementDescription elementDescription : this.getCodeElementExtractor().getTopElements(this.getGrammar(), this.getCodeBuilderConfig())) {
            TopElementDescription topElementDescription = new TopElementDescription(elementDescription, memberElements.contains(elementDescription.elementType().getName()), this.getCodeBuilderConfig().isXtendSupportEnabled() && elementDescription.annotationInfo());
            this.generateTopElement(topElementDescription, forInterface, forAppender);
            topElements.add(topElementDescription);
            topElementContainers.add(topElementDescription.getElementDescription().grammarComponent());
        }
        for (TopElementDescription topElementDescription : topElements) {
            topElementDescription.getNamedMembers().removeAll(topElementContainers);
        }
        return topElements;
    }

    protected void generateTopElement(final TopElementDescription description, final boolean forInterface, final boolean forAppender) {
        final AtomicBoolean isExtendKeywordFound = new AtomicBoolean(false);
        final AtomicBoolean isExtendsKeywordFound = new AtomicBoolean(false);
        final AtomicBoolean isImplementKeywordFound = new AtomicBoolean(false);
        final AtomicBoolean isImplementsKeywordFound = new AtomicBoolean(false);
        final AtomicBoolean isAnnotated = new AtomicBoolean(false);
        final AtomicBoolean hasModifiers = new AtomicBoolean(false);
        final AtomicBoolean hasTypeParameters = new AtomicBoolean(false);
        AbstractRule memberRule = null;
        for (Assignment assignment : GrammarUtil.containedAssignments((EObject)description.getElementDescription().grammarComponent())) {
            AbstractElement abstractElement;
            if (Objects.equals(this.getCodeBuilderConfig().getModifierListGrammarName(), assignment.getFeature())) {
                hasModifiers.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getTypeParameterListGrammarName(), assignment.getFeature())) {
                hasTypeParameters.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getAnnotationListGrammarName(), assignment.getFeature())) {
                isAnnotated.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getTypeExtensionGrammarName(), assignment.getFeature())) {
                if (Objects.equals("*", assignment.getCardinality()) || Objects.equals("+=", assignment.getCardinality()) || isExtendKeywordFound.get()) {
                    isExtendsKeywordFound.set(true);
                }
                isExtendKeywordFound.set(true);
                continue;
            }
            if (Objects.equals(this.getCodeBuilderConfig().getTypeImplementationGrammarName(), assignment.getFeature())) {
                if (Objects.equals("*", assignment.getCardinality()) || Objects.equals("+=", assignment.getCardinality()) || isImplementKeywordFound.get()) {
                    isImplementsKeywordFound.set(true);
                }
                isImplementKeywordFound.set(true);
                continue;
            }
            if (!Objects.equals(this.getCodeBuilderConfig().getMemberCollectionExtensionGrammarName(), assignment.getFeature()) || memberRule != null || !((abstractElement = assignment.getTerminal()) instanceof RuleCall)) continue;
            RuleCall cvalue = (RuleCall)abstractElement;
            memberRule = cvalue.getRule();
        }
        if (memberRule != null) {
            EClassifier commonSuperClassifier = this.getCodeElementExtractor().getGeneratedTypeFor(memberRule);
            this.getCodeElementExtractor().visitMemberElements(description.getElementDescription(), (EObject)memberRule, (it, grammarContainer, memberContainer, classifier) -> {
                description.getConstructors().add(it.newElementDescription(classifier.getName(), (EObject)memberContainer, (EClassifier)classifier, commonSuperClassifier));
                return null;
            }, (it, grammarContainer, memberContainer, classifier) -> {
                description.getNamedMembers().add(it.newElementDescription(classifier.getName(), (EObject)memberContainer, (EClassifier)classifier, commonSuperClassifier));
                return null;
            }, (it, grammarContainer, memberContainer, classifier) -> {
                description.getUnnamedMembers().add(it.newElementDescription(classifier.getName(), (EObject)memberContainer, (EClassifier)classifier, commonSuperClassifier));
                return null;
            }, (it, grammarContainer, memberContainer, classifier) -> {
                description.getImplicitlyNamedMembers().add(it.newElementDescription(classifier.getName(), (EObject)memberContainer, (EClassifier)classifier, commonSuperClassifier));
                return null;
            });
        }
        final String generatedObjectFieldName = Strings.toFirstLower((String)description.getElementDescription().elementType().getSimpleName());
        description.setContent(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                String defaultType;
                if (!forInterface && !forAppender) {
                    it.append((Object)"\tprivate ");
                    it.append((Object)description.getElementDescription().elementType());
                    it.append((Object)" ");
                    it.append((Object)generatedObjectFieldName);
                    it.append((Object)";");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    if (description.isMemberElement()) {
                        it.append((Object)"\tprivate ");
                        it.append(EObject.class);
                        it.append((Object)" container;");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                } else {
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for the type reference use");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(JvmType.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context in which the type is defined");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, ");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\tpublic ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext() {");
                    it.newLine();
                    it.append((Object)"\t\treturn this.builder.getTypeResolutionContext();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tvoid dispose();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic void dispose() {");
                    it.newLine();
                    it.append((Object)"\t\tthis.builder.dispose();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (!forInterface) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Override.class);
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(String.class);
                    it.append((Object)" toString() {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    if (forAppender) {
                        it.append((Object)"this.builder.toString();");
                    } else {
                        it.append(EmfFormatter.class);
                        it.append((Object)".objToStr(");
                        it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(description.getElementDescription().elementType()));
                        it.append((Object)");");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Initialize the Ecore element when inside a script.");
                it.newLine();
                it.append((Object)"\t * @param script the SARL script in which this ");
                it.append((Object)description.getElementDescription().elementType().getSimpleName());
                it.append((Object)" is added.");
                it.newLine();
                it.append((Object)"\t * @param name the simple name of the ");
                it.append((Object)description.getElementDescription().elementType().getSimpleName());
                it.append((Object)".");
                it.newLine();
                it.append((Object)"\t * @param context the context in which the resolution of types must be done.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void eInit(");
                it.append((Object)TopElementBuilderFragment.this.getCodeElementExtractor().getLanguageScriptInterface());
                it.append((Object)" script, String name, ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" context)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.eInit(script, name, context);");
                    } else {
                        it.append((Object)"\t\tsetTypeResolutionContext(context);");
                        it.newLine();
                        it.append((Object)"\t\tif (this.");
                        it.append((Object)generatedObjectFieldName);
                        it.append((Object)" == null) {");
                        it.newLine();
                        if (description.isMemberElement()) {
                            it.append((Object)"\t\t\tthis.container = script;");
                            it.newLine();
                        }
                        it.append((Object)"\t\t\tthis.");
                        it.append((Object)generatedObjectFieldName);
                        it.append((Object)" = ");
                        it.append((Object)TopElementBuilderFragment.this.getXFactoryFor(description.getElementDescription().elementType()));
                        it.append((Object)".eINSTANCE.create");
                        it.append((Object)Strings.toFirstUpper((String)description.getElementDescription().elementType().getSimpleName()));
                        it.append((Object)"();");
                        it.newLine();
                        if (description.isAnnotationInfo()) {
                            TypeReference commonType = description.getElementDescription().commonSuperType();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)".setAnnotationInfo(");
                            it.append((Object)TopElementBuilderFragment.this.getXFactoryFor(commonType));
                            it.append((Object)".eINSTANCE.create");
                            it.append((Object)Strings.toFirstUpper((String)commonType.getSimpleName()));
                            it.append((Object)"());");
                            it.newLine();
                        }
                        it.append((Object)"\t\t\tthis.");
                        it.append((Object)generatedObjectFieldName);
                        it.append((Object)".setName(name);");
                        it.newLine();
                        it.append((Object)"\t\t\tscript.");
                        it.append((Object)TopElementBuilderFragment.this.getLanguageScriptMemberGetter());
                        it.append((Object)"().add(this.");
                        it.append((Object)generatedObjectFieldName);
                        it.append((Object)");");
                        it.newLine();
                        it.append((Object)"\t\t}");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (description.isMemberElement()) {
                    it.append((Object)"\t/** Initialize the Ecore element when inner type declaration.");
                    it.newLine();
                    it.append((Object)"\t * @param container the Ecore type that must contain this new ");
                    it.append((Object)description.getElementDescription().elementType().getSimpleName());
                    it.append((Object)".");
                    it.newLine();
                    it.append((Object)"\t * @param name the simple name of the ");
                    it.append((Object)description.getElementDescription().elementType().getSimpleName());
                    it.append((Object)".");
                    it.newLine();
                    it.append((Object)"\t * @param context the context in which the resolution of types must be done.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)"void eInit(");
                    it.append((Object)TopElementBuilderFragment.this.getCodeElementExtractor().getLanguageTopElementType());
                    it.append((Object)" container, String name, ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" context)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.eInit(container, name, context);");
                        } else {
                            it.append((Object)"\t\tsetTypeResolutionContext(context);");
                            it.newLine();
                            it.append((Object)"\t\tif (this.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)" == null) {");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.container = container;");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)" = ");
                            it.append((Object)TopElementBuilderFragment.this.getXFactoryFor(description.getElementDescription().elementType()));
                            it.append((Object)".eINSTANCE.create");
                            it.append((Object)Strings.toFirstUpper((String)description.getElementDescription().elementType().getSimpleName()));
                            it.append((Object)"();");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)".setName(name);");
                            it.newLine();
                            it.append((Object)"\t\t\tcontainer.");
                            it.append((Object)TopElementBuilderFragment.this.getLanguageContainerMemberGetter());
                            it.append((Object)"().add(this.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)");");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)("\t/** Replies the generated " + description.getElementDescription().elementType().getSimpleName() + "."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)description.getElementDescription().elementType());
                it.append((Object)" ");
                it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(description.getElementDescription().elementType()));
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.");
                        it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(description.getElementDescription().elementType()));
                        it.append((Object)";");
                    } else {
                        it.append((Object)"\t\treturn this.");
                        it.append((Object)generatedObjectFieldName);
                        it.append((Object)";");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the reference to the generated SarlAgent.");
                it.newLine();
                if (hasTypeParameters.get()) {
                    it.append((Object)"\t * @param args the generic type arguments to put inside the reference.");
                    it.newLine();
                }
                it.append((Object)"\t * @since 0.15");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(JvmTypeReference.class);
                it.append((Object)" get");
                it.append((Object)description.getElementDescription().elementType());
                it.append((Object)"Reference(");
                if (hasTypeParameters.get()) {
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args");
                }
                it.append((Object)")");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.get");
                        it.append((Object)description.getElementDescription().elementType());
                        it.append((Object)"Reference(");
                        if (hasTypeParameters.get()) {
                            it.append((Object)"args");
                        }
                        it.append((Object)");");
                    } else {
                        it.append((Object)"\t\t");
                        it.append((Object)description.getElementDescription().elementType());
                        it.append((Object)" ecoreObject = ");
                        it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(description.getElementDescription().elementType()));
                        it.append((Object)";");
                        it.newLine();
                        it.append((Object)"\t\treturn getTypeReferenceFor(ecoreObject");
                        if (hasTypeParameters.get()) {
                            it.append((Object)", args");
                        }
                        it.append((Object)");");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the JVM declared type for this generated ");
                it.append((Object)description.getElementDescription().elementType());
                it.append((Object)".");
                it.newLine();
                it.append((Object)"\t * @return the type, never {@code null}.");
                it.newLine();
                it.append((Object)"\t * @since 0.15");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(JvmDeclaredType.class);
                it.append((Object)" getJvmDeclaredType()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    if (forAppender) {
                        it.append((Object)"this.builder.getJvmDeclaredType();");
                    } else {
                        it.append((Object)"getAssociatedElement(");
                        it.append(JvmDeclaredType.class);
                        it.append((Object)".class, ");
                        it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(description.getElementDescription().elementType()));
                        it.append((Object)", eResource(), true);");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)("\t/** Replies the resource to which the " + description.getElementDescription().elementType().getSimpleName() + " is attached."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(Resource.class);
                it.append((Object)" eResource()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(description.getElementDescription().elementType()));
                    it.append((Object)".eResource();");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)TopElementBuilderFragment.this.generateStandardCommentFunctions(forInterface, forAppender, TopElementBuilderFragment.this.getGeneratedTypeAccessor(description.getElementDescription().elementType()), description.getElementDescription().builderInterfaceType()));
                if (isExtendKeywordFound.get()) {
                    defaultType = TopElementBuilderFragment.this.getCodeBuilderConfig().getDefaultSupers().get(description.getElementDescription().elementType().getSimpleName());
                    if (isExtendsKeywordFound.get()) {
                        it.append((Object)"\t/** Add the super type.");
                        it.newLine();
                        it.append((Object)"\t * @param superType the qualified name of the super type.");
                        it.newLine();
                        it.append((Object)"\t * @return {@code this}");
                        it.newLine();
                        AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                        it.append((Object)"\t */");
                        it.newLine();
                        it.append((Object)"\t");
                        if (!forInterface) {
                            it.append((Object)"public ");
                        }
                        it.append((Object)description.getElementDescription().builderInterfaceType());
                        it.append((Object)" addExtends(String superType)");
                    } else {
                        it.append((Object)"\t/** Change the super type.");
                        it.newLine();
                        it.append((Object)"\t * @param superType the qualified name of the super type,");
                        it.newLine();
                        it.append((Object)"\t *     or {@code null} if the default type.");
                        it.newLine();
                        it.append((Object)"\t * @return {@code this}");
                        it.newLine();
                        AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                        it.append((Object)"\t */");
                        it.newLine();
                        it.append((Object)"\t");
                        if (!forInterface) {
                            it.append((Object)"public ");
                        }
                        it.append((Object)description.getElementDescription().builderInterfaceType());
                        it.append((Object)" setExtends(String superType)");
                    }
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            if (isExtendsKeywordFound.get()) {
                                it.append((Object)"\t\tthis.builder.addExtends(superType);");
                            } else {
                                it.append((Object)"\t\tthis.builder.setExtends(superType);");
                            }
                        } else {
                            it.append((Object)"\t\tif (!");
                            it.append(Strings.class);
                            it.append((Object)".isEmpty(superType)) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" superTypeRef = newTypeRef(this.");
                            if (description.isMemberElement()) {
                                it.append((Object)"container");
                            } else {
                                it.append((Object)generatedObjectFieldName);
                            }
                            it.append((Object)", superType);");
                            it.newLine();
                            it.append((Object)"\t\t\tif (superTypeRef instanceof ");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)" pref) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t");
                            if (isExtendsKeywordFound.get()) {
                                it.append((Object)"add");
                            } else {
                                it.append((Object)"set");
                            }
                            it.append((Object)"Extends(pref);");
                            it.newLine();
                            it.append((Object)"\t\t\t} else {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tthrow new ");
                            it.append(IllegalArgumentException.class);
                            it.append((Object)"();");
                            it.newLine();
                            it.append((Object)"\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t}");
                            if (!isExtendsKeywordFound.get()) {
                                it.append((Object)" else {");
                                it.newLine();
                                it.append((Object)"\t\t\tsetExtends((");
                                it.append(JvmParameterizedTypeReference.class);
                                it.append((Object)") null);");
                                it.newLine();
                                it.append((Object)"\t\t}");
                            }
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    if (isExtendsKeywordFound.get()) {
                        it.append((Object)"\t/** Add the super type.");
                        it.newLine();
                        it.append((Object)"\t * @param superType the super type.");
                        it.newLine();
                        it.append((Object)"\t * @return {@code this}");
                        it.newLine();
                        AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                        it.append((Object)"\t */");
                        it.newLine();
                        it.append((Object)"\t");
                        if (!forInterface) {
                            it.append((Object)"public ");
                        }
                        it.append((Object)description.getElementDescription().builderInterfaceType());
                        it.append((Object)" addExtends(");
                        it.append(JvmParameterizedTypeReference.class);
                        it.append((Object)" superType)");
                    } else {
                        it.append((Object)"\t/** Change the super type.");
                        it.newLine();
                        it.append((Object)"\t * @param superType the super type,");
                        it.newLine();
                        it.append((Object)"\t *     or {@code null} if the default type.");
                        it.newLine();
                        it.append((Object)"\t * @return {@code this}.");
                        it.newLine();
                        AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                        it.append((Object)"\t */");
                        it.newLine();
                        it.append((Object)"\t");
                        if (!forInterface) {
                            it.append((Object)"public ");
                        }
                        it.append((Object)description.getElementDescription().builderInterfaceType());
                        it.append((Object)" setExtends(");
                        it.append(JvmTypeReference.class);
                        it.append((Object)" superType)");
                    }
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            if (isExtendsKeywordFound.get()) {
                                it.append((Object)"\t\tthis.builder.addExtends(superType);");
                            } else {
                                it.append((Object)"\t\tthis.builder.setExtends(superType);");
                            }
                        } else {
                            it.append((Object)"\t\tif (superType instanceof ");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)" psuperType");
                            if (!Strings.isEmpty((String)defaultType)) {
                                it.append((Object)" && !");
                                it.append((Object)new TypeReference(defaultType));
                                it.append((Object)".class.getName().equals(superType.getType().getIdentifier())");
                            }
                            it.append((Object)") {");
                            it.newLine();
                            if (!Strings.isEmpty((String)defaultType)) {
                                it.append((Object)"\t\t\t");
                                it.append(JvmTypeReference.class);
                                it.append((Object)" baseTypeRef = findType(this.");
                                if (description.isMemberElement()) {
                                    it.append((Object)"container");
                                } else {
                                    it.append((Object)generatedObjectFieldName);
                                }
                                it.append((Object)", ");
                                it.append((Object)new TypeReference(defaultType));
                                it.append((Object)".class.getCanonicalName());");
                                it.newLine();
                                it.append((Object)"\t\t\tif (isSubTypeOf(this.");
                                if (description.isMemberElement()) {
                                    it.append((Object)"container");
                                } else {
                                    it.append((Object)generatedObjectFieldName);
                                }
                                it.append((Object)", superType, baseTypeRef)) {");
                                it.newLine();
                                it.append((Object)"\t\t\t\t");
                            } else {
                                it.append((Object)"\t\t\t");
                            }
                            it.append((Object)"this.");
                            it.append((Object)generatedObjectFieldName);
                            if (isExtendsKeywordFound.get()) {
                                it.append((Object)".getExtends().add(psuperType);");
                            } else {
                                it.append((Object)".setExtends(psuperType);");
                            }
                            it.newLine();
                            if (!Strings.isEmpty((String)defaultType)) {
                                it.append((Object)"\t\t\t\treturn this;");
                            } else {
                                it.append((Object)"\t\t\treturn this;");
                            }
                            it.newLine();
                            if (!Strings.isEmpty((String)defaultType)) {
                                it.append((Object)"\t\t\t}");
                                it.newLine();
                            }
                            it.append((Object)"\t\t}");
                            if (!isExtendsKeywordFound.get()) {
                                it.newLine();
                                it.append((Object)"\t\tthis.");
                                it.append((Object)generatedObjectFieldName);
                                it.append((Object)".setExtends(null);");
                            }
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (isImplementKeywordFound.get()) {
                    defaultType = TopElementBuilderFragment.this.getCodeBuilderConfig().getDefaultImplementedSupers().get(description.getElementDescription().elementType().getSimpleName());
                    if (isImplementsKeywordFound.get()) {
                        it.append((Object)"\t/** Add an implemented type.");
                        it.newLine();
                        it.append((Object)"\t * @param type the qualified name of the implemented type.");
                        it.newLine();
                        it.append((Object)"\t * @return {@code this}");
                    } else {
                        it.append((Object)"\t/** Change the implemented type.");
                        it.newLine();
                        it.append((Object)"\t * @param type the qualified name of the implemented type,");
                        it.newLine();
                        it.append((Object)"\t *     or {@code null} for nothing.");
                        it.newLine();
                        it.append((Object)"\t * @return {@code this}");
                    }
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)description.getElementDescription().builderInterfaceType());
                    it.append((Object)" ");
                    if (isImplementsKeywordFound.get()) {
                        it.append((Object)"add");
                    } else {
                        it.append((Object)"set");
                    }
                    it.append((Object)"Implements(String type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.");
                            if (isImplementsKeywordFound.get()) {
                                it.append((Object)"add");
                            } else {
                                it.append((Object)"set");
                            }
                            it.append((Object)"Implements(type);");
                        } else {
                            it.append((Object)"\t\tif (!");
                            it.append(Strings.class);
                            it.append((Object)".isEmpty(type)) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" superTypeRef = newTypeRef(this.");
                            if (description.isMemberElement()) {
                                it.append((Object)"container");
                            } else {
                                it.append((Object)generatedObjectFieldName);
                            }
                            it.append((Object)", type);");
                            it.newLine();
                            it.append((Object)"\t\t\tif (superTypeRef instanceof ");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)" pref) {");
                            it.newLine();
                            it.append((Object)"\t\t\t\t");
                            if (isImplementsKeywordFound.get()) {
                                it.append((Object)"add");
                            } else {
                                it.append((Object)"set");
                            }
                            it.append((Object)"Implements(pref);");
                            it.newLine();
                            it.append((Object)"\t\t\t} else {");
                            it.newLine();
                            it.append((Object)"\t\t\t\tthrow new ");
                            it.append(IllegalArgumentException.class);
                            it.append((Object)"(type);");
                            it.newLine();
                            it.append((Object)"\t\t\t}");
                            it.newLine();
                            it.append((Object)"\t\t}");
                            if (!isImplementsKeywordFound.get()) {
                                it.append((Object)" else {");
                                it.newLine();
                                it.append((Object)"\t\t\tsetImplements((");
                                it.append(JvmParameterizedTypeReference.class);
                                it.append((Object)") null);");
                                it.newLine();
                                it.append((Object)"\t\t}");
                            }
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    if (isImplementsKeywordFound.get()) {
                        it.append((Object)"\t/** Add an implemented type.");
                        it.newLine();
                        it.append((Object)"\t * @param type the implemented type.");
                        it.newLine();
                        it.append((Object)"\t * @return {@code this}");
                    } else {
                        it.append((Object)"\t/** Change the implemented type.");
                        it.newLine();
                        it.append((Object)"\t * @param type the implemented type,");
                        it.newLine();
                        it.append((Object)"\t *     or {@code null} for nothing.");
                        it.newLine();
                        it.append((Object)"\t * @return {@code this}");
                    }
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)description.getElementDescription().builderInterfaceType());
                    it.append((Object)" ");
                    if (isImplementsKeywordFound.get()) {
                        it.append((Object)"add");
                    } else {
                        it.append((Object)"set");
                    }
                    it.append((Object)"Implements(");
                    it.append(JvmTypeReference.class);
                    it.append((Object)" type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.");
                            if (isImplementsKeywordFound.get()) {
                                it.append((Object)"add");
                            } else {
                                it.append((Object)"set");
                            }
                            it.append((Object)"Implements(type);");
                        } else {
                            it.append((Object)"\t\tif (type instanceof ");
                            it.append(JvmParameterizedTypeReference.class);
                            it.append((Object)" ptype");
                            if (!Strings.isEmpty((String)defaultType)) {
                                it.append((Object)" && !");
                                it.append((Object)new TypeReference(defaultType));
                                it.append((Object)".class.getName().equals(type.getType().getIdentifier())");
                            }
                            it.append((Object)") {");
                            it.newLine();
                            if (!Strings.isEmpty((String)defaultType)) {
                                it.append((Object)"\t\t\t");
                                it.append(JvmTypeReference.class);
                                it.append((Object)" baseTypeRef = findType(this.");
                                if (description.isMemberElement()) {
                                    it.append((Object)"container");
                                } else {
                                    it.append((Object)generatedObjectFieldName);
                                }
                                it.append((Object)", ");
                                it.append((Object)new TypeReference(defaultType));
                                it.append((Object)".class.getCanonicalName());");
                                it.newLine();
                                it.append((Object)"\t\t\tif (isSubTypeOf(this.");
                                if (description.isMemberElement()) {
                                    it.append((Object)"container");
                                } else {
                                    it.append((Object)generatedObjectFieldName);
                                }
                                it.append((Object)", type, baseTypeRef)) {");
                                it.newLine();
                                it.append((Object)"\t\t\t\t");
                            } else {
                                it.append((Object)"\t\t\t");
                            }
                            it.append((Object)"this.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)".");
                            if (isImplementsKeywordFound.get()) {
                                it.append((Object)"getImplements().add(");
                            } else {
                                it.append((Object)"setImplements(");
                            }
                            it.append((Object)"ptype);");
                            if (!Strings.isEmpty((String)defaultType)) {
                                it.newLine();
                                if (!isImplementsKeywordFound.get()) {
                                    it.append((Object)"\t\t\t\treturn;");
                                    it.newLine();
                                }
                                it.append((Object)"\t\t\t}");
                            } else if (!isImplementsKeywordFound.get()) {
                                it.newLine();
                                it.append((Object)"\t\t\treturn;");
                            }
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        if (!isImplementsKeywordFound.get()) {
                            it.newLine();
                            it.append((Object)"\tthis;");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)".setImplements(null);");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (isAnnotated.get()) {
                    it.append((Object)"\t/** Add an annotation.");
                    it.newLine();
                    it.append((Object)"\t * @param type the qualified name of the annotation.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)"void addAnnotation(String type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.addAnnotation(type);");
                        } else {
                            it.append((Object)"\t\tif (!");
                            it.append(Strings.class);
                            it.append((Object)".isEmpty(type)) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append(JvmTypeReference.class);
                            it.append((Object)" ref = newTypeRef(this.");
                            if (description.isMemberElement()) {
                                it.append((Object)"container");
                            } else {
                                it.append((Object)generatedObjectFieldName);
                            }
                            it.append((Object)", type);");
                            it.newLine();
                            it.append((Object)"\t\t\taddAnotation(ref);");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Add an annotation.");
                    it.newLine();
                    it.append((Object)"\t * @param type the annotation type.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)"void addAnnotation(");
                    it.append(JvmParameterizedTypeReference.class);
                    it.append((Object)" type)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.addAnnotation(type);");
                        } else {
                            it.append((Object)"\t\tif (type != null) {");
                            it.newLine();
                            it.append((Object)"\t\t\t");
                            it.append(XAnnotation.class);
                            it.append((Object)" annotation = ");
                            it.append(XAnnotationsFactory.class);
                            it.append((Object)".eINSTANCE.createXAnnotation();");
                            it.newLine();
                            it.append((Object)"\t\t\tannotation.setAnnotationType(type.getType());");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)".getAnnotations().add(annotation);");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasModifiers.get()) {
                    it.append((Object)"\t/** Add a modifier.");
                    it.newLine();
                    it.append((Object)"\t * @param modifier the modifier to add.");
                    it.newLine();
                    it.append((Object)"\t * @return {@code this}.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)description.getElementDescription().builderInterfaceType());
                    it.append((Object)" addModifier(String modifier)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\tthis.builder.addModifier(modifier);");
                        } else {
                            it.append((Object)"\t\tif (!");
                            it.append(Strings.class);
                            it.append((Object)".isEmpty(modifier)) {");
                            it.newLine();
                            it.append((Object)"\t\t\tthis.");
                            it.append((Object)generatedObjectFieldName);
                            it.append((Object)".getModifiers().add(modifier);");
                            it.newLine();
                            it.append((Object)"\t\t}");
                        }
                        it.newLine();
                        it.append((Object)"\t\treturn this;");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (hasTypeParameters.get()) {
                    if (!forInterface && !forAppender) {
                        it.append((Object)"\t@");
                        it.append(TopElementBuilderFragment.this.getInjectType());
                        it.newLine();
                        it.append((Object)"\tprivate ");
                        it.append(Provider.class);
                        it.append((Object)"<");
                        it.append((Object)TopElementBuilderFragment.this.getTypeParameterBuilderInterface());
                        it.append((Object)"> iTypeParameterBuilderProvider;");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                    it.append((Object)"\t/** Add a type parameter.");
                    it.newLine();
                    it.append((Object)"\t * @param name the simple name of the type parameter.");
                    it.newLine();
                    it.append((Object)"\t * @return the builder of type parameter.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append((Object)TopElementBuilderFragment.this.getTypeParameterBuilderInterface());
                    it.append((Object)" addTypeParameter(String name)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        if (forAppender) {
                            it.append((Object)"\t\treturn this.builder.addTypeParameter(name);");
                        } else {
                            it.append((Object)"\t\t");
                            it.append((Object)TopElementBuilderFragment.this.getTypeParameterBuilderInterface());
                            it.append((Object)" builder = this.iTypeParameterBuilderProvider.get();");
                            it.newLine();
                            it.append((Object)"\t\tfinal ");
                            it.append((Object)description.getElementDescription().elementType());
                            it.append((Object)" object = ");
                            it.append((Object)TopElementBuilderFragment.this.getGeneratedTypeAccessor(description.getElementDescription().elementType()));
                            it.append((Object)";");
                            it.newLine();
                            it.append((Object)"\t\t");
                            it.append(JvmType.class);
                            it.append((Object)" jvmType = get");
                            it.append((Object)description.getElementDescription().elementType());
                            it.append((Object)"Reference().getType();");
                            it.newLine();
                            it.append((Object)"\t\tbuilder.eInit(object, jvmType instanceof ");
                            it.append(JvmTypeParameterDeclarator.class);
                            it.append((Object)" declarator ? declarator : null, name, getTypeResolutionContext());");
                            it.newLine();
                            it.append((Object)"\t\tobject.getTypeParameters().add(builder.getJvmTypeParameter());");
                            it.newLine();
                            it.append((Object)"\t\treturn builder;");
                        }
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
            }
        });
    }

    public static class TopElementDescription {
        private final CodeElementExtractor.ElementDescription element;
        private final Collection<CodeElementExtractor.ElementDescription> namedMemberCandidates = new ArrayList<CodeElementExtractor.ElementDescription>();
        private final Collection<CodeElementExtractor.ElementDescription> unnamedMemberCandidates = new ArrayList<CodeElementExtractor.ElementDescription>();
        private final Collection<CodeElementExtractor.ElementDescription> implicitlyNnamedMemberCandidates = new ArrayList<CodeElementExtractor.ElementDescription>();
        private final Collection<CodeElementExtractor.ElementDescription> constructorCandidates = new ArrayList<CodeElementExtractor.ElementDescription>();
        private StringConcatenationClient content;
        private final boolean isMemberElement;
        private final boolean isAnnotationInfo;

        public TopElementDescription(CodeElementExtractor.ElementDescription element, boolean isMemberElement, boolean isAnnotationInfo) {
            this.element = element;
            this.isMemberElement = isMemberElement;
            this.isAnnotationInfo = isAnnotationInfo;
        }

        public String toString() {
            return this.element.name();
        }

        public CodeElementExtractor.ElementDescription getElementDescription() {
            return this.element;
        }

        public boolean isMemberElement() {
            return this.isMemberElement;
        }

        public boolean isAnnotationInfo() {
            return this.isAnnotationInfo;
        }

        @Pure
        public Collection<CodeElementExtractor.ElementDescription> getNamedMembers() {
            return this.namedMemberCandidates;
        }

        @Pure
        public Collection<CodeElementExtractor.ElementDescription> getUnnamedMembers() {
            return this.unnamedMemberCandidates;
        }

        @Pure
        public Collection<CodeElementExtractor.ElementDescription> getImplicitlyNamedMembers() {
            return this.implicitlyNnamedMemberCandidates;
        }

        @Pure
        public Collection<CodeElementExtractor.ElementDescription> getConstructors() {
            return this.constructorCandidates;
        }

        @Pure
        public StringConcatenationClient getContent() {
            return this.content;
        }

        public void setContent(StringConcatenationClient content) {
            this.content = content;
        }
    }
}

