/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder.fragments;

import com.google.inject.Inject;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class TypeParameterBuilderFragment
extends AbstractSubCodeBuilderFragment {
    @Pure
    public TypeReference getTypeParameterBuilderImpl() {
        return this.getCodeElementExtractor().getElementBuilderImpl("TypeParameter");
    }

    @Pure
    public TypeReference getTypeParameterBuilderImplCustom() {
        return this.getCodeElementExtractor().getElementBuilderImplCustom("TypeParameter");
    }

    @Override
    public void generate() {
        this.generateITypeParameterBuilder();
        this.generateTypeParameterBuilderImpl();
        if (this.getCodeBuilderConfig().isISourceAppendableEnable()) {
            this.generateTypeParameterAppender();
        }
        super.generate();
    }

    @Override
    public void generateRuntimeBindings(GuiceModuleAccess.BindingFactory factory) {
        super.generateRuntimeBindings(factory);
        this.bindTypeReferences(factory, this.getTypeParameterBuilderInterface(), this.getTypeParameterBuilderImpl(), this.getTypeParameterBuilderImplCustom());
    }

    protected void generateITypeParameterBuilder() {
        final TypeReference builder = this.getTypeParameterBuilderInterface();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + TypeParameterBuilderFragment.this.getLanguageName() + " type parameter."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public interface ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)TypeParameterBuilderFragment.this.generateMembers(true, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateTypeParameterBuilderImpl() {
        final TypeReference builderInterface = this.getTypeParameterBuilderInterface();
        final TypeReference builder = this.getTypeParameterBuilderImpl();
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Builder of a " + TypeParameterBuilderFragment.this.getLanguageName() + " type parameter."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)builder.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)TypeParameterBuilderFragment.this.getAbstractBuilderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)TypeParameterBuilderFragment.this.generateMembers(false, false));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(builder, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected void generateTypeParameterAppender() {
        CodeElementExtractor.ElementDescription parameter = this.getCodeElementExtractor().getTypeParameter();
        final String accessor = "get" + Strings.toFirstUpper((String)parameter.elementType().getSimpleName()) + "()";
        final TypeReference builderInterface = this.getTypeParameterBuilderInterface();
        final TypeReference appender = this.getCodeElementExtractor().getElementAppenderImpl("TypeParameter");
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)("/** Appender of a " + TypeParameterBuilderFragment.this.getLanguageName() + " type parameter."));
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@SuppressWarnings(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)appender.getSimpleName());
                it.append((Object)" extends ");
                it.append((Object)TypeParameterBuilderFragment.this.getCodeElementExtractor().getAbstractAppenderImpl());
                it.append((Object)" implements ");
                it.append((Object)builderInterface);
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)TypeParameterBuilderFragment.this.generateAppenderMembers(appender.getSimpleName(), builderInterface, accessor));
                it.append((Object)TypeParameterBuilderFragment.this.generateMembers(false, true));
                it.append((Object)"}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.getFileAccessFactory().createJavaFile(appender, content);
        javaFile.writeTo(this.getSrcGen());
    }

    protected StringConcatenationClient generateMembers(final boolean forInterface, final boolean forAppender) {
        final CodeElementExtractor.ElementDescription parameter = this.getCodeElementExtractor().getTypeParameter();
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                if (!forInterface && !forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append(EObject.class);
                    it.append((Object)" context;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate ");
                    it.append((Object)parameter.elementType());
                    it.append((Object)" parameter;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Inject.class);
                    it.newLine();
                    it.append((Object)"\t\tprivate ");
                    it.append(TypesFactory.class);
                    it.append((Object)" jvmTypesFactory;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprivate boolean hasDefaultConstraint = true;");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else {
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given name.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context for the type reference use");
                    it.newLine();
                    it.append((Object)"\t * @param typeName the fully qualified name of the type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, String typeName)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, typeName);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(JvmType.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                    it.append((Object)"\t/** Find the reference to the type with the given type parameters.");
                    it.newLine();
                    it.append((Object)"\t * @param context the context in which the type is defined");
                    it.newLine();
                    it.append((Object)"\t * @param type the type to reference");
                    it.newLine();
                    it.append((Object)"\t * @param args the type parameters to add to the to reference to the given type");
                    it.newLine();
                    it.append((Object)"\t * @return the type reference.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    if (!forInterface) {
                        it.append((Object)"public ");
                    }
                    it.append(JvmTypeReference.class);
                    it.append((Object)" newTypeRef(");
                    it.append(Notifier.class);
                    it.append((Object)" context, ");
                    it.append(Class.class);
                    it.append((Object)" type, ");
                    it.append(JvmTypeReference.class);
                    it.append((Object)"... args)");
                    if (forInterface) {
                        it.append((Object)";");
                    } else {
                        it.append((Object)" {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.builder.newTypeRef(context, type, args);");
                        it.newLine();
                        it.append((Object)"\t}");
                    }
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Initialize the type parameter.");
                it.newLine();
                it.append((Object)"\t * <p>Caution: This initialization function does not add the type parameter in its container.");
                it.newLine();
                it.append((Object)"\t * The container is responsible of adding the type parameter in its internal object.");
                it.newLine();
                it.append((Object)"\t * However, this function sets the declarator of the type parameter by calling");
                it.newLine();
                it.append((Object)"\t * {@link JvmTypeParameter#setDeclarator(JvmTypeParameterDeclarator)}.");
                it.newLine();
                it.append((Object)"\t * @param context the container of the type parameter.");
                it.newLine();
                it.append((Object)"\t * @param declarator the container of the type parameter.");
                it.newLine();
                it.append((Object)"\t * @param name the name of the type parameter.");
                it.newLine();
                it.append((Object)"\t * @param typeContext the provider of types or null.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void eInit(");
                it.append(XtendTypeDeclaration.class);
                it.append((Object)" context, ");
                it.append(JvmTypeParameterDeclarator.class);
                it.append((Object)" declarator, String name, ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" typeContext)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.eInit(context, declarator, name, typeContext);");
                    } else {
                        it.append((Object)"\t\tinternalEInit(context, declarator, name, typeContext);");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Initialize the type parameter.");
                it.newLine();
                it.append((Object)"\t * <p>Caution: This initialization function does not add the type parameter in its container.");
                it.newLine();
                it.append((Object)"\t * The container is responsible of adding the type parameter in its internal object.");
                it.newLine();
                it.append((Object)"\t * However, this function sets the declarator of the type parameter by calling");
                it.newLine();
                it.append((Object)"\t * {@link JvmTypeParameter#setDeclarator(JvmTypeParameterDeclarator)}.");
                it.newLine();
                it.append((Object)"\t * @param context the container of the type parameter.");
                it.newLine();
                it.append((Object)"\t * @param declarator the container of the type parameter.");
                it.newLine();
                it.append((Object)"\t * @param name the name of the type parameter.");
                it.newLine();
                it.append((Object)"\t * @param typeContext the provider of types or null.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)"void eInit(");
                it.append(XtendExecutable.class);
                it.append((Object)" context, ");
                it.append(JvmTypeParameterDeclarator.class);
                it.append((Object)" declarator, String name, ");
                it.append(IJvmTypeProvider.class);
                it.append((Object)" typeContext)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\tthis.builder.eInit(context, declarator, name, typeContext);");
                    } else {
                        it.append((Object)"\t\tinternalEInit(context, declarator, name, typeContext);");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (!forInterface && !forAppender) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\tprotected ");
                    it.append((Object)"void internalEInit(");
                    it.append(EObject.class);
                    it.append((Object)" context, ");
                    it.append(JvmTypeParameterDeclarator.class);
                    it.append((Object)" declarator, String name, ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" typeContext)");
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\tsetTypeResolutionContext(typeContext);");
                    it.newLine();
                    it.append((Object)"\t\tthis.context = context;");
                    it.newLine();
                    it.append((Object)"\t\tthis.parameter = this.jvmTypesFactory.create");
                    it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                    it.append((Object)"();");
                    it.newLine();
                    it.append((Object)"\t\tthis.parameter.set");
                    it.append((Object)Strings.toFirstUpper((String)TypeParameterBuilderFragment.this.getCodeBuilderConfig().getParameterNameGrammarName()));
                    it.append((Object)"(name);");
                    it.newLine();
                    it.append((Object)"\t\tif (declarator != null) {");
                    it.newLine();
                    it.append((Object)"\t\t\tthis.parameter.setDeclarator(declarator);");
                    it.newLine();
                    it.append((Object)"\t\t}");
                    it.newLine();
                    it.append((Object)"\t\tfinal ");
                    it.append(JvmUpperBound.class);
                    it.append((Object)" constraint = this.jvmTypesFactory.createJvmUpperBound();");
                    it.newLine();
                    it.append((Object)"\t\tconstraint.setTypeReference(newTypeRef(");
                    it.append(Object.class);
                    it.append((Object)".class));");
                    it.newLine();
                    it.append((Object)"\t\tgetJvmTypeParameter().getConstraints().add(constraint);");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\t");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Replies the context for type resolution.");
                    it.newLine();
                    it.append((Object)"\t * @return the context or {@code null} if the Ecore object is the context.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(IJvmTypeProvider.class);
                    it.append((Object)" getTypeResolutionContext() {");
                    it.newLine();
                    it.append((Object)"\t\treturn this.builder.getTypeResolutionContext();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Replies the created parameter.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the parameter.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)parameter.elementType());
                it.append((Object)" get");
                it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                it.append((Object)"()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.get");
                        it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                        it.append((Object)"();");
                    } else {
                        it.append((Object)"\t\treturn this.parameter;");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies a reference to the created parameter.");
                it.newLine();
                it.append((Object)"\t *");
                it.newLine();
                it.append((Object)"\t * @return the reference to the parameter.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(JvmTypeReference.class);
                it.append((Object)" get");
                it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                it.append((Object)"Reference()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    if (forAppender) {
                        it.append((Object)"\t\treturn this.builder.get");
                        it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                        it.append((Object)"Reference();");
                    } else {
                        it.append((Object)"\t\treturn newTypeRef(this.parameter);");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the resource to which the type parameter is attached.");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t@");
                it.append(Pure.class);
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append(Resource.class);
                it.append((Object)" eResource()");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\treturn get");
                    it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                    it.append((Object)"().eResource();");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                if (!forAppender && !forInterface) {
                    AbstractSubCodeBuilderFragment.appendEmptyComment(it);
                    it.append((Object)"\t@");
                    it.append(Override.class);
                    it.newLine();
                    it.append((Object)"\t@");
                    it.append(Pure.class);
                    it.newLine();
                    it.append((Object)"\tpublic ");
                    it.append(String.class);
                    it.append((Object)" toString() {");
                    it.newLine();
                    it.append((Object)"\t\treturn ");
                    if (forAppender) {
                        it.append((Object)"this.builder.toString();");
                    } else {
                        it.append(EmfFormatter.class);
                        it.append((Object)".objToStr(get");
                        it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                        it.append((Object)"());");
                    }
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                if (forInterface) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tvoid dispose();");
                    it.newLineIfNotEmpty();
                    it.newLine();
                } else if (forAppender) {
                    it.append((Object)"\t/** Dispose the resource.");
                    it.newLine();
                    AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                    it.append((Object)"\t */");
                    it.newLine();
                    it.append((Object)"\tpublic void dispose() {");
                    it.newLine();
                    it.append((Object)"\t\tthis.builder.dispose();");
                    it.newLine();
                    it.append((Object)"\t}");
                    it.newLineIfNotEmpty();
                    it.newLine();
                }
                it.append((Object)"\t/** Add upper type bounds.");
                it.newLine();
                it.append((Object)"\t * @param type the type.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)TypeParameterBuilderFragment.this.getTypeParameterBuilderInterface());
                it.append((Object)" addUpperConstraint(String type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    if (forAppender) {
                        it.append((Object)"this.builder.addUpperConstraint(type);");
                    } else {
                        it.append((Object)"addUpperConstraint(newTypeRef(this.context, type));");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Add upper type bounds.");
                it.newLine();
                it.append((Object)"\t * @param type the type.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)TypeParameterBuilderFragment.this.getTypeParameterBuilderInterface());
                it.append((Object)" addUpperConstraint(");
                it.append(JvmTypeReference.class);
                it.append((Object)" type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    if (forAppender) {
                        it.append((Object)"this.builder.addUpperConstraint(type);");
                    } else {
                        it.append((Object)"if (this.hasDefaultConstraint) {");
                        it.newLine();
                        it.append((Object)"\t\t\tthis.hasDefaultConstraint = false;");
                        it.newLine();
                        it.append((Object)"\t\t\tgetJvmTypeParameter().getConstraints().clear();");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\tfinal ");
                        it.append(JvmUpperBound.class);
                        it.append((Object)" constraint = this.jvmTypesFactory.createJvmUpperBound();");
                        it.newLine();
                        it.append((Object)"\t\tconstraint.setTypeReference(type);");
                        it.newLine();
                        it.append((Object)"\t\tget");
                        it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                        it.append((Object)"().getConstraints().add(constraint);");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Add lower type bounds.");
                it.newLine();
                it.append((Object)"\t * @param type the type.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)TypeParameterBuilderFragment.this.getTypeParameterBuilderInterface());
                it.append((Object)" addLowerConstraint(String type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    if (forAppender) {
                        it.append((Object)"this.builder.addLowerConstraint(type);");
                    } else {
                        it.append((Object)"addLowerConstraint(newTypeRef(this.context, type));");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Add lower type bounds.");
                it.newLine();
                it.append((Object)"\t * @param type the type.");
                it.newLine();
                it.append((Object)"\t * @return {@code this}");
                it.newLine();
                AbstractSubCodeBuilderFragment.appendFileLineComment(it);
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\t");
                if (!forInterface) {
                    it.append((Object)"public ");
                }
                it.append((Object)TypeParameterBuilderFragment.this.getTypeParameterBuilderInterface());
                it.append((Object)" addLowerConstraint(");
                it.append(JvmTypeReference.class);
                it.append((Object)" type)");
                if (forInterface) {
                    it.append((Object)";");
                } else {
                    it.append((Object)" {");
                    it.newLine();
                    it.append((Object)"\t\t");
                    if (forAppender) {
                        it.append((Object)"this.builder.addLowerConstraint(type);");
                    } else {
                        it.append((Object)"if (this.hasDefaultConstraint) {");
                        it.newLine();
                        it.append((Object)"\t\t\tthis.hasDefaultConstraint = false;");
                        it.newLine();
                        it.append((Object)"\t\t\tgetJvmTypeParameter().getConstraints().clear();");
                        it.newLine();
                        it.append((Object)"\t\t}");
                        it.newLine();
                        it.append((Object)"\t\tfinal ");
                        it.append(JvmLowerBound.class);
                        it.append((Object)" constraint = this.jvmTypesFactory.createJvmLowerBound();");
                        it.newLine();
                        it.append((Object)"\t\tconstraint.setTypeReference(type);");
                        it.newLine();
                        it.append((Object)"\t\tget");
                        it.append((Object)Strings.toFirstUpper((String)parameter.elementType().getSimpleName()));
                        it.append((Object)"().getConstraints().add(constraint);");
                    }
                    it.newLine();
                    it.append((Object)"\t\treturn this;");
                    it.newLine();
                    it.append((Object)"\t}");
                }
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
    }
}

