/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.sarl.lang.mwe2.externalspec.ExternalHighlightingConfig;
import io.sarl.lang.mwe2.externalspec.IStyleAppendable;
import io.sarl.lang.mwe2.keywords.GrammarKeywordAccessConfig;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.impl.Primitives;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.AbstractStringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;

public abstract class AbstractExternalHighlightingFragment2<T extends IStyleAppendable>
extends AbstractXtextGeneratorFragment {
    private static final Logger LOG = Logger.getLogger(AbstractExternalHighlightingFragment2.class);
    private static final Pattern KEYWORD_PATTERN = Pattern.compile("^[a-zA-Z]{2,}$");
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile("^[!#%&()*/+,\\-:;<=>?@\\[\\\\\\]^{|}~.%]+$");
    private static final Pattern MODIFIER_RULE_PATTERN = Pattern.compile("^[a-zA-Z]+Modifier$");
    private static final String README_BASENAME = "README";
    private static final String REGEX_SPECIAL_CHARS = "[\\<\\(\\[\\{\\\\\\^\\-\\=\\$\\!\\|\\]\\}\\)\\?\\*\\+\\.\\>\\:\\=\\!]";
    private static final String REGEX_SPECIAL_CHARS_PROTECT = "\\\\$0";
    @Inject
    private GrammarKeywordAccessConfig grammarKeywordAccessConfig;
    @Inject
    private CodeConfig codeConfig;
    @Inject
    private ExternalHighlightingConfig highlightingConfig;
    @Inject
    @Named(value="LANGUAGE_VERSION")
    private String languageVersion;
    private final Set<String> outputDirectories = new TreeSet<String>();
    private String basename;
    private String basenameTemplate = "{0}.txt";
    private boolean enableColors = true;
    private final List<String> mimeTypes = new ArrayList<String>();
    private Functions.Function2<? super File, ? super String, ? extends File> outputDirectoryFilter;

    public Functions.Function2<? super File, ? super String, ? extends File> getOutputDirectoryFilter() {
        return this.outputDirectoryFilter;
    }

    public void setOutputDirectoryFilter(Functions.Function2<? super File, ? super String, ? extends File> filter) {
        this.outputDirectoryFilter = filter;
    }

    protected static String quoteRegex(String regex) {
        if (regex == null) {
            return "";
        }
        return regex.replaceAll(REGEX_SPECIAL_CHARS, REGEX_SPECIAL_CHARS_PROTECT);
    }

    protected static String orRegex(Iterable<String> elements) {
        StringBuilder regex = new StringBuilder();
        for (String element : elements) {
            if (regex.length() > 0) {
                regex.append("|");
            }
            regex.append("(?:");
            regex.append(AbstractExternalHighlightingFragment2.quoteRegex(element));
            regex.append(")");
        }
        return regex.toString();
    }

    protected static String keywordRegex(Iterable<String> keywords) {
        return "\\b(?:" + AbstractExternalHighlightingFragment2.orRegex(keywords) + ")\\b";
    }

    @SafeVarargs
    protected static Set<String> sortedConcat(Iterable<String> ... iterables) {
        TreeSet<String> set = new TreeSet<String>();
        for (Iterable<String> iterable : iterables) {
            for (String obj : iterable) {
                set.add(obj);
            }
        }
        return set;
    }

    public void addMimeType(String mimeType) {
        if (!Strings.isEmpty((String)mimeType)) {
            for (String mtype : mimeType.split("[:;,]")) {
                this.mimeTypes.add(mtype);
            }
        }
    }

    @Pure
    public List<String> getMimeTypes() {
        if (this.mimeTypes.isEmpty()) {
            return Arrays.asList("text/x-" + this.getLanguageSimpleName().toLowerCase());
        }
        return this.mimeTypes;
    }

    @Pure
    public void setBasename(String basename) {
        if (!Strings.isEmpty((String)basename)) {
            this.basename = basename;
        }
    }

    @Pure
    public String getBasename() {
        return this.getBasename(null);
    }

    @Pure
    public String getBasename(String defaultName) {
        if (Strings.isEmpty((String)this.basename)) {
            return defaultName;
        }
        return this.basename;
    }

    @Pure
    public void setBasenameTemplate(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.basenameTemplate = pattern;
        }
    }

    @Pure
    public String getBasenameTemplate() {
        return this.basenameTemplate;
    }

    public void setEnableColors(boolean useColors) {
        this.enableColors = useColors;
    }

    @Pure
    public boolean getEnableColors() {
        return this.enableColors;
    }

    public void addOutput(String directory) {
        if (!Strings.isEmpty((String)directory)) {
            this.outputDirectories.add(directory);
        }
    }

    @Pure
    public Set<String> getOutputs() {
        return this.outputDirectories;
    }

    @Pure
    protected CodeConfig getCodeConfig() {
        return this.codeConfig;
    }

    @Pure
    protected ExternalHighlightingConfig getHighlightingConfig() {
        return this.highlightingConfig;
    }

    private static void exploreGrammar(Grammar grammar, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> literals, Set<String> excludedKeywords, Set<String> ignored) {
        for (AbstractRule rule : grammar.getRules()) {
            boolean isModifierRule = MODIFIER_RULE_PATTERN.matcher(rule.getName()).matches();
            TreeIterator iterator = rule.eAllContents();
            while (iterator.hasNext()) {
                Keyword xkeyword;
                String value;
                EObject object = (EObject)iterator.next();
                if (!(object instanceof Keyword) || Strings.isEmpty((String)(value = (xkeyword = (Keyword)object).getValue()))) continue;
                if (KEYWORD_PATTERN.matcher(value).matches()) {
                    if (literals.contains(value) || primitiveTypes.contains(value)) continue;
                    if (excludedKeywords.contains(value)) {
                        ignored.add(value);
                        continue;
                    }
                    if (isModifierRule) {
                        modifiers.add(value);
                        continue;
                    }
                    expressionKeywords.add(value);
                    continue;
                }
                if (!PUNCTUATION_PATTERN.matcher(value).matches()) continue;
                punctuation.add(value);
            }
        }
    }

    public final void generate() {
        Grammar grammar = this.getGrammar();
        if (grammar == null) {
            throw new RuntimeException("No grammar defined");
        }
        LOG.info((Object)MessageFormat.format("Generating highlighting configuration for {0}", ((Object)((Object)this)).toString()));
        TreeSet<String> literals = new TreeSet<String>();
        TreeSet<String> expressionKeywords = new TreeSet<String>();
        TreeSet<String> modifiers = new TreeSet<String>();
        TreeSet<String> primitiveTypes = new TreeSet<String>();
        ExternalHighlightingConfig hconfig = this.getHighlightingConfig();
        if (hconfig.getInheritFromGrammarKeywordAccesss() && this.grammarKeywordAccessConfig != null) {
            literals.addAll(this.grammarKeywordAccessConfig.getLiterals());
        }
        literals.addAll(hconfig.getLiterals());
        if (hconfig.getInheritFromGrammarKeywordAccesss() && this.grammarKeywordAccessConfig != null) {
            for (String string : this.grammarKeywordAccessConfig.getKeywords()) {
                if (literals.contains(string)) continue;
                expressionKeywords.add(string);
            }
        }
        Set<String> hKeywords = hconfig.getKeywords();
        for (String keyword : hKeywords) {
            if (literals.contains(keyword)) continue;
            expressionKeywords.add(keyword);
        }
        if (hconfig.getAddNativeTypes()) {
            for (Class type : Primitives.ALL_PRIMITIVE_TYPES) {
                primitiveTypes.add(type.getSimpleName());
            }
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(hconfig.getPunctuation());
        ArrayDeque<Grammar> grammars = new ArrayDeque<Grammar>();
        grammars.add(grammar);
        HashSet<String> excluded = new HashSet<String>();
        if (hconfig.getInheritFromGrammarKeywordAccesss() && this.grammarKeywordAccessConfig != null) {
            for (String ignoredKeyword : this.grammarKeywordAccessConfig.getIgnoredKeywords()) {
                if (hKeywords.contains(ignoredKeyword)) continue;
                excluded.add(ignoredKeyword);
            }
        }
        excluded.addAll(hconfig.getIgnoredKeywords());
        TreeSet<String> ignored = new TreeSet<String>();
        while (!grammars.isEmpty()) {
            Grammar grammarToTreat = (Grammar)grammars.poll();
            grammars.addAll((Collection<Grammar>)grammarToTreat.getUsedGrammars());
            AbstractExternalHighlightingFragment2.exploreGrammar(grammarToTreat, expressionKeywords, modifiers, primitiveTypes, treeSet, literals, excluded, ignored);
        }
        expressionKeywords.removeAll(modifiers);
        TreeSet tmp = new TreeSet(excluded);
        tmp.removeAll(ignored);
        if (!tmp.isEmpty()) {
            throw new RuntimeException(MessageFormat.format("The following keywords cannot be ignored because they are not defined in the grammars: {0}", tmp));
        }
        TreeSet<String> specialKeywords = new TreeSet<String>();
        for (String specialKeyword : hconfig.getSpecialKeywords()) {
            if (!expressionKeywords.contains(specialKeyword) && !modifiers.contains(specialKeyword) && !primitiveTypes.contains(specialKeyword) || ignored.contains(specialKeyword)) continue;
            specialKeywords.add(specialKeyword);
            expressionKeywords.remove(specialKeyword);
            modifiers.remove(specialKeyword);
            primitiveTypes.remove(specialKeyword);
        }
        TreeSet<String> typeDeclarationKeywords = new TreeSet<String>();
        for (String typeDeclarationKeyword : hconfig.getTypeDeclarationKeywords()) {
            if (!expressionKeywords.contains(typeDeclarationKeyword) && !modifiers.contains(typeDeclarationKeyword) && !primitiveTypes.contains(typeDeclarationKeyword) || ignored.contains(typeDeclarationKeyword)) continue;
            typeDeclarationKeywords.add(typeDeclarationKeyword);
            expressionKeywords.remove(typeDeclarationKeyword);
            modifiers.remove(typeDeclarationKeyword);
            primitiveTypes.remove(typeDeclarationKeyword);
        }
        this.generate(literals, expressionKeywords, modifiers, primitiveTypes, treeSet, ignored, specialKeywords, typeDeclarationKeywords);
    }

    protected final void generate(Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        T appendable = this.newStyleAppendable();
        this.generate(appendable, literals, expressionKeywords, modifiers, primitiveTypes, punctuation, ignored, specialKeywords, typeDeclarationKeywords);
        String language = this.getLanguageSimpleName().toLowerCase();
        String basename = this.getBasename(MessageFormat.format(this.getBasenameTemplate(), language));
        this.writeFile(basename, appendable);
        this.generateAdditionalFiles(basename, appendable);
        this.generateReadme(basename);
    }

    protected abstract void generate(T var1, Set<String> var2, Set<String> var3, Set<String> var4, Set<String> var5, Set<String> var6, Set<String> var7, Set<String> var8, Set<String> var9);

    protected void generateAdditionalFiles(String basename, T appendable) {
    }

    protected abstract Object getReadmeFileContent(String var1);

    public static CharSequence concat(final CharSequence ... lines) {
        return new CharSequence(){
            private final StringBuilder content = new StringBuilder();
            private int next;
            private int length = -1;

            @Override
            public String toString() {
                this.ensure(this.length());
                return this.content.toString();
            }

            private void ensure(int index) {
                while (this.next < lines.length && index >= this.content.length()) {
                    if (lines[this.next] != null) {
                        this.content.append(lines[this.next]).append("\n");
                    }
                    ++this.next;
                }
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                this.ensure(end - 1);
                return this.content.subSequence(start, end);
            }

            @Override
            public int length() {
                if (this.length < 0) {
                    int len = 0;
                    for (CharSequence seq : lines) {
                        len += seq.length() + 1;
                    }
                    this.length = len = Math.max(0, len - 1);
                }
                return this.length;
            }

            @Override
            public char charAt(int index) {
                this.ensure(index);
                return this.content.charAt(index);
            }
        };
    }

    protected void generateReadme(String basename) {
        String textualContent;
        Object content = this.getReadmeFileContent(basename);
        if (content != null && !Strings.isEmpty((String)(textualContent = content.toString()))) {
            byte[] bytes = textualContent.getBytes();
            for (String output : this.getOutputs()) {
                File directory = new File(output).getAbsoluteFile();
                try {
                    directory.mkdirs();
                    File outputFile = new File(directory, README_BASENAME);
                    Files.write(Paths.get(outputFile.getAbsolutePath(), new String[0]), bytes, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void writeFile(String basename, T content) {
        this.writeFile(basename, content, this.getOutputDirectoryFilter());
    }

    protected void writeFile(String basename, T content, Functions.Function2<? super File, ? super String, ? extends File> outputDirectoryFilter) {
        byte[] bytes = content.toString().getBytes(Charset.forName(this.getCodeConfig().getEncoding()));
        this.writeFile(basename, bytes, outputDirectoryFilter);
    }

    protected void writeFile(String basename, byte[] content) {
        this.writeFile(basename, content, this.getOutputDirectoryFilter());
    }

    protected void writeFile(String basename, byte[] content, Functions.Function2<? super File, ? super String, ? extends File> outputDirectoryFilter) {
        for (String output : this.getOutputs()) {
            File directory = new File(output).getAbsoluteFile();
            if (outputDirectoryFilter != null) {
                directory = (File)outputDirectoryFilter.apply((Object)directory, (Object)basename);
            }
            try {
                File outputFile = new File(directory, basename);
                outputFile.getParentFile().mkdirs();
                Files.write(Paths.get(outputFile.getAbsolutePath(), new String[0]), content, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String getLanguageSimpleName() {
        String name = this.getGrammar().getName();
        int index = name.lastIndexOf(46);
        if (index > 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    protected String getLanguageVersion() {
        return Strings.emptyIfNull((String)this.languageVersion);
    }

    protected abstract T newStyleAppendable();

    @Pure
    protected String lines(String prefix, String ... lines) {
        String delimiter = this.getCodeConfig().getLineDelimiter();
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(prefix);
            buffer.append(line);
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    protected static abstract class AbstractAppendable
    extends AbstractStringBuilderBasedAppendable
    implements IStyleAppendable {
        private final CodeConfig codeConfig;
        private final String languageName;
        private final String languageVersion;

        protected AbstractAppendable(CodeConfig codeConfig, String languageName, String languageVersion) {
            this("  ", codeConfig, languageName, languageVersion);
        }

        protected AbstractAppendable(String indentation, CodeConfig codeConfig, String languageName, String languageVersion) {
            super(indentation, codeConfig.getLineDelimiter(), false);
            this.codeConfig = codeConfig;
            this.languageName = languageName;
            this.languageVersion = languageVersion;
        }

        protected String getLanguageSimpleName() {
            return this.languageName;
        }

        protected String getLanguageVersion() {
            return this.languageVersion;
        }

        protected CodeConfig getCodeConfig() {
            return this.codeConfig;
        }

        protected void appendType(JvmType type, StringBuilder builder) {
            builder.append(type.getQualifiedName());
        }

        protected void appendType(Class<?> type, StringBuilder builder) {
            builder.append(type.getName());
        }

        @Deprecated(since="0.10", forRemoval=true)
        public List<String> getImports() {
            return Collections.emptyList();
        }
    }
}

