/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec;

import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import io.sarl.lang.mwe2.externalspec.AbstractExternalHighlightingFragment2;
import io.sarl.lang.mwe2.externalspec.IXmlStyleAppendable;
import io.sarl.lang.mwe2.externalspec.IXmlStyleCloseable;
import java.nio.channels.UnsupportedAddressTypeException;
import java.text.MessageFormat;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xtext.generator.CodeConfig;

public abstract class AbstractXmlHighlightingFragment2
extends AbstractExternalHighlightingFragment2<IXmlStyleAppendable> {
    @Override
    protected IXmlStyleAppendable newStyleAppendable() {
        return new XmlAppendable(this.getCodeConfig(), this.getLanguageSimpleName(), this.getLanguageVersion());
    }

    protected static class XmlAppendable
    extends AbstractExternalHighlightingFragment2.AbstractAppendable
    implements IXmlStyleAppendable {
        protected XmlAppendable(CodeConfig codeConfig, String languageName, String languageVersion) {
            super(" ", codeConfig, languageName, languageVersion);
        }

        @Override
        public void appendComment(String text, Object ... parameters) {
            this.appendCommentNoNl(text, parameters);
            this.newLine();
        }

        void appendCommentNoNl(String text, Object ... parameters) {
            String comment = this.applyFormat(text, parameters);
            this.appendNl("<!-- ");
            for (String line : comment.split("[\n\r]")) {
                this.appendNl("\t " + line.trim());
            }
            this.append("-->");
        }

        @Override
        public void appendHeader() {
            this.appendNl(MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\"?>", this.getCodeConfig().getEncoding()));
            String[] header = Strings.emptyIfNull((String)this.getCodeConfig().getFileHeader()).split("[\n\r]+");
            this.appendNl("<!--");
            for (String headerLine : header) {
                this.appendNl(headerLine.replaceFirst("^\\s*[/]?[*][/]?", "\t ").replaceFirst("\\s+$", ""));
            }
            this.appendNl("-->");
            this.appendNl("<!-- Style for {0} {1} -->", new Object[]{this.getLanguageSimpleName(), this.getLanguageVersion()});
            this.newLine();
        }

        void internalOpenTag(String tag, String ... nameValuePairs) {
            this.append("<").append((CharSequence)tag);
            for (int i = 0; i < nameValuePairs.length; i += 2) {
                this.append(" ");
                this.append(nameValuePairs[i]);
                this.append("=\"");
                this.append(XmlEscapers.xmlAttributeEscaper().escape(nameValuePairs[i + 1]));
                this.append("\"");
            }
        }

        @Override
        public IXmlStyleCloseable open(String tag, String ... nameValuePairs) {
            this.internalOpenTag(tag, nameValuePairs);
            this.append(">");
            this.increaseIndentation();
            return new XmlCloseable(tag, this);
        }

        @Override
        public void appendTag(String tag, String ... nameValuePairs) {
            this.appendTagNoNl(tag, nameValuePairs);
            this.newLine();
        }

        void appendTagNoNl(String tag, String ... nameValuePairs) {
            this.internalOpenTag(tag, nameValuePairs);
            this.append(" />");
        }

        @Override
        public void appendTagWithValue(String tag, String value, String ... nameValuePairs) {
            this.appendTagWithValueNoNl(tag, value, nameValuePairs);
            this.newLine();
        }

        void appendTagWithValueNoNl(String tag, String value, String ... nameValuePairs) {
            this.internalOpenTag(tag, nameValuePairs);
            if (Strings.isEmpty((String)value)) {
                this.append(" />");
            } else {
                this.append(">");
                boolean block = value.contains("\n") || value.contains("\r");
                Escaper escaper = XmlEscapers.xmlContentEscaper();
                if (block) {
                    this.increaseIndentation();
                    boolean first = true;
                    for (String line : value.split("[\n\r]+")) {
                        if (first) {
                            first = false;
                        } else {
                            this.newLine();
                        }
                        String escapedValue = escaper.escape(line);
                        this.append(escapedValue);
                    }
                    this.decreaseIndentation();
                    this.newLine();
                } else {
                    String escapedValue = escaper.escape(value);
                    this.append(escapedValue.trim());
                }
                this.append("</").append((CharSequence)tag).append((CharSequence)">");
            }
        }
    }

    protected static class XmlCloseable
    implements IXmlStyleCloseable {
        private final String tag;
        private final XmlAppendable parent;
        private int nbLines = 1;

        protected XmlCloseable(String tag, XmlAppendable parent) {
            this.tag = tag;
            this.parent = parent;
        }

        @Override
        public void appendHeader() {
            throw new UnsupportedAddressTypeException();
        }

        @Override
        public void appendComment(String text, Object ... parameters) {
            this.appendNewLines();
            this.parent.appendCommentNoNl(text, parameters);
            this.newLine();
        }

        public ISourceAppender append(CharSequence string) {
            this.appendNewLines();
            this.parent.append(string);
            return this;
        }

        public ISourceAppender append(JvmType type) {
            this.appendNewLines();
            this.parent.append(type);
            return this;
        }

        public ISourceAppender append(LightweightTypeReference typeRef) {
            this.appendNewLines();
            this.parent.append(typeRef);
            return this;
        }

        public ISourceAppender increaseIndentation() {
            this.appendNewLines();
            this.parent.increaseIndentation();
            return this;
        }

        public ISourceAppender decreaseIndentation() {
            this.appendNewLines();
            this.parent.decreaseIndentation();
            return this;
        }

        public boolean isJava() {
            return this.parent.isJava();
        }

        @Override
        public void appendTag(String tag, String ... nameValuePairs) {
            this.appendNewLines();
            this.parent.appendTagNoNl(tag, nameValuePairs);
            this.newLine();
        }

        @Override
        public void appendTagWithValue(String tag, String value, String ... nameValuePairs) {
            this.appendNewLines();
            this.parent.appendTagWithValueNoNl(tag, value, nameValuePairs);
            this.newLine();
        }

        @Override
        public IXmlStyleCloseable open(String tag, String ... nameValuePairs) {
            this.appendNewLines();
            return this.parent.open(tag, nameValuePairs);
        }

        public ISourceAppender newLine() {
            ++this.nbLines;
            return this;
        }

        @Override
        public void close() {
            this.parent.decreaseIndentation();
            this.nbLines = Math.max(1, this.nbLines);
            this.appendNewLines();
            this.append("</").append((CharSequence)this.tag).append((CharSequence)">");
            this.parent.newLine();
        }

        private void appendNewLines() {
            int nb = this.nbLines;
            this.nbLines = 0;
            for (int i = 0; i < nb; ++i) {
                this.parent.newLine();
            }
        }
    }
}

