/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec;

import com.google.inject.Injector;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;

public class ExternalHighlightingConfig
implements IGuiceAwareGeneratorComponent {
    public static final boolean DEFAULT_ADD_NATIVE_TYPES = false;
    public static final boolean DEFAULT_INHERIT_GRAMMAR_KEYWORD_ACCESS = false;
    private final Set<String> additionalLiterals = new TreeSet<String>();
    private final Set<String> additionalKeywords = new TreeSet<String>();
    private final Set<String> excludedKeywords = new TreeSet<String>();
    private final Set<String> additionalPunctuation = new TreeSet<String>();
    private final Set<String> specialKeywords = new TreeSet<String>();
    private final Set<String> typeDeclarationKeywords = new TreeSet<String>();
    private Boolean addNativeTypes;
    private Boolean inheritFromGrammarKeywordAccess;
    private ColorConfig colors = new ColorConfig();

    public void initialize(Injector injector) {
        injector.injectMembers((Object)this);
    }

    public void setInheritFromGrammarKeywordAccesss(boolean inheritFromGrammarKeywordAccess) {
        this.inheritFromGrammarKeywordAccess = inheritFromGrammarKeywordAccess;
    }

    @Pure
    public boolean getInheritFromGrammarKeywordAccesss() {
        if (this.inheritFromGrammarKeywordAccess == null) {
            return false;
        }
        return this.inheritFromGrammarKeywordAccess;
    }

    public void setAddNativeTypes(boolean addNativeTypes) {
        this.addNativeTypes = addNativeTypes;
    }

    @Pure
    public boolean getAddNativeTypes() {
        if (this.addNativeTypes == null) {
            return false;
        }
        return this.addNativeTypes;
    }

    public void addLiteral(String literal) {
        if (!Strings.isEmpty((String)literal)) {
            this.additionalLiterals.add(literal);
        }
    }

    @Pure
    public Set<String> getLiterals() {
        return this.additionalLiterals;
    }

    public void addKeyword(String keyword) {
        if (!Strings.isEmpty((String)keyword)) {
            this.additionalKeywords.add(keyword);
        }
    }

    @Pure
    public Set<String> getKeywords() {
        return this.additionalKeywords;
    }

    public void addIgnoreKeyword(String keyword) {
        if (!Strings.isEmpty((String)keyword)) {
            this.excludedKeywords.add(keyword);
        }
    }

    @Pure
    public Set<String> getIgnoredKeywords() {
        return this.excludedKeywords;
    }

    public void addSpecialKeyword(String keyword) {
        if (!Strings.isEmpty((String)keyword)) {
            this.specialKeywords.add(keyword);
        }
    }

    @Pure
    public Set<String> getSpecialKeywords() {
        return this.specialKeywords;
    }

    public void addTypeDeclarationKeyword(String keyword) {
        if (!Strings.isEmpty((String)keyword)) {
            this.typeDeclarationKeywords.add(keyword);
        }
    }

    @Pure
    public Set<String> getTypeDeclarationKeywords() {
        return this.typeDeclarationKeywords;
    }

    public void addPunctuation(String symbol) {
        if (!Strings.isEmpty((String)symbol)) {
            this.additionalPunctuation.add(symbol);
        }
    }

    @Pure
    public Set<String> getPunctuation() {
        return this.additionalPunctuation;
    }

    public void setColors(ColorConfig colors) {
        this.colors = colors;
    }

    @Pure
    public ColorConfig getColors() {
        return this.colors;
    }

    public static class ColorConfig {
        private static final String DEFAULT_COLOR = "black";
        private final Map<String, Color> colors = new TreeMap<String, Color>();
        private String commentColor;
        private String stringColor;
        private String keywordColor;
        private String identifierColor;
        private String lineNumberColor;

        public void setColor(Color color) {
            if (color != null) {
                this.colors.put(color.getName(), color);
            }
        }

        public Map<String, Color> getColors() {
            return this.colors;
        }

        public void setCommentColor(String name) {
            this.commentColor = name;
        }

        public String getCommentColor() {
            if (Strings.isEmpty((String)this.commentColor)) {
                return DEFAULT_COLOR;
            }
            return this.commentColor;
        }

        public void setStringColor(String name) {
            this.stringColor = name;
        }

        public String getStringColor() {
            if (Strings.isEmpty((String)this.stringColor)) {
                return DEFAULT_COLOR;
            }
            return this.stringColor;
        }

        public void setKeywordColor(String name) {
            this.keywordColor = name;
        }

        public String getKeywordColor() {
            if (Strings.isEmpty((String)this.keywordColor)) {
                return DEFAULT_COLOR;
            }
            return this.keywordColor;
        }

        public void setIdentifierColor(String name) {
            this.identifierColor = name;
        }

        public String getIdentifierColor() {
            if (Strings.isEmpty((String)this.identifierColor)) {
                return DEFAULT_COLOR;
            }
            return this.identifierColor;
        }

        public void setLineNumberColor(String name) {
            this.lineNumberColor = name;
        }

        public String getLineNumberColor() {
            if (Strings.isEmpty((String)this.lineNumberColor)) {
                return DEFAULT_COLOR;
            }
            return this.lineNumberColor;
        }
    }

    public static class Color {
        private static final int MIN_COLOR = 0;
        private static final int MAX_COLOR = 255;
        private String name = "SARLdefault";
        private int red;
        private int green;
        private int blue;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setRgb(String rgb) {
            String[] components = rgb.split("[^0-9]+");
            this.red = 0;
            if (components.length > 0) {
                this.red = Integer.parseInt(components[0]);
                if (this.red < 0 || this.red > 255) {
                    throw new NumberFormatException("red is not between 255 and 255");
                }
            }
            this.green = 0;
            if (components.length > 1) {
                this.green = Integer.parseInt(components[1]);
                if (this.green < 0 || this.green > 255) {
                    throw new NumberFormatException("green is not between 0 and 255");
                }
            }
            this.blue = 0;
            if (components.length > 1) {
                this.blue = Integer.parseInt(components[2]);
                if (this.blue < 0 || this.blue > 255) {
                    throw new NumberFormatException("blue is not between 0 and 255");
                }
            }
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }
    }
}

