/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec.gnusrchighlight;

import com.google.inject.Injector;
import io.sarl.lang.mwe2.externalspec.AbstractScriptHighlightingFragment2;
import io.sarl.lang.mwe2.externalspec.IStyleAppendable;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GnuSrcHighlightGenerator2
extends AbstractScriptHighlightingFragment2 {
    public static final String BASENAME_PATTERN = "{0}.lang";

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.setBasenameTemplate(BASENAME_PATTERN);
    }

    public String toString() {
        return "GNU source-highlight";
    }

    @Override
    protected void generate(IStyleAppendable it, Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        StringBuilder punctuationPattern = new StringBuilder();
        for (String string : punctuation) {
            if (punctuationPattern.length() > 0) {
                punctuationPattern.append("|");
            }
            punctuationPattern.append(string.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\")).replaceAll(Pattern.quote("|"), Matcher.quoteReplacement("\\|")));
        }
        StringBuilder keywordPattern = new StringBuilder();
        for (String string : GnuSrcHighlightGenerator2.sortedConcat(expressionKeywords, modifiers, primitiveTypes, typeDeclarationKeywords, specialKeywords)) {
            if (keywordPattern.length() > 0) {
                keywordPattern.append("|");
            }
            keywordPattern.append(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String literal : literals) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(literal);
        }
        it.appendHeader();
        if (!specialKeywords.isEmpty()) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String specialKeyword : specialKeywords) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(",");
                }
                stringBuilder2.append("\"" + specialKeyword + "\"");
            }
            it.appendNl("preproc = {0}", stringBuilder2);
            it.newLine();
        }
        it.appendComment("SARL comments", new Object[0]);
        it.appendNl("include \"c_comment.lang\"");
        it.newLine();
        it.appendComment("Numbers (integer, decimals, or hexadecimals", new Object[0]);
        it.appendNl("number = '\\<[+-]?((0[xX][[:xdigit:]_]+(\\#(([bB][iI])|([lL])))?)|(([[:digit:]][[:digit:]_]*\\.)?[[:digit:]]+([eE][+-]?[[:digit:]]+)?(([bB][iIdD])|([lLdDfF]))?))\\>'");
        it.newLine();
        it.appendComment("Strings of characters", new Object[0]);
        it.appendNl("include \"c_string.lang\"");
        it.newLine();
        it.appendComment("Annotations", new Object[0]);
        it.appendNl("label = '@[$[:alnum:]_.:^]+'");
        it.newLine();
        it.appendComment("Protected IDs with ^", new Object[0]);
        it.appendNl("normal = '\\^[$[:alnum:]_]+'");
        it.newLine();
        if (!typeDeclarationKeywords.isEmpty()) {
            it.appendComment("Highlight the type declarations", new Object[0]);
            StringBuilder stringBuilder3 = new StringBuilder();
            for (String typeDeclarationKeyword : typeDeclarationKeywords) {
                if (stringBuilder3.length() > 0) {
                    stringBuilder3.append("|");
                }
                stringBuilder3.append(typeDeclarationKeyword);
            }
            it.appendNl("(keyword,normal,classname) = `(\\<(?:{0}))([[:blank:]]+)([$[:alnum:]_]+)`", stringBuilder3);
            it.newLine();
        }
        it.appendNl("keyword = \"{0}\"", keywordPattern);
        it.newLine();
        it.appendNl("keyword = \"{0}\"", stringBuilder);
        it.newLine();
        it.appendNl("symbol = \"{0}\"", punctuationPattern);
        it.newLine();
        it.appendNl("cbracket = \"{|}\"");
        it.newLine();
        it.appendNl("cbracket = \"[|]\"");
    }

    @Override
    protected Object getReadmeFileContent(String basename) {
        return null;
    }
}

