/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec.gtk;

import com.google.inject.Injector;
import io.sarl.lang.mwe2.externalspec.AbstractXmlHighlightingFragment2;
import io.sarl.lang.mwe2.externalspec.IXmlStyleAppendable;
import io.sarl.lang.mwe2.externalspec.IXmlStyleCloseable;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.generator.web.RegexpExtensions;

public class GtkSourceViewerGenerator2
extends AbstractXmlHighlightingFragment2 {
    public static final String BASENAME_PATTERN = "{0}.lang";
    private static final String XML_FORMAT_VERSION = "2.0";

    public String toString() {
        return "GtkSourceView";
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.setBasenameTemplate(BASENAME_PATTERN);
    }

    @Override
    protected void generate(IXmlStyleAppendable it, Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        it.appendHeader();
        IXmlStyleCloseable tag1 = it.open("language", "id", this.getLanguageSimpleName().toLowerCase(), "_name", this.getLanguageSimpleName(), "version", XML_FORMAT_VERSION, "_section", "Source");
        IXmlStyleCloseable tag2 = tag1.open("metadata", new String[0]);
        this.generateMetadata(tag2);
        tag2.close();
        tag2 = tag1.open("styles", new String[0]);
        this.generateStyles(tag2);
        tag2.close();
        tag2 = tag1.open("definitions", new String[0]);
        this.generateDefinitions(tag2, literals, GtkSourceViewerGenerator2.sortedConcat(expressionKeywords, modifiers, primitiveTypes, typeDeclarationKeywords, specialKeywords), punctuation);
        tag2.close();
        tag1.close();
    }

    protected void generateMetadata(IXmlStyleAppendable it) {
        it.appendTagWithValue("property", Strings.concat((String)";", this.getMimeTypes()), "name", "mimetypes");
        StringBuilder buffer = new StringBuilder();
        for (String fileExtension : this.getLanguage().getFileExtensions()) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append("*.").append(fileExtension);
        }
        it.appendTagWithValue("property", buffer.toString(), "name", "globs");
        it.appendTagWithValue("property", "//", "name", "line-comment-start");
        it.appendTagWithValue("property", "/*", "name", "block-comment-start");
        it.appendTagWithValue("property", "*/", "name", "block-comment-end");
    }

    protected void generateStyles(IXmlStyleAppendable it) {
        it.appendTag("style", "id", "comment", "_name", "Comment", "map-to", "def:comment");
        it.appendTag("style", "id", "error", "_name", "Error", "map-to", "def:error");
        it.appendTag("style", "id", "escaped-character", "_name", "Escaped Character", "map-to", "def:special-char");
        it.appendTag("style", "id", "string", "_name", "String", "map-to", "def:string");
        it.appendTag("style", "id", "keyword", "_name", "Keyword", "map-to", "def:keyword");
        it.appendTag("style", "id", "literal", "_name", "Literal", "map-to", "def:special-constant");
        it.appendTag("style", "id", "number", "_name", "Number", "map-to", "def:number");
        it.appendTag("style", "id", "operator", "_name", "Operator", "map-to", "def:operator");
        it.appendTag("style", "id", "identifier", "_name", "Identifier", "map-to", "def:text");
        it.appendTag("style", "id", "annotation", "_name", "Annotation", "map-to", "def:preprocessor");
    }

    protected void generateDefinitions(IXmlStyleAppendable it, Set<String> literals, Iterable<String> keywords, Set<String> punctuation) {
        it.appendTagWithValue("define-regex", this.lines("\t", "", "\\\\(               # leading backslash", "[\\\\\\\"\\'nrbtf] |   # escaped character", "[0-9]{1,3}    |   # latin encoded char", "u[0-9]{1,4}       # unicode char", ")"), "id", "escaped-character", "extended", "true");
        it.appendTagWithValue("define-regex", "0[xX][0-9a-fA-F_]+(#(([bB][iI])|([lL])))?", "id", "hex-number");
        it.appendTagWithValue("define-regex", "[0-9][0-9_]*", "id", "int-number");
        it.appendTagWithValue("define-regex", "\\%{int-number}([eE][+\\-]?\\%{int-number})?(([bB][iIdD])|([lLdDfF]))?", "id", "decimal-number");
        it.appendTagWithValue("define-regex", "(\\%{hex-number})|(\\%{decimal-number}(\\.\\%{decimal-number})?)", "id", "sarl-number");
        it.appendTagWithValue("define-regex", "\\^?[a-zA-Z_$][a-zA-Z_$0-9]*", "id", "sarl-identifier");
        IXmlStyleCloseable tag1 = it.open("context", "id", "qq-string", "style-ref", "string", "end-at-line-end", "true", "class", "string", "class-disabled", "no-spell-check");
        tag1.appendTagWithValue("start", "\"", new String[0]);
        tag1.appendTagWithValue("end", "\"", new String[0]);
        IXmlStyleCloseable tag2 = tag1.open("include", new String[0]);
        IXmlStyleCloseable tag3 = tag2.open("context", "id", "qq-string-escaped-character", "style-ref", "escaped-character");
        tag3.appendTagWithValue("match", "\\%{escaped-character}", new String[0]);
        tag3.close();
        tag2.close();
        tag1.close();
        IXmlStyleCloseable tag4 = it.open("context", "id", "q-string", "style-ref", "string", "end-at-line-end", "true", "class", "string", "class-disabled", "no-spell-check");
        tag4.appendTagWithValue("start", "'", new String[0]);
        tag4.appendTagWithValue("end", "'", new String[0]);
        IXmlStyleCloseable tag5 = tag4.open("include", new String[0]);
        IXmlStyleCloseable tag6 = tag5.open("context", "id", "q-string-escaped-character", "style-ref", "escaped-character");
        tag6.appendTagWithValue("match", "\\%{escaped-character}", new String[0]);
        tag6.close();
        tag5.close();
        tag4.close();
        IXmlStyleCloseable tag7 = it.open("context", "id", "line-comment", "style-ref", "comment", "end-at-line-end", "true", "class", "comment", "class-disabled", "no-spell-check");
        tag7.appendTagWithValue("start", "//", new String[0]);
        IXmlStyleCloseable tag8 = tag7.open("include", new String[0]);
        tag8.appendTag("context", "ref", "def:in-line-comment");
        tag8.close();
        tag7.close();
        IXmlStyleCloseable tag9 = it.open("context", "id", "block-comment", "style-ref", "comment", "class", "comment", "class-disabled", "no-spell-check");
        tag9.appendTagWithValue("start", "/\\*", new String[0]);
        tag9.appendTagWithValue("end", "\\*/", new String[0]);
        IXmlStyleCloseable tag10 = tag9.open("include", new String[0]);
        tag10.appendTag("context", "ref", "def:in-comment");
        tag10.close();
        tag9.close();
        IXmlStyleCloseable tag11 = it.open("context", "id", "close-comment-outside-comment", "style-ref", "error");
        tag11.appendTagWithValue("match", "\\*/(?!\\*)", new String[0]);
        tag11.close();
        IXmlStyleCloseable tag12 = it.open("context", "id", "sarl-keywords", "style-ref", "keyword");
        for (String string : keywords) {
            tag12.appendTagWithValue("keyword", string, new String[0]);
        }
        tag12.close();
        IXmlStyleCloseable tag13 = it.open("context", "id", "sarl-literals", "style-ref", "literal");
        for (String literal : literals) {
            tag13.appendTagWithValue("keyword", literal, new String[0]);
        }
        tag13.close();
        IXmlStyleCloseable iXmlStyleCloseable = it.open("context", "id", "annotations", "style-ref", "annotation");
        iXmlStyleCloseable.appendTagWithValue("match", "\\@\\%{sarl-identifier}(\\.\\%{sarl-identifier})*", new String[0]);
        iXmlStyleCloseable.close();
        IXmlStyleCloseable tag15 = it.open("context", "id", "identifiers", "style-ref", "identifier");
        tag15.appendTagWithValue("match", "\\%{sarl-identifier}", new String[0]);
        tag15.close();
        IXmlStyleCloseable tag16 = it.open("context", "id", "numeric", "style-ref", "number");
        tag16.appendTagWithValue("match", "\\%{sarl-number}", new String[0]);
        tag16.close();
        IXmlStyleCloseable tag17 = it.open("context", "id", "operators", "style-ref", "operator", "extend-parent", "false");
        StringBuilder buffer = new StringBuilder();
        TreeSet characters = new TreeSet();
        for (String string : punctuation) {
            if (buffer.length() > 0) {
                buffer.append("|");
            }
            buffer.append("(");
            buffer.append(RegexpExtensions.toRegexpString((String)string, (boolean)false));
            buffer.append(")");
            string.chars().forEach(c -> characters.add(Character.valueOf((char)c)));
        }
        tag17.appendTagWithValue("match", buffer.toString(), new String[0]);
        tag17.close();
        IXmlStyleCloseable tag18 = it.open("context", "id", "invalid-operators", "style-ref", "error");
        buffer = new StringBuilder();
        for (Character character : characters) {
            buffer.append(RegexpExtensions.toRegexpString((String)character.toString(), (boolean)false));
        }
        tag18.appendTagWithValue("match", "[" + buffer.toString() + "]+", new String[0]);
        tag18.close();
        IXmlStyleCloseable iXmlStyleCloseable2 = it.open("context", "id", this.getLanguageSimpleName().toLowerCase(), "class", "no-spell-check");
        IXmlStyleCloseable tag20 = iXmlStyleCloseable2.open("include", new String[0]);
        tag20.appendTag("context", "ref", "qq-string");
        tag20.appendTag("context", "ref", "q-string");
        tag20.appendTag("context", "ref", "line-comment");
        tag20.appendTag("context", "ref", "block-comment");
        tag20.appendTag("context", "ref", "close-comment-outside-comment");
        tag20.appendTag("context", "ref", "sarl-keywords");
        tag20.appendTag("context", "ref", "sarl-literals");
        tag20.appendTag("context", "ref", "annotations");
        tag20.appendTag("context", "ref", "identifiers");
        tag20.appendTag("context", "ref", "numeric");
        tag20.appendTag("context", "ref", "operators");
        tag20.close();
        iXmlStyleCloseable2.close();
    }

    @Override
    protected Object getReadmeFileContent(String basename) {
        return GtkSourceViewerGenerator2.concat("1. MANUAL INSTALLATION", "", "Copy the " + basename + " file into one of the folders:", "* $HOME/.local/share/gtksourceview-3.0/language-specs/", "* $HOME/.local/share/gtksourceview-2.0/language-specs/");
    }
}

