/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec.latex;

import com.google.inject.Injector;
import io.sarl.lang.mwe2.externalspec.IStyleAppendable;
import io.sarl.lang.mwe2.externalspec.latex.LaTeXListingsGenerator2;

public class LaTeXBeamerGenerator2
extends LaTeXListingsGenerator2 {
    public static final String BEAMER_BASENAME_PATTERN = "{0}-beamer-listing.sty";

    @Override
    public void initialize(Injector injector) {
        super.initialize(injector);
        this.clearRequirements();
        this.setLineNumbers(false);
        this.setFloatBasicStyle("\\usebeamertemplate{code basic style}");
        this.setInlineBasicStyle("\\usebeamertemplate{code inline style}");
        this.setIdentifierStyle("\\usebeamertemplate{code identifier style}");
        this.setCommentStyle("\\usebeamercolor[fg]{code comment}");
        this.setStringStyle("\\usebeamercolor[fg]{code string}");
        this.setKeywordStyle("\\usebeamertemplate*{code keyword style}\\usebeamercolor[fg]{code keyword}");
        this.setBasenameTemplate(BEAMER_BASENAME_PATTERN);
    }

    @Override
    protected void generateExtension(IStyleAppendable it) {
        it.append("\\ifusesarlcolors");
        it.increaseIndentation().newLine();
        it.appendNl("\\setbeamercolor*{code keyword}{fg=SARLkeyword}");
        it.appendNl("\\setbeamercolor*{code string}{fg=SARLstring}");
        it.append("\\setbeamercolor*{code comment}{fg=SARLcomment}");
        it.decreaseIndentation().newLine();
        it.appendNl("\\fi");
    }

    @Override
    public String toString() {
        return "LaTeX Beamer";
    }
}

