/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec.latex;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.google.inject.Injector;
import io.sarl.lang.mwe2.externalspec.AbstractExternalHighlightingFragment2;
import io.sarl.lang.mwe2.externalspec.ExternalHighlightingConfig;
import io.sarl.lang.mwe2.externalspec.IStyleAppendable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.generator.CodeConfig;

public class LaTeXListingsGenerator2
extends AbstractExternalHighlightingFragment2<IStyleAppendable> {
    public static final String BASENAME_PATTERN = "{0}-listing.sty";
    public static final String DEFAULT_FLOAT_BASIC_STYLE = "\\smaller\\smaller";
    public static final String DEFAULT_COLORIZED_FLOAT_BASIC_STYLE = "\\normalcolor\\smaller\\smaller";
    public static final String DEFAULT_INLINE_BASIC_STYLE = "{}";
    public static final String DEFAULT_COLORIZED_INLINE_BASIC_STYLE = "\\normalcolor";
    public static final String DEFAULT_IDENTIFIER_STYLE = "\\ttfamily";
    public static final String DEFAULT_COLORIZED_IDENTIFIER_STYLE = "\\color{SARLidentifier}\\ttfamily";
    public static final String DEFAULT_COMMENT_STYLE = "\\smaller\\bfseries";
    public static final String DEFAULT_COLORIZED_COMMENT_STYLE = "\\color{SARLcomment}\\smaller\\bfseries";
    public static final String DEFAULT_STRING_STYLE = "\\ttfamily";
    public static final String DEFAULT_COLORIZED_STRING_STYLE = "\\color{SARLstring}\\ttfamily";
    public static final String DEFAULT_KEYWORD_STYLE = "\\bfseries";
    public static final String DEFAULT_COLORIZED_KEYWORD_STYLE = "\\color{SARLkeyword}\\bfseries";
    public static final String[] DEFAULT_REQUIREMENTS = new String[]{"relsize"};
    private String floatBasicStyle;
    private String identifierStyle;
    private String commentStyle;
    private String stringStyle;
    private String keywordStyle;
    private String inlineBasicStyle;
    private boolean showLines = true;
    private int lineStep = 2;
    private int tabSize = 2;
    private boolean showSpecialCharacters;
    private Collection<String> requirements;

    @Override
    protected IStyleAppendable newStyleAppendable() {
        return new TeXAppendable(this.getCodeConfig(), this.getLanguageSimpleName(), this.getLanguageVersion());
    }

    public String toString() {
        return "LaTeX listings";
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.setBasenameTemplate(BASENAME_PATTERN);
    }

    public void setFloatBasicStyle(String style) {
        this.floatBasicStyle = style;
    }

    public void setInlineBasicStyle(String style) {
        this.inlineBasicStyle = style;
    }

    public void setIdentifierStyle(String style) {
        this.identifierStyle = style;
    }

    public void setCommentStyle(String style) {
        this.commentStyle = style;
    }

    public void setStringStyle(String style) {
        this.stringStyle = style;
    }

    public void setKeywordStyle(String style) {
        this.keywordStyle = style;
    }

    public void setLineNumbers(boolean showLineNumbers) {
        this.showLines = showLineNumbers;
    }

    public void setLineStep(int step) {
        this.lineStep = step;
    }

    public void setTabSize(int size) {
        this.tabSize = size;
    }

    public void setShowSpecialChars(boolean showSpecialChars) {
        this.showSpecialCharacters = showSpecialChars;
    }

    public void clearRequirements() {
        if (this.requirements == null) {
            this.requirements = new ArrayList<String>();
        } else {
            this.requirements.clear();
        }
    }

    public void addRequirement(String requirement) {
        if (!Strings.isEmpty((String)requirement)) {
            if (this.requirements == null) {
                this.requirements = new ArrayList<String>();
            }
            this.requirements.add(requirement);
        }
    }

    @Override
    protected void generate(IStyleAppendable it, Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        ExternalHighlightingConfig.ColorConfig colors = this.getHighlightingConfig().getColors();
        Set<String> texKeywords = LaTeXListingsGenerator2.sortedConcat(expressionKeywords, modifiers, primitiveTypes, specialKeywords, typeDeclarationKeywords, literals);
        it.appendHeader();
        String basename = this.getBasename(MessageFormat.format(this.getBasenameTemplate(), this.getLanguageSimpleName().toLowerCase()));
        String simpleBasename = Files.getNameWithoutExtension((String)basename);
        it.appendNl("\\NeedsTeXFormat{LaTeX2e}[1995/12/01]");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        it.appendNl("\\ProvidesPackage'{'{0}'}'[{1}]", simpleBasename, dateFormat.format(new Date()));
        if (this.generateOptions(it)) {
            it.appendNl("\\ProcessOptions*");
        }
        it.appendNl("\\RequirePackage{algpseudocode}");
        it.appendNl("\\RequirePackage{listings}");
        it.appendNl("\\RequirePackage{xspace}");
        Collection<String> requirements = this.requirements;
        if (requirements == null) {
            requirements = Arrays.asList(DEFAULT_REQUIREMENTS);
        }
        for (String requirement : requirements) {
            it.appendNl("\\RequirePackage'{'{0}'}'", requirement);
        }
        if (this.getEnableColors()) {
            it.appendNl("\\RequirePackage{xcolor}");
        }
        if (this.getEnableColors()) {
            for (ExternalHighlightingConfig.Color color : colors.getColors().values()) {
                it.appendNl("\\definecolor'{'{0}'}{'RGB'}{'{1},{2},{3}'}'", color.getName(), color.getRed(), color.getGreen(), color.getBlue());
            }
            it.appendNl("\\colorlet'{'SARLcomment'}{'{0}'}'", colors.getCommentColor());
            it.appendNl("\\colorlet'{'SARLstring'}{'{0}'}'", colors.getStringColor());
            it.appendNl("\\colorlet'{'SARLkeyword'}{'{0}'}'", colors.getKeywordColor());
            it.appendNl("\\colorlet'{'SARLidentifier'}{'{0}'}'", colors.getIdentifierColor());
            it.appendNl("\\colorlet'{'SARLlinenumber'}{'{0}'}'", colors.getLineNumberColor());
        }
        String langName = this.getLanguageSimpleName().toUpperCase();
        it.appendNl("\\lstdefinelanguage'{'{0}'}{'%", langName);
        it.appendNl("   morecomment=[l]{//},");
        it.appendNl("   morecomment=[s]{/*}{*/},");
        it.appendNl("   morestring=[b]\",");
        it.appendNl("   morekeywords='{'{0}'}',", Joiner.on((String)",").join(texKeywords));
        it.appendNl("}");
        it.appendNl("\\lstset{%");
        String floatBasicStyle = this.floatBasicStyle;
        if (floatBasicStyle == null) {
            floatBasicStyle = this.getEnableColors() ? DEFAULT_COLORIZED_FLOAT_BASIC_STYLE : DEFAULT_FLOAT_BASIC_STYLE;
        }
        floatBasicStyle = Strings.emptyIfNull((String)floatBasicStyle);
        it.appendNl("   basicstyle= arl@basesize {0}, % the size of the fonts that are used for the code", floatBasicStyle);
        it.appendNl("   breakatwhitespace=false, % sets if automatic breaks should only happen at whitespace");
        it.appendNl("   breaklines=true, % sets automatic line breaking");
        it.appendNl("   captionpos=b, % sets the caption-position to bottom");
        it.appendNl("   deletekeywords={filter}, % if you want to delete keywords from the given language");
        it.appendNl("   escapeinside={(*@}{@*)}, % if you want to add LaTeX within your code");
        it.append("   extendedchars=true, % lets you use non-ASCII characters; for 8-bits ");
        it.appendNl("encodings only, does not work with UTF-8");
        it.appendNl("   frame=none, % no frame around the code");
        it.append("   keepspaces=true, % keeps spaces in text, useful for keeping ");
        it.appendNl("indentation of code (possibly needs columns=flexible)");
        String identifierStyle = this.identifierStyle;
        if (identifierStyle == null) {
            identifierStyle = this.getEnableColors() ? DEFAULT_COLORIZED_IDENTIFIER_STYLE : "\\ttfamily";
        }
        identifierStyle = Strings.emptyIfNull((String)identifierStyle);
        it.appendNl("   identifierstyle={0},", identifierStyle);
        String commentStyle = this.commentStyle;
        if (commentStyle == null) {
            commentStyle = this.getEnableColors() ? DEFAULT_COLORIZED_COMMENT_STYLE : DEFAULT_COMMENT_STYLE;
        }
        commentStyle = Strings.emptyIfNull((String)commentStyle);
        it.appendNl("   commentstyle={0},", commentStyle);
        String stringStyle = this.stringStyle;
        if (stringStyle == null) {
            stringStyle = this.getEnableColors() ? DEFAULT_COLORIZED_STRING_STYLE : "\\ttfamily";
        }
        stringStyle = Strings.emptyIfNull((String)stringStyle);
        it.appendNl("   stringstyle={0},", stringStyle);
        String keywordStyle = this.keywordStyle;
        if (keywordStyle == null) {
            keywordStyle = this.getEnableColors() ? DEFAULT_COLORIZED_KEYWORD_STYLE : DEFAULT_KEYWORD_STYLE;
        }
        keywordStyle = Strings.emptyIfNull((String)keywordStyle);
        it.appendNl("   keywordstyle={0}, % keyword style", keywordStyle);
        it.appendNl("   language={0}, % the default language of the code", langName);
        it.append("   showspaces={0}, % show spaces everywhere adding particular ", this.showSpecialCharacters);
        it.appendNl("underscores; it overrides 'showstringspaces'");
        it.appendNl("   showstringspaces={0}, % underline spaces within strings only", this.showSpecialCharacters);
        it.appendNl("   showtabs={0}, % show tabs within strings adding particular underscores", this.showSpecialCharacters);
        if (this.showLines) {
            it.appendNl("   numbers=left,% Numbers on left");
            it.appendNl("   firstnumber=1, % First line number");
            it.appendNl("   numberfirstline=false, %Start numbers at first line");
            it.append("   stepnumber={0}, % the step between two line-numbers. ", this.lineStep);
            it.appendNl("If it's 1, each line will be numbered");
        }
        it.appendNl("   tabsize={0}, % sets default tabsize to 2 spaces", this.tabSize);
        it.append("   title=\\lstname, % show the filename of files included with ");
        it.appendNl("\\lstinputlisting; also try caption instead of title");
        it.appendNl("   frameround=fttt, % If framed, use this rounded corner style");
        it.appendNl("   xleftmargin=20pt,");
        it.append("   numberstyle=");
        if (this.getEnableColors()) {
            it.append("\\color{SARLlinenumber}");
        }
        it.appendNl("\\tiny,");
        it.appendNl("}");
        String inlineBasicStyle = this.inlineBasicStyle;
        if (inlineBasicStyle == null) {
            inlineBasicStyle = this.getEnableColors() ? DEFAULT_COLORIZED_INLINE_BASIC_STYLE : DEFAULT_INLINE_BASIC_STYLE;
        }
        inlineBasicStyle = Strings.emptyIfNull((String)inlineBasicStyle);
        it.append("\\newcommand{\\code}[1]{");
        it.append("\\ifmmode\\text'{'\\lstinline[basicstyle={0}]'{'#1'}}'", inlineBasicStyle);
        it.append("\\else\\lstinline[basicstyle={0}]'{'#1'}'", inlineBasicStyle);
        it.appendNl("\\fi}");
        it.appendNl("\\lstnewenvironment{sarl-lst}[1][]{\\lstset{#1,language=SARL}}{}");
        it.appendNl("\\newcommand{\\sarl}{\\mbox{SARL}\\xspace}");
        it.appendNl("\\newcommand'{'\\sarlversion'}{'{0}'}'", this.getLanguageVersion());
        this.generateExtension(it);
        it.appendNl("\\endinput");
    }

    protected void generateExtension(IStyleAppendable it) {
    }

    @Override
    protected Object getReadmeFileContent(String basename) {
        return null;
    }

    protected boolean generateOptions(IStyleAppendable it) {
        if (this.getEnableColors()) {
            it.appendNl("\\newif\\ifusesarlcolors\\usesarlcolorstrue");
            it.appendNl("\\DeclareOption{sarlcolors}{\\global\\usesarlcolorstrue}");
            it.appendNl("\\DeclareOption{nosarlcolors}{\\global\\usesarlcolorsfalse}");
            return true;
        }
        it.appendNl("\\gdef\\sarl@basesize{}");
        it.appendNl("\\DeclareOption{smaller}{\\protected@xdef\\sarl@basesize{\\sarl@basesize\\protect\\smaller}}");
        return false;
    }

    protected static class TeXAppendable
    extends AbstractExternalHighlightingFragment2.AbstractAppendable {
        protected TeXAppendable(CodeConfig codeConfig, String languageName, String languageVersion) {
            super(codeConfig, languageName, languageVersion);
        }

        @Override
        public void appendComment(String text, Object ... parameters) {
            String comment = this.applyFormat(text, parameters);
            for (String line : comment.split("[\n\r]")) {
                this.appendNl("% " + line.trim());
            }
        }

        @Override
        public void appendHeader() {
            String[] header;
            for (String headerLine : header = Strings.emptyIfNull((String)this.getCodeConfig().getFileHeader()).split("[\n\r]+")) {
                this.appendNl(headerLine.replaceFirst("^\\s*[/]?[*][/]?", "%"));
            }
        }
    }
}

