/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec.prettify;

import com.google.inject.Injector;
import io.sarl.lang.mwe2.externalspec.AbstractCsyntaxHighlightingFragment2;
import io.sarl.lang.mwe2.externalspec.IStyleAppendable;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.xtext.util.Strings;

public class GooglePrettifyGenerator2
extends AbstractCsyntaxHighlightingFragment2 {
    public static final String BASENAME_PATTERN = "lang-{0}.js";
    private String whitespaces = "\\t\\n\\r \\xA0";
    private String doubleQuotedStrings = "^(?:\"(?:[^\\\"\\\\]|\\\\.)*\"|'(?!\\'\\')(?:[^\\'\\\\]|\\\\.)*')";
    private String singleQuotedStrings = "^'(?:[^\\r\\n\\\\']|\\\\(?:'|[^\\r\\n']+))'";
    private String characterLiteral = "^'[a-zA-Z_$][\\w$]*(?!['$\\w])";
    private String numberLiteral = "^(?:(?:0(?:[0-7]+|X[0-9A-F]+))L?|(?:(?:0|[1-9][0-9]*)(?:(?:\\.[0-9]+)?(?:E[+\\-]?[0-9]+)?F?|L?))|\\\\.[0-9]+(?:E[+\\-]?[0-9]+)?F?)";
    private String typePattern = "^[$_]*[A-Z][_$A-Z0-9]*[a-z][\\w$]*";
    private String plainTextPattern = "^[$a-zA-Z_][\\w$]*";
    private String commentPattern = "^\\/(?:\\/.*|\\*(?:\\/|\\**[^*/])*(?:\\*+\\/?)?)";

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.setBasenameTemplate(BASENAME_PATTERN);
    }

    public String toString() {
        return "Google Prettify";
    }

    public void setWhitespacePattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.whitespaces = pattern;
        }
    }

    public void setDoubleQuotedStringPattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.doubleQuotedStrings = pattern;
        }
    }

    public void setSingleQuotedStringPattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.singleQuotedStrings = pattern;
        }
    }

    public void setCharacterLiteralPattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.characterLiteral = pattern;
        }
    }

    public void setNumberLiteralPattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.numberLiteral = pattern;
        }
    }

    public void setTypePattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.typePattern = pattern;
        }
    }

    public void setPlainTextPattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.plainTextPattern = pattern;
        }
    }

    public void setCommentPattern(String pattern) {
        if (!Strings.isEmpty((String)pattern)) {
            this.commentPattern = pattern;
        }
    }

    @Override
    protected void generate(IStyleAppendable it, Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        TreeSet characters = new TreeSet();
        for (String punct : punctuation) {
            punct.chars().forEach(candidate -> characters.add(Character.valueOf((char)candidate)));
        }
        StringBuilder punctuationCharacters1 = new StringBuilder();
        StringBuilder punctuationCharacters2 = new StringBuilder();
        block8: for (Object candidate2 : characters) {
            switch (((Character)candidate2).charValue()) {
                case '-': 
                case '[': 
                case '\\': 
                case ']': {
                    punctuationCharacters1.append("\\").append(((Character)candidate2).toString());
                    break;
                }
                case '^': {
                    if (punctuationCharacters1.length() > 0) {
                        punctuationCharacters1.append(((Character)candidate2).toString());
                        break;
                    }
                    punctuationCharacters1.append("\\").append(((Character)candidate2).toString());
                    break;
                }
                default: {
                    punctuationCharacters1.append(((Character)candidate2).toString());
                }
            }
            switch (((Character)candidate2).charValue()) {
                case '\'': 
                case '\\': {
                    punctuationCharacters2.append("\\").append(((Character)candidate2).toString());
                    continue block8;
                }
            }
            punctuationCharacters2.append(((Character)candidate2).toString());
        }
        StringBuilder keywordPattern = new StringBuilder();
        for (String string : GooglePrettifyGenerator2.sortedConcat(expressionKeywords, modifiers, primitiveTypes, specialKeywords, typeDeclarationKeywords)) {
            if (keywordPattern.length() > 0) {
                keywordPattern.append("|");
            }
            keywordPattern.append(string);
        }
        StringBuilder literalPattern = new StringBuilder();
        for (String literal : literals) {
            if (literalPattern.length() > 0) {
                literalPattern.append("|");
            }
            literalPattern.append(literal);
        }
        it.appendHeader();
        it.appendNl("PR['registerLangHandler'](");
        it.appendNl("   PR['createSimpleLexer'](");
        it.appendNl("      [");
        it.appendNl("         [PR[''PR_PLAIN''], /^[{0}]+/, null, ''{0}''],", this.whitespaces);
        it.appendNl("         [PR[''PR_PUNCTUATION''], /^[{0}]+/, null, ''{1}''],", punctuationCharacters1, punctuationCharacters2);
        it.appendNl("      ],");
        it.appendNl("      [");
        it.appendNl("         [PR[''PR_STRING''], /{0}/],", this.doubleQuotedStrings);
        it.appendNl("         [PR[''PR_STRING''], /{0}/],", this.singleQuotedStrings);
        it.appendNl("         [PR[''PR_LITERAL''], /{0}/],", this.characterLiteral);
        it.appendNl("         [PR[''PR_KEYWORD''], /^(?:{0})\\b/],", keywordPattern);
        it.appendNl("         [PR[''PR_LITERAL''], /^(?:{0})\\b/],", literalPattern);
        it.appendNl("         [PR[''PR_LITERAL''], /{0}/i],", this.numberLiteral);
        it.appendNl("         [PR[''PR_TYPE''], /{0}/],", this.typePattern);
        it.appendNl("         [PR[''PR_PLAIN''], /{0}/],", this.plainTextPattern);
        it.appendNl("         [PR[''PR_COMMENT''], /{0}/],", this.commentPattern);
        it.appendNl("         [PR['PR_PUNCTUATION'], /^(?:\\.+|\\/)/]");
        it.appendNl("      ]),");
        String string = this.getLanguageSimpleName().toLowerCase();
        it.appendNl("   [''{0}'']);", string);
    }

    @Override
    protected Object getReadmeFileContent(String basename) {
        return null;
    }
}

