/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec.pygments;

import com.google.inject.Injector;
import io.sarl.lang.mwe2.externalspec.AbstractScriptHighlightingFragment2;
import io.sarl.lang.mwe2.externalspec.IStyleAppendable;
import java.io.File;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Functions;

public class PygmentsGenerator2
extends AbstractScriptHighlightingFragment2 {
    public static final String BASENAME_PATTERN = "{0}.py";
    private String url;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.setBasenameTemplate(BASENAME_PATTERN);
    }

    public String toString() {
        return "Pygments";
    }

    @Override
    protected void generate(IStyleAppendable it, Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        it.appendNl("# -*- coding: {0} -*-", this.getCodeConfig().getEncoding().toLowerCase());
        it.appendHeader();
        it.newLine();
        it.appendNl("import re");
        it.newLine();
        it.appendNl("from pygments.lexer import Lexer, RegexLexer, include, bygroups, using, this");
        it.appendNl("from pygments.token import Text, Comment, Operator, Keyword, Name, String, Number, Punctuation");
        it.newLine();
        it.appendNl("class SarlLexer(RegexLexer):");
        it.appendNl("\t\"\"\"");
        it.appendNl("\tFor `{0} <{1}>`_ source code.", this.getLanguageSimpleName(), this.getUrl());
        it.appendNl("\t");
        it.appendNl("\t.. versionadded:: {0}", this.getLanguageVersion());
        it.appendNl("\t\"\"\"");
        it.appendNl("\t");
        it.appendNl("\tname = ''{0}''", this.getLanguageSimpleName());
        it.appendNl("\taliases = [''{0}'']", this.getLanguageSimpleName().toLowerCase());
        StringBuilder pyFileExtensions = new StringBuilder();
        for (Object fileExtension : this.getLanguage().getFileExtensions()) {
            if (pyFileExtensions.length() > 0) {
                pyFileExtensions.append(",");
            }
            pyFileExtensions.append("'*.").append((String)fileExtension).append("'");
        }
        it.appendNl("\tfilenames = [{0}]", pyFileExtensions);
        StringBuilder pyMimes = new StringBuilder();
        for (String string : this.getMimeTypes()) {
            if (pyMimes.length() > 0) {
                pyMimes.append(",");
            }
            pyMimes.append("'").append(string).append("'");
        }
        it.appendNl("\tmimetypes = [{0}]", pyMimes);
        it.appendNl("\t");
        it.appendNl("\tflags = re.MULTILINE | re.DOTALL");
        it.appendNl("\t");
        it.appendNl("\ttokens = {");
        it.appendNl("\t\t'root': [");
        it.appendNl("\t\t\t# method names");
        it.appendNl("\t\t\t(r'^(\\s*(?:[a-zA-Z_][\\w.\\[\\]]*\\s+)+?)'  # return arguments");
        it.appendNl("\t\t\t r'([a-zA-Z_$][\\w$]*)'                      # method name");
        it.appendNl("\t\t\t r'(\\s*)(\\()',                             # signature start");
        it.appendNl("\t\t\t bygroups(using(this), Name.Function, Text, Operator)),");
        it.appendNl("\t\t\t(r'[^\\S\\n]+', Text),");
        it.appendNl("\t\t\t(r'//.*?\\n', Comment.Single),");
        it.appendNl("\t\t\t(r'/\\*.*?\\*/', Comment.Multiline),");
        it.appendNl("\t\t\t(r'@[a-zA-Z_][\\w.]*', Name.Decorator),");
        StringBuilder rawKeywords = new StringBuilder();
        for (String string : expressionKeywords) {
            if (rawKeywords.length() > 0) {
                rawKeywords.append("|");
            }
            rawKeywords.append(string);
        }
        it.appendNl("\t\t\t(r''({0})\\b'',", rawKeywords);
        it.appendNl("\t\t\t Keyword),");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : modifiers) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(string);
        }
        it.appendNl("\t\t\t(r''({0})\\b'', Keyword.Declaration),", stringBuilder);
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string : primitiveTypes) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("|");
            }
            stringBuilder2.append(string);
        }
        it.appendNl("\t\t\t (r''({0})\\b'',", stringBuilder2);
        it.appendNl("\t\t\t  Keyword.Type),");
        StringBuilder stringBuilder3 = new StringBuilder();
        for (String string : specialKeywords) {
            if ("import".equals(string)) continue;
            if (stringBuilder3.length() > 0) {
                stringBuilder3.append("|");
            }
            stringBuilder3.append(string);
        }
        it.appendNl("\t\t\t (r''({0})(\\s+)'', bygroups(Keyword.Namespace, Text)),", stringBuilder3);
        StringBuilder stringBuilder4 = new StringBuilder();
        for (String string : literals) {
            if (stringBuilder4.length() > 0) {
                stringBuilder4.append("|");
            }
            stringBuilder4.append(string);
        }
        it.appendNl("\t\t\t (r''({0})\\b'', Keyword.Constant),", stringBuilder4);
        StringBuilder stringBuilder5 = new StringBuilder();
        for (String typeDeclaration : typeDeclarationKeywords) {
            if (stringBuilder5.length() > 0) {
                stringBuilder5.append("|");
            }
            stringBuilder5.append(typeDeclaration);
        }
        it.appendNl("\t\t\t (r''({0})(\\s+)'', bygroups(Keyword.Declaration, Text),", stringBuilder5);
        it.appendNl("\t\t\t  'class'),");
        StringBuilder stringBuilder6 = new StringBuilder();
        for (String special : specialKeywords) {
            if (!"import".equals(special)) continue;
            if (stringBuilder6.length() > 0) {
                stringBuilder6.append("|");
            }
            stringBuilder6.append(special);
        }
        it.appendNl("\t\t\t (r''({0})(\\s+)'', bygroups(Keyword.Namespace, Text), ''import''),", stringBuilder6);
        it.appendNl("\t\t\t (r'\"(\\\\\\\\|\\\\\"|[^\"])*\"', String),");
        it.appendNl("\t\t\t (r\"'(\\\\\\\\|\\\\'|[^'])*'\", String),");
        it.appendNl("\t\t\t (r'[a-zA-Z_]\\w*:', Name.Label),");
        it.appendNl("\t\t\t (r'[a-zA-Z_$]\\w*', Name),");
        it.appendNl("\t\t\t (r'[~^*!%&\\[\\](){}<>\\|+=:;,./?-]', Operator),");
        it.appendNl("\t\t\t (r'[0-9][0-9]*\\.[0-9]+([eE][0-9]+)?[fFdD]?', Number.Float),");
        it.appendNl("\t\t\t (r'0[xX][0-9a-fA-F]+', Number.Hex),");
        it.appendNl("\t\t\t (r'[0-9]+[lL]?', Number.Integer),");
        it.appendNl("\t\t\t (r'\\n', Text)");
        it.appendNl("\t\t],");
        it.appendNl("\t\t'class': [");
        it.appendNl("\t\t\t(r'[a-zA-Z_]\\w*', Name.Class, '#pop')");
        it.appendNl("\t\t],");
        it.appendNl("\t\t'import': [");
        it.appendNl("\t\t\t(r'[\\w.]+\\*?', Name.Namespace, '#pop')");
        it.appendNl("\t\t],");
        it.appendNl("\t}");
        it.newLine();
    }

    @Override
    protected void generateAdditionalFiles(String basename, IStyleAppendable writtenAppendable) {
        IStyleAppendable appendable = this.newStyleAppendable();
        this.generatePythonPackage(appendable, basename);
        this.writeFile("__init__.py", appendable);
        appendable = this.newStyleAppendable();
        this.generatePythonSetup(appendable, basename);
        this.writeFile("setup.py", appendable, (Functions.Function2<File, String, File>)((Functions.Function2)(folder, bname) -> folder.getParentFile()));
    }

    protected void generatePythonSetup(IStyleAppendable it, String basename) {
        it.appendNl("# -*- coding: {0} -*-", this.getCodeConfig().getEncoding().toLowerCase());
        it.appendHeader();
        it.newLine();
        it.append("from setuptools import setup");
        it.newLine().newLine();
        it.append("setup (");
        it.increaseIndentation().newLine();
        it.append("name='").append((CharSequence)basename).append((CharSequence)"lexer',");
        it.newLine();
        it.append("version='").append((CharSequence)this.getLanguageVersion()).append((CharSequence)"',");
        it.newLine();
        it.append("packages=['").append((CharSequence)basename).append((CharSequence)"lexer'],");
        it.newLine();
        it.append("entry_points =");
        it.newLine();
        it.append("\"\"\"");
        it.newLine();
        it.append("[pygments.lexers]");
        it.newLine();
        it.append("sarllexer = ").append((CharSequence)basename).append((CharSequence)"lexer.").append((CharSequence)basename);
        it.append(":SarlLexer");
        it.newLine();
        it.append("\"\"\",");
        it.decreaseIndentation().newLine();
        it.append(")");
        it.newLine();
    }

    protected void generatePythonPackage(IStyleAppendable it, String basename) {
        it.appendNl("# -*- coding: {0} -*-", this.getCodeConfig().getEncoding().toLowerCase());
        it.appendHeader();
        it.newLine();
        it.append("__all__ = [ ]");
        it.newLine();
    }

    @Override
    protected Object getReadmeFileContent(String basename) {
        return null;
    }
}

