/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec.textmate;

import com.google.common.io.Files;
import com.google.inject.Injector;
import io.sarl.lang.mwe2.externalspec.AbstractExternalHighlightingFragment2;
import io.sarl.lang.mwe2.externalspec.textmate.ITmStyleAppendable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xtext.generator.CodeConfig;

public class TextMateGenerator2
extends AbstractExternalHighlightingFragment2<ITmStyleAppendable> {
    public static final String BASENAME_PATTERN_OLD = "{0}.property-list";
    public static final String BASENAME_PATTERN_NEW = "{0}.tmLanguage";
    public static final String LICENSE_FILE = "LICENSE";
    private static final String FIRST_LINE_MATCHING = "^//.*\\bsarl\\b.";
    private static final String FOLDING_START = "\\{\\s*(//.*)?$";
    private static final String FOLDING_END = "^\\s*\\}";
    private static final String BLOCK_COMMENT_STYLE = "comment.block";
    private static final String BLOCK_COMMENT_DELIMITER_STYLE = "punctuation.definition.comment";
    private static final String LINE_COMMENT_STYLE = "comment.line";
    private static final String LINE_COMMENT_DELIMITER_STYLE = "comment.line.double-slash";
    private static final String DOUBLE_QUOTE_STRING_STYLE = "string.quoted.double";
    private static final String SINGLE_QUOTE_STRING_STYLE = "string.quoted.single";
    private static final String STRING_BEGIN_STYLE = "punctuation.definition.string.begin";
    private static final String STRING_END_STYLE = "punctuation.definition.string.end";
    private static final String ESCAPE_CHARACTER_STYLE = "constant.character.escape";
    private static final String LITERAL_STYLE = "constant.language";
    private static final String NUMBER_STYLE = "constant.numeric";
    private static final String PRIMITIVE_TYPE_STYLE = "storage.type.primitive";
    private static final String PUNCTUATION_STYLE = "keyword.operator";
    private static final String MODIFIER_STYLE = "storage.modifier";
    private static final String SPECIAL_KEYWORD_STYLE = "keyword.other.special";
    private static final String KEYWORD_STYLE = "keyword.control";
    private static final String TYPE_DECLARATION_STYLE = "keyword.other.declaration";
    private static final String ANNOTATION_STYLE = "support.type";
    private static final String BEGIN_PROP = "begin";
    private static final String END_PROP = "end";
    private static final String MATCH_PROP = "match";
    private static final String NAME_PROP = "name";
    private static final String SCOPE_NAME_PROP = "scopeName";
    private static final String CAPTURES_PROP = "captures";
    private static final String FILE_TYPES_PROP = "fileTypes";
    private static final String FIRST_LINE_MATCH_PROP = "firstLineMatch";
    private static final String FOLDING_START_PROP = "foldingStartMarker";
    private static final String FOLDING_END_PROP = "foldingStopMarker";
    private static final String PATTERNS_PROP = "patterns";
    private static final String SARL_VERSION_PROP = "__sarlVersion";
    private static final String VERSION_PROP = "version";
    private static final String UUID_PROP = "uuid";
    private static final String BEGIN_CAPTURES_PROP = "beginCaptures";
    private static final String END_CAPTURES_PROP = "endCaptures";
    private static final String COMMENT_PROP = "comment";

    public String toString() {
        return "TextMate";
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.setBasenameTemplate(BASENAME_PATTERN_OLD);
    }

    @Override
    protected ITmStyleAppendable newStyleAppendable() {
        return new CombinedTmAppendable(this.getCodeConfig(), this.getLanguageSimpleName(), this.getLanguageVersion());
    }

    protected UUID getUUID() {
        return UUID.nameUUIDFromBytes(this.getLanguageVersion().getBytes());
    }

    @Override
    protected void generate(ITmStyleAppendable appendable, Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put(NAME_PROP, this.getLanguageSimpleName());
        root.put(SARL_VERSION_PROP, this.getLanguageVersion());
        root.put(VERSION_PROP, this.getLanguageVersion());
        root.put(UUID_PROP, this.getUUID().toString().toUpperCase());
        root.put(SCOPE_NAME_PROP, "source." + (String)this.getLanguage().getFileExtensions().get(0));
        root.put(FILE_TYPES_PROP, this.getLanguage().getFileExtensions());
        root.put(FIRST_LINE_MATCH_PROP, FIRST_LINE_MATCHING);
        root.put(FOLDING_START_PROP, FOLDING_START);
        root.put(FOLDING_END_PROP, FOLDING_END);
        root.put(PATTERNS_PROP, this.createPatterns(literals, expressionKeywords, modifiers, primitiveTypes, punctuation, ignored, specialKeywords, typeDeclarationKeywords));
        appendable.appendHeader();
        appendable.appendProperty(root);
        appendable.appendFooter();
    }

    @Override
    protected void generateAdditionalFiles(String oldBasename, ITmStyleAppendable writtenAppendable) {
        if (writtenAppendable instanceof CombinedTmAppendable) {
            CombinedTmAppendable cvalue = (CombinedTmAppendable)writtenAppendable;
            this.generatePlistFile(cvalue);
        }
        this.generateLicenseFile();
    }

    protected void generatePlistFile(CombinedTmAppendable it) {
        String language = this.getLanguageSimpleName().toLowerCase();
        String newBasename = this.getBasename(MessageFormat.format(BASENAME_PATTERN_NEW, language));
        this.writeFile(newBasename, it.getNewSyntaxContent());
    }

    protected void generateLicenseFile() {
        String text;
        CharSequence licenseText = this.getLicenseText();
        if (licenseText != null && !Strings.isEmpty((String)(text = licenseText.toString()))) {
            this.writeFile(LICENSE_FILE, text.getBytes());
        }
    }

    protected CharSequence getLicenseText() {
        URL url = ((Object)((Object)this)).getClass().getResource(LICENSE_FILE);
        if (url != null) {
            File filename = new File(url.getPath());
            try {
                byte[] array = Files.toByteArray((File)filename);
                if (array != null) {
                    return new String(array);
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    protected List<?> createPatterns(Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        ArrayList patterns = new ArrayList();
        patterns.addAll(this.generateComments());
        patterns.addAll(this.generateStrings());
        patterns.addAll(this.generateNumericConstants());
        patterns.addAll(this.generateAnnotations());
        patterns.addAll(this.generateLiterals(literals));
        patterns.addAll(this.generatePrimitiveTypes(primitiveTypes));
        patterns.addAll(this.generateSpecialKeywords(specialKeywords));
        patterns.addAll(this.generateModifiers(modifiers));
        patterns.addAll(this.generateTypeDeclarations(typeDeclarationKeywords));
        patterns.addAll(this.generateStandardKeywords(expressionKeywords));
        patterns.addAll(this.generatePunctuation(punctuation));
        return patterns;
    }

    protected List<Map<String, ?>> generateAnnotations() {
        ArrayList list = new ArrayList();
        list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
            it.matches("\\@[_a-zA-Z$][_0-9a-zA-Z$]*");
            it.style(ANNOTATION_STYLE);
            it.comment("Annotations");
        })));
        return list;
    }

    protected List<Map<String, ?>> generateComments() {
        ArrayList list = new ArrayList();
        list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
            it.delimiters("(/\\*+)", "(\\*/)");
            it.style(BLOCK_COMMENT_STYLE);
            it.beginStyle(BLOCK_COMMENT_DELIMITER_STYLE);
            it.endStyle(BLOCK_COMMENT_DELIMITER_STYLE);
            it.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it2 -> {
                it2.matches("^\\s*(\\*)(?!/)");
                it2.style(BLOCK_COMMENT_DELIMITER_STYLE);
            }));
            it.comment("Multiline comments");
        })));
        list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
            it.matches("\\s*(//)(.*)$");
            it.substyle(1, LINE_COMMENT_DELIMITER_STYLE);
            it.substyle(2, LINE_COMMENT_STYLE);
            it.comment("Single-line comment");
        })));
        return list;
    }

    protected List<Map<String, ?>> generateStrings() {
        ArrayList list = new ArrayList();
        list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
            it.delimiters("\"", "\"");
            it.style(DOUBLE_QUOTE_STRING_STYLE);
            it.beginStyle(STRING_BEGIN_STYLE);
            it.endStyle(STRING_END_STYLE);
            it.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it2 -> {
                it2.matches("\\\\.");
                it2.style(ESCAPE_CHARACTER_STYLE);
            }));
            it.comment("Double quoted strings of characters");
        })));
        list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
            it.delimiters("'", "'");
            it.style(SINGLE_QUOTE_STRING_STYLE);
            it.beginStyle(STRING_BEGIN_STYLE);
            it.endStyle(STRING_END_STYLE);
            it.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it2 -> {
                it2.matches("\\\\.");
                it2.style(ESCAPE_CHARACTER_STYLE);
            }));
            it.comment("Single quoted strings of characters");
        })));
        return list;
    }

    protected List<Map<String, ?>> generateNumericConstants() {
        ArrayList list = new ArrayList();
        list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
            it.matches("(?:[0-9][0-9]*\\.[0-9]+([eE][0-9]+)?[fFdD]?)|(?:0[xX][0-9a-fA-F]+)|(?:[0-9]+[lL]?)");
            it.style(NUMBER_STYLE);
            it.comment("Numbers");
        })));
        return list;
    }

    protected List<Map<String, ?>> generatePrimitiveTypes(Set<String> primitiveTypes) {
        ArrayList list = new ArrayList();
        if (!primitiveTypes.isEmpty()) {
            list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
                it.matches(TextMateGenerator2.keywordRegex(primitiveTypes) + "(?:\\s*\\[\\s*\\])*");
                it.style(PRIMITIVE_TYPE_STYLE);
                it.comment("Primitive types");
            })));
        }
        return list;
    }

    protected List<Map<String, ?>> generateLiterals(Set<String> literals) {
        ArrayList list = new ArrayList();
        if (!literals.isEmpty()) {
            list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
                it.matches(TextMateGenerator2.keywordRegex(literals));
                it.style(LITERAL_STYLE);
                it.comment("SARL Literals and Constants");
            })));
        }
        return list;
    }

    protected List<Map<String, ?>> generatePunctuation(Set<String> punctuation) {
        ArrayList list = new ArrayList();
        if (!punctuation.isEmpty()) {
            list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
                it.matches(TextMateGenerator2.orRegex(punctuation));
                it.style(PUNCTUATION_STYLE);
                it.comment("Operators and Punctuations");
            })));
        }
        return list;
    }

    protected List<Map<String, ?>> generateModifiers(Set<String> modifiers) {
        ArrayList list = new ArrayList();
        if (!modifiers.isEmpty()) {
            list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
                it.matches(TextMateGenerator2.keywordRegex(modifiers));
                it.style(MODIFIER_STYLE);
                it.comment("Modifiers");
            })));
        }
        return list;
    }

    protected List<Map<String, ?>> generateSpecialKeywords(Set<String> keywords) {
        ArrayList list = new ArrayList();
        if (!keywords.isEmpty()) {
            list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
                it.matches(TextMateGenerator2.keywordRegex(keywords));
                it.style(SPECIAL_KEYWORD_STYLE);
                it.comment("Special Keywords");
            })));
        }
        return list;
    }

    protected List<Map<String, ?>> generateStandardKeywords(Set<String> keywords) {
        ArrayList list = new ArrayList();
        if (!keywords.isEmpty()) {
            list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
                it.matches(TextMateGenerator2.keywordRegex(keywords));
                it.style(KEYWORD_STYLE);
                it.comment("Standard Keywords");
            })));
        }
        return list;
    }

    protected List<Map<String, ?>> generateTypeDeclarations(Set<String> declarators) {
        ArrayList list = new ArrayList();
        if (!declarators.isEmpty()) {
            list.add(this.pattern((Procedures.Procedure1<? super Pattern>)((Procedures.Procedure1)it -> {
                it.matches(TextMateGenerator2.keywordRegex(declarators));
                it.style(TYPE_DECLARATION_STYLE);
                it.comment("Type Declarations");
            })));
        }
        return list;
    }

    protected Map<String, ?> pattern(Procedures.Procedure1<? super Pattern> proc) {
        Pattern patternDefinition = new Pattern();
        proc.apply((Object)patternDefinition);
        return patternDefinition.getDefinition();
    }

    @Override
    protected Object getReadmeFileContent(String basename) {
        return TextMateGenerator2.concat("SARL highlighting for TextMate", "==============================", "", "A TextMate package to apply syntax highlighting for the SARL language.", "", "1. INSTALLATION", "", "1.1. Manual", "", "Copy the " + basename + "file into one of the following folders:", "* Sublime Text 3: $HOME/.config/sublime-text-3/Packages/User/SARL/", "", "1.2 With Sublime TextPackage Control", "", "If you have the Package Control package installed, you can install the highlighting format", "from inside Sublime Text itself. Open the Command Palette and select \"Package Control: ", "Install Package\", then search for \"SARL\".");
    }

    protected static final class CombinedTmAppendable
    implements ITmStyleAppendable {
        private final OldStyleTmAppendable oldAppendable;
        private final XmlBasedTmAppendable newAppendable;

        protected CombinedTmAppendable(CodeConfig codeConfig, String languageName, String languageVersion) {
            this.oldAppendable = new OldStyleTmAppendable(codeConfig, languageName, languageVersion);
            this.newAppendable = new XmlBasedTmAppendable(codeConfig, languageName, languageVersion);
        }

        public String toString() {
            return this.oldAppendable.toString();
        }

        public ITmStyleAppendable getOldSyntaxContent() {
            return this.oldAppendable;
        }

        public ITmStyleAppendable getNewSyntaxContent() {
            return this.newAppendable;
        }

        @Override
        public void appendComment(String text, Object ... parameters) {
            this.oldAppendable.appendComment(text, parameters);
            this.newAppendable.appendComment(text, parameters);
        }

        @Override
        public void appendHeader() {
            this.oldAppendable.appendHeader();
            this.newAppendable.appendHeader();
        }

        public ISourceAppender append(CharSequence string) {
            this.oldAppendable.append(string);
            this.newAppendable.append(string);
            return this;
        }

        public ISourceAppender append(JvmType type) {
            this.oldAppendable.append(type);
            this.newAppendable.append(type);
            return this;
        }

        public ISourceAppender append(LightweightTypeReference typeRef) {
            this.oldAppendable.append(typeRef);
            this.newAppendable.append(typeRef);
            return this;
        }

        public ISourceAppender newLine() {
            this.oldAppendable.newLine();
            this.newAppendable.newLine();
            return this;
        }

        public ISourceAppender increaseIndentation() {
            this.oldAppendable.increaseIndentation();
            this.newAppendable.increaseIndentation();
            return this;
        }

        public ISourceAppender decreaseIndentation() {
            this.oldAppendable.decreaseIndentation();
            this.newAppendable.decreaseIndentation();
            return this;
        }

        public boolean isJava() {
            return this.oldAppendable.isJava() || this.newAppendable.isJava();
        }

        @Override
        public void appendFooter() {
            this.oldAppendable.appendFooter();
            this.newAppendable.appendFooter();
        }

        @Override
        public void appendProperty(Object value) {
            this.oldAppendable.appendProperty(value);
            this.newAppendable.appendProperty(value);
        }
    }

    protected final class Pattern {
        private Map<String, Object> content = new HashMap<String, Object>();
        private Map<Integer, String> captures = new HashMap<Integer, String>();
        private List<Map<String, ?>> patterns = new ArrayList();

        Pattern() {
        }

        public Map<String, Object> getDefinition() {
            if (!this.captures.isEmpty()) {
                HashMap captures = new HashMap();
                for (Map.Entry<Integer, String> part : this.captures.entrySet()) {
                    HashMap<String, String> val = new HashMap<String, String>();
                    val.put(TextMateGenerator2.NAME_PROP, part.getValue());
                    captures.put(part.getKey().toString(), val);
                }
                this.content.put(TextMateGenerator2.CAPTURES_PROP, captures);
            }
            if (!this.patterns.isEmpty()) {
                this.content.put(TextMateGenerator2.PATTERNS_PROP, this.patterns);
            }
            return this.content;
        }

        public void pattern(Procedures.Procedure1<? super Pattern> proc) {
            Map<String, ?> pattern = TextMateGenerator2.this.pattern(proc);
            this.patterns.add(pattern);
        }

        public void comment(String text) {
            this.content.put(TextMateGenerator2.COMMENT_PROP, text);
        }

        public void delimiters(String begin, String end) {
            this.content.put(TextMateGenerator2.BEGIN_PROP, begin);
            this.content.put(TextMateGenerator2.END_PROP, end);
            this.content.remove(TextMateGenerator2.MATCH_PROP);
        }

        public void matches(String pattern) {
            this.content.put(TextMateGenerator2.MATCH_PROP, pattern);
            this.content.remove(TextMateGenerator2.BEGIN_PROP);
            this.content.remove(TextMateGenerator2.END_PROP);
        }

        private String toName(String name) {
            return name + "." + TextMateGenerator2.this.getLanguageSimpleName().toLowerCase();
        }

        public void style(String name) {
            this.tmStyle(this.toName(name));
        }

        public void substyle(int part, String style) {
            this.captures.put(part, this.toName(style));
        }

        public void endStyle(String style) {
            HashMap value = new HashMap();
            HashMap<String, String> svalue = new HashMap<String, String>();
            svalue.put(TextMateGenerator2.NAME_PROP, this.toName(style));
            value.put(0, svalue);
            this.content.put(TextMateGenerator2.BEGIN_CAPTURES_PROP, value);
        }

        public void beginStyle(String style) {
            HashMap value = new HashMap();
            HashMap<String, String> svalue = new HashMap<String, String>();
            svalue.put(TextMateGenerator2.NAME_PROP, this.toName(style));
            value.put(0, svalue);
            this.content.put(TextMateGenerator2.END_CAPTURES_PROP, value);
        }

        public void tmStyle(String name) {
            this.content.put(TextMateGenerator2.NAME_PROP, name);
        }
    }

    protected static class XmlBasedTmAppendable
    extends AbstractExternalHighlightingFragment2.AbstractAppendable
    implements ITmStyleAppendable {
        private static final String PLIST_VERSION = "1.0";

        protected XmlBasedTmAppendable(CodeConfig codeConfig, String languageName, String languageVersion) {
            super("\t", codeConfig, languageName, languageVersion);
        }

        @Override
        protected void appendType(JvmType type, StringBuilder builder) {
            builder.append(type.getQualifiedName());
        }

        @Override
        protected void appendType(Class<?> type, StringBuilder builder) {
            builder.append(type.getName());
        }

        @Override
        public void appendHeader() {
            this.appendNl(MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\"?>", this.getCodeConfig().getEncoding()));
            this.append("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-");
            this.append(PLIST_VERSION);
            this.appendNl(".dtd\">");
            String[] header = Strings.emptyIfNull((String)this.getCodeConfig().getFileHeader()).split("[\n\r]+");
            this.appendNl("<!--");
            for (String headerLine : header) {
                this.appendNl(headerLine.replaceFirst("^\\s*[/]?[*][/]?", "\t ").replaceFirst("\\s+$", ""));
            }
            this.appendNl("-->");
            this.append("<plist version=\"");
            this.append(PLIST_VERSION);
            this.appendNl("\">");
        }

        @Override
        public void appendFooter() {
            this.newLine();
            this.appendNl("</plist>");
        }

        @Override
        public void appendComment(String text, Object ... parameters) {
            this.appendCommentNoNl(text, parameters);
            this.newLine();
        }

        void appendCommentNoNl(String text, Object ... parameters) {
            String comment = this.applyFormat(text, parameters);
            this.appendNl("<!-- ");
            for (String line : comment.split("[\n\r]")) {
                this.appendNl("\t " + line.trim());
            }
            this.append("-->");
        }

        @Override
        public void appendProperty(Object value) {
            if (value instanceof Iterable) {
                Iterable cvalue = (Iterable)value;
                this.append("<array>");
                this.increaseIndentation().newLine();
                boolean first = true;
                for (Object arrayElement : cvalue) {
                    if (first) {
                        first = false;
                    } else {
                        this.newLine();
                    }
                    this.appendProperty(arrayElement);
                }
                this.decreaseIndentation().newLine();
                this.append("</array>");
            } else if (value instanceof Map) {
                Map cvalue = (Map)value;
                this.append("<dict>");
                this.increaseIndentation().newLine();
                boolean first = true;
                for (Map.Entry entry : cvalue.entrySet()) {
                    Object rawKey = entry.getKey();
                    if (rawKey == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.newLine();
                    }
                    Object rawValue = entry.getValue();
                    this.append("<key>");
                    this.append(rawKey.toString());
                    this.appendNl("</key>");
                    this.appendProperty(rawValue);
                }
                this.decreaseIndentation().newLine();
                this.append("</dict>");
            } else {
                this.append("<string>");
                if (value != null) {
                    this.append(this.protect(value.toString()));
                }
                this.append("</string>");
            }
        }

        protected String protect(String value) {
            String tmp = value.replaceAll("&", "&amp;");
            tmp = tmp.replaceAll(">", "&gt;");
            return tmp.replaceAll("<", "&lt;");
        }
    }

    protected static class OldStyleTmAppendable
    extends AbstractExternalHighlightingFragment2.AbstractAppendable
    implements ITmStyleAppendable {
        protected OldStyleTmAppendable(CodeConfig codeConfig, String languageName, String languageVersion) {
            super("  ", codeConfig, languageName, languageVersion);
        }

        @Override
        protected void appendType(JvmType type, StringBuilder builder) {
            builder.append(type.getQualifiedName());
        }

        @Override
        protected void appendType(Class<?> type, StringBuilder builder) {
            builder.append(type.getName());
        }

        @Override
        public void appendHeader() {
        }

        @Override
        public void appendFooter() {
        }

        @Override
        public void appendComment(String text, Object ... parameters) {
        }

        protected String protect(String value) {
            if (value == null) {
                return new String();
            }
            return value.replaceAll("\\'", "''");
        }

        @Override
        public void appendProperty(Object value) {
            if (value instanceof Iterable) {
                Iterable cvalue = (Iterable)value;
                this.append("(");
                this.increaseIndentation().newLine();
                boolean first = true;
                for (Object arrayElement : cvalue) {
                    if (first) {
                        first = false;
                    } else {
                        this.append(",").newLine();
                    }
                    this.appendProperty(arrayElement);
                }
                this.decreaseIndentation().newLine();
                this.append(")");
            } else if (value instanceof Map) {
                Map cvalue = (Map)value;
                this.append("{");
                this.increaseIndentation().newLine();
                boolean first = true;
                for (Map.Entry entry : cvalue.entrySet()) {
                    Object rawKey = entry.getKey();
                    if (rawKey == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.append(";").newLine();
                    }
                    Object rawValue = entry.getValue();
                    this.append(rawKey.toString());
                    this.append(" = ");
                    this.appendProperty(rawValue);
                }
                this.decreaseIndentation().newLine();
                this.append("}");
            } else {
                this.append("'");
                this.append(value == null ? "" : this.protect(value.toString()));
                this.append("'");
            }
        }
    }
}

