/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.externalspec.vim;

import com.google.inject.Injector;
import io.sarl.lang.mwe2.externalspec.AbstractExternalHighlightingFragment2;
import io.sarl.lang.mwe2.externalspec.IStyleAppendable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xtext.generator.CodeConfig;

public class VimGenerator2
extends AbstractExternalHighlightingFragment2<IStyleAppendable> {
    public static final String FILE_EXTENSION = ".vim";
    public static final String BASENAME_PATTERN = "{0}.vim";
    public static final String SYNTAX_FOLDER = "syntax";
    public static final String FTDETECT_FOLDER = "ftdetect";
    private final Map<String, VimSyntaxGroup> highlights = new HashMap<String, VimSyntaxGroup>();

    @Override
    protected IStyleAppendable newStyleAppendable() {
        return new VimAppendable(this.getCodeConfig(), this.getLanguageSimpleName(), this.getLanguageVersion());
    }

    public String toString() {
        return "Vim";
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.setBasenameTemplate(BASENAME_PATTERN);
        this.setOutputDirectoryFilter((Functions.Function2<File, String, File>)((Functions.Function2)(folder, basename) -> {
            if (basename.endsWith(FILE_EXTENSION)) {
                return new File((File)folder, SYNTAX_FOLDER);
            }
            return folder;
        }));
    }

    @Override
    protected void generate(IStyleAppendable it, Set<String> literals, Set<String> expressionKeywords, Set<String> modifiers, Set<String> primitiveTypes, Set<String> punctuation, Set<String> ignored, Set<String> specialKeywords, Set<String> typeDeclarationKeywords) {
        it.appendHeader();
        this.generatePreamble(it);
        this.generateComments(it);
        this.generateNumericConstants(it);
        this.generateStrings(it);
        this.generateAnnotations(it);
        this.generatePrimitiveTypes(it, primitiveTypes);
        this.generateKeywords(it, "sarlLiteral", VimSyntaxGroup.IDENTIFIER, literals);
        this.generateKeywords(it, "sarlSpecial", VimSyntaxGroup.SPECIAL, specialKeywords);
        this.generateKeywords(it, "sarlTypeDeclaration", VimSyntaxGroup.TYPE_DECLARATION, typeDeclarationKeywords);
        this.generateKeywords(it, "sarlModifier", VimSyntaxGroup.STATEMENT, modifiers);
        this.generateKeywords(it, "sarlKeyword", VimSyntaxGroup.STATEMENT, expressionKeywords);
        this.generatePunctuation(it, punctuation);
        this.generatePostamble(it);
    }

    protected void generatePreamble(IStyleAppendable it) {
        this.clearHilights();
        String nm = this.getLanguageSimpleName().toLowerCase();
        String cmd = Strings.toFirstUpper((String)this.getLanguageSimpleName().toLowerCase()) + "HiLink";
        this.appendComment(it, "Quit when a syntax file was already loaded");
        this.appendCmd(it, false, "if !exists(\"main_syntax\")").increaseIndentation().newLine();
        this.appendCmd(it, false, "if exists(\"b:current_syntax\")").increaseIndentation().newLine();
        this.appendCmd(it, false, "finish").decreaseIndentation().newLine();
        this.appendCmd(it, "endif");
        this.appendComment(it, "we define it here so that included files can test for it");
        this.appendCmd(it, "let main_syntax='" + nm + "'");
        this.appendCmd(it, false, "syn region " + nm + "Fold start=\"{\" end=\"}\" transparent fold");
        it.decreaseIndentation().newLine();
        this.appendCmd(it, "endif");
        it.newLine();
        this.appendCmd(it, "let s:cpo_save = &cpo");
        this.appendCmd(it, "set cpo&vim");
        it.newLine();
        this.appendComment(it, "don't use standard HiLink, it will not work with included syntax files");
        this.appendCmd(it, false, "if version < 508").increaseIndentation().newLine();
        this.appendCmd(it, false, "command! -nargs=+ " + cmd + " hi link <args>").decreaseIndentation().newLine();
        this.appendCmd(it, false, "else").increaseIndentation().newLine();
        this.appendCmd(it, false, "command! -nargs=+ " + cmd + " hi def link <args>").decreaseIndentation().newLine();
        this.appendCmd(it, "endif");
        it.newLine();
        this.appendComment(it, "some characters that cannot be in a SARL program (outside a string)");
        this.appendMatch(it, nm + "Error", "[\\\\`]", new String[0]);
        it.newLine();
    }

    protected void generatePostamble(IStyleAppendable it) {
        this.appendComment(it, "catch errors caused by wrong parenthesis");
        this.appendCmd(it, "syn region sarlParenT transparent matchgroup=sarlParen  start=\"(\" end=\")\" contains=@sarlTop,sarlParenT1");
        this.appendCmd(it, "syn region sarlParenT1 transparent matchgroup=sarlParen1 start=\"(\" end=\")\" contains=@sarlTop,sarlParenT2 contained");
        this.appendCmd(it, "syn region sarlParenT2 transparent matchgroup=sarlParen2 start=\"(\" end=\")\" contains=@sarlTop,sarlParenT contained");
        this.appendCmd(it, "syn match sarlParenError \")\"");
        this.appendComment(it, "catch errors caused by wrong square parenthesis");
        this.appendCmd(it, "syn region sarlParenT transparent matchgroup=sarlParen  start=\"\\[\" end=\"\\]\" contains=@sarlTop,sarlParenT1");
        this.appendCmd(it, "syn region sarlParenT1 transparent matchgroup=sarlParen1 start=\"\\[\" end=\"\\]\" contains=@sarlTop,sarlParenT2 contained");
        this.appendCmd(it, "syn region sarlParenT2 transparent matchgroup=sarlParen2 start=\"\\[\" end=\"\\]\" contains=@sarlTop,sarlParenT  contained");
        this.appendCmd(it, "syn match sarlParenError \"\\]\"");
        it.newLine();
        this.appendCmd(it, "SarlHiLink sarlParenError sarlError");
        it.newLine();
        this.appendCmd(it, false, "if !exists(\"sarl_minlines\")").increaseIndentation().newLine();
        this.appendCmd(it, false, "let sarl_minlines = 10").decreaseIndentation().newLine();
        this.appendCmd(it, "endif");
        this.appendCmd(it, "exec \"syn sync ccomment sarlComment minlines=\" . sarl_minlines");
        it.newLine();
        this.appendComment(it, "The default highlighting.");
        for (Map.Entry<String, VimSyntaxGroup> hilight : this.highlights.entrySet()) {
            this.appendCmd(it, "SarlHiLink " + hilight.getKey() + " " + hilight.getValue().getVimConstant());
        }
        this.clearHilights();
        it.newLine();
        this.appendCmd(it, "delcommand SarlHiLink");
        it.newLine();
        this.appendCmd(it, "let b:current_syntax = \"" + this.getLanguageSimpleName().toLowerCase() + "\"");
        it.newLine();
        this.appendCmd(it, false, "if main_syntax == '" + this.getLanguageSimpleName().toLowerCase() + "'");
        it.increaseIndentation().newLine();
        this.appendCmd(it, false, "unlet main_syntax").decreaseIndentation().newLine();
        this.appendCmd(it, "endif");
        it.newLine();
        this.appendCmd(it, "let b:spell_options=\"contained\"");
        this.appendCmd(it, "let &cpo = s:cpo_save");
        this.appendCmd(it, "unlet s:cpo_save");
    }

    protected void generatePunctuation(IStyleAppendable it, Iterable<String> punctuation) {
    }

    protected void generatePrimitiveTypes(IStyleAppendable it, Iterable<String> types) {
        Iterator<String> iterator = types.iterator();
        if (iterator.hasNext()) {
            this.appendComment(it, "primitive types.");
            this.appendMatch(it, "sarlArrayDeclaration", "\\(\\s*\\[\\s*\\]\\)*", true, new String[0]);
            it.append("syn keyword sarlPrimitiveType");
            do {
                it.append(" ");
                it.append(iterator.next());
            } while (iterator.hasNext());
            it.append(" nextgroup=sarlArrayDeclaration").newLine();
            this.appendCluster(it, "sarlPrimitiveType", new String[0]);
            this.hilight("sarlPrimitiveType", VimSyntaxGroup.SPECIAL);
            this.hilight("sarlArrayDeclaration", VimSyntaxGroup.SPECIAL);
            it.newLine();
        }
    }

    protected void generateComments(IStyleAppendable it) {
        this.appendComment(it, "comments");
        this.appendRegion(it, "sarlComment", "/\\*", "\\*/", "@Spell");
        this.appendCmd(it, "syn match sarlCommentStar contained \"^\\s*\\*[^/]\"me=e-1");
        this.appendMatch(it, "sarlCommentStar", "^\\s*\\*$", true, new String[0]);
        this.appendMatch(it, "sarlLineComment", "//.*", "@Spell");
        this.appendCluster(it, "sarlComment", "sarlLineComment");
        this.hilight("sarlComment", VimSyntaxGroup.COMMENT);
        this.hilight("sarlLineComment", VimSyntaxGroup.COMMENT);
        this.appendComment(it, "match the special comment /**/");
        this.appendMatch(it, "sarlComment", "/\\*\\*/", new String[0]);
        it.newLine();
    }

    protected void generateStrings(IStyleAppendable it) {
        this.appendComment(it, "Strings constants");
        this.appendMatch(it, "sarlSpecialError", "\\\\.", true, new String[0]);
        this.appendMatch(it, "sarlSpecialCharError", "[^']", true, new String[0]);
        this.appendMatch(it, "sarlSpecialChar", "\\\\\\([4-9]\\d\\|[0-3]\\d\\d\\|[\"\\\\'ntbrf]\\|u\\x\\{4\\}\\)", true, new String[0]);
        this.appendRegion(it, true, "sarlString", "\"", "\"", "sarlSpecialChar", "sarlSpecialError", "@Spell");
        this.appendRegion(it, true, "sarlString", "'", "'", "sarlSpecialChar", "sarlSpecialError", "@Spell");
        this.appendCluster(it, "sarlString", new String[0]);
        this.hilight("sarlString", VimSyntaxGroup.CONSTANT);
        it.newLine();
    }

    protected void generateNumericConstants(IStyleAppendable it) {
        this.appendComment(it, "numerical constants");
        this.appendMatch(it, "sarlNumber", "[0-9][0-9]*\\.[0-9]\\+([eE][0-9]\\+)\\?[fFdD]\\?", new String[0]);
        this.appendMatch(it, "sarlNumber", "0[xX][0-9a-fA-F]\\+", new String[0]);
        this.appendMatch(it, "sarlNumber", "[0-9]\\+[lL]\\?", new String[0]);
        this.appendCluster(it, "sarlNumber", new String[0]);
        this.hilight("sarlNumber", VimSyntaxGroup.CONSTANT);
        it.newLine();
    }

    protected void generateAnnotations(IStyleAppendable it) {
        this.appendComment(it, "annnotation");
        this.appendMatch(it, "sarlAnnotation", "@[_a-zA-Z][_0-9a-zA-Z]*\\([.$][_a-zA-Z][_0-9a-zA-Z]*\\)*", new String[0]);
        this.appendCluster(it, "sarlAnnotation", new String[0]);
        this.hilight("sarlAnnotation", VimSyntaxGroup.PRE_PROCESSOR);
        it.newLine();
    }

    protected void generateKeywords(IStyleAppendable it, String family, VimSyntaxGroup color, Iterable<String> keywords) {
        this.appendComment(it, "keywords for the '" + family + "' family.");
        Iterator<String> iterator = keywords.iterator();
        if (iterator.hasNext()) {
            it.append("syn keyword ");
            it.append(family);
            do {
                it.append(" ");
                it.append(iterator.next());
            } while (iterator.hasNext());
        }
        it.newLine();
        this.appendCluster(it, family, new String[0]);
        this.hilight(family, color);
        it.newLine();
    }

    protected void clearHilights() {
        this.highlights.clear();
    }

    protected void hilight(String name, VimSyntaxGroup group) {
        this.highlights.put(name, group);
    }

    protected IStyleAppendable appendCluster(IStyleAppendable it, String element0, String ... elements) {
        return this.appendCluster(it, true, element0, elements);
    }

    protected IStyleAppendable appendCluster(IStyleAppendable it, boolean addNewLine, String element0, String ... elements) {
        it.append("syn cluster ");
        it.append(this.getLanguageSimpleName().toLowerCase());
        it.append("Top add=");
        it.append(element0);
        for (String element : elements) {
            it.append(",");
            it.append(element);
        }
        if (addNewLine) {
            it.newLine();
        }
        return it;
    }

    protected IStyleAppendable appendRegion(IStyleAppendable it, String name, String start, String end, String ... contains) {
        return this.appendRegion(it, true, name, start, end, contains);
    }

    protected IStyleAppendable appendRegion(IStyleAppendable it, boolean addNewLine, String name, String start, String end, String ... contains) {
        return this.appendRegion(it, addNewLine, name, start, new String[]{end}, contains);
    }

    protected IStyleAppendable appendRegion(IStyleAppendable it, boolean addNewLine, String name, String start, String[] end, String ... contains) {
        it.append("syn region  ");
        it.append(name);
        it.append(" start=");
        it.append(VimGenerator2.regexString(start));
        for (String endPattern : end) {
            it.append(" end=");
            it.append(VimGenerator2.regexString(endPattern));
        }
        if (contains.length > 0) {
            it.append(" contains=").append((CharSequence)contains[0]);
            for (int i = 1; i < contains.length; ++i) {
                it.append(",").append((CharSequence)contains[i]);
            }
        }
        if (addNewLine) {
            it.newLine();
        }
        return it;
    }

    protected IStyleAppendable appendMatch(IStyleAppendable it, String name, String pattern, String ... contains) {
        return this.appendMatch(it, true, name, pattern, false, contains);
    }

    protected IStyleAppendable appendMatch(IStyleAppendable it, String name, String pattern, boolean contained, String ... contains) {
        return this.appendMatch(it, true, name, pattern, contained, contains);
    }

    protected IStyleAppendable appendMatch(IStyleAppendable it, boolean addNewLine, String name, String pattern, String ... contains) {
        return this.appendMatch(it, addNewLine, name, pattern, false, contains);
    }

    protected IStyleAppendable appendMatch(IStyleAppendable it, boolean addNewLine, String name, String pattern, boolean contained, String ... contains) {
        it.append("syn match ");
        it.append(name);
        if (contained) {
            it.append(" contained");
        }
        it.append(" ");
        it.append(VimGenerator2.regexString(pattern));
        if (contains.length > 0) {
            it.append(" contains=").append((CharSequence)contains[0]);
            for (int i = 1; i < contains.length; ++i) {
                it.append(",").append((CharSequence)contains[i]);
            }
        }
        if (addNewLine) {
            it.newLine();
        }
        return it;
    }

    protected IStyleAppendable appendComment(IStyleAppendable it, String text) {
        return this.appendComment(it, true, text);
    }

    protected IStyleAppendable appendComment(IStyleAppendable it, boolean addNewLine, String text) {
        it.append("\" ");
        it.append(text);
        if (addNewLine) {
            it.newLine();
        }
        return it;
    }

    protected IStyleAppendable appendCmd(IStyleAppendable it, String text) {
        return this.appendCmd(it, true, text);
    }

    protected IStyleAppendable appendCmd(IStyleAppendable it, boolean addNewLine, String text) {
        it.append(text);
        if (addNewLine) {
            it.newLine();
        }
        return it;
    }

    @Override
    protected Object getReadmeFileContent(String basename) {
        return VimGenerator2.concat("1. MANUAL INSTALLATION", "", "For Unix:", "* Copy the content of the 'syntax' folder into $HOME/.vim/syntax", "* Copy the content of the 'ftdetect' folder into $HOME/.vim/ftdetect", "", "For Windows:", "* Copy the content of the 'syntax' folder into C:\\Document and Settings\\User\\vimfiles\\syntax", "* Copy the content of the 'ftdetect' folder into C:\\Document and Settings\\User\\vimfiles\\ftdetect");
    }

    @Override
    protected void generateAdditionalFiles(String basename, IStyleAppendable appendable) {
        this.generateFileTypeDetectionScript(basename);
    }

    protected void generateFileTypeDetectionScript(String basename) {
        String textualContent;
        CharSequence scriptContent = this.getFileTypeDetectionScript();
        if (scriptContent != null && !Strings.isEmpty((String)(textualContent = scriptContent.toString()))) {
            byte[] bytes = textualContent.getBytes();
            for (String output : this.getOutputs()) {
                File directory = new File(output, FTDETECT_FOLDER).getAbsoluteFile();
                try {
                    File outputFile = new File(directory, basename);
                    outputFile.getParentFile().mkdirs();
                    Files.write(Paths.get(outputFile.getAbsolutePath(), new String[0]), bytes, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected CharSequence getFileTypeDetectionScript() {
        return VimGenerator2.concat("\" Vim filetype-detection file", "\" Language: " + this.getLanguageSimpleName(), "\" Version: " + this.getLanguageVersion(), "", "au BufRead,BufNewFile *." + (String)this.getLanguage().getFileExtensions().get(0) + " set filetype=" + this.getLanguageSimpleName().toLowerCase());
    }

    private static String regexString(String expression) {
        if (expression.contains("\"")) {
            if (expression.contains("'")) {
                if (expression.contains("+")) {
                    throw new IllegalStateException();
                }
                return "+" + expression + "+";
            }
            return "'" + expression + "'";
        }
        return "\"" + expression + "\"";
    }

    protected static class VimAppendable
    extends AbstractExternalHighlightingFragment2.AbstractAppendable {
        protected VimAppendable(CodeConfig codeConfig, String languageName, String languageVersion) {
            super("  ", codeConfig, languageName, languageVersion);
        }

        @Override
        public void appendComment(String text, Object ... parameters) {
            String comment = this.applyFormat(text, parameters);
            for (String line : comment.split("[\n\r]")) {
                this.appendNl("\" " + line.trim());
            }
        }

        @Override
        public void appendHeader() {
            String[] header;
            this.appendNl("\" Vim syntax file");
            this.appendNl("\" Language: " + this.getLanguageSimpleName());
            this.appendNl("\" Version: " + this.getLanguageVersion());
            for (String headerLine : header = Strings.emptyIfNull((String)this.getCodeConfig().getFileHeader()).split("[\n\r]+")) {
                this.appendNl(headerLine.replaceFirst("^\\s*[/]?[*][/]?", "\" "));
            }
            this.newLine().newLine();
        }
    }

    protected static enum VimSyntaxGroup {
        NORMAL("Normal"),
        COMMENT("Comment"),
        CONSTANT("Constant"),
        SPECIAL("Special"),
        IDENTIFIER("Identifier"),
        STATEMENT("Statement"),
        PRE_PROCESSOR("PreProc"),
        TYPE_DECLARATION("Type"),
        UNDERLINED("Underlined"),
        TODO("Todo"),
        OPERATOR("Operator");

        private final String vimConstant;

        private VimSyntaxGroup(String vimConstant) {
            this.vimConstant = vimConstant;
        }

        public String getVimConstant() {
            return this.vimConstant;
        }
    }
}

