/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.inject;

import com.google.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import javax.inject.Provider;

public enum InjectionAPI {
    JAKARTA{

        @Override
        public Class<?> getInjectType() {
            return jakarta.inject.Inject.class;
        }

        @Override
        public Class<?> getNamedType() {
            return Named.class;
        }

        @Override
        public Class<?> getProviderType() {
            return jakarta.inject.Provider.class;
        }

        @Override
        public Class<?> getSingletonType() {
            return Singleton.class;
        }
    }
    ,
    JAVAX{

        @Override
        public Class<?> getInjectType() {
            return javax.inject.Inject.class;
        }

        @Override
        public Class<?> getNamedType() {
            return javax.inject.Named.class;
        }

        @Override
        public Class<?> getProviderType() {
            return Provider.class;
        }

        @Override
        public Class<?> getSingletonType() {
            return javax.inject.Singleton.class;
        }
    }
    ,
    GOOGLE_GUICE{

        @Override
        public Class<?> getInjectType() {
            return Inject.class;
        }

        @Override
        public Class<?> getNamedType() {
            return com.google.inject.name.Named.class;
        }

        @Override
        public Class<?> getProviderType() {
            return com.google.inject.Provider.class;
        }

        @Override
        public Class<?> getSingletonType() {
            return com.google.inject.Singleton.class;
        }
    };


    public static InjectionAPI getDefault() {
        return JAKARTA;
    }

    public abstract Class<?> getInjectType();

    public abstract Class<?> getNamedType();

    public abstract Class<?> getProviderType();

    public abstract Class<?> getSingletonType();
}

