/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.keywords;

import com.google.common.base.Strings;
import io.sarl.lang.mwe2.inject.InjectionAPI;
import io.sarl.lang.mwe2.keywords.GrammarKeywordAccessKeywordConfig;
import io.sarl.lang.mwe2.keywords.NamedGrammarKeywordAccessConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class GrammarKeywordAccessConfig
extends GrammarKeywordAccessKeywordConfig {
    private InjectionAPI injectionAPI = InjectionAPI.getDefault();
    private String protectionSymbol = "^";
    private boolean isDependencyGrammarInheritance;
    private boolean removeKeywordsDefinedInScopes = true;
    private final List<NamedGrammarKeywordAccessConfig> scopes = new ArrayList<NamedGrammarKeywordAccessConfig>();

    public List<NamedGrammarKeywordAccessConfig> getScopes() {
        return this.scopes;
    }

    public void addScope(NamedGrammarKeywordAccessConfig configuration) {
        if (configuration != null) {
            this.scopes.add(configuration);
        }
    }

    public void setKeywordProtectionSymbol(String symbol) {
        if (!Strings.isNullOrEmpty((String)symbol)) {
            this.protectionSymbol = symbol;
        }
    }

    public String getKeywordProtectionSymbol() {
        return this.protectionSymbol;
    }

    public void setDependencyGrammarInheritance(boolean enable) {
        this.isDependencyGrammarInheritance = enable;
    }

    public boolean getDependencyGrammarInheritance() {
        return this.isDependencyGrammarInheritance;
    }

    public InjectionAPI getInjectionAPI() {
        return this.injectionAPI;
    }

    public void setInjectionAPI(InjectionAPI api) {
        this.injectionAPI = api == null ? InjectionAPI.getDefault() : api;
    }

    @Deprecated(since="0.15", forRemoval=true)
    public boolean getGoogleInjectionTypes() {
        return this.injectionAPI == InjectionAPI.GOOGLE_GUICE;
    }

    @Deprecated(since="0.15", forRemoval=true)
    public void setGoogleInjectionTypes(boolean isGoogle) {
        this.injectionAPI = isGoogle ? InjectionAPI.GOOGLE_GUICE : InjectionAPI.getDefault();
    }

    @Deprecated(since="0.15", forRemoval=true)
    public Class<?> getInjectType() {
        return this.getInjectionAPI().getInjectType();
    }

    @Deprecated(since="0.15", forRemoval=true)
    public Class<?> getNamedType() {
        return this.getInjectionAPI().getNamedType();
    }

    @Deprecated(since="0.15", forRemoval=true)
    public Class<?> getProviderType() {
        return this.getInjectionAPI().getProviderType();
    }

    @Deprecated(since="0.15", forRemoval=true)
    public Class<?> getSingletonType() {
        return this.getInjectionAPI().getSingletonType();
    }

    public boolean getRemoveKeywordsDefinedInScopes() {
        return this.removeKeywordsDefinedInScopes;
    }

    public void setRemoveKeywordsDefinedInScopes(boolean remove) {
        this.removeKeywordsDefinedInScopes = remove;
    }

    public Set<String> getAllKeywordsDefinedInScope() {
        TreeSet<String> all = new TreeSet<String>();
        for (NamedGrammarKeywordAccessConfig scope : this.getScopes()) {
            all.addAll(scope.getKeywords());
        }
        return all;
    }
}

