/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.keywords;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.mwe2.keywords.GrammarKeywordAccessConfig;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.grammarAccess.GrammarAccessExtensions;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class GrammarKeywordAccessFragment2
extends AbstractXtextGeneratorFragment {
    private static final Logger LOG = Logger.getLogger(GrammarKeywordAccessFragment2.class);
    @Inject
    private FileAccessFactory fileAccessFactory;
    @Inject
    private XtextGeneratorNaming naming;
    @Inject
    private GrammarAccessExtensions grammarAccessExtensions;
    @Inject
    private GrammarKeywordAccessConfig configuration;
    @Inject
    private JavaKeywords javaKeywords;

    @Pure
    public String getLanguageName() {
        return Strings.toFirstUpper((String)GrammarUtil.getSimpleName((Grammar)this.getGrammar()).toLowerCase());
    }

    @Pure
    public String getBasePackage() {
        Grammar grammar = this.getGrammar();
        String basePackage = this.naming.getRuntimeBasePackage(grammar);
        return basePackage + ".services";
    }

    @Pure
    public TypeReference getAccessorType() {
        return new TypeReference(this.getBasePackage() + "." + this.getLanguageName().toUpperCase() + "GrammarKeywordAccess");
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
    }

    public Class<?> getInjectType() {
        return this.configuration.getInjectionAPI().getInjectType();
    }

    public void generate() {
        LOG.info((Object)("Generating the grammar keyword access for " + this.getLanguageName()));
        StringConcatenationClient content = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"/** Set of SARL keywords that are not directly supported by the");
                it.newLine();
                it.append((Object)" * {@link SARLGrammarAccess} or hardly accessible.");
                it.newLine();
                it.append((Object)" */");
                it.newLine();
                it.append((Object)"@");
                it.append(SuppressWarnings.class);
                it.append((Object)"(\"all\")");
                it.newLine();
                it.append((Object)"public class ");
                it.append((Object)GrammarKeywordAccessFragment2.this.getAccessorType().getSimpleName());
                it.append((Object)" {");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t@");
                it.append(Inject.class);
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append((Object)GrammarKeywordAccessFragment2.this.grammarAccessExtensions.getGrammarAccess(GrammarKeywordAccessFragment2.this.getGrammar()));
                it.append((Object)" grammarAccess;");
                it.newLineIfNotEmpty();
                it.newLine();
                HashSet<String> addedKeywords = new HashSet<String>();
                HashMap<String, String> getters = new HashMap<String, String>();
                LinkedList<Grammar> grammars = new LinkedList<Grammar>();
                grammars.add(GrammarKeywordAccessFragment2.this.getGrammar());
                while (!grammars.isEmpty()) {
                    Grammar grammar = (Grammar)grammars.removeFirst();
                    if (!GrammarKeywordAccessFragment2.this.isValidGrammar(grammar)) continue;
                    it.append((Object)GrammarKeywordAccessFragment2.this.generateMembers(grammar, addedKeywords, getters));
                    if (!GrammarKeywordAccessFragment2.this.configuration.getDependencyGrammarInheritance()) continue;
                    grammars.addAll(GrammarKeywordAccessFragment2.getEffectivelyUsedGrammars(grammar));
                }
                it.append((Object)GrammarKeywordAccessFragment2.this.generateMembersFromConfig(addedKeywords, getters));
                it.append((Object)GrammarKeywordAccessFragment2.this.generateAccessors(addedKeywords, getters));
                it.append((Object)"}");
                it.newLine();
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
        JavaFileAccess javaFile = this.fileAccessFactory.createJavaFile(this.getAccessorType(), content);
        javaFile.writeTo((IFileSystemAccess2)this.getProjectConfig().getRuntime().getSrcGen());
    }

    protected boolean isValidGrammar(Grammar grammar) {
        return !Objects.equal((Object)grammar.getName(), (Object)"org.eclipse.xtext.common.Terminals");
    }

    protected StringConcatenationClient generateMembersFromConfig(Set<String> addedKeywords, Map<String, String> getters) {
        String id;
        final ArrayList<StringConcatenationClient> clients = new ArrayList<StringConcatenationClient>();
        Set scopedKeywords = this.configuration.getRemoveKeywordsDefinedInScopes() ? this.configuration.getAllKeywordsDefinedInScope() : Collections.emptySet();
        for (String keyword : this.configuration.getKeywords()) {
            id = keyword.toLowerCase();
            if (addedKeywords.contains(id) || this.configuration.getIgnoredKeywords().contains(keyword) || scopedKeywords.contains(keyword)) continue;
            clients.add(this.generateKeyword(keyword, this.getGrammar().getName(), getters));
            addedKeywords.add(id);
        }
        for (String keyword : this.configuration.getLiterals()) {
            id = keyword.toLowerCase();
            if (addedKeywords.contains(id) || this.configuration.getIgnoredKeywords().contains(keyword)) continue;
            clients.add(this.generateKeyword(keyword, this.getGrammar().getName(), getters));
            addedKeywords.add(id);
        }
        return new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                for (StringConcatenationClient client : clients) {
                    it.append((Object)client);
                }
            }
        };
    }

    protected StringConcatenationClient generateMembers(Grammar grammar, Set<String> addedKeywords, Map<String, String> getters) {
        final ArrayList<StringConcatenationClient> clients = new ArrayList<StringConcatenationClient>();
        Set scopedKeywords = this.configuration.getRemoveKeywordsDefinedInScopes() ? this.configuration.getAllKeywordsDefinedInScope() : Collections.emptySet();
        for (Keyword grammarKeyword : GrammarKeywordAccessFragment2.getAllKeywords(grammar)) {
            String keyword = grammarKeyword.getValue().trim();
            if (keyword.isEmpty() || addedKeywords.contains(keyword) || this.configuration.getIgnoredKeywords().contains(keyword) || scopedKeywords.contains(keyword)) continue;
            clients.add(this.generateKeyword(grammarKeyword, grammar.getName(), getters));
            addedKeywords.add(keyword);
        }
        return new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                for (StringConcatenationClient client : clients) {
                    it.append((Object)client);
                }
            }
        };
    }

    protected static Iterable<Keyword> getAllKeywords(Grammar grammar) {
        HashMap<String, Keyword> keywords = new HashMap<String, Keyword>();
        List rules = GrammarUtil.allParserRules((Grammar)grammar);
        for (ParserRule parserRule : rules) {
            List list = EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((EObject)parserRule), Keyword.class);
            for (Keyword keyword : list) {
                keywords.put(keyword.getValue(), keyword);
            }
        }
        List enumRules = GrammarUtil.allEnumRules((Grammar)grammar);
        for (EnumRule enumRule : enumRules) {
            List list = EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((EObject)enumRule), Keyword.class);
            for (Keyword keyword : list) {
                keywords.put(keyword.getValue(), keyword);
            }
        }
        return keywords.values();
    }

    protected StringConcatenationClient generateKeyword(final String keyword, final String comment, Map<String, String> getters) {
        final String fieldName = keyword.toUpperCase().replaceAll("[^a-zA-Z0-9_]+", "_");
        final String methodName = Strings.toFirstUpper((String)keyword.replaceAll("[^a-zA-Z0-9_]+", "_")) + "Keyword";
        if (getters != null) {
            getters.put(methodName, keyword);
        }
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"\tprivate static final String ");
                it.append((Object)fieldName);
                it.append((Object)" = \"");
                it.append((Object)Strings.convertToJavaString((String)keyword));
                it.append((Object)"\";");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Keyword: {@code ");
                it.append((Object)GrammarKeywordAccessFragment2.this.protectCommentKeyword(keyword));
                it.append((Object)"}.");
                it.newLine();
                if (!Strings.isEmpty((String)comment)) {
                    it.append((Object)"\t * Source: ");
                    it.append((Object)comment);
                    it.newLine();
                }
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic String get");
                it.append((Object)methodName);
                it.append((Object)"() {");
                it.newLine();
                it.append((Object)"\t\treturn ");
                it.append((Object)fieldName);
                it.append((Object)";");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
    }

    protected StringConcatenationClient generateKeyword(final Keyword keyword, final String comment, Map<String, String> getters) {
        try {
            final String methodName = this.getIdentifier(keyword);
            final String accessor = this.grammarAccessExtensions.gaAccessor((EObject)keyword);
            if (!Strings.isEmpty((String)methodName) && !Strings.isEmpty((String)accessor)) {
                if (getters != null) {
                    getters.put(methodName, keyword.getValue());
                }
                return new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                        it.append((Object)"\t/** Keyword: {@code ");
                        it.append((Object)GrammarKeywordAccessFragment2.this.protectCommentKeyword(keyword.getValue()));
                        it.append((Object)"}.");
                        it.newLine();
                        if (!Strings.isEmpty((String)comment)) {
                            it.append((Object)"\t * Source: ");
                            it.append((Object)comment);
                            it.newLine();
                        }
                        it.append((Object)"\t */");
                        it.newLine();
                        it.append((Object)"\tpublic String get");
                        it.append((Object)methodName);
                        it.append((Object)"() {");
                        it.newLine();
                        it.append((Object)"\t\treturn this.grammarAccess.");
                        it.append((Object)accessor);
                        it.append((Object)".getValue();");
                        it.newLine();
                        it.append((Object)"\t}");
                        it.newLineIfNotEmpty();
                        it.newLine();
                    }
                };
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String getIdentifier(Keyword keyword) {
        return this.grammarAccessExtensions.gaElementIdentifier((AbstractElement)keyword).replaceFirst("[0-9_]+$", "");
    }

    protected String protectCommentKeyword(String keyword) {
        if ("*/".equals(keyword)) {
            return "* /";
        }
        if ("/*".equals(keyword)) {
            return "/ *";
        }
        if ("//".equals(keyword)) {
            return "/ /";
        }
        return keyword.replace("{", "&#123;").replace("}", "&#125;");
    }

    protected static List<Grammar> getEffectivelyUsedGrammars(Grammar grammar) {
        List allRules = GrammarUtil.allRules((Grammar)grammar);
        List map = ListExtensions.map((List)allRules, it -> GrammarUtil.getGrammar((EObject)it));
        Iterable filter = IterableExtensions.filter((Iterable)map, it -> it != grammar);
        Set set = IterableExtensions.toSet((Iterable)filter);
        return IterableExtensions.toList((Iterable)set);
    }

    protected StringConcatenationClient generateAccessors(Set<String> addedKeywords, final Map<String, String> getters) {
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                it.append((Object)"\tprivate ");
                it.append(SoftReference.class);
                it.append((Object)"<");
                it.append(Set.class);
                it.append((Object)"<String>> allKeywords;");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the SARL keywords.");
                it.newLine();
                it.append((Object)"\t * @return the SARL keywords.");
                it.newLine();
                it.append((Object)"\t * @see #getPureKeywords()");
                it.newLine();
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(Set.class);
                it.append((Object)"<String> getKeywords() {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(Set.class);
                it.append((Object)"<String> kws = this.allKeywords == null ? null : this.allKeywords.get();");
                it.newLine();
                it.append((Object)"\t\tif (kws == null) {");
                it.newLine();
                it.append((Object)"\t\t\tkws = new ");
                it.append(TreeSet.class);
                it.append((Object)"<>();");
                it.newLine();
                Pattern pattern = Pattern.compile("^[a-zA-Z_$]+$");
                for (Map.Entry getter : getters.entrySet()) {
                    if (!pattern.matcher((CharSequence)getter.getValue()).matches()) continue;
                    it.append((Object)"\t\t\tkws.add(get");
                    it.append(getter.getKey());
                    it.append((Object)"());");
                    it.newLine();
                }
                it.append((Object)"\t\t\tthis.allKeywords = new ");
                it.append(SoftReference.class);
                it.append((Object)"<>(kws);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn ");
                it.append(Collections.class);
                it.append((Object)".unmodifiableSet(kws);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies if the given string of characters is a SARL keyword.");
                it.newLine();
                it.append((Object)"\t * @param str the string of characters.");
                it.newLine();
                it.append((Object)"\t * @return {@code true} if the string of characters is a SARL keyword.");
                it.newLine();
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic boolean isKeyword(String str) {");
                it.newLine();
                it.append((Object)"\t\tassert !");
                it.append(Strings.class);
                it.append((Object)".isEmpty(str);");
                it.newLine();
                it.append((Object)"\t\treturn getKeywords().contains(str);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(SoftReference.class);
                it.append((Object)"<");
                it.append(Set.class);
                it.append((Object)"<String>> pureSarlKeywords;");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies the pure SARL keywords.");
                it.newLine();
                it.append((Object)"\t * Pure SARL keywords are SARL keywords that are not Java keywords.");
                it.newLine();
                it.append((Object)"\t * @return the pure SARL keywords.");
                it.newLine();
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic ");
                it.append(Set.class);
                it.append((Object)"<String> getPureKeywords() {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(Set.class);
                it.append((Object)"<String> kws = this.pureSarlKeywords == null ? null : this.pureSarlKeywords.get();");
                it.newLine();
                it.append((Object)"\t\tif (kws == null) {");
                it.newLine();
                it.append((Object)"\t\t\tkws = new ");
                it.append(HashSet.class);
                it.append((Object)"<>();");
                it.newLine();
                for (Map.Entry getter : getters.entrySet()) {
                    if (!pattern.matcher((CharSequence)getter.getValue()).matches() || GrammarKeywordAccessFragment2.this.javaKeywords.isJavaKeyword((String)getter.getValue())) continue;
                    it.append((Object)"\t\t\tkws.add(get");
                    it.append(getter.getKey());
                    it.append((Object)"());");
                    it.newLine();
                }
                it.append((Object)"\t\t\tthis.pureSarlKeywords = new ");
                it.append(SoftReference.class);
                it.append((Object)"<>(kws);");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn ");
                it.append(Collections.class);
                it.append((Object)".unmodifiableSet(kws);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Replies if the given string of characters is a pure SARL keyword.");
                it.newLine();
                it.append((Object)"\t * Pure SARL keywords are SARL keywords that are not Java keywords.");
                it.newLine();
                it.append((Object)"\t * @param str the string of characters.");
                it.newLine();
                it.append((Object)"\t * @return {@code true} if the string of characters is a SARL keyword.");
                it.newLine();
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic boolean isPureKeyword(String str) {");
                it.newLine();
                it.append((Object)"\t\tassert !");
                it.append(Strings.class);
                it.append((Object)".isEmpty(str);");
                it.newLine();
                it.append((Object)"\t\treturn getPureKeywords().contains(str);");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\t/** Protect the given text if it is a keyword.");
                it.newLine();
                it.append((Object)"\t * @param text the text to protect.");
                it.newLine();
                it.append((Object)"\t * @return the protected text.");
                it.newLine();
                it.append((Object)"\t */");
                it.newLine();
                it.append((Object)"\tpublic String protectKeyword(String text) {");
                it.newLine();
                it.append((Object)"\t\tif (!");
                it.append(Strings.class);
                it.append((Object)".isEmpty(text) && isKeyword(text)) {");
                it.newLine();
                it.append((Object)"\t\t\treturn \"");
                it.append((Object)Strings.convertToJavaString((String)GrammarKeywordAccessFragment2.this.configuration.getKeywordProtectionSymbol()));
                it.append((Object)"\" + text;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn text;");
                it.newLine();
                it.append((Object)"\t}");
                it.newLineIfNotEmpty();
                it.newLine();
            }
        };
    }
}

