/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.typesystem;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.mwe2.typesystem.TypeSystemToolsConfig;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class TypeSystemToolsFragment2
extends AbstractXtextGeneratorFragment {
    private static final Logger LOG = Logger.getLogger(TypeSystemToolsFragment2.class);
    @Inject
    private FileAccessFactory fileAccessFactory;
    @Inject
    private TypeSystemToolsConfig configuration;

    public TypeReference getLanguageKeywordAccessor() {
        Grammar grammar = this.getGrammar();
        return new TypeReference(this.getBasePackage() + "." + GrammarUtil.getSimpleName((Grammar)grammar).toUpperCase() + "GrammarKeywordAccess");
    }

    protected Class<?> getInjectType() {
        return this.configuration.getInjectionAPI().getInjectType();
    }

    @Pure
    public String getLanguageName() {
        return Strings.toFirstUpper((String)GrammarUtil.getSimpleName((Grammar)this.getGrammar()).toLowerCase());
    }

    @Pure
    public String getBasePackage() {
        return this.configuration.getBasePackage(this.getGrammar());
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
    }

    protected GuiceModuleAccess.BindingFactory createRuntimeBindings() {
        GuiceModuleAccess.BindingFactory factory = new GuiceModuleAccess.BindingFactory(((Object)((Object)this)).getClass().getName());
        this.bindTypeReferences(factory, this.getTypeDefaultValueProviderInterface(), this.getTypeDefaultValueProviderImpl(), this.getTypeDefaultValueProviderImplCustom());
        return factory;
    }

    protected GuiceModuleAccess.BindingFactory createEclipseBindings() {
        GuiceModuleAccess.BindingFactory factory = new GuiceModuleAccess.BindingFactory(((Object)((Object)this)).getClass().getName());
        return factory;
    }

    protected GuiceModuleAccess.BindingFactory createIdeaBindings() {
        GuiceModuleAccess.BindingFactory factory = new GuiceModuleAccess.BindingFactory(((Object)((Object)this)).getClass().getName());
        return factory;
    }

    protected GuiceModuleAccess.BindingFactory createWebBindings() {
        GuiceModuleAccess.BindingFactory factory = new GuiceModuleAccess.BindingFactory(((Object)((Object)this)).getClass().getName());
        return factory;
    }

    @Pure
    public TypeReference getTypeDefaultValueProviderInterface() {
        return this.configuration.getDefaultValueProviderInterface(this.getGrammar());
    }

    @Pure
    public TypeReference getTypeDefaultValueProviderImpl() {
        return this.configuration.getDefaultValueProviderImpl(this.getGrammar());
    }

    @Pure
    public TypeReference getTypeDefaultValueProviderImplCustom() {
        return this.configuration.getDefaultValueProviderImplCustom(this.getGrammar());
    }

    public void generate() {
        JavaFileAccess javaFile;
        LOG.info((Object)("Generating the type system tools for " + this.getLanguageName()));
        if (this.configuration.getGenerateTypeDefaultValueProviderInterface()) {
            javaFile = this.fileAccessFactory.createJavaFile(this.getTypeDefaultValueProviderInterface(), new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    TypeSystemToolsFragment2.this.generateTypeDefaultValueProvider(it, TypeSystemToolsFragment2.this.getTypeDefaultValueProviderInterface(), null);
                }
            });
            javaFile.writeTo((IFileSystemAccess2)this.getProjectConfig().getRuntime().getSrcGen());
        }
        if (this.configuration.getGenerateTypeDefaultValueProviderImpl()) {
            javaFile = this.fileAccessFactory.createJavaFile(this.getTypeDefaultValueProviderImpl(), new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation it) {
                    TypeSystemToolsFragment2.this.generateTypeDefaultValueProvider(it, TypeSystemToolsFragment2.this.getTypeDefaultValueProviderImpl(), TypeSystemToolsFragment2.this.getTypeDefaultValueProviderInterface());
                }
            });
            javaFile.writeTo((IFileSystemAccess2)this.getProjectConfig().getRuntime().getSrcGen());
        }
        this.createRuntimeBindings().contributeTo(this.getLanguage().getRuntimeGenModule());
        this.createEclipseBindings().contributeTo(this.getLanguage().getEclipsePluginGenModule());
        this.createIdeaBindings().contributeTo(this.getLanguage().getIdeGenModule());
        this.createWebBindings().contributeTo(this.getLanguage().getWebGenModule());
        Set exportedPackages = this.getProjectConfig().getRuntime().getManifest().getExportedPackages();
        if (exportedPackages != null) {
            exportedPackages.add(this.getBasePackage());
        }
    }

    protected void bindTypeReferences(GuiceModuleAccess.BindingFactory factory, TypeReference interfaceType, TypeReference implementationType, TypeReference customImplementationType) {
        IXtextGeneratorFileSystemAccess fileSystem = this.getProjectConfig().getRuntime().getSrc();
        TypeReference type = fileSystem.isFile(implementationType.getJavaPath()) || fileSystem.isFile(customImplementationType.getXtendPath()) ? customImplementationType : implementationType;
        factory.addfinalTypeToType(interfaceType, type);
    }

    protected void generateTypeDefaultValueProvider(StringConcatenationClient.TargetStringConcatenation it, TypeReference type, TypeReference implemented) {
        boolean isInterface = implemented == null;
        it.append((Object)"/** Replies the default value that is associated to a {@code JvmType}.");
        it.newLine();
        it.append((Object)" */");
        it.newLine();
        it.append((Object)"@");
        it.append(SuppressWarnings.class);
        it.append((Object)"(\"all\")");
        it.newLine();
        it.append((Object)"public ");
        if (isInterface) {
            it.append((Object)"interface");
        } else {
            it.append((Object)"class");
        }
        it.append((Object)" ");
        it.append((Object)type.getSimpleName());
        if (!isInterface) {
            it.append((Object)" implements ");
            it.append((Object)implemented);
        }
        it.append((Object)" {");
        if (!isInterface) {
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\tprivate ");
            it.append(TypeReferences.class);
            it.append((Object)" typeReferences;");
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\tprivate ");
            it.append((Object)this.getLanguageKeywordAccessor());
            it.append((Object)" keywords;");
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\t@");
            it.append(this.getInjectType());
            it.newLine();
            it.append((Object)"\tpublic void setTypeReferences(");
            it.append(TypeReferences.class);
            it.append((Object)" typeReferences) {");
            it.newLine();
            it.append((Object)"\t\tthis.typeReferences = typeReferences;");
            it.newLine();
            it.append((Object)"\t}");
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\t@");
            it.append(this.getInjectType());
            it.newLine();
            it.append((Object)"\tpublic void setKeywords(");
            it.append((Object)this.getLanguageKeywordAccessor());
            it.append((Object)" keywords) {");
            it.newLine();
            it.append((Object)"\t\tthis.keywords = keywords;");
            it.newLine();
            it.append((Object)"\t}");
        }
        if (this.configuration.getGenerateFunctionsForDefaultValueJavaObjects()) {
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\t/** Replies the default value that is associated to the given type.");
            it.newLine();
            it.append((Object)"\t * @param type the type to consider.");
            it.newLine();
            it.append((Object)"\t * @return the default value");
            it.newLine();
            it.append((Object)"\t */");
            it.newLine();
            it.append((Object)"\t@");
            it.append(Pure.class);
            it.newLine();
            it.append((Object)"\t");
            if (!isInterface) {
                it.append((Object)"public ");
            }
            it.append((Object)"Object getDefaultValue(");
            it.append(JvmType.class);
            it.append((Object)" type)");
            if (isInterface) {
                it.append((Object)";");
            } else {
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\tif (type == null) {");
                it.newLine();
                it.append((Object)"\t\t\treturn null;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn getDefaultValue(type.getQualifiedName());");
                it.newLine();
                it.append((Object)"\t};");
            }
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\t/** Replies the default value that is associated to the given type.");
            it.newLine();
            it.append((Object)"\t * @param typeName the name of the type to consider.");
            it.newLine();
            it.append((Object)"\t * @return the default value");
            it.newLine();
            it.append((Object)"\t */");
            it.newLine();
            it.append((Object)"\t@");
            it.append(Pure.class);
            it.newLine();
            it.append((Object)"\t");
            if (!isInterface) {
                it.append((Object)"public ");
            }
            it.append((Object)"Object getDefaultValue(");
            it.append(String.class);
            it.append((Object)" typeName)");
            if (isInterface) {
                it.append((Object)";");
            } else {
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(Object.class);
                it.append((Object)" defaultValue = null;");
                it.newLine();
                it.append((Object)"\t\tif (!");
                it.append(Strings.class);
                it.append((Object)".isEmpty(typeName) && !\"");
                it.append((Object)Void.TYPE.getName());
                it.append((Object)"\".equals(typeName)) {");
                it.newLine();
                it.append((Object)"\t\t\tswitch (typeName) {");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Boolean.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Boolean.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicBooleanSameAsBoolean()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicBoolean.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\tdefaultValue = ");
                it.append(Boolean.class);
                it.append((Object)".FALSE;");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Double.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Double.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicDoubleSameAsDouble()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicDouble.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                if (this.configuration.getBigDecimalSameAsDouble()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)BigDecimal.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\tdefaultValue = ");
                it.append(Double.class);
                it.append((Object)".valueOf(0.);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Float.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Float.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = ");
                it.append(Float.class);
                it.append((Object)".valueOf(0f);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Integer.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Integer.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicIntegerSameAsInt()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicInteger.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                if (this.configuration.getBigIntegerSameAsInt()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)BigInteger.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\tdefaultValue = ");
                it.append(Integer.class);
                it.append((Object)".valueOf(0);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Long.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Long.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicLongSameAsLong()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicLong.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\tdefaultValue = ");
                it.append(Long.class);
                it.append((Object)".valueOf(0);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Byte.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Byte.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = ");
                it.append(Byte.class);
                it.append((Object)".valueOf((byte) 0);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Short.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Short.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = ");
                it.append(Short.class);
                it.append((Object)".valueOf((short) 0);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Character.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Character.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = ");
                it.append(Character.class);
                it.append((Object)".valueOf((char) 0);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tdefault:");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = null;");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn defaultValue;");
                it.newLine();
                it.append((Object)"\t};");
            }
        }
        if (this.configuration.getGenerateFunctionsForDefaultValueStrings()) {
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\t/** Replies the default value in ");
            it.append((Object)this.getLanguageName());
            it.append((Object)" syntax and that is associated to the given type.");
            it.newLine();
            it.append((Object)"\t * @param type the type to consider.");
            it.newLine();
            it.append((Object)"\t * @return the default value in ");
            it.append((Object)this.getLanguageName());
            it.append((Object)" syntax");
            it.newLine();
            it.append((Object)"\t */");
            it.newLine();
            it.append((Object)"\t@");
            it.append(Pure.class);
            it.newLine();
            it.append((Object)"\t");
            if (!isInterface) {
                it.append((Object)"public ");
            }
            it.append((Object)"String getDefaultValueIn");
            it.append((Object)this.getLanguageName());
            it.append((Object)"Syntax(");
            it.append(JvmType.class);
            it.append((Object)" type)");
            if (isInterface) {
                it.append((Object)";");
            } else {
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\tif (type == null) {");
                it.newLine();
                it.append((Object)"\t\t\treturn null;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn getDefaultValueIn");
                it.append((Object)this.getLanguageName());
                it.append((Object)"Syntax(type.getQualifiedName());");
                it.newLine();
                it.append((Object)"\t}");
            }
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\t/** Replies the default value in ");
            it.append((Object)this.getLanguageName());
            it.append((Object)" syntax and that is associated to the given type.");
            it.newLine();
            it.append((Object)"\t * @param typeName the name of the type to consider.");
            it.newLine();
            it.append((Object)"\t * @return the default value in ");
            it.append((Object)this.getLanguageName());
            it.append((Object)" syntax");
            it.newLine();
            it.append((Object)"\t */");
            it.newLine();
            it.append((Object)"\t@");
            it.append(Pure.class);
            it.newLine();
            it.append((Object)"\t");
            if (!isInterface) {
                it.append((Object)"public ");
            }
            it.append((Object)"String getDefaultValueIn");
            it.append((Object)this.getLanguageName());
            it.append((Object)"Syntax(");
            it.append(String.class);
            it.append((Object)" typeName)");
            if (isInterface) {
                it.append((Object)";");
            } else {
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(String.class);
                it.append((Object)" defaultValue = \"\";");
                it.newLine();
                it.append((Object)"\t\tif (!");
                it.append(Strings.class);
                it.append((Object)".isEmpty(typeName) && !\"");
                it.append((Object)Void.TYPE.getName());
                it.append((Object)"\".equals(typeName)) {");
                it.newLine();
                it.append((Object)"\t\t\tswitch (typeName) {");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Boolean.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Boolean.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicBooleanSameAsBoolean()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicBoolean.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\tdefaultValue = \"false\";");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Double.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Double.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicDoubleSameAsDouble()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicDouble.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                if (this.configuration.getBigDecimalSameAsDouble()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)BigDecimal.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\tdefaultValue = \"0.0\";");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Float.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Float.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = \"0.0f\";");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Integer.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Integer.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Long.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Long.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicIntegerSameAsInt()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicInteger.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                if (this.configuration.getAtomicLongSameAsLong()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicLong.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                if (this.configuration.getBigIntegerSameAsInt()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)BigInteger.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\tdefaultValue = \"0\";");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Byte.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Byte.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = \"(0 \" + this.keywords.getAsKeyword() + \" ");
                it.append((Object)Byte.TYPE.getName());
                it.append((Object)")\";");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Short.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Short.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = \"(0 \" + this.keywords.getAsKeyword() + \" ");
                it.append((Object)Short.TYPE.getName());
                it.append((Object)")\";");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Character.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Character.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = \"(0 \" + this.keywords.getAsKeyword() + \" ");
                it.append((Object)Character.TYPE.getName());
                it.append((Object)")\";");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tdefault:");
                it.newLine();
                it.append((Object)"\t\t\t\tdefaultValue = \"null\";");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn defaultValue;");
                it.newLine();
                it.append((Object)"\t}");
            }
        }
        if (this.configuration.getGenerateFunctionsForDefaultValueXExpressions()) {
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\t/** Replies the XExpression for the default value that is associated to the given type.");
            it.newLine();
            it.append((Object)"\t * @param type the type to consider.");
            it.newLine();
            it.append((Object)"\t * @param notifier the context from whic a type must be loaded if needed.");
            it.newLine();
            it.append((Object)"\t * @return the XExpression for the default value");
            it.newLine();
            it.append((Object)"\t */");
            it.newLine();
            it.append((Object)"\t@");
            it.append(Pure.class);
            it.newLine();
            it.append((Object)"\t");
            if (!isInterface) {
                it.append((Object)"public ");
            }
            it.append(XExpression.class);
            it.append((Object)" getDefaultValueXExpression(");
            it.append(JvmType.class);
            it.append((Object)" type, ");
            it.append(Notifier.class);
            it.append((Object)" notifier)");
            if (isInterface) {
                it.append((Object)";");
            } else {
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\tif (type == null) {");
                it.newLine();
                it.append((Object)"\t\t\treturn null;");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn getDefaultValueXExpression(type.getQualifiedName(), notifier);");
                it.newLine();
                it.append((Object)"\t}");
            }
            it.newLineIfNotEmpty();
            it.newLine();
            it.append((Object)"\t/** Replies the XExpression for the default value that is associated to the given type.");
            it.newLine();
            it.append((Object)"\t * @param typeName the type to consider.");
            it.newLine();
            it.append((Object)"\t * @param notifier the context from whic a type must be loaded if needed.");
            it.newLine();
            it.append((Object)"\t * @return the XExpression for the default value");
            it.newLine();
            it.append((Object)"\t */");
            it.newLine();
            it.append((Object)"\t@");
            it.append(Pure.class);
            it.newLine();
            it.append((Object)"\t");
            if (!isInterface) {
                it.append((Object)"public ");
            }
            it.append(XExpression.class);
            it.append((Object)" getDefaultValueXExpression(");
            it.append(String.class);
            it.append((Object)" typeName, ");
            it.append(Notifier.class);
            it.append((Object)" notifier)");
            if (isInterface) {
                it.append((Object)";");
            } else {
                it.append((Object)" {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(XExpression.class);
                it.append((Object)" expr = null;");
                it.newLine();
                it.append((Object)"\t\tif (typeName != null && !\"");
                it.append((Object)Void.TYPE.getName());
                it.append((Object)"\".equals(typeName) && !");
                it.append(Void.class);
                it.append((Object)".class.getName().equals(typeName)) {");
                it.newLine();
                it.append((Object)"\t\t\tswitch (typeName) {");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Boolean.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Boolean.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicBooleanSameAsBoolean()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicBoolean.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\t");
                it.append(XBooleanLiteral.class);
                it.append((Object)" booleanLiteral = ");
                it.append(XbaseFactory.class);
                it.append((Object)".eINSTANCE.createXBooleanLiteral();");
                it.newLine();
                it.append((Object)"\t\t\t\tbooleanLiteral.setIsTrue(false);");
                it.newLine();
                it.append((Object)"\t\t\t\texpr = booleanLiteral;");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Float.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Float.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\t");
                it.append(XNumberLiteral.class);
                it.append((Object)" floatLiteral = ");
                it.append(XbaseFactory.class);
                it.append((Object)".eINSTANCE.createXNumberLiteral();");
                it.newLine();
                it.append((Object)"\t\t\t\tfloatLiteral.setValue(\"0.0f\");");
                it.newLine();
                it.append((Object)"\t\t\t\texpr = floatLiteral;");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Double.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Double.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicDoubleSameAsDouble()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicDouble.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                if (this.configuration.getBigDecimalSameAsDouble()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)BigDecimal.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\t");
                it.append(XNumberLiteral.class);
                it.append((Object)" doubleLiteral = ");
                it.append(XbaseFactory.class);
                it.append((Object)".eINSTANCE.createXNumberLiteral();");
                it.newLine();
                it.append((Object)"\t\t\t\tdoubleLiteral.setValue(\"0.0\");");
                it.newLine();
                it.append((Object)"\t\t\t\texpr = doubleLiteral;");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Integer.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Integer.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Long.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Long.class.getName());
                it.append((Object)"\":");
                it.newLine();
                if (this.configuration.getAtomicIntegerSameAsInt()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicInteger.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                if (this.configuration.getAtomicLongSameAsLong()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)AtomicLong.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                if (this.configuration.getBigIntegerSameAsInt()) {
                    it.append((Object)"\t\t\tcase \"");
                    it.append((Object)BigInteger.class.getName());
                    it.append((Object)"\":");
                    it.newLine();
                }
                it.append((Object)"\t\t\t\t");
                it.append(XNumberLiteral.class);
                it.append((Object)" intLiteral = ");
                it.append(XbaseFactory.class);
                it.append((Object)".eINSTANCE.createXNumberLiteral();");
                it.newLine();
                it.append((Object)"\t\t\t\tintLiteral.setValue(\"0\");");
                it.newLine();
                it.append((Object)"\t\t\t\texpr = intLiteral;");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Byte.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Byte.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\texpr = createCastExpression(\"");
                it.append((Object)Byte.TYPE.getName());
                it.append((Object)"\", notifier);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Short.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Short.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\texpr = createCastExpression(\"");
                it.append((Object)Short.TYPE.getName());
                it.append((Object)"\", notifier);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Character.TYPE.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\tcase \"");
                it.append((Object)Character.class.getName());
                it.append((Object)"\":");
                it.newLine();
                it.append((Object)"\t\t\t\texpr = createCastExpression(\"");
                it.append((Object)Character.TYPE.getName());
                it.append((Object)"\", notifier);");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\tdefault:");
                it.newLine();
                it.append((Object)"\t\t\t\texpr = ");
                it.append(XbaseFactory.class);
                it.append((Object)".eINSTANCE.createXNullLiteral();");
                it.newLine();
                it.append((Object)"\t\t\t\tbreak;");
                it.newLine();
                it.append((Object)"\t\t\t}");
                it.newLine();
                it.append((Object)"\t\t}");
                it.newLine();
                it.append((Object)"\t\treturn expr;");
                it.newLine();
                it.append((Object)"\t}");
            }
            if (!isInterface) {
                it.newLineIfNotEmpty();
                it.newLine();
                it.append((Object)"\tprivate ");
                it.append(XExpression.class);
                it.append((Object)" createCastExpression(");
                it.append(String.class);
                it.append((Object)" targetTypeName, ");
                it.append(Notifier.class);
                it.append((Object)" notifier) {");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(XNumberLiteral.class);
                it.append((Object)" cnumberLiteral = ");
                it.append(XbaseFactory.class);
                it.append((Object)".eINSTANCE.createXNumberLiteral();");
                it.newLine();
                it.append((Object)"\t\tcnumberLiteral.setValue(\"0\");");
                it.newLine();
                it.append((Object)"\t\t");
                it.append(XCastedExpression.class);
                it.append((Object)" castExpression = ");
                it.append(XbaseFactory.class);
                it.append((Object)".eINSTANCE.createXCastedExpression();");
                it.newLine();
                it.append((Object)"\t\tcastExpression.setTarget(cnumberLiteral);");
                it.newLine();
                it.append((Object)"\t\tcastExpression.setType(this.typeReferences.getTypeForName(targetTypeName, notifier));");
                it.newLine();
                it.append((Object)"\t\treturn castExpression;");
                it.newLine();
                it.append((Object)"\t}");
            }
        }
        it.newLineIfNotEmpty();
        it.newLine();
        it.append((Object)"}");
        it.newLine();
    }
}

