/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.pythongenerator.configuration;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.sarl.lang.pythongenerator.configuration.IPyGeneratorConfigurationProvider;
import io.sarl.lang.pythongenerator.configuration.PyGeneratorConfiguration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.util.internal.EmfAdaptable;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
public class PyGeneratorConfigurationProvider
implements IPyGeneratorConfigurationProvider {
    @Inject
    @Named(value="languageName")
    private String languageId;

    @Override
    public PyGeneratorConfiguration get(Resource context, boolean installedIfNew) {
        PyGeneratorConfigAdapter adapter;
        ResourceSet resourceSet = context != null ? context.getResourceSet() : null;
        if (resourceSet != null && (adapter = PyGeneratorConfigAdapter.findInEmfObject((Notifier)resourceSet)) != null && adapter.getLanguage2GeneratorConfig().containsKey(this.languageId)) {
            return adapter.getLanguage2GeneratorConfig().get(this.languageId);
        }
        PyGeneratorConfiguration config = this.createConfiguration(context);
        if (installedIfNew && resourceSet != null) {
            this.install(resourceSet, config);
        }
        return config;
    }

    protected PyGeneratorConfiguration createConfiguration(Resource context) {
        return new PyGeneratorConfiguration();
    }

    public PyGeneratorConfiguration install(ResourceSet resourceSet, PyGeneratorConfiguration config) {
        assert (config != null);
        PyGeneratorConfigAdapter adapter = PyGeneratorConfigAdapter.findInEmfObject((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new PyGeneratorConfigAdapter();
        }
        adapter.attachToEmfObject((Notifier)resourceSet);
        return adapter.getLanguage2GeneratorConfig().put(this.languageId, config);
    }

    @EmfAdaptable
    public static class PyGeneratorConfigAdapter {
        private final Map<String, PyGeneratorConfiguration> language2GeneratorConfig = new HashMap<String, PyGeneratorConfiguration>();

        public static PyGeneratorConfigAdapter findInEmfObject(Notifier emfObject) {
            if (emfObject != null) {
                for (Adapter adapter : emfObject.eAdapters()) {
                    if (!(adapter instanceof PyGeneratorConfigAdapterAdapter)) continue;
                    PyGeneratorConfigAdapterAdapter cvalue = (PyGeneratorConfigAdapterAdapter)adapter;
                    return cvalue.get();
                }
            }
            return null;
        }

        public static PyGeneratorConfigAdapter removeFromEmfObject(Notifier emfObject) {
            EList adapters = emfObject.eAdapters();
            Iterator iterator = adapters.iterator();
            while (iterator.hasNext()) {
                Adapter adapter = (Adapter)iterator.next();
                if (!(adapter instanceof PyGeneratorConfigAdapterAdapter)) continue;
                PyGeneratorConfigAdapterAdapter cvalue = (PyGeneratorConfigAdapterAdapter)adapter;
                iterator.remove();
                return cvalue.get();
            }
            return null;
        }

        public void attachToEmfObject(Notifier emfObject) {
            PyGeneratorConfigAdapter result = PyGeneratorConfigAdapter.findInEmfObject(emfObject);
            if (result != null) {
                throw new IllegalStateException();
            }
            PyGeneratorConfigAdapterAdapter adapter = new PyGeneratorConfigAdapterAdapter(this);
            emfObject.eAdapters().add((Object)adapter);
        }

        @Pure
        public Map<String, PyGeneratorConfiguration> getLanguage2GeneratorConfig() {
            return this.language2GeneratorConfig;
        }

        public static class PyGeneratorConfigAdapterAdapter
        extends AdapterImpl {
            private final PyGeneratorConfigAdapter element;

            public PyGeneratorConfigAdapterAdapter(PyGeneratorConfigAdapter element) {
                this.element = element;
            }

            public PyGeneratorConfigAdapter get() {
                return this.element;
            }

            public boolean isAdapterForType(Object object) {
                return object == PyGeneratorConfigAdapter.class;
            }
        }
    }
}

