/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.pythongenerator.generator;

import com.google.inject.Inject;
import io.sarl.lang.extralanguage.compiler.AbstractExpressionGenerator;
import io.sarl.lang.extralanguage.compiler.AbstractExtraLanguageGenerator;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageAppendable;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageConversionInitializer;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorContext;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageKeywordProvider;
import io.sarl.lang.extralanguage.compiler.IRootGenerator;
import io.sarl.lang.pythongenerator.PyGeneratorPlugin;
import io.sarl.lang.pythongenerator.generator.Messages;
import io.sarl.lang.pythongenerator.generator.PyAppendable;
import io.sarl.lang.pythongenerator.generator.PyGenerator;
import io.sarl.lang.pythongenerator.generator.PyInitializers;
import io.sarl.lang.pythongenerator.generator.PyKeywordProvider;
import io.sarl.lang.sarl.SarlAssertExpression;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlContinueExpression;
import io.sarl.lang.util.Utils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.osgi.framework.Bundle;

public class PyExpressionGenerator
extends AbstractExpressionGenerator {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private CommonTypeComputationServices typeServices;
    @Inject
    private Logger log;

    @Inject
    public PyExpressionGenerator(PyKeywordProvider keywordProvider) {
        super((IExtraLanguageKeywordProvider)keywordProvider);
    }

    protected AbstractExtraLanguageGenerator.ExtraLanguageSupportModule getSupportModule() {
        return new AbstractExtraLanguageGenerator.ExtraLanguageSupportModule(){

            public Bundle getBundle() {
                return PyGeneratorPlugin.getBundle();
            }

            public void logException(Throwable exception) {
                if (exception != null) {
                    PyExpressionGenerator.this.log.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
        };
    }

    protected IExtraLanguageConversionInitializer getTypeConverterInitializer() {
        return PyInitializers.getTypeConverterInitializer(this.getSupportModule());
    }

    protected IExtraLanguageConversionInitializer getFeatureNameConverterInitializer() {
        return PyInitializers.getFeatureNameConverterInitializer(this.getSupportModule());
    }

    private static void appendReturnIfExpectedReturnedExpression(IAppendable it, IExtraLanguageGeneratorContext context) {
        if (context.getExpectedExpressionType() != null) {
            it.append((CharSequence)"return ");
        }
    }

    protected void before(XExpression expression, IAppendable output, IExtraLanguageGeneratorContext context) {
        if (!(expression instanceof XClosure) && !(expression instanceof AnonymousClass)) {
            for (XClosure closure : EcoreUtil2.getAllContentsOfType((EObject)expression, XClosure.class)) {
                this.generateClosureDefinition(closure, output, context);
            }
            for (AnonymousClass anonClass : EcoreUtil2.getAllContentsOfType((EObject)expression, AnonymousClass.class)) {
                this.generateAnonymousClassDefinition(anonClass, output, context);
            }
        }
    }

    protected void generateClosureDefinition(XClosure closure, IAppendable it, IExtraLanguageGeneratorContext context) {
        if (!it.hasName((Object)closure)) {
            FunctionTypeReference fctRef;
            LightweightTypeReference closureType0;
            LightweightTypeReference closureType = closureType0 = this.getExpectedType((XExpression)closure);
            if (closureType0.isFunctionType() && (fctRef = closureType0.tryConvertToFunctionTypeReference(true)) != null) {
                closureType = Utils.toLightweightTypeReference((JvmType)fctRef.getType(), (CommonTypeComputationServices)this.typeServices).getRawTypeReference();
            }
            String closureName = it.declareSyntheticVariable((Object)closure, "__Jclosure_" + closureType.getSimpleName());
            JvmDeclaredType rawType = (JvmDeclaredType)closureType.getType();
            JvmOperation function = (JvmOperation)rawType.getDeclaredOperations().iterator().next();
            JvmTypeReference objType = this.getTypeReferences().getTypeForName(Object.class, (Notifier)closure, new JvmTypeReference[0]);
            it.openPseudoScope();
            it.append((CharSequence)"class ").append((CharSequence)closureName).append((CharSequence)"(").append(closureType).append((CharSequence)",").append(objType.getType()).append((CharSequence)"):").increaseIndentation().newLine().append((CharSequence)"def ").append((CharSequence)function.getSimpleName()).append((CharSequence)"(").append((CharSequence)this.getExtraLanguageKeywordProvider().getThisKeywordLambda().apply());
            for (JvmFormalParameter param : closure.getFormalParameters()) {
                it.append((CharSequence)", ");
                String name = it.declareUniqueNameVariable((Object)param, param.getName());
                it.append((CharSequence)name);
            }
            it.append((CharSequence)"):");
            it.increaseIndentation().newLine();
            if (closure.getExpression() != null) {
                FunctionTypeReference fctRef2;
                Object returnType = closureType0;
                returnType = returnType.isFunctionType() ? ((fctRef2 = returnType.tryConvertToFunctionTypeReference(true)) != null ? fctRef2.getReturnType() : null) : null;
                this.generate(closure.getExpression(), (LightweightTypeReference)returnType, it, context);
            } else {
                it.append((CharSequence)"pass");
            }
            it.decreaseIndentation().decreaseIndentation().newLine();
            it.closeScope();
        }
    }

    protected void generateAnonymousClassDefinition(AnonymousClass anonClass, IAppendable it, IExtraLanguageGeneratorContext context) {
        if (!it.hasName((Object)anonClass) && it instanceof PyAppendable) {
            LightweightTypeReference jvmAnonType = this.getExpectedType((XExpression)anonClass);
            String anonName = it.declareSyntheticVariable((Object)anonClass, jvmAnonType.getSimpleName());
            QualifiedName anonQualifiedName = QualifiedName.create((String[])jvmAnonType.getType().getQualifiedName().split(Pattern.quote(".")));
            if ((anonQualifiedName = anonQualifiedName.skipLast(1)).isEmpty()) {
                assert (anonClass.getDeclaringType() == null) : "The Xtend API has changed the AnonymousClass definition!";
                XtendTypeDeclaration container = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)anonClass.eContainer(), XtendTypeDeclaration.class);
                anonQualifiedName = anonQualifiedName.append(this.qualifiedNameProvider.getFullyQualifiedName((EObject)container));
            }
            anonQualifiedName = anonQualifiedName.append(anonName);
            it.openPseudoScope();
            IRootGenerator rootGenerator = context.getRootGenerator();
            assert (rootGenerator instanceof PyGenerator);
            ArrayList<JvmTypeReference> types = new ArrayList<JvmTypeReference>();
            for (JvmTypeReference superType : anonClass.getConstructorCall().getConstructor().getDeclaringType().getSuperTypes()) {
                if (Object.class.getCanonicalName().equals(superType.getIdentifier())) continue;
                types.add(superType);
            }
            ((PyGenerator)rootGenerator).generateTypeDeclaration(anonQualifiedName.toString(), anonName, false, types, this.getTypeBuilder().getDocumentation((EObject)anonClass), false, (List<? extends XtendMember>)anonClass.getMembers(), (PyAppendable)it, context, null);
            it.closeScope();
        }
    }

    protected XExpression _generate(AnonymousClass anonClass, IAppendable it, IExtraLanguageGeneratorContext context) {
        if (it.hasName((Object)anonClass)) {
            PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
            it.append((CharSequence)it.getName((Object)anonClass)).append((CharSequence)"(");
            boolean firstArg = true;
            for (XExpression arg : anonClass.getConstructorCall().getArguments()) {
                if (firstArg) {
                    firstArg = false;
                } else {
                    it.append((CharSequence)", ");
                }
                this.generate(arg, it, context);
            }
            it.append((CharSequence)")");
        }
        return anonClass;
    }

    protected XExpression _generate(XClosure closure, IAppendable it, IExtraLanguageGeneratorContext context) {
        if (it.hasName((Object)closure)) {
            PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
            it.append((CharSequence)it.getName((Object)closure)).append((CharSequence)"()");
        }
        return closure;
    }

    protected XExpression _generate(XBlockExpression block, IAppendable it, IExtraLanguageGeneratorContext context) {
        XBlockExpression last = block;
        if (block.getExpressions().isEmpty()) {
            it.append((CharSequence)"pass");
        } else {
            it.openScope();
            if (context.getExpectedExpressionType() == null) {
                boolean first = true;
                for (XExpression expression : block.getExpressions()) {
                    if (first) {
                        first = false;
                    } else {
                        it.newLine();
                    }
                    last = this.generate(expression, it, context);
                }
            } else {
                EList exprs = block.getExpressions();
                if (!exprs.isEmpty()) {
                    for (int i = 0; i < exprs.size() - 1; ++i) {
                        if (i > 0) {
                            it.newLine();
                        }
                        last = this.generate((XExpression)exprs.get(i), it, context);
                    }
                    last = this.generate((XExpression)exprs.get(exprs.size() - 1), context.getExpectedExpressionType(), it, context);
                }
            }
            it.closeScope();
        }
        return last;
    }

    protected XExpression _generate(XNumberLiteral literal, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append((CharSequence)literal.getValue());
        return literal;
    }

    protected XExpression _generate(XStringLiteral literal, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append((CharSequence)"u\"").append((CharSequence)Strings.convertToJavaString((String)literal.getValue())).append((CharSequence)"\"");
        return literal;
    }

    protected XExpression _generate(SarlBreakExpression breakStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        if (context.getExpectedExpressionType() == null) {
            it.append((CharSequence)"break");
        } else {
            it.append((CharSequence)"return ").append((CharSequence)PyExpressionGenerator.toDefaultValue(context.getExpectedExpressionType().toJavaCompliantTypeReference()));
        }
        return breakStatement;
    }

    protected XExpression _generate(SarlContinueExpression continueStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        if (context.getExpectedExpressionType() == null) {
            it.append((CharSequence)"continue");
        } else {
            it.append((CharSequence)"return ").append((CharSequence)PyExpressionGenerator.toDefaultValue(context.getExpectedExpressionType().toJavaCompliantTypeReference()));
        }
        return continueStatement;
    }

    protected XExpression _generate(SarlAssertExpression assertStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        boolean haveAssert;
        boolean bl = haveAssert = !assertStatement.isIsStatic() && assertStatement.getCondition() != null;
        if (haveAssert) {
            it.append((CharSequence)"assert (lambda:");
            it.increaseIndentation().newLine();
            this.generate(assertStatement.getCondition(), it, context);
            it.decreaseIndentation().newLine();
            it.append((CharSequence)")()");
        }
        if (context.getExpectedExpressionType() != null) {
            if (haveAssert) {
                it.newLine();
            }
            it.append((CharSequence)"return ").append((CharSequence)PyExpressionGenerator.toDefaultValue(context.getExpectedExpressionType().toJavaCompliantTypeReference()));
        }
        return assertStatement;
    }

    protected XExpression _generate(XAssignment assignment, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append((CharSequence)"(");
        this.newFeatureCallGenerator(context, it).generate((XAbstractFeatureCall)assignment);
        it.append((CharSequence)" = ");
        this.generate(assignment.getValue(), it, context);
        it.append((CharSequence)")");
        return assignment;
    }

    protected XExpression _generate(XBinaryOperation operation, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        String operator = this.getOperatorSymbol((XAbstractFeatureCall)operation);
        if (operator != null) {
            it.append((CharSequence)"(");
            this.generate(operation.getLeftOperand(), it, context);
            switch (operator) {
                case "-": 
                case "+": 
                case "*": 
                case "/": 
                case "%": 
                case "-=": 
                case "+=": 
                case "*=": 
                case "/=": 
                case "%=": 
                case "<": 
                case ">": 
                case "<=": 
                case ">=": 
                case "==": 
                case "!=": 
                case "<<": 
                case ">>": {
                    it.append((CharSequence)" ").append((CharSequence)operator).append((CharSequence)" ");
                    break;
                }
                case "&&": {
                    it.append((CharSequence)" and ");
                    break;
                }
                case "||": {
                    it.append((CharSequence)" or ");
                    break;
                }
                case "===": {
                    it.append((CharSequence)" is ");
                    break;
                }
                case "!==": {
                    it.append((CharSequence)" is not ");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.PyExpressionGenerator_0, operator));
                }
            }
            this.generate(operation.getRightOperand(), it, context);
            it.append((CharSequence)")");
        }
        return operation;
    }

    protected XExpression _generate(XFeatureCall call, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        this.newFeatureCallGenerator(context, it).generate((XAbstractFeatureCall)call);
        return call;
    }

    protected XExpression _generate(XMemberFeatureCall call, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        this.newFeatureCallGenerator(context, it).generate((XAbstractFeatureCall)call);
        return call;
    }

    protected XExpression _generate(XPostfixOperation operation, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        String operator = this.getOperatorSymbol((XAbstractFeatureCall)operation);
        if (operator != null) {
            it.append((CharSequence)"(");
            switch (operator) {
                case "++": {
                    this.generate(operation.getOperand(), it, context);
                    it.append((CharSequence)" += 1");
                    break;
                }
                case "--": {
                    this.generate(operation.getOperand(), it, context);
                    it.append((CharSequence)" -= 1");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.PyExpressionGenerator_0, operator));
                }
            }
            it.append((CharSequence)")");
        }
        return operation;
    }

    protected XExpression _generate(XUnaryOperation operation, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        String operator = this.getOperatorSymbol((XAbstractFeatureCall)operation);
        if (operator != null) {
            it.append((CharSequence)"(");
            switch (operator) {
                case "+": {
                    this.generate(operation.getOperand(), it, context);
                    break;
                }
                case "-": {
                    it.append((CharSequence)"-");
                    this.generate(operation.getOperand(), it, context);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.PyExpressionGenerator_0, operator));
                }
            }
            it.append((CharSequence)")");
        }
        return operation;
    }

    protected XExpression _generate(XConstructorCall call, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        this.newFeatureCallGenerator(context, it).generate(call);
        return call;
    }

    protected XExpression _generate(XWhileExpression whileLoop, IAppendable it, IExtraLanguageGeneratorContext context) {
        it.append((CharSequence)"while ");
        this.generate(whileLoop.getPredicate(), it, context);
        it.append((CharSequence)":");
        it.increaseIndentation().newLine();
        XExpression last = this.generate(whileLoop.getBody(), it, context);
        it.decreaseIndentation();
        return last;
    }

    protected XExpression _generate(XDoWhileExpression whileLoop, IAppendable it, IExtraLanguageGeneratorContext context) {
        this.generate(whileLoop.getBody(), it, context);
        it.newLine();
        it.append((CharSequence)"while ");
        this.generate(whileLoop.getPredicate(), it, context);
        it.append((CharSequence)":");
        it.increaseIndentation().newLine();
        XExpression last = this.generate(whileLoop.getBody(), it, context);
        it.decreaseIndentation();
        return last;
    }

    protected XExpression _generate(XForLoopExpression forLoop, IAppendable it, IExtraLanguageGeneratorContext context) {
        it.append((CharSequence)"for ");
        String varName = it.declareUniqueNameVariable((Object)forLoop.getDeclaredParam(), forLoop.getDeclaredParam().getSimpleName());
        it.append((CharSequence)varName);
        it.append((CharSequence)" in ");
        this.generate(forLoop.getForExpression(), it, context);
        it.append((CharSequence)":");
        it.increaseIndentation().newLine();
        XExpression last = this.generate(forLoop.getEachExpression(), it, context);
        it.decreaseIndentation();
        return last;
    }

    protected XExpression _generate(XBasicForLoopExpression forLoop, IAppendable it, IExtraLanguageGeneratorContext context) {
        for (XExpression expr : forLoop.getInitExpressions()) {
            this.generate(expr, it, context);
            it.newLine();
        }
        it.append((CharSequence)"while ");
        this.generate(forLoop.getExpression(), it, context);
        it.append((CharSequence)":");
        it.increaseIndentation().newLine();
        XExpression last = this.generate(forLoop.getEachExpression(), it, context);
        for (XExpression expr : forLoop.getUpdateExpressions()) {
            it.newLine();
            this.generate(expr, it, context);
        }
        it.decreaseIndentation();
        return last;
    }

    protected XExpression _generate(XBooleanLiteral literal, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append((CharSequence)(literal.isIsTrue() ? "True" : "False"));
        return literal;
    }

    protected XExpression _generate(XCastedExpression castOperator, IAppendable it, IExtraLanguageGeneratorContext context) {
        return this.generate(castOperator.getTarget(), context.getExpectedExpressionType(), it, context);
    }

    protected XExpression _generate(XListLiteral literal, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append((CharSequence)"[");
        boolean first = true;
        for (XExpression value : literal.getElements()) {
            if (first) {
                first = false;
            } else {
                it.append((CharSequence)", ");
            }
            this.generate(value, it, context);
        }
        it.append((CharSequence)"]");
        return literal;
    }

    protected XExpression _generate(XSetLiteral literal, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append((CharSequence)"{");
        boolean first = true;
        for (XExpression value : literal.getElements()) {
            if (first) {
                first = false;
            } else {
                it.append((CharSequence)", ");
            }
            this.generate(value, it, context);
        }
        it.append((CharSequence)"}");
        return literal;
    }

    protected XExpression _generate(XIfExpression ifStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        it.append((CharSequence)"if ");
        this.generate(ifStatement.getIf(), it, context);
        it.append((CharSequence)":");
        it.increaseIndentation().newLine();
        if (ifStatement.getThen() != null) {
            this.generate(ifStatement.getThen(), context.getExpectedExpressionType(), it, context);
        } else if (context.getExpectedExpressionType() == null) {
            it.append((CharSequence)"pass");
        } else {
            it.append((CharSequence)"return ").append((CharSequence)PyExpressionGenerator.toDefaultValue(context.getExpectedExpressionType().toJavaCompliantTypeReference()));
        }
        it.decreaseIndentation();
        if (ifStatement.getElse() != null) {
            it.newLine().append((CharSequence)"else:");
            it.increaseIndentation().newLine();
            this.generate(ifStatement.getElse(), context.getExpectedExpressionType(), it, context);
            it.decreaseIndentation();
        } else if (context.getExpectedExpressionType() != null) {
            it.newLine().append((CharSequence)"else:");
            it.increaseIndentation().newLine();
            it.append((CharSequence)"return ").append((CharSequence)PyExpressionGenerator.toDefaultValue(context.getExpectedExpressionType().toJavaCompliantTypeReference()));
            it.decreaseIndentation();
        }
        return ifStatement;
    }

    protected XExpression _generate(XInstanceOfExpression operator, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append((CharSequence)"isinstance(");
        this.generate(operator.getExpression(), it, context);
        it.append((CharSequence)", ");
        it.append(operator.getType().getType());
        it.append((CharSequence)")");
        return operator;
    }

    protected XExpression _generate(XNullLiteral literal, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append((CharSequence)"None");
        return literal;
    }

    protected XExpression _generate(XReturnExpression returnStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        it.append((CharSequence)"return ");
        this.generate(returnStatement.getExpression(), it, context);
        return returnStatement;
    }

    protected XExpression _generate(XSwitchExpression switchStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        String varName = switchStatement.getDeclaredParam() != null ? it.declareUniqueNameVariable((Object)switchStatement.getDeclaredParam(), switchStatement.getDeclaredParam().getSimpleName()) : it.declareSyntheticVariable((Object)switchStatement, "___expression");
        it.openPseudoScope();
        it.append((CharSequence)varName).append((CharSequence)" = ");
        this.generate(switchStatement.getSwitch(), it, context);
        it.newLine();
        boolean first = true;
        boolean fallThrough = false;
        for (XCasePart caseExpression : switchStatement.getCases()) {
            if (fallThrough) {
                it.append((CharSequence)") or (");
            } else if (first) {
                it.append((CharSequence)"if (");
                first = false;
            } else {
                it.append((CharSequence)"elif (");
            }
            if (caseExpression.getTypeGuard() != null) {
                it.append((CharSequence)"isinstance(").append((CharSequence)varName);
                it.append((CharSequence)", ").append(caseExpression.getTypeGuard().getType());
                it.append((CharSequence)")");
                if (caseExpression.getCase() != null) {
                    it.append((CharSequence)" and (");
                    this.generate(caseExpression.getCase(), it, context);
                    it.append((CharSequence)")");
                    convertedType = this.getExpectedType(caseExpression.getCase());
                    if (!convertedType.isType(Boolean.TYPE) && !convertedType.isType(Boolean.class)) {
                        it.append((CharSequence)" == ").append((CharSequence)varName);
                    }
                }
            } else if (caseExpression.getCase() != null) {
                it.append((CharSequence)"(");
                this.generate(caseExpression.getCase(), it, context);
                it.append((CharSequence)")");
                convertedType = this.getExpectedType(caseExpression.getCase());
                if (!convertedType.isType(Boolean.TYPE) && !convertedType.isType(Boolean.class)) {
                    it.append((CharSequence)" == ").append((CharSequence)varName);
                }
            }
            if (fallThrough = caseExpression.isFallThrough()) continue;
            it.append((CharSequence)"):");
            it.increaseIndentation().newLine();
            if (caseExpression.getThen() != null) {
                this.generate(caseExpression.getThen(), it, context);
            } else {
                it.append((CharSequence)"pass");
            }
            it.decreaseIndentation().newLine();
        }
        if (switchStatement.getDefault() != null) {
            if (first) {
                this.generate(switchStatement.getDefault(), it, context);
                it.newLine();
            } else {
                it.append((CharSequence)"else:");
                it.increaseIndentation().newLine();
                this.generate(switchStatement.getDefault(), it, context);
                it.decreaseIndentation().newLine();
            }
        }
        it.closeScope();
        return switchStatement;
    }

    protected XExpression _generate(XSynchronizedExpression synchronizedStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        return this.generate(synchronizedStatement.getExpression(), context.getExpectedExpressionType(), it, context);
    }

    protected XExpression _generate(XThrowExpression throwStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        it.append((CharSequence)"raise ");
        this.generate(throwStatement.getExpression(), it, context);
        return throwStatement;
    }

    protected XExpression _generate(XTryCatchFinallyExpression tryStatement, IAppendable it, IExtraLanguageGeneratorContext context) {
        it.append((CharSequence)"try:");
        it.increaseIndentation().newLine();
        this.generate(tryStatement.getExpression(), context.getExpectedExpressionType(), it, context);
        it.decreaseIndentation().newLine();
        for (XCatchClause clause : tryStatement.getCatchClauses()) {
            it.append((CharSequence)"except ");
            it.append(clause.getDeclaredParam().getParameterType().getType());
            it.append((CharSequence)", ");
            it.append((CharSequence)it.declareUniqueNameVariable((Object)clause.getDeclaredParam(), clause.getDeclaredParam().getSimpleName()));
            it.append((CharSequence)":");
            it.increaseIndentation().newLine();
            this.generate(clause.getExpression(), context.getExpectedExpressionType(), it, context);
            it.decreaseIndentation().newLine();
        }
        if (tryStatement.getFinallyExpression() != null) {
            it.append((CharSequence)"finally:");
            it.increaseIndentation().newLine();
            this.generate(tryStatement.getFinallyExpression(), it, context);
            it.decreaseIndentation();
        }
        return tryStatement;
    }

    protected XExpression _generate(XTypeLiteral literal, IAppendable it, IExtraLanguageGeneratorContext context) {
        PyExpressionGenerator.appendReturnIfExpectedReturnedExpression(it, context);
        it.append(literal.getType());
        return literal;
    }

    protected XExpression _generate(XVariableDeclaration varDeclaration, IAppendable it, IExtraLanguageGeneratorContext context) {
        String name = it.declareUniqueNameVariable((Object)varDeclaration, varDeclaration.getName());
        it.append((CharSequence)name);
        it.append((CharSequence)" = ");
        if (varDeclaration.getRight() != null) {
            this.generate(varDeclaration.getRight(), it, context);
        } else if (varDeclaration.getType() != null) {
            it.append((CharSequence)PyExpressionGenerator.toDefaultValue(varDeclaration.getType()));
        } else {
            it.append((CharSequence)"None");
        }
        if (context.getExpectedExpressionType() != null) {
            it.newLine();
            it.append((CharSequence)"return ").append((CharSequence)name);
        }
        return varDeclaration;
    }

    public static String toDefaultValue(JvmTypeReference type) {
        String id = type.getIdentifier();
        if (!"void".equals(id)) {
            if (Strings.equal((String)Boolean.class.getName(), (String)id) || Strings.equal((String)Boolean.TYPE.getName(), (String)id)) {
                return "False";
            }
            if (Strings.equal((String)Float.class.getName(), (String)id) || Strings.equal((String)Float.TYPE.getName(), (String)id) || Strings.equal((String)Double.class.getName(), (String)id) || Strings.equal((String)Double.TYPE.getName(), (String)id)) {
                return "0.0";
            }
            if (Strings.equal((String)Integer.class.getName(), (String)id) || Strings.equal((String)Integer.TYPE.getName(), (String)id) || Strings.equal((String)Long.class.getName(), (String)id) || Strings.equal((String)Long.TYPE.getName(), (String)id) || Strings.equal((String)Byte.class.getName(), (String)id) || Strings.equal((String)Byte.TYPE.getName(), (String)id) || Strings.equal((String)Short.class.getName(), (String)id) || Strings.equal((String)Short.TYPE.getName(), (String)id)) {
                return "0";
            }
            if (Strings.equal((String)Character.class.getName(), (String)id) || Strings.equal((String)Character.TYPE.getName(), (String)id)) {
                return "\"\\0\"";
            }
        }
        return "None";
    }

    protected PyFeatureCallGenerator newFeatureCallGenerator(IExtraLanguageGeneratorContext context, IAppendable it) {
        return new PyFeatureCallGenerator(context, (ExtraLanguageAppendable)it);
    }

    public class PyFeatureCallGenerator
    extends AbstractExpressionGenerator.FeatureCallGenerator {
        protected PyFeatureCallGenerator(IExtraLanguageGeneratorContext context, ExtraLanguageAppendable codeReceiver) {
            super((AbstractExpressionGenerator)PyExpressionGenerator.this, context, codeReceiver);
        }

        private void appendCallPrefix(Collection<?> elements, String postfix) {
            if (elements != null && !elements.isEmpty()) {
                boolean first = true;
                for (Object element : elements) {
                    if (first) {
                        first = false;
                    } else {
                        this.codeReceiver.append((CharSequence)".");
                    }
                    if (element instanceof XExpression) {
                        XExpression cvalue = (XExpression)element;
                        PyExpressionGenerator.this.generate(cvalue, (IAppendable)this.codeReceiver, this.context);
                        continue;
                    }
                    if (element instanceof JvmType) {
                        JvmType cvalue = (JvmType)element;
                        this.codeReceiver.append(cvalue);
                        continue;
                    }
                    if (element instanceof LightweightTypeReference) {
                        LightweightTypeReference cvalue = (LightweightTypeReference)element;
                        this.codeReceiver.append(cvalue);
                        continue;
                    }
                    this.codeReceiver.append((CharSequence)element.toString());
                }
                this.codeReceiver.append((CharSequence)postfix);
            }
        }

        protected void appendCall(JvmIdentifiableElement calledFeature, List<Object> leftOperand, List<Object> receiver, String name, List<XExpression> args, Functions.Function0<? extends XExpression> beginOfBlock) {
            if (beginOfBlock != null) {
                this.codeReceiver.append((CharSequence)"if ");
                PyExpressionGenerator.this.generate((XExpression)beginOfBlock.apply(), (IAppendable)this.codeReceiver, this.context);
                this.codeReceiver.append((CharSequence)" != None:");
                this.codeReceiver.increaseIndentation().newLine();
            }
            this.appendCallPrefix(leftOperand, " = ");
            this.appendCallPrefix(receiver, ".");
            if (args != null) {
                this.codeReceiver.append((CharSequence)name);
                this.codeReceiver.append((CharSequence)"(");
                boolean first = true;
                for (XExpression arg : args) {
                    if (first) {
                        first = false;
                    } else {
                        this.codeReceiver.append((CharSequence)", ");
                    }
                    PyExpressionGenerator.this.generate(arg, (IAppendable)this.codeReceiver, this.context);
                }
                this.codeReceiver.append((CharSequence)")");
            } else {
                this.codeReceiver.append((CharSequence)name);
            }
            if (beginOfBlock != null) {
                this.codeReceiver.decreaseIndentation().newLine();
            }
        }
    }
}

