/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.pythongenerator.generator;

import com.google.inject.Inject;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import io.sarl.lang.extralanguage.compiler.AbstractExtraLanguageGenerator;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageAppendable;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageTypeConverter;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorContext;
import io.sarl.lang.pythongenerator.configuration.IPyGeneratorConfigurationProvider;
import io.sarl.lang.pythongenerator.configuration.PyGeneratorConfiguration;
import io.sarl.lang.pythongenerator.configuration.PyOutputConfigurationProvider;
import io.sarl.lang.pythongenerator.generator.PyAppendable;
import io.sarl.lang.pythongenerator.generator.PyExpressionGenerator;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlAnnotationType;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlConstructor;
import io.sarl.lang.sarl.SarlEnumeration;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.SarlFormalParameter;
import io.sarl.lang.sarl.SarlInterface;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.InferredValuedParameter;
import io.sarl.lang.sarl.actionprototype.QualifiedActionName;
import io.sarl.lang.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class PyGenerator
extends AbstractExtraLanguageGenerator {
    public static final String PYTHON_FILE_HEADER = "#!/usr/bin/env python3";
    private static final String PYTHON_FILENAME_EXTENSION = ".py";
    private static final String LIBRARY_CONTENT = "__all__ = []";
    private static final String LIBRARY_FILENAME = "__init__";
    private static final String INSTANCE_VARIABLES_MEMENTO = "INSTANCE_VARIABLES";
    private static final String EVENT_GUARDS_MEMENTO = "EVENT_GUARDS";
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    private PyExpressionGenerator expressionGenerator;
    private IPyGeneratorConfigurationProvider configuration;
    private Map<JvmOperation, String> useCapacityMapping = new HashMap<JvmOperation, String>();

    @Inject
    public void setPyGeneratorConfigurationProvider(IPyGeneratorConfigurationProvider provider) {
        this.configuration = provider;
    }

    @Inject
    public void setExpressionGenerator(PyExpressionGenerator generator) {
        this.expressionGenerator = generator;
    }

    public PyExpressionGenerator getExpressionGenerator() {
        return this.expressionGenerator;
    }

    protected void initializeContext(IExtraLanguageGeneratorContext generatorContext) {
        PyGeneratorConfiguration config = this.configuration.get(generatorContext.getResource(), true);
        ExtraLanguageTypeConverter converter = this.getExpressionGenerator().getTypeConverter(generatorContext);
        converter.setImplicitJvmTypes(config.isImplicitJvmTypes());
    }

    protected PyAppendable createAppendable(JvmDeclaredType thisType, IExtraLanguageGeneratorContext context) {
        ExtraLanguageTypeConverter converter = this.getTypeConverter(context);
        PyAppendable appendable = new PyAppendable(thisType, converter);
        this.markCapacityFunctions(appendable);
        return appendable;
    }

    protected String getOutputConfigurationName() {
        return PyOutputConfigurationProvider.OUTPUT_CONFIGURATION_NAME;
    }

    protected String getFilenameExtension() {
        return PYTHON_FILENAME_EXTENSION;
    }

    protected String getPreferenceID() {
        return "io.sarl.lang.pythongenerator";
    }

    protected boolean writeFile(QualifiedName name, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
        if (super.writeFile(name, appendable, context)) {
            this.writePackageFiles(name, appendable.getLineSeparator(), context);
            return true;
        }
        return false;
    }

    protected void writePackageFiles(QualifiedName name, String lineSeparator, IExtraLanguageGeneratorContext context) {
        IFileSystemAccess2 fsa = context.getFileSystemAccess();
        String outputConfiguration = this.getOutputConfigurationName();
        QualifiedName libraryName = null;
        for (String segment : name.skipLast(1).getSegments()) {
            String fileName = this.toFilename(libraryName = libraryName == null ? QualifiedName.create((String[])new String[]{segment, LIBRARY_FILENAME}) : libraryName.append(segment).append(LIBRARY_FILENAME));
            if (!fsa.isFile(fileName)) {
                String content = PYTHON_FILE_HEADER + lineSeparator + this.getGenerationComment(context) + lineSeparator + LIBRARY_CONTENT;
                if (Strings.isEmpty((String)outputConfiguration)) {
                    fsa.generateFile(fileName, (CharSequence)content);
                } else {
                    fsa.generateFile(fileName, outputConfiguration, (CharSequence)content);
                }
            }
            libraryName = libraryName.skipLast(1);
        }
    }

    protected String getGenerationComment(IExtraLanguageGeneratorContext context) {
        return "# Generated by the SARL compiler the " + context.getGenerationDate().toString() + ". Do not change this file.";
    }

    protected boolean generatePythonClassDeclaration(String typeName, boolean isAbstract, List<? extends JvmTypeReference> superTypes, String comment, boolean ignoreObjectType, PyAppendable it, IExtraLanguageGeneratorContext context) {
        if (!Strings.isEmpty((String)typeName)) {
            it.append("class ").append((CharSequence)typeName).append((CharSequence)"(");
            boolean isOtherSuperType = false;
            boolean first = true;
            for (JvmTypeReference jvmTypeReference : superTypes) {
                if (ignoreObjectType && Strings.equal((String)jvmTypeReference.getQualifiedName(), (String)Object.class.getCanonicalName())) continue;
                isOtherSuperType = true;
                if (first) {
                    first = false;
                } else {
                    it.append(",");
                }
                it.append(jvmTypeReference.getType());
            }
            if (isOtherSuperType) {
                it.append(",");
            }
            it.append("object):");
            it.increaseIndentation().newLine();
            PyGenerator.generateDocString(comment, it);
            return true;
        }
        return false;
    }

    protected static boolean generateDocString(String comment, PyAppendable it) {
        String cmt;
        String string = cmt = comment == null ? null : comment.trim();
        if (!Strings.isEmpty((String)cmt)) {
            assert (cmt != null);
            it.append("\"\"\"").increaseIndentation();
            for (String line : cmt.split("[\n\r\f]+")) {
                it.newLine().append((CharSequence)line);
            }
            it.decreaseIndentation().newLine();
            it.append("\"\"\"").newLine();
            return true;
        }
        return false;
    }

    protected static boolean generateBlockComment(String comment, PyAppendable it) {
        String cmt;
        String string = cmt = comment == null ? null : comment.trim();
        if (!Strings.isEmpty((String)cmt)) {
            assert (cmt != null);
            for (String line : cmt.split("[\n\r\f]+")) {
                it.append("# ").append((CharSequence)line).newLine();
            }
            return true;
        }
        return false;
    }

    protected boolean generateTypeDeclaration(String fullyQualifiedName, String name, boolean isAbstract, List<? extends JvmTypeReference> superTypes, String comment, boolean ignoreObjectType, List<? extends XtendMember> members, PyAppendable it, IExtraLanguageGeneratorContext context, Procedures.Procedure2<? super PyAppendable, ? super IExtraLanguageGeneratorContext> memberGenerator) {
        if (!Strings.isEmpty((String)name)) {
            if (!this.generatePythonClassDeclaration(name, isAbstract, superTypes, comment, ignoreObjectType, it, context) || context.getCancelIndicator().isCanceled()) {
                return false;
            }
            it.openScope();
            if (!this.generateSarlMembers(members, it, context) || context.getCancelIndicator().isCanceled()) {
                return false;
            }
            if (memberGenerator != null) {
                memberGenerator.apply((Object)it, (Object)context);
            }
            if (!this.generatePythonConstructors(fullyQualifiedName, members, it, context) || context.getCancelIndicator().isCanceled()) {
                return false;
            }
            it.decreaseIndentation().newLine().newLine();
            it.closeScope();
            return !context.getCancelIndicator().isCanceled();
        }
        return false;
    }

    protected boolean generateEnumerationDeclaration(SarlEnumeration enumeration, PyAppendable it, IExtraLanguageGeneratorContext context) {
        if (!Strings.isEmpty((String)enumeration.getName())) {
            it.append("class ").append((CharSequence)enumeration.getName());
            it.append("(Enum");
            it.append(this.newType("enum.Enum"));
            it.append("):");
            it.increaseIndentation().newLine();
            PyGenerator.generateDocString(this.getTypeBuilder().getDocumentation((EObject)enumeration), it);
            int i = 0;
            for (XtendMember item : enumeration.getMembers()) {
                if (context.getCancelIndicator().isCanceled()) {
                    return false;
                }
                if (!(item instanceof XtendEnumLiteral)) continue;
                XtendEnumLiteral literal = (XtendEnumLiteral)item;
                it.append(literal.getName()).append((CharSequence)" = ");
                it.append(Integer.toString(i));
                it.newLine();
                ++i;
            }
            it.decreaseIndentation().newLine().newLine();
            return true;
        }
        return false;
    }

    protected boolean generatePythonConstructors(String container, List<? extends XtendMember> members, PyAppendable it, IExtraLanguageGeneratorContext context) {
        boolean hasConstructor = false;
        for (XtendMember xtendMember : members) {
            if (context.getCancelIndicator().isCanceled()) {
                return false;
            }
            if (!(xtendMember instanceof SarlConstructor)) continue;
            hasConstructor = true;
            this.generate((EObject)xtendMember, it, context);
            it.newLine();
        }
        if (context.getCancelIndicator().isCanceled()) {
            return false;
        }
        if (!hasConstructor) {
            it.append("def __init__(self):");
            it.increaseIndentation().newLine();
            List fields = context.getMultimapValues(INSTANCE_VARIABLES_MEMENTO, (Object)container);
            if (fields.isEmpty()) {
                it.append("pass");
            } else {
                for (SarlField field : fields) {
                    this.generatePythonField(field, it, context);
                }
            }
            it.decreaseIndentation().newLine();
        }
        return true;
    }

    protected JvmType newType(String pythonName) {
        JvmGenericType type = TypesFactory.eINSTANCE.createJvmGenericType();
        int index = pythonName.indexOf(".");
        if (index <= 0) {
            type.setSimpleName(pythonName);
        } else {
            type.setPackageName(pythonName.substring(0, index - 1));
            type.setSimpleName(pythonName.substring(index + 1));
        }
        return type;
    }

    protected void generatePythonField(SarlField field, PyAppendable it, IExtraLanguageGeneratorContext context) {
        PyGenerator.generateBlockComment(this.getTypeBuilder().getDocumentation((EObject)field), it);
        if (!field.isStatic()) {
            it.append("self.");
        }
        String fieldName = it.declareUniqueNameVariable(field, field.getName());
        it.append(fieldName);
        it.append(" = ");
        if (field.getInitialValue() != null) {
            this.generate(field.getInitialValue(), null, it, context);
        } else {
            it.append(PyExpressionGenerator.toDefaultValue(field.getType()));
        }
        it.newLine();
    }

    protected void generateExecutable(String name, XtendExecutable executable, boolean appendSelf, boolean isAbstract, JvmTypeReference returnType, String comment, PyAppendable it, IExtraLanguageGeneratorContext context) {
        it.append("def ").append((CharSequence)name);
        it.append("(");
        boolean firstParam = true;
        if (appendSelf) {
            firstParam = false;
            it.append((CharSequence)this.getExpressionGenerator().getExtraLanguageKeywordProvider().getThisKeywordLambda().apply());
        }
        for (XtendParameter parameter : executable.getParameters()) {
            if (firstParam) {
                firstParam = false;
            } else {
                it.append(", ");
            }
            if (parameter.isVarArg()) {
                it.append("*");
            }
            String pname = it.declareUniqueNameVariable(parameter, parameter.getName());
            it.append(pname).append((CharSequence)" : ").append(parameter.getParameterType().getType());
        }
        LightweightTypeReference actualReturnType = this.getExpectedType(executable, returnType);
        it.append(")");
        if (actualReturnType != null) {
            it.append(" -> ").append(actualReturnType);
        }
        it.append(":");
        it.increaseIndentation().newLine();
        PyGenerator.generateDocString(comment, it);
        if (executable.getExpression() != null) {
            it.openScope();
            this.generate(executable.getExpression(), actualReturnType, it, context);
            it.closeScope();
        } else if (isAbstract) {
            it.append("raise Exception(\"Unimplemented function\")");
        } else {
            it.append("pass");
        }
        it.decreaseIndentation().newLine();
        IActionPrototypeProvider prototypeProvider = this.getActionPrototypeProvider();
        QualifiedActionName actionName = prototypeProvider.createQualifiedActionName((JvmIdentifiableElement)this.getJvmModelAssociations().getPrimaryJvmElement((EObject)executable.getDeclaringType()), name);
        InferredPrototype inferredPrototype = this.getActionPrototypeProvider().createPrototypeFromSarlModel(context.getActionPrototypeContext(this.getActionPrototypeProvider()), actionName, Utils.isVarArg((List)executable.getParameters()), (List)executable.getParameters());
        for (Map.Entry types : inferredPrototype.getInferredParameterTypes().entrySet()) {
            List argumentsToOriginal = (List)types.getValue();
            it.append("def ").append((CharSequence)name);
            it.append("(self");
            for (InferredStandardParameter parameter : argumentsToOriginal) {
                if (parameter instanceof InferredValuedParameter) continue;
                it.append(", ");
                if (((XtendParameter)parameter.getParameter()).isVarArg()) {
                    it.append("*");
                }
                it.append(parameter.getName()).append((CharSequence)" : ").append(parameter.getType().getType());
            }
            it.append(")");
            if (actualReturnType != null) {
                it.append(" -> ").append(actualReturnType);
            }
            it.append(":");
            it.increaseIndentation().newLine();
            if (actualReturnType != null) {
                it.append("return ");
            }
            it.append("self.").append((CharSequence)name).append((CharSequence)"(");
            boolean first = true;
            for (InferredStandardParameter parameter : argumentsToOriginal) {
                if (first) {
                    first = false;
                } else {
                    it.append(", ");
                }
                if (parameter instanceof InferredValuedParameter) {
                    InferredValuedParameter valuedParameter = (InferredValuedParameter)parameter;
                    this.generate(((SarlFormalParameter)valuedParameter.getParameter()).getDefaultValue(), null, it, context);
                    continue;
                }
                it.append(parameter.getName());
            }
            it.append(")");
            it.decreaseIndentation().newLine();
        }
    }

    protected void generateGuardEvaluators(String container, PyAppendable it, IExtraLanguageGeneratorContext context) {
        Map allGuardEvaluators = context.getMapData(EVENT_GUARDS_MEMENTO);
        Map guardEvaluators = (Map)allGuardEvaluators.get(container);
        if (guardEvaluators == null) {
            return;
        }
        boolean first = true;
        for (Map.Entry entry : guardEvaluators.entrySet()) {
            if (first) {
                first = false;
            } else {
                it.newLine();
            }
            it.append("def __guard_");
            it.append(((String)entry.getKey()).replaceAll("[^a-zA-Z0-9_]+", "_"));
            it.append("__(self, occurrence):");
            it.increaseIndentation().newLine();
            it.append("it = occurrence").newLine();
            String eventHandleName = it.declareUniqueNameVariable(new Object(), "__event_handles");
            it.append(eventHandleName).append((CharSequence)" = list");
            for (Pair guardDesc : (List)entry.getValue()) {
                it.newLine();
                if (guardDesc.getKey() == null) {
                    it.append(eventHandleName).append((CharSequence)".add(").append((CharSequence)guardDesc.getValue()).append((CharSequence)")");
                    continue;
                }
                it.append("if ");
                this.generate((XExpression)guardDesc.getKey(), null, it, context);
                it.append(":").increaseIndentation().newLine();
                it.append(eventHandleName).append((CharSequence)".add(").append((CharSequence)guardDesc.getValue()).append((CharSequence)")");
                it.decreaseIndentation();
            }
            it.newLine().append((CharSequence)"return ").append((CharSequence)eventHandleName);
            it.decreaseIndentation().newLine();
        }
    }

    protected void generateFileHeader(QualifiedName qualifiedName, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
        appendable.append((CharSequence)PYTHON_FILE_HEADER);
        appendable.newLine();
        appendable.append((CharSequence)this.getGenerationComment(context));
        appendable.newLine().newLine();
    }

    protected void generateImportStatement(QualifiedName qualifiedName, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
        String typeName = qualifiedName.getLastSegment();
        QualifiedName packageName = qualifiedName.skipLast(1);
        appendable.append((CharSequence)"from ");
        appendable.append((CharSequence)packageName.toString());
        appendable.append((CharSequence)" import ");
        appendable.append((CharSequence)typeName);
        appendable.newLine();
    }

    protected void _generate(SarlClass clazz, IExtraLanguageGeneratorContext context) {
        JvmGenericType jvmType = this.getJvmModelAssociations().getInferredType((XtendClass)clazz);
        PyAppendable appendable = this.createAppendable((JvmDeclaredType)jvmType, context);
        if (this.generateTypeDeclaration(this.qualifiedNameProvider.getFullyQualifiedName((EObject)clazz).toString(), clazz.getName(), clazz.isAbstract(), PyGenerator.getSuperTypes((JvmTypeReference)clazz.getExtends(), (List)clazz.getImplements()), this.getTypeBuilder().getDocumentation((EObject)clazz), true, (List<? extends XtendMember>)clazz.getMembers(), appendable, context, null)) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)clazz);
            this.writeFile(name, appendable, context);
        }
    }

    protected void _generate(SarlInterface interf, IExtraLanguageGeneratorContext context) {
        JvmGenericType jvmType = this.getJvmModelAssociations().getInferredType((XtendInterface)interf);
        PyAppendable appendable = this.createAppendable((JvmDeclaredType)jvmType, context);
        if (this.generateTypeDeclaration(this.qualifiedNameProvider.getFullyQualifiedName((EObject)interf).toString(), interf.getName(), true, (List<? extends JvmTypeReference>)interf.getExtends(), this.getTypeBuilder().getDocumentation((EObject)interf), true, (List<? extends XtendMember>)interf.getMembers(), appendable, context, null)) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)interf);
            this.writeFile(name, appendable, context);
        }
    }

    protected void _generate(SarlEnumeration enumeration, IExtraLanguageGeneratorContext context) {
        JvmDeclaredType jvmType = this.getJvmModelAssociations().getInferredType((XtendTypeDeclaration)enumeration);
        PyAppendable appendable = this.createAppendable(jvmType, context);
        if (this.generateEnumerationDeclaration(enumeration, appendable, context)) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)enumeration);
            this.writeFile(name, appendable, context);
        }
    }

    protected void _generate(SarlAnnotationType annotation, IExtraLanguageGeneratorContext context) {
        JvmDeclaredType jvmType = this.getJvmModelAssociations().getInferredType((XtendTypeDeclaration)annotation);
        PyAppendable appendable = this.createAppendable(jvmType, context);
        if (this.generateTypeDeclaration(this.qualifiedNameProvider.getFullyQualifiedName((EObject)annotation).toString(), annotation.getName(), false, Collections.emptyList(), this.getTypeBuilder().getDocumentation((EObject)annotation), true, (List<? extends XtendMember>)annotation.getMembers(), appendable, context, null)) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)annotation);
            this.writeFile(name, appendable, context);
        }
    }

    protected void _generate(SarlEvent event, IExtraLanguageGeneratorContext context) {
        JvmGenericType jvmType = this.getJvmModelAssociations().getInferredType(event);
        PyAppendable appendable = this.createAppendable((JvmDeclaredType)jvmType, context);
        List<Object> superTypes = event.getExtends() != null ? Collections.singletonList(event.getExtends()) : Collections.singletonList(this.getTypeReferences().getTypeForName(Event.class, (Notifier)event, new JvmTypeReference[0]));
        if (this.generateTypeDeclaration(this.qualifiedNameProvider.getFullyQualifiedName((EObject)event).toString(), event.getName(), event.isAbstract(), superTypes, this.getTypeBuilder().getDocumentation((EObject)event), true, (List<? extends XtendMember>)event.getMembers(), appendable, context, null)) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)event);
            this.writeFile(name, appendable, context);
        }
    }

    protected void var(SarlAgent agent, IExtraLanguageGeneratorContext context) {
        JvmGenericType jvmType = this.getJvmModelAssociations().getInferredType(agent);
        PyAppendable appendable = this.createAppendable((JvmDeclaredType)jvmType, context);
        List<Object> superTypes = agent.getExtends() != null ? Collections.singletonList(agent.getExtends()) : Collections.singletonList(this.getTypeReferences().getTypeForName(Agent.class, (Notifier)agent, new JvmTypeReference[0]));
        String qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)agent).toString();
        if (this.generateTypeDeclaration(qualifiedName, agent.getName(), agent.isAbstract(), superTypes, this.getTypeBuilder().getDocumentation((EObject)agent), true, (List<? extends XtendMember>)agent.getMembers(), appendable, context, (Procedures.Procedure2<? super PyAppendable, ? super IExtraLanguageGeneratorContext>)((Procedures.Procedure2)(it, context2) -> this.generateGuardEvaluators(qualifiedName, (PyAppendable)((Object)it), (IExtraLanguageGeneratorContext)context2)))) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)agent);
            this.writeFile(name, appendable, context);
        }
    }

    protected void _generate(SarlBehavior behavior, IExtraLanguageGeneratorContext context) {
        JvmGenericType jvmType = this.getJvmModelAssociations().getInferredType(behavior);
        PyAppendable appendable = this.createAppendable((JvmDeclaredType)jvmType, context);
        List<Object> superTypes = behavior.getExtends() != null ? Collections.singletonList(behavior.getExtends()) : Collections.singletonList(this.getTypeReferences().getTypeForName(Behavior.class, (Notifier)behavior, new JvmTypeReference[0]));
        String qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)behavior).toString();
        if (this.generateTypeDeclaration(qualifiedName, behavior.getName(), behavior.isAbstract(), superTypes, this.getTypeBuilder().getDocumentation((EObject)behavior), true, (List<? extends XtendMember>)behavior.getMembers(), appendable, context, (Procedures.Procedure2<? super PyAppendable, ? super IExtraLanguageGeneratorContext>)((Procedures.Procedure2)(it, context2) -> this.generateGuardEvaluators(qualifiedName, (PyAppendable)((Object)it), (IExtraLanguageGeneratorContext)context2)))) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)behavior);
            this.writeFile(name, appendable, context);
        }
    }

    protected void _generate(SarlCapacity capacity, IExtraLanguageGeneratorContext context) {
        JvmGenericType jvmType = this.getJvmModelAssociations().getInferredType(capacity);
        PyAppendable appendable = this.createAppendable((JvmDeclaredType)jvmType, context);
        Object superTypes = !capacity.getExtends().isEmpty() ? capacity.getExtends() : Collections.singletonList(this.getTypeReferences().getTypeForName(Capacity.class, (Notifier)capacity, new JvmTypeReference[0]));
        if (this.generateTypeDeclaration(this.qualifiedNameProvider.getFullyQualifiedName((EObject)capacity).toString(), capacity.getName(), true, (List<? extends JvmTypeReference>)superTypes, this.getTypeBuilder().getDocumentation((EObject)capacity), true, (List<? extends XtendMember>)capacity.getMembers(), appendable, context, null)) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)capacity);
            this.writeFile(name, appendable, context);
        }
    }

    protected void _generate(SarlSkill skill, IExtraLanguageGeneratorContext context) {
        String qualifiedName;
        JvmGenericType jvmType = this.getJvmModelAssociations().getInferredType(skill);
        PyAppendable appendable = this.createAppendable((JvmDeclaredType)jvmType, context);
        List<JvmTypeReference> superTypes = PyGenerator.getSuperTypes((JvmTypeReference)skill.getExtends(), (List)skill.getImplements());
        if (superTypes.isEmpty()) {
            superTypes = Collections.singletonList(this.getTypeReferences().getTypeForName(Skill.class, (Notifier)skill, new JvmTypeReference[0]));
        }
        if (this.generateTypeDeclaration(qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)skill).toString(), skill.getName(), skill.isAbstract(), superTypes, this.getTypeBuilder().getDocumentation((EObject)skill), true, (List<? extends XtendMember>)skill.getMembers(), appendable, context, (Procedures.Procedure2<? super PyAppendable, ? super IExtraLanguageGeneratorContext>)((Procedures.Procedure2)(it, context2) -> this.generateGuardEvaluators(qualifiedName, (PyAppendable)((Object)it), (IExtraLanguageGeneratorContext)context2)))) {
            QualifiedName name = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)skill);
            this.writeFile(name, appendable, context);
        }
    }

    protected void _generate(SarlClass clazz, PyAppendable it, IExtraLanguageGeneratorContext context) {
        this.generateTypeDeclaration(this.qualifiedNameProvider.getFullyQualifiedName((EObject)clazz).toString(), clazz.getName(), clazz.isAbstract(), PyGenerator.getSuperTypes((JvmTypeReference)clazz.getExtends(), (List)clazz.getImplements()), this.getTypeBuilder().getDocumentation((EObject)clazz), true, (List<? extends XtendMember>)clazz.getMembers(), it, context, null);
    }

    protected void _generate(SarlInterface interf, PyAppendable it, IExtraLanguageGeneratorContext context) {
        this.generateTypeDeclaration(this.qualifiedNameProvider.getFullyQualifiedName((EObject)interf).toString(), interf.getName(), true, (List<? extends JvmTypeReference>)interf.getExtends(), this.getTypeBuilder().getDocumentation((EObject)interf), true, (List<? extends XtendMember>)interf.getMembers(), it, context, null);
    }

    protected void _generate(SarlEnumeration enumeration, PyAppendable it, IExtraLanguageGeneratorContext context) {
        this.generateEnumerationDeclaration(enumeration, it, context);
    }

    protected void _generate(SarlAnnotationType annotation, PyAppendable it, IExtraLanguageGeneratorContext context) {
        this.generateTypeDeclaration(this.qualifiedNameProvider.getFullyQualifiedName((EObject)annotation).toString(), annotation.getName(), false, Collections.emptyList(), this.getTypeBuilder().getDocumentation((EObject)annotation), true, (List<? extends XtendMember>)annotation.getMembers(), it, context, null);
    }

    protected void _generate(SarlField field, PyAppendable it, IExtraLanguageGeneratorContext context) {
        if (field.isStatic()) {
            this.generatePythonField(field, it, context);
        } else {
            String key = this.qualifiedNameProvider.getFullyQualifiedName((EObject)field.getDeclaringType()).toString();
            List fields = context.getMultimapValues(INSTANCE_VARIABLES_MEMENTO, (Object)key);
            fields.add(field);
        }
    }

    protected void _generate(SarlAction action, PyAppendable it, IExtraLanguageGeneratorContext context) {
        String feature = this.getFeatureNameConverter(context).convertDeclarationName(action.getName(), action);
        this.generateExecutable(feature, (XtendExecutable)action, !action.isStatic(), action.isAbstract(), action.getReturnType(), this.getTypeBuilder().getDocumentation((EObject)action), it, context);
    }

    protected void _generate(SarlConstructor constructor, PyAppendable it, IExtraLanguageGeneratorContext context) {
        if (constructor.isStatic()) {
            this.generateExecutable("___static_init___", (XtendExecutable)constructor, false, false, null, this.getTypeBuilder().getDocumentation((EObject)constructor), it, context);
            it.newLine().append((CharSequence)"___static_init___()");
        } else {
            this.generateExecutable(LIBRARY_FILENAME, (XtendExecutable)constructor, true, false, null, this.getTypeBuilder().getDocumentation((EObject)constructor), it, context);
        }
    }

    protected void _generate(SarlBehaviorUnit handler, PyAppendable it, IExtraLanguageGeneratorContext context) {
        String eventId;
        ArrayList<Pair> guards;
        JvmParameterizedTypeReference event = handler.getName();
        String handleName = it.declareUniqueNameVariable(handler, "__on_" + event.getSimpleName() + "__");
        it.append("def ").append((CharSequence)handleName).append((CharSequence)"(self, occurrence):");
        it.increaseIndentation().newLine();
        PyGenerator.generateDocString(this.getTypeBuilder().getDocumentation((EObject)handler), it);
        if (handler.getExpression() != null) {
            this.generate(handler.getExpression(), null, it, context);
        } else {
            it.append("pass");
        }
        it.decreaseIndentation().newLine();
        String key = this.qualifiedNameProvider.getFullyQualifiedName((EObject)handler.getDeclaringType()).toString();
        Map map = context.getMapData(EVENT_GUARDS_MEMENTO);
        HashMap<String, ArrayList<Pair>> submap = (HashMap<String, ArrayList<Pair>>)map.get(key);
        if (submap == null) {
            submap = new HashMap<String, ArrayList<Pair>>();
            map.put(key, submap);
        }
        if ((guards = (ArrayList<Pair>)submap.get(eventId = event.getIdentifier())) == null) {
            guards = new ArrayList<Pair>();
            submap.put(eventId, guards);
        }
        guards.add(new Pair((Object)handler.getGuard(), (Object)handleName));
    }

    protected void _generate(SarlCapacityUses uses, PyAppendable it, IExtraLanguageGeneratorContext context) {
    }

    protected void _before(SarlCapacityUses uses, IExtraLanguageGeneratorContext context) {
        for (JvmParameterizedTypeReference capacity : uses.getCapacities()) {
            JvmType type = capacity.getType();
            if (!(type instanceof JvmDeclaredType)) continue;
            JvmDeclaredType cvalue = (JvmDeclaredType)type;
            this.computeCapacityFunctionMarkers(cvalue);
        }
    }

    private void computeCapacityFunctionMarkers(JvmDeclaredType leafType) {
        HashMap<JvmOperation, String> mapping = new HashMap<JvmOperation, String>();
        LinkedList<JvmDeclaredType> buffer = new LinkedList<JvmDeclaredType>();
        TreeSet<String> processed = new TreeSet<String>();
        buffer.addLast(leafType);
        while (!buffer.isEmpty()) {
            JvmDeclaredType type = (JvmDeclaredType)buffer.removeFirst();
            boolean markOne = false;
            for (JvmOperation operation : type.getDeclaredOperations()) {
                if (mapping.containsKey(operation)) continue;
                markOne = true;
                mapping.put(operation, "getSkill(" + type.getSimpleName() + ")." + operation.getSimpleName());
            }
            if (!markOne) continue;
            for (JvmTypeReference superTypeReference : type.getExtendedInterfaces()) {
                JvmType jvmType;
                if (!processed.add(superTypeReference.getIdentifier()) || !((jvmType = superTypeReference.getType()) instanceof JvmDeclaredType)) continue;
                JvmDeclaredType cvalue = (JvmDeclaredType)jvmType;
                buffer.addLast(cvalue);
            }
        }
        this.useCapacityMapping = mapping;
    }

    private void markCapacityFunctions(PyAppendable it) {
        Map<JvmOperation, String> mapping = this.useCapacityMapping;
        this.useCapacityMapping = new HashMap<JvmOperation, String>();
        ImportManager imports = it.getImportManager();
        for (Map.Entry<JvmOperation, String> entry : mapping.entrySet()) {
            JvmOperation operation = entry.getKey();
            JvmDeclaredType type = operation.getDeclaringType();
            imports.addImportFor((JvmType)type);
            it.declareVariable(operation, entry.getValue());
        }
    }
}

