/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.pythongenerator.generator;

import io.sarl.lang.extralanguage.compiler.AbstractExtraLanguageGenerator;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageConversionInitializer;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.xbase.lib.Pair;

public final class PyInitializers {
    private static final String FEATURE_NAME_PATTERN = "^.*\\.([a-zA-Z_$*]+)(?:\\(.*?\\))?$";
    private static final Pattern FEATURE_NAME_PAT = Pattern.compile("^.*\\.([a-zA-Z_$*]+)(?:\\(.*?\\))?$");
    private static final String TYPE_NAME_PATTERN = "^.*[.$]([^.$]+)$";
    private static final Pattern TYPE_NAME_PAT = Pattern.compile("^.*[.$]([^.$]+)$");
    private static final String TYPE_CONVERSION_FILENAME = "conversions/type_conversion.properties";
    private static final String FEATURE_CONVERSION_FILENAME = "conversions/feature_name_conversion.properties";

    private PyInitializers() {
    }

    private static List<Pair<String, String>> loadPropertyFile(String filename, AbstractExtraLanguageGenerator.ExtraLanguageSupportModule supportModule) {
        return AbstractExtraLanguageGenerator.loadPropertyFile((String)filename, (AbstractExtraLanguageGenerator.ExtraLanguageSupportModule)supportModule, PyInitializers.class);
    }

    public static IExtraLanguageConversionInitializer getTypeConverterInitializer(AbstractExtraLanguageGenerator.ExtraLanguageSupportModule supportModule) {
        return it -> {
            List<Pair<String, String>> properties = PyInitializers.loadPropertyFile(TYPE_CONVERSION_FILENAME, supportModule);
            if (!properties.isEmpty()) {
                for (Pair<String, String> entry : properties) {
                    String source = Objects.toString(entry.getKey());
                    String target = Objects.toString(entry.getValue());
                    Matcher matcher = TYPE_NAME_PAT.matcher(source);
                    String baseName = matcher.find() ? matcher.group(1) : source;
                    it.apply((Object)baseName, (Object)source, (Object)target);
                }
            }
        };
    }

    public static IExtraLanguageConversionInitializer getFeatureNameConverterInitializer(AbstractExtraLanguageGenerator.ExtraLanguageSupportModule supportModule) {
        return it -> {
            List<Pair<String, String>> properties = PyInitializers.loadPropertyFile(FEATURE_CONVERSION_FILENAME, supportModule);
            if (!properties.isEmpty()) {
                for (Pair<String, String> entry : properties) {
                    String source = Objects.toString(entry.getKey());
                    String target = Objects.toString(entry.getValue());
                    Matcher matcher = FEATURE_NAME_PAT.matcher(source);
                    String featureName = matcher.find() ? matcher.group(1) : source;
                    it.apply((Object)featureName, (Object)source, (Object)target);
                }
            }
        };
    }
}

