/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.pythongenerator.validator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.extralanguage.compiler.AbstractExtraLanguageGenerator;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageTypeConverter;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageConversionInitializer;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageKeywordProvider;
import io.sarl.lang.extralanguage.validator.AbstractExtraLanguageValidator;
import io.sarl.lang.pythongenerator.PyGeneratorPlugin;
import io.sarl.lang.pythongenerator.configuration.IPyGeneratorConfigurationProvider;
import io.sarl.lang.pythongenerator.configuration.PyGeneratorConfiguration;
import io.sarl.lang.pythongenerator.generator.PyInitializers;
import io.sarl.lang.pythongenerator.generator.PyKeywordProvider;
import io.sarl.lang.pythongenerator.validator.Messages;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;
import org.osgi.framework.Bundle;

@Singleton
public class PyValidator
extends AbstractExtraLanguageValidator {
    private final Procedures.Procedure3<? super EObject, ? super JvmType, ? super String> typeErrorHandler1 = (source, invalidType, name) -> this.error(MessageFormat.format(Messages.PyValidator_0, name), (EObject)source, (EStructuralFeature)XtypePackage.eINSTANCE.getXImportDeclaration_ImportedType());
    private final Procedures.Procedure3<? super EObject, ? super JvmType, ? super String> typeErrorHandler2 = (source, invalidType, name) -> this.error(MessageFormat.format(Messages.PyValidator_0, name), (EObject)source, (EStructuralFeature)XbasePackage.eINSTANCE.getXAbstractFeatureCall_Feature());
    private final Functions.Function2<? super EObject, ? super JvmIdentifiableElement, ? extends Boolean> featureErrorHandler = (source, element) -> {
        String message;
        if (element instanceof JvmConstructor) {
            message = MessageFormat.format(Messages.PyValidator_1, this.simpleNameProvider.getSimpleName(element));
        } else if (element instanceof JvmField) {
            message = MessageFormat.format(Messages.PyValidator_2, this.simpleNameProvider.getSimpleName(element));
        } else if (element instanceof JvmOperation) {
            message = MessageFormat.format(Messages.PyValidator_3, this.simpleNameProvider.getSimpleName(element));
        } else {
            return Boolean.FALSE;
        }
        this.error(message, (EObject)source, (EStructuralFeature)XbasePackage.eINSTANCE.getXAbstractFeatureCall_Feature());
        return Boolean.TRUE;
    };
    @Inject
    private IdentifiableSimpleNameProvider simpleNameProvider;
    @Inject
    private Logger log;
    private IPyGeneratorConfigurationProvider configuration;

    @Inject
    public PyValidator(PyKeywordProvider keywordProvider) {
        super((IExtraLanguageKeywordProvider)keywordProvider);
    }

    protected AbstractExtraLanguageGenerator.ExtraLanguageSupportModule getSupportModule() {
        return new AbstractExtraLanguageGenerator.ExtraLanguageSupportModule(){

            public Bundle getBundle() {
                return PyGeneratorPlugin.getBundle();
            }

            public void logException(Throwable exception) {
                if (exception != null) {
                    PyValidator.this.log.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
        };
    }

    @Inject
    public void setPyGeneratorConfigurationProvider(IPyGeneratorConfigurationProvider provider) {
        this.configuration = provider;
    }

    protected void initializeContext(AbstractExtraLanguageValidator.Context validatorContext) {
        Resource resource = validatorContext.getCurrentObject().eResource();
        PyGeneratorConfiguration config = this.configuration.get(resource, true);
        ExtraLanguageTypeConverter converter = this.getTypeConverter();
        converter.setImplicitJvmTypes(config.isImplicitJvmTypes());
    }

    protected IExtraLanguageConversionInitializer getTypeConverterInitializer() {
        return PyInitializers.getTypeConverterInitializer(this.getSupportModule());
    }

    protected IExtraLanguageConversionInitializer getFeatureConverterInitializer() {
        return PyInitializers.getFeatureNameConverterInitializer(this.getSupportModule());
    }

    protected String getErrorMessageFormat() {
        return Messages.PyValidator_4;
    }

    @Check
    public void checkImportsMapping(XImportDeclaration importDeclaration) {
        JvmDeclaredType type = importDeclaration.getImportedType();
        this.doTypeMappingCheck((EObject)importDeclaration, (JvmType)type, this.typeErrorHandler1);
    }

    @Check
    public void checkMemberFeatureCallMapping(XMemberFeatureCall featureCall) {
        this.doCheckMemberFeatureCallMapping((XAbstractFeatureCall)featureCall, this.typeErrorHandler2, this.featureErrorHandler);
    }

    @Check
    public void checkMemberFeatureCallMapping(XFeatureCall featureCall) {
        this.doCheckMemberFeatureCallMapping((XAbstractFeatureCall)featureCall, this.typeErrorHandler2, this.featureErrorHandler);
    }
}

