/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.abstractmojos;

import com.google.common.base.Strings;
import io.sarl.lang.compiler.batch.OptimizationLevel;
import io.sarl.lang.core.SREBootstrap;
import io.sarl.lang.maven.compiler.abstractmojos.AbstractSarlBatchCompilerMojo;
import io.sarl.lang.maven.compiler.abstractmojos.Messages;
import io.sarl.lang.maven.compiler.compiler.JavaCompiler;
import io.sarl.lang.maven.compiler.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.arakhne.afc.vmutil.FileSystem;

public abstract class AbstractCompileMojo
extends AbstractSarlBatchCompilerMojo {
    private static final String STUB_FOLDER = "sarl-temp";
    private static final String METAINF_FOLDER_NAME = "META-INF";
    private static final String METAINF_SERVICE_FOLDER_NAME = "services";
    private static final String JAR_SEPARATOR = "/";
    @Parameter(defaultValue="21", required=false)
    private String source;
    @Parameter(required=false)
    private String encoding;
    @Parameter
    private File tempDirectory;
    @Parameter(required=false)
    private String javaCompiler;
    private JavaCompiler javaCompilerInstance;
    @Parameter(defaultValue="false", required=false)
    private boolean generateInlines;
    @Parameter(defaultValue="true", required=false)
    private boolean generatePures;
    @Parameter(defaultValue="true", required=false)
    private boolean generateTraceFiles;
    @Parameter(defaultValue="true", required=false)
    private boolean generateStorageFiles;
    @Parameter(defaultValue="true", required=false)
    private boolean generateEqualityTestFunctions;
    @Parameter(defaultValue="true", required=false)
    private boolean generateToStringFunctions;
    @Parameter(defaultValue="true", required=false)
    private boolean generateCloneFunctions;
    @Parameter(defaultValue="true", required=false)
    private boolean generateSerialNumberFields;
    @Parameter(defaultValue="false", required=false)
    private boolean tycho;
    @Parameter(required=false)
    private String[] extraGenerators;
    @Parameter(required=false)
    private String optimization;
    private OptimizationLevel optimizationInstance;
    @Parameter(defaultValue="false")
    private boolean fixClasspathJdtJse;
    @Parameter(defaultValue="true")
    private boolean verifySREInDependencies;
    @Parameter(defaultValue="false")
    private boolean failWhenMissedSRE;

    @Override
    protected boolean isTychoEnvironment() {
        return this.tycho;
    }

    @Override
    protected boolean isFixingJavaClasspathForJre() {
        return this.fixClasspathJdtJse;
    }

    @Override
    protected List<File> buildClassPath() throws MojoExecutionException {
        if (this.isFixingJavaClasspathForJre()) {
            return this.fixJreClassPathFiles(super.buildClassPath(), Messages.AbstractCompileMojo_3);
        }
        return super.buildClassPath();
    }

    @Override
    protected List<File> buildTestClassPath() throws MojoExecutionException {
        if (this.isFixingJavaClasspathForJre()) {
            return this.fixJreClassPathFiles(super.buildTestClassPath(), Messages.AbstractCompileMojo_4);
        }
        return super.buildTestClassPath();
    }

    @Override
    protected String[] getExtraGenerators() {
        if (this.extraGenerators == null) {
            this.extraGenerators = new String[0];
        }
        return this.extraGenerators;
    }

    @Override
    protected String getSourceVersion() {
        return this.source;
    }

    @Override
    protected String getEncoding() {
        return this.encoding == null || this.encoding.isEmpty() ? Charset.defaultCharset().displayName() : this.encoding;
    }

    @Override
    protected File getTempDirectory() {
        if (this.tempDirectory == null) {
            File targetDir = new File(this.getProject().getBuild().getDirectory());
            return this.makeAbsolute(new File(targetDir, STUB_FOLDER));
        }
        return this.makeAbsolute(this.tempDirectory);
    }

    @Override
    protected JavaCompiler getJavaCompiler() {
        if (this.javaCompilerInstance == null) {
            if (!Strings.isNullOrEmpty((String)this.javaCompiler)) {
                this.javaCompilerInstance = JavaCompiler.valueOfCaseInsensitive(this.javaCompiler);
                if (this.javaCompilerInstance == null) {
                    String values = null;
                    for (JavaCompiler comp : JavaCompiler.values()) {
                        values = values == null ? comp.getNameInMavenConfiguration() : MessageFormat.format(Messages.AbstractCompileMojo_1, values, comp.getNameInMavenConfiguration());
                    }
                    this.getLogger().warn(MessageFormat.format(Messages.AbstractCompileMojo_0, this.javaCompiler, values, JavaCompiler.getDefault().getNameInMavenConfiguration()));
                }
            }
            if (this.javaCompilerInstance == null) {
                this.javaCompilerInstance = JavaCompiler.getDefault();
            }
        }
        return this.javaCompilerInstance;
    }

    @Override
    protected OptimizationLevel getOptimization() {
        if (this.optimizationInstance == null) {
            if (!Strings.isNullOrEmpty((String)this.optimization)) {
                this.optimizationInstance = OptimizationLevel.valueOfCaseInsensitive((String)this.optimization);
                if (this.optimizationInstance == null) {
                    String values = null;
                    for (OptimizationLevel lvl : OptimizationLevel.values()) {
                        values = values == null ? lvl.getCaseInsensitiveName() : MessageFormat.format(Messages.AbstractCompileMojo_1, values, lvl.getCaseInsensitiveName());
                    }
                    this.getLogger().warn(MessageFormat.format(Messages.AbstractCompileMojo_2, this.optimization, values, OptimizationLevel.getDefault().getCaseInsensitiveName()));
                }
            }
            if (this.optimizationInstance == null) {
                this.optimizationInstance = OptimizationLevel.getDefault();
            }
        }
        return this.optimizationInstance;
    }

    @Override
    protected boolean getGenerateInlines() {
        return this.generateInlines;
    }

    @Override
    protected boolean getGenerateEqualityTestFunctions() {
        return this.generateEqualityTestFunctions;
    }

    @Override
    protected boolean getGenerateToStringFunctions() {
        return this.generateToStringFunctions;
    }

    @Override
    protected boolean getGenerateCloneFunctions() {
        return this.generateCloneFunctions;
    }

    @Override
    protected boolean getGenerateSerialNumberFields() {
        return this.generateSerialNumberFields;
    }

    @Override
    protected boolean getGeneratePures() {
        return this.generatePures;
    }

    @Override
    protected boolean getGenerateTraceFiles() {
        return this.generateTraceFiles;
    }

    @Override
    protected boolean getGenerateStorageFiles() {
        return this.generateStorageFiles;
    }

    @Override
    protected void buildPropertyString(StringBuilder buffer) {
        super.buildPropertyString(buffer);
        buffer.append("source = ").append(this.source).append("\n");
        buffer.append("encoding = ").append(this.encoding).append("\n");
        buffer.append("tempDirectory = ").append(this.tempDirectory).append("\n");
        buffer.append("javaCompiler = ").append(this.javaCompiler).append("\n");
        buffer.append("generateInlines = ").append(this.generateInlines).append("\n");
        buffer.append("generateTraceFiles = ").append(this.generateTraceFiles).append("\n");
        buffer.append("generateStorageFiles = ").append(this.generateStorageFiles).append("\n");
        buffer.append("generateEqualityTestFunctions = ").append(this.generateEqualityTestFunctions).append("\n");
        buffer.append("generateToStringFunctions = ").append(this.generateToStringFunctions).append("\n");
        buffer.append("generateCloneFunctions = ").append(this.generateCloneFunctions).append("\n");
        buffer.append("generateSerialNumberFields = ").append(this.generateSerialNumberFields).append("\n");
    }

    @Override
    protected void ensureDefaultParameterValues() {
        super.ensureDefaultParameterValues();
        if (Strings.isNullOrEmpty((String)this.encoding)) {
            Properties properties = this.mavenHelper.getSession().getCurrentProject().getProperties();
            this.encoding = properties.getProperty("project.build.sourceEncoding", null);
            if (Strings.isNullOrEmpty((String)this.encoding)) {
                this.encoding = Charset.defaultCharset().name();
            }
        }
    }

    @Override
    protected void executeMojo() throws MojoExecutionException, MojoFailureException {
        this.ensureSARLVersions();
        this.validateDependencyVersions();
        this.compileSARL();
    }

    private static boolean containsVersion(ArtifactVersion version, ArtifactVersion rangeMin, ArtifactVersion rangeMax) {
        return version.compareTo((Object)rangeMin) >= 0 && version.compareTo((Object)rangeMax) < 0;
    }

    private void ensureSARLVersions() throws MojoExecutionException, MojoFailureException {
        String compilerVersionString = this.mavenHelper.getConfig("plugin.version");
        DefaultArtifactVersion compilerVersion = new DefaultArtifactVersion(compilerVersionString);
        DefaultArtifactVersion maxCompilerVersion = new DefaultArtifactVersion(compilerVersion.getMajorVersion() + "." + (compilerVersion.getMinorVersion() + 1) + ".0");
        this.getLogger().info(MessageFormat.format(Messages.AbstractCompileMojo_5, compilerVersionString, maxCompilerVersion));
        StringBuilder classpath = new StringBuilder();
        Set<String> foundVersions = this.findSARLLibrary((ArtifactVersion)compilerVersion, (ArtifactVersion)maxCompilerVersion, classpath, this.isTychoEnvironment());
        if (foundVersions.isEmpty()) {
            throw new MojoFailureException(MessageFormat.format(Messages.AbstractCompileMojo_6, classpath.toString()));
        }
        StringBuilder versions = new StringBuilder();
        for (String version : foundVersions) {
            if (versions.length() > 0) {
                versions.append(", ");
            }
            versions.append(version);
        }
        if (foundVersions.size() > 1) {
            this.getLogger().info(MessageFormat.format(Messages.AbstractCompileMojo_7, versions));
        } else {
            this.getLogger().info(MessageFormat.format(Messages.AbstractCompileMojo_8, versions));
        }
    }

    private Set<String> findSARLLibrary(ArtifactVersion compilerVersion, ArtifactVersion maxCompilerVersion, StringBuilder classpath, boolean enableTycho) throws MojoExecutionException, MojoFailureException {
        String sarlLibGroupId = this.mavenHelper.getConfig("sarl-lib.groupId");
        String sarlLibArtifactId = this.mavenHelper.getConfig("sarl-lib.artifactId");
        String sarlLibGroupIdTycho = "p2.eclipse-plugin";
        String sarlLibArtifactIdTycho = this.mavenHelper.getConfig("sarl-lib.osgiBundleId");
        TreeSet<String> foundVersions = new TreeSet<String>();
        for (Artifact dep : this.mavenHelper.getSession().getCurrentProject().getArtifacts()) {
            this.getLogger().debug(MessageFormat.format(Messages.AbstractCompileMojo_9, dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
            if (classpath.length() > 0) {
                classpath.append(":");
            }
            classpath.append("{");
            classpath.append(ArtifactUtils.versionlessKey((Artifact)dep));
            classpath.append("}");
            String gid = null;
            String aid = null;
            if (sarlLibGroupId.equals(dep.getGroupId()) && sarlLibArtifactId.equals(dep.getArtifactId())) {
                gid = sarlLibGroupId;
                aid = sarlLibArtifactId;
            } else if (enableTycho && "p2.eclipse-plugin".equals(dep.getGroupId()) && sarlLibArtifactIdTycho.equals(dep.getArtifactId())) {
                gid = "p2.eclipse-plugin";
                aid = sarlLibArtifactIdTycho;
            }
            if (gid == null || aid == null) continue;
            DefaultArtifactVersion dependencyVersion = new DefaultArtifactVersion(dep.getVersion());
            if (!AbstractCompileMojo.containsVersion((ArtifactVersion)dependencyVersion, compilerVersion, maxCompilerVersion)) {
                String shortMessage = MessageFormat.format(Messages.AbstractCompileMojo_10, gid, aid, dependencyVersion.toString(), compilerVersion.toString(), maxCompilerVersion.toString());
                String longMessage = MessageFormat.format(Messages.AbstractCompileMojo_11, sarlLibGroupId, sarlLibArtifactId, dependencyVersion.toString(), compilerVersion.toString(), maxCompilerVersion.toString());
                throw new MojoFailureException((Object)this, shortMessage, longMessage);
            }
            foundVersions.add(dep.getVersion());
        }
        return foundVersions;
    }

    private void validateDependencyVersions() throws MojoExecutionException, MojoFailureException {
        Map projectDependencyTree = this.mavenHelper.getSession().getCurrentProject().getArtifactMap();
        this.validateSarlSdk(projectDependencyTree);
        this.validateSreOnClasspath(projectDependencyTree);
    }

    private void validateSarlSdk(Map<String, Artifact> projectDependencyTree) throws MojoExecutionException, MojoFailureException {
        this.getLogger().info(Messages.AbstractCompileMojo_12);
        String sarlSdkGroupId = this.mavenHelper.getConfig("sarl-sdk.groupId");
        String sarlSdkArtifactId = this.mavenHelper.getConfig("sarl-sdk.artifactId");
        boolean hasError = false;
        String sdkArtifactKey = ArtifactUtils.versionlessKey((String)sarlSdkGroupId, (String)sarlSdkArtifactId);
        Artifact sdkArtifact = projectDependencyTree.get(sdkArtifactKey);
        if (sdkArtifact != null) {
            TreeMap<String, DefaultArtifactVersion> pluginDependencyTree = new TreeMap<String, DefaultArtifactVersion>();
            Set<Artifact> pluginScopeDependencies = this.mavenHelper.resolveDependencies(sdkArtifactKey, false);
            for (Artifact artifact : pluginScopeDependencies) {
                DefaultArtifactVersion pluginScopeDependencyVersion = new DefaultArtifactVersion(artifact.getVersion());
                String pluginScopeDependencyKey = ArtifactUtils.versionlessKey((Artifact)artifact);
                ArtifactVersion currentVersion = (ArtifactVersion)pluginDependencyTree.get(pluginScopeDependencyKey);
                if (currentVersion != null && pluginScopeDependencyVersion.compareTo(currentVersion) <= 0) continue;
                pluginDependencyTree.put(pluginScopeDependencyKey, pluginScopeDependencyVersion);
            }
            for (Map.Entry entry : projectDependencyTree.entrySet()) {
                Artifact projectArtifact;
                DefaultArtifactVersion projectDependencyVersion;
                ArtifactVersion pluginDependencyArtifactVersion = (ArtifactVersion)pluginDependencyTree.get(entry.getKey());
                if (pluginDependencyArtifactVersion == null || Utils.compareMajorMinorVersions(pluginDependencyArtifactVersion, (ArtifactVersion)(projectDependencyVersion = new DefaultArtifactVersion((projectArtifact = (Artifact)entry.getValue()).getVersion()))) == 0) continue;
                String message = MessageFormat.format(Messages.AbstractCompileMojo_13, projectArtifact.getGroupId(), projectArtifact.getArtifactId(), pluginDependencyArtifactVersion.toString(), projectDependencyVersion.toString());
                this.getLogger().error(message);
                hasError = true;
            }
        }
        if (hasError) {
            throw new MojoFailureException(Messages.AbstractCompileMojo_14);
        }
    }

    private void validateSreOnClasspath(Map<String, Artifact> projectDependencyTree) {
        if (this.verifySREInDependencies) {
            this.getLogger().info(Messages.AbstractCompileMojo_15);
            for (Artifact artifact : projectDependencyTree.values()) {
                File file = artifact.getFile();
                boolean found = false;
                if (file != null) {
                    if (file.isDirectory()) {
                        File sreServiceFile = FileSystem.join((File)file, (String[])new String[]{METAINF_FOLDER_NAME, METAINF_SERVICE_FOLDER_NAME, SREBootstrap.class.getName()});
                        found = sreServiceFile.exists();
                    } else {
                        try (JarFile jarFile = new JarFile(file);){
                            found = jarFile.getEntry("META-INF/services/" + SREBootstrap.class.getName()) != null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (!found) continue;
                this.getLogger().info(MessageFormat.format(Messages.AbstractCompileMojo_17, artifact.getId()));
                return;
            }
            this.getLogger().warn(Messages.AbstractCompileMojo_18);
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(Messages.AbstractCompileMojo_16);
        }
    }

    protected abstract void compileSARL() throws MojoExecutionException, MojoFailureException;
}

