/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.abstractmojos;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import io.sarl.lang.SARLStandaloneSetup;
import io.sarl.lang.compiler.batch.CleaningPolicy;
import io.sarl.lang.compiler.batch.OptimizationLevel;
import io.sarl.lang.compiler.batch.SarlBatchCompiler;
import io.sarl.lang.maven.compiler.abstractmojos.AbstractSarlMojo;
import io.sarl.lang.maven.compiler.abstractmojos.MavenPrivateModule;
import io.sarl.lang.maven.compiler.abstractmojos.Messages;
import io.sarl.lang.maven.compiler.compiler.JavaCompiler;
import io.sarl.lang.maven.compiler.utils.MavenJulHandler;
import io.sarl.lang.maven.compiler.utils.MavenProjectResourceSetProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.arakhne.afc.vmutil.FileSystem;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

public abstract class AbstractSarlBatchCompilerMojo
extends AbstractSarlMojo {
    private static final String CONFLICTING_JAR_PATTERN = "^java([0-9]+)api\\.jar$";
    private static final String NUM_PATTERN = "^([0-9]+)";
    private Injector injector;
    private Provider<SarlBatchCompiler> sarlBatchCompilerProvider;
    private ReflectExtensions reflect;
    @Parameter(readonly=true, defaultValue="${basedir}/.settings/io.sarl.lang.SARL.prefs")
    private String propertiesFileLocation;
    @Parameter(defaultValue="false")
    private boolean warningsAsErrors;
    private List<File> bufferedClassPath;
    private List<File> bufferedTestClassPath;
    private List<File> bufferedModulePath;
    private List<File> bufferedTestModulePath;
    @Parameter
    private Map<String, String> issueSeverities;
    private Map<String, Severity> issueSeverityOverrides;

    protected Severity toSeverity(String severity) {
        if (!Strings.isEmpty((String)severity)) {
            String item = severity.toUpperCase();
            for (Severity candidate : Severity.values()) {
                if (!item.equals(candidate.name())) continue;
                return candidate;
            }
        }
        return null;
    }

    protected Map<String, Severity> getIssueSeverityOverrides() throws MojoFailureException {
        if (this.issueSeverityOverrides == null) {
            this.issueSeverityOverrides = new HashMap<String, Severity>();
            if (this.issueSeverities != null && !this.issueSeverities.isEmpty()) {
                for (Map.Entry<String, String> entry : this.issueSeverities.entrySet()) {
                    if (Strings.isEmpty((String)entry.getKey())) continue;
                    String severityStr = entry.getValue();
                    if (Strings.isEmpty((String)severityStr)) {
                        throw new MojoFailureException(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_14, entry.getKey()));
                    }
                    Severity severity = this.toSeverity(severityStr);
                    if (severity == null) {
                        throw new MojoFailureException(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_15, entry.getKey(), severityStr));
                    }
                    this.issueSeverityOverrides.put(entry.getKey(), severity);
                }
            }
        }
        return Collections.unmodifiableMap(this.issueSeverityOverrides);
    }

    protected abstract boolean isFixingJavaClasspathForJre();

    protected abstract boolean isTychoEnvironment();

    protected List<File> fixJreClassPathFiles(List<File> currentClassPath, String classpathName) {
        Pattern conflictPattern = Pattern.compile(CONFLICTING_JAR_PATTERN);
        Pattern numPattern = Pattern.compile(NUM_PATTERN);
        ArrayList<File> newClassPath = new ArrayList<File>(currentClassPath.size());
        int currentVersion = AbstractSarlBatchCompilerMojo.parseInt(numPattern, System.getProperty("java.version"));
        for (File file : currentClassPath) {
            String basename = file.getName();
            Matcher matcher = conflictPattern.matcher(basename);
            if (matcher.find()) {
                int version = AbstractSarlBatchCompilerMojo.parseInt(numPattern, matcher.group(1));
                if (version <= currentVersion) {
                    newClassPath.add(file);
                    continue;
                }
                this.getLogger().info(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_11, basename, classpathName));
                continue;
            }
            newClassPath.add(file);
        }
        return newClassPath;
    }

    protected List<URL> fixJreClassPathURLs(List<URL> currentClassPath, String classpathName) {
        Pattern conflictPattern = Pattern.compile(CONFLICTING_JAR_PATTERN);
        Pattern numPattern = Pattern.compile(NUM_PATTERN);
        ArrayList<URL> newClassPath = new ArrayList<URL>(currentClassPath.size());
        int currentVersion = AbstractSarlBatchCompilerMojo.parseInt(numPattern, System.getProperty("java.version"));
        for (URL file : currentClassPath) {
            String basename = FileSystem.largeBasename((URL)file);
            Matcher matcher = conflictPattern.matcher(basename);
            if (matcher.find()) {
                int version = AbstractSarlBatchCompilerMojo.parseInt(numPattern, matcher.group(1));
                if (version <= currentVersion) {
                    newClassPath.add(file);
                    continue;
                }
                this.getLogger().warn(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_11, basename, classpathName));
                continue;
            }
            newClassPath.add(file);
        }
        return newClassPath;
    }

    private static int parseInt(Pattern pattern, String text) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    protected synchronized void prepareExecution() throws MojoExecutionException {
        if (this.injector == null) {
            try {
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                Class<?> setup = classLoader.loadClass(SARLStandaloneSetup.class.getName());
                Method method = setup.getDeclaredMethod("doSetup", new Class[0]);
                Injector mainInjector = (Injector)method.invoke(null, new Object[0]);
                Class<?> innerModuleType = classLoader.loadClass(MavenPrivateModule.class.getName());
                Module innerModule = (Module)innerModuleType.getConstructor(AbstractSarlBatchCompilerMojo.class).newInstance(new Object[]{this});
                this.injector = mainInjector.createChildInjector(Arrays.asList(innerModule));
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.sarlBatchCompilerProvider == null) {
            this.sarlBatchCompilerProvider = this.injector.getProvider(SarlBatchCompiler.class);
        }
        if (this.reflect == null) {
            this.reflect = (ReflectExtensions)this.injector.getInstance(ReflectExtensions.class);
        }
        if (this.sarlBatchCompilerProvider == null || this.reflect == null) {
            throw new MojoExecutionException(Messages.AbstractSarlBatchCompilerMojo_0);
        }
    }

    protected SarlBatchCompiler getBatchCompiler() {
        return (SarlBatchCompiler)this.sarlBatchCompilerProvider.get();
    }

    protected MavenProject getProject() {
        return this.mavenHelper.getSession().getCurrentProject();
    }

    protected abstract String getSourceVersion();

    protected abstract String getEncoding();

    protected abstract boolean getGenerateInlines();

    protected abstract boolean getGeneratePures();

    protected abstract boolean getGenerateTraceFiles();

    protected abstract boolean getGenerateStorageFiles();

    protected abstract boolean getGenerateEqualityTestFunctions();

    protected abstract boolean getGenerateToStringFunctions();

    protected abstract boolean getGenerateCloneFunctions();

    protected abstract boolean getGenerateSerialNumberFields();

    protected abstract String[] getExtraGenerators();

    protected abstract JavaCompiler getJavaCompiler();

    protected abstract OptimizationLevel getOptimization();

    protected abstract boolean isTestContext();

    @Override
    protected boolean isSkipped() {
        if (this.isTestContext()) {
            boolean mavenTestSkip = false;
            try {
                mavenTestSkip = Boolean.parseBoolean(this.session.getUserProperties().getProperty("maven.test.skip", "false"));
            }
            catch (Throwable exception) {
                mavenTestSkip = false;
            }
            if (mavenTestSkip) {
                return true;
            }
            try {
                mavenTestSkip = Boolean.parseBoolean(this.session.getUserProperties().getProperty("sarl.test.skip", "false"));
            }
            catch (Throwable exception) {
                mavenTestSkip = false;
            }
            if (mavenTestSkip) {
                return true;
            }
        } else {
            boolean mavenCompileSkip = false;
            try {
                mavenCompileSkip = Boolean.parseBoolean(this.session.getUserProperties().getProperty("sarl.compile.skip", "false"));
            }
            catch (Throwable exception) {
                mavenCompileSkip = false;
            }
            if (mavenCompileSkip) {
                return true;
            }
        }
        return super.isSkipped();
    }

    protected boolean isSarlJvmInferrerSkipped() {
        boolean sarlCompileSkip = false;
        try {
            sarlCompileSkip = Boolean.parseBoolean(this.session.getUserProperties().getProperty("sarl.jvminferrer.skip", "false"));
        }
        catch (Throwable exception) {
            sarlCompileSkip = false;
        }
        return sarlCompileSkip;
    }

    protected void compile(List<File> classPath, List<File> modulePath, List<File> sourcePaths, File sarlOutputPath, File classOutputPath) throws MojoExecutionException, MojoFailureException {
        SarlBatchCompiler compiler = this.getBatchCompiler();
        MavenProject project = this.getProject();
        compiler.setResourceSetProvider((Provider)new MavenProjectResourceSetProvider(project));
        Iterable filtered = Iterables.filter(sourcePaths, input -> input.isDirectory());
        if (Iterables.isEmpty((Iterable)filtered)) {
            String dir = Iterables.toString(sourcePaths);
            this.getLogger().info(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_1, dir));
            return;
        }
        String baseDir = project.getBasedir().getAbsolutePath();
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder out = new StringBuilder();
            out.append("sarlOutputPath = ");
            out.append(sarlOutputPath);
            out.append("\nclassOutputPath = ");
            out.append(classOutputPath);
            this.getLogger().debug(out.toString());
        }
        compiler.setSarlCompilationEnable(!this.isSarlJvmInferrerSkipped());
        JavaCompiler compilerType = this.getJavaCompiler();
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        logger.setUseParentHandlers(false);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.addHandler(new MavenJulHandler(this.getLogger()));
        compiler.setLogger(logger);
        compiler.setJavaPostCompilationEnable(compilerType != JavaCompiler.NONE);
        for (Map.Entry entry : this.getIssueSeverityOverrides().entrySet()) {
            compiler.setWarningSeverity((String)entry.getKey(), (Severity)entry.getValue());
        }
        compiler.setReportWarningsAsErrors(this.warningsAsErrors);
        compiler.setOptimizationLevel(this.getOptimization());
        compiler.setClassOutputPath(classOutputPath);
        compiler.setJavaSourceVersion(this.getSourceVersion());
        compiler.setBasePath(baseDir);
        compiler.setTempDirectory(this.getTempDirectory());
        compiler.setCleaningPolicy(CleaningPolicy.NO_CLEANING);
        compiler.setClassPath(classPath);
        compiler.setModulePath(modulePath);
        ArrayList filteredSourcePaths = Lists.newArrayList((Iterable)filtered);
        compiler.setSourcePath((Collection)filteredSourcePaths);
        compiler.setOutputPath(sarlOutputPath);
        compiler.setFileEncoding(this.getEncoding());
        compiler.setWriteTraceFiles(this.getGenerateTraceFiles());
        compiler.setWriteStorageFiles(this.getGenerateStorageFiles());
        compiler.setGenerateInlineAnnotation(this.getGenerateInlines());
        compiler.setGeneratePureAnnotation(this.getGeneratePures());
        compiler.setGenerateEqualityTestFunctions(this.getGenerateEqualityTestFunctions());
        compiler.setGenerateToStringFunctions(this.getGenerateToStringFunctions());
        compiler.setGenerateCloneFunctions(this.getGenerateCloneFunctions());
        compiler.setGenerateSerialNumberFields(this.getGenerateSerialNumberFields());
        StringBuilder stringBuilder = new StringBuilder();
        for (String identifier : this.getExtraGenerators()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(identifier);
        }
        compiler.setExtraLanguageGenerators(stringBuilder.toString());
        compiler.setIssueMessageFormatter((severity, issue, uriToProblem) -> {
            String filename = uriToProblem != null ? uriToProblem.toFileString() : Messages.AbstractSarlBatchCompilerMojo_2;
            return MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_3, filename, issue.getLineNumber(), issue.getColumn(), issue.getMessage(), issue.getCode());
        });
        String[] errorMessage = new String[]{null};
        compiler.addIssueMessageListener((severity, issue, uri, message) -> {
            boolean isError;
            boolean bl = isError = severity == Severity.ERROR || issue.isSyntaxError();
            if (isError && Strings.isEmpty((String)errorMessage[0])) {
                errorMessage[0] = message;
            }
        });
        if (!compiler.compile()) {
            StringBuilder dir = new StringBuilder();
            for (File file : filtered) {
                if (dir.length() > 0) {
                    dir.append(File.pathSeparator);
                }
                dir.append(file.getAbsolutePath());
            }
            if (Strings.isEmpty((String)errorMessage[0])) {
                throw new MojoFailureException(Messages.AbstractSarlBatchCompilerMojo_4);
            }
            throw new MojoFailureException(errorMessage[0]);
        }
    }

    protected abstract File getTempDirectory();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readSarlEclipseSetting(String sourceDirectory) {
        if (this.propertiesFileLocation == null) return null;
        File file = new File(this.propertiesFileLocation);
        if (!file.canRead()) {
            this.getLogger().debug(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_9, this.propertiesFileLocation));
            return null;
        }
        Properties sarlSettings = new Properties();
        try (FileInputStream stream = new FileInputStream(file);){
            sarlSettings.load(stream);
            String sarlOutputDirProp = sarlSettings.getProperty("outlet.DEFAULT_OUTPUT.directory", null);
            if (sarlOutputDirProp == null) return null;
            File srcDir = new File(sourceDirectory);
            this.getLogger().debug(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_7, srcDir.getPath(), srcDir.exists()));
            if (!srcDir.exists()) return null;
            if (srcDir.getParent() == null) return null;
            String path = new File(srcDir.getParent(), sarlOutputDirProp).getPath();
            this.getLogger().debug(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_8, sarlOutputDirProp));
            String string = path;
            return string;
        }
        catch (FileNotFoundException e) {
            this.getLogger().warn(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            this.getLogger().warn(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    protected void updateAtomicallyClasspathFiles(List<File> classpathFiles, Set<String> duplicateAvoider, boolean isMandatory, boolean warnIfMissed, Iterable<String> files) {
        for (String file : files) {
            if (!duplicateAvoider.add(file)) continue;
            File fileObj = new File(file);
            if (fileObj.exists()) {
                classpathFiles.add(fileObj);
                continue;
            }
            if (isMandatory) {
                if (!fileObj.mkdirs()) {
                    this.getLogger().warn(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_10, file));
                    continue;
                }
                classpathFiles.add(fileObj);
                continue;
            }
            if (!warnIfMissed) continue;
            this.getLogger().warn(MessageFormat.format(Messages.AbstractSarlBatchCompilerMojo_10, file));
        }
    }

    protected List<File> buildClassPath() throws MojoExecutionException {
        LinkedHashSet<String> duplicateAvoider = new LinkedHashSet<String>();
        ArrayList<File> classpathFiles = new ArrayList<File>();
        MavenProject project = this.getProject();
        this.updateAtomicallyClasspathFiles(classpathFiles, duplicateAvoider, true, true, Collections.singleton(project.getBuild().getOutputDirectory()));
        this.updateAtomicallyClasspathFiles(classpathFiles, duplicateAvoider, false, false, Collections.singleton(project.getBuild().getSourceDirectory()));
        try {
            this.updateAtomicallyClasspathFiles(classpathFiles, duplicateAvoider, false, true, project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        for (Artifact dep : project.getArtifacts()) {
            this.updateAtomicallyClasspathFiles(classpathFiles, duplicateAvoider, false, true, Collections.singleton(dep.getFile().getAbsolutePath()));
        }
        return classpathFiles;
    }

    protected final List<File> getClassPath() throws MojoExecutionException {
        if (this.bufferedClassPath == null) {
            this.bufferedClassPath = this.buildClassPath();
        }
        return this.bufferedClassPath;
    }

    protected List<File> buildTestClassPath() throws MojoExecutionException {
        LinkedHashSet<String> duplicateAvoider = new LinkedHashSet<String>();
        ArrayList<File> classpathFiles = new ArrayList<File>();
        MavenProject project = this.getProject();
        this.updateAtomicallyClasspathFiles(classpathFiles, duplicateAvoider, true, true, Collections.singleton(project.getBuild().getTestOutputDirectory()));
        this.updateAtomicallyClasspathFiles(classpathFiles, duplicateAvoider, false, false, Collections.singleton(project.getBuild().getTestSourceDirectory()));
        try {
            this.updateAtomicallyClasspathFiles(classpathFiles, duplicateAvoider, false, true, project.getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        for (Artifact dep : project.getArtifacts()) {
            this.updateAtomicallyClasspathFiles(classpathFiles, duplicateAvoider, false, true, Collections.singleton(dep.getFile().getAbsolutePath()));
        }
        return classpathFiles;
    }

    protected final List<File> getTestClassPath() throws MojoExecutionException {
        if (this.bufferedTestClassPath == null) {
            this.bufferedTestClassPath = this.buildTestClassPath();
        }
        return this.bufferedTestClassPath;
    }

    protected List<File> buildModulePath() throws MojoExecutionException {
        ArrayList<File> modulePathFiles = new ArrayList<File>();
        return modulePathFiles;
    }

    protected final List<File> getModulePath() throws MojoExecutionException {
        if (this.bufferedModulePath == null) {
            this.bufferedModulePath = this.buildModulePath();
        }
        return this.bufferedModulePath;
    }

    protected List<File> buildTestModulePath() throws MojoExecutionException {
        ArrayList<File> modulePathFiles = new ArrayList<File>();
        return modulePathFiles;
    }

    protected final List<File> getTestModulePath() throws MojoExecutionException {
        if (this.bufferedTestModulePath == null) {
            this.bufferedTestModulePath = this.buildTestModulePath();
        }
        return this.bufferedTestModulePath;
    }
}

