/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.abstractmojos;

import io.sarl.lang.maven.compiler.abstractmojos.Messages;
import io.sarl.lang.maven.compiler.utils.MavenHelper;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.arakhne.afc.vmutil.FileSystem;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSarlMojo
extends AbstractMojo {
    public static final String MAVEN_TEST_SKIP_NAME = "maven.test.skip";
    public static final String SARL_TEST_SKIP_NAME = "sarl.test.skip";
    public static final String SARL_COMPILE_SKIP_NAME = "sarl.compile.skip";
    public static final String SARL_JVMINFERRER_SKIP_NAME = "sarl.jvminferrer.skip";
    public static final String SARL_CLEAN_SKIP_NAME = "sarl.clean.skip";
    protected MavenHelper mavenHelper;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Inject
    private BuildPluginManager buildPluginManager;
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private ResolutionErrorHandler resolutionErrorHandler;
    @Parameter(defaultValue="src/main/generated-sources/sarl")
    private File output;
    @Parameter(defaultValue="src/main/sarl")
    private File input;
    @Parameter(defaultValue="src/test/generated-sources/sarl")
    private File testOutput;
    @Parameter(defaultValue="src/test/sarl")
    private File testInput;
    @Parameter(defaultValue="src/it/sarl")
    private File integrationTestInput;
    @Parameter(defaultValue="false")
    private boolean skip;
    private Logger logger;

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    protected boolean isSkipped() {
        return this.skip;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipped()) {
            this.getLogger().info(Messages.AbstractSarlMojo_5);
            return;
        }
        try {
            this.mavenHelper = new MavenHelper(this.session, this.buildPluginManager, this.repositorySystem, this.resolutionErrorHandler, this.getLogger());
            this.ensureDefaultParameterValues();
            this.prepareExecution();
            this.executeMojo();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
    }

    protected void ensureDefaultParameterValues() {
    }

    protected void prepareExecution() throws MojoExecutionException {
    }

    protected static File unix2os(String filename) {
        File file = null;
        for (String base : filename.split(Pattern.quote("/"))) {
            file = file == null ? new File(base) : new File(file, base);
        }
        return file;
    }

    protected File makeAbsolute(File file) {
        if (!file.isAbsolute()) {
            File basedir = this.mavenHelper.getSession().getCurrentProject().getBasedir();
            return new File(basedir, file.getPath()).getAbsoluteFile();
        }
        return file;
    }

    protected File getInput() {
        return this.makeAbsolute(this.input == null ? AbstractSarlMojo.unix2os("src/main/sarl") : this.input);
    }

    protected File getOutput() {
        return this.output == null ? this.getDefaultOutput() : this.makeAbsolute(this.output);
    }

    protected File getDefaultOutput() {
        return this.makeAbsolute(AbstractSarlMojo.unix2os("src/main/generated-sources/sarl"));
    }

    protected File getDefaultTestOutput() {
        return this.makeAbsolute(AbstractSarlMojo.unix2os("src/test/generated-sources/sarl"));
    }

    protected File getTestInput() {
        return this.makeAbsolute(this.testInput == null ? AbstractSarlMojo.unix2os("src/test/sarl") : this.testInput);
    }

    protected File getIntegrationTestInput() {
        return this.makeAbsolute(this.integrationTestInput == null ? AbstractSarlMojo.unix2os("src/it/sarl") : this.integrationTestInput);
    }

    protected File getTestOutput() {
        return this.makeAbsolute(this.testOutput == null ? AbstractSarlMojo.unix2os("src/test/generated-sources/sarl") : this.testOutput);
    }

    protected abstract void executeMojo() throws MojoExecutionException, MojoFailureException, DependencyResolutionRequiredException;

    protected void executeMojo(String groupId, String artifactId, String version, String goal, String configuration, Dependency ... dependencies) throws MojoExecutionException, MojoFailureException {
        Xpp3Dom mojoXml;
        Plugin plugin = new Plugin();
        plugin.setArtifactId(artifactId);
        plugin.setGroupId(groupId);
        plugin.setVersion(version);
        plugin.setDependencies(Arrays.asList(dependencies));
        this.getLogger().debug(MessageFormat.format(Messages.AbstractSarlMojo_0, plugin.getId()));
        PluginDescriptor pluginDescriptor = this.mavenHelper.loadPlugin(plugin);
        if (pluginDescriptor == null) {
            throw new MojoExecutionException(MessageFormat.format(Messages.AbstractSarlMojo_1, plugin.getId()));
        }
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
        if (mojoDescriptor == null) {
            throw new MojoExecutionException(MessageFormat.format(Messages.AbstractSarlMojo_2, goal));
        }
        try {
            mojoXml = this.mavenHelper.toXpp3Dom(mojoDescriptor.getMojoConfiguration());
        }
        catch (PlexusConfigurationException e1) {
            throw new MojoExecutionException(e1.getLocalizedMessage(), (Exception)((Object)e1));
        }
        Xpp3Dom configurationXml = this.mavenHelper.toXpp3Dom(configuration, this.getLogger());
        configurationXml = configurationXml != null ? Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)configurationXml, (Xpp3Dom)mojoXml) : mojoXml;
        this.getLogger().debug(MessageFormat.format(Messages.AbstractSarlMojo_3, plugin.getId(), configurationXml.toString()));
        MojoExecution execution = new MojoExecution(mojoDescriptor, configurationXml);
        this.mavenHelper.executeMojo(execution);
    }

    protected Dependency[] getDependenciesFor(String configurationKeyPrefix) throws MojoExecutionException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Pattern pattern = Pattern.compile("^[ \t\n\r]*([^: \t\n\t]+)[ \t\n\r]*:[ \t\n\r]*([^: \t\n\t]+)[ \t\n\r]*$");
        String rawDependencies = this.mavenHelper.getConfig(configurationKeyPrefix + ".dependencies");
        Map<String, Dependency> pomDependencies = this.mavenHelper.getPluginDependencies();
        for (String dependencyId : rawDependencies.split("\\s*[;|,]+\\s*")) {
            String dependencyArtifactId;
            Matcher matcher = pattern.matcher(dependencyId);
            if (matcher == null || !matcher.matches()) continue;
            String dependencyGroupId = matcher.group(1);
            String dependencyKey = ArtifactUtils.versionlessKey((String)dependencyGroupId, (String)(dependencyArtifactId = matcher.group(2)));
            Dependency dependencyObject = pomDependencies.get(dependencyKey);
            if (dependencyObject == null) {
                throw new MojoExecutionException(MessageFormat.format(Messages.AbstractSarlMojo_4, dependencyKey));
            }
            dependencies.add(dependencyObject);
        }
        Dependency[] dependencyArray = new Dependency[dependencies.size()];
        dependencies.toArray(dependencyArray);
        return dependencyArray;
    }

    protected void buildPropertyString(StringBuilder buffer) {
        buffer.append("input = ").append(this.input).append("\n");
        buffer.append("output = ").append(this.output).append("\n");
        buffer.append("testInput = ").append(this.testInput).append("\n");
        buffer.append("integrationTestInput = ").append(this.integrationTestInput).append("\n");
        buffer.append("testOutput = ").append(this.testOutput).append("\n");
    }

    protected List<URL> getMavenPlatformClassPath() {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            return Arrays.asList(ucl.getURLs());
        }
        String[] paths = System.getProperty("java.class.path").split(Pattern.quote(File.pathSeparator));
        ArrayList<URL> files = new ArrayList<URL>(paths.length);
        for (String path : paths) {
            files.add(FileSystem.convertStringToURL((String)path, (boolean)false));
        }
        return files;
    }
}

