/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.compiler;

import com.google.common.base.Strings;
import com.google.inject.Injector;
import io.sarl.lang.compiler.batch.EcjBatchCompiler;
import io.sarl.lang.compiler.batch.IJavaBatchCompiler;
import io.sarl.lang.compiler.batch.JavacBatchCompiler;
import io.sarl.lang.compiler.batch.SarlBatchCompilerUtils;
import io.sarl.lang.maven.compiler.compiler.MavenBatchCompiler;
import io.sarl.lang.maven.compiler.utils.MavenHelper;
import org.apache.maven.project.MavenProject;
import org.eclipse.xtext.xbase.lib.Pure;

public enum JavaCompiler {
    MAVEN{

        @Override
        public Class<? extends IJavaBatchCompiler> getImplementationType() {
            return MavenBatchCompiler.class;
        }

        @Override
        public IJavaBatchCompiler newCompilerInstance(MavenProject project, MavenHelper helper, boolean isTestContext, Injector injector) {
            MavenBatchCompiler cmp = new MavenBatchCompiler(helper, isTestContext);
            injector.injectMembers((Object)cmp);
            return cmp;
        }
    }
    ,
    NONE{

        @Override
        public Class<? extends IJavaBatchCompiler> getImplementationType() {
            return SarlBatchCompilerUtils.getDefaultJavaBatchCompilerImplementationType();
        }

        @Override
        public IJavaBatchCompiler newCompilerInstance(MavenProject project, MavenHelper helper, boolean isTestContext, Injector injector) {
            return SarlBatchCompilerUtils.newDefaultJavaBatchCompiler();
        }
    }
    ,
    ECJ{

        @Override
        public Class<? extends IJavaBatchCompiler> getImplementationType() {
            return EcjBatchCompiler.class;
        }

        @Override
        public IJavaBatchCompiler newCompilerInstance(MavenProject project, MavenHelper helper, boolean isTestContext, Injector injector) {
            return (IJavaBatchCompiler)injector.getInstance(EcjBatchCompiler.class);
        }
    }
    ,
    JAVAC{

        @Override
        public Class<? extends IJavaBatchCompiler> getImplementationType() {
            return JavacBatchCompiler.class;
        }

        @Override
        public IJavaBatchCompiler newCompilerInstance(MavenProject project, MavenHelper helper, boolean isTestContext, Injector injector) {
            return (IJavaBatchCompiler)injector.getInstance(JavacBatchCompiler.class);
        }
    };


    public static JavaCompiler valueOfCaseInsensitive(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        try {
            return JavaCompiler.valueOf(name.toUpperCase());
        }
        catch (Throwable exception) {
            return null;
        }
    }

    public String getNameInMavenConfiguration() {
        return this.name().toLowerCase();
    }

    public abstract IJavaBatchCompiler newCompilerInstance(MavenProject var1, MavenHelper var2, boolean var3, Injector var4);

    @Pure
    public abstract Class<? extends IJavaBatchCompiler> getImplementationType();

    @Pure
    public static JavaCompiler fromImplementationType(Class<? extends IJavaBatchCompiler> type) {
        if (type != null) {
            for (JavaCompiler compiler : JavaCompiler.values()) {
                Class<? extends IJavaBatchCompiler> implementation;
                if (compiler == NONE || (implementation = compiler.getImplementationType()) == null || !implementation.isAssignableFrom(type)) continue;
                return compiler;
            }
        }
        return null;
    }

    public static JavaCompiler getDefault() {
        JavaCompiler jc = JavaCompiler.fromImplementationType(SarlBatchCompilerUtils.getDefaultJavaBatchCompilerImplementationType());
        if (jc != null) {
            return jc;
        }
        return ECJ;
    }
}

