/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.compiler;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import io.sarl.lang.compiler.batch.CompilerStatus;
import io.sarl.lang.compiler.batch.IJavaBatchCompiler;
import io.sarl.lang.compiler.batch.OptimizationLevel;
import io.sarl.lang.maven.compiler.compiler.Messages;
import io.sarl.lang.maven.compiler.utils.MavenHelper;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.xtext.util.Strings;

public final class MavenBatchCompiler
implements IJavaBatchCompiler {
    private static final String DEFAULT_COMPILER_VERSION = "3.14.0";
    private static final String MAVEN_COMPILER_PLUGIN_GROUPID = "org.apache.maven.plugins";
    private static final String MAVEN_COMPILER_PLUGIN_ARTIFACTID = "maven-compiler-plugin";
    private static final String MAVEN_COMPILER_PLUGIN_STANDARD_GOAL = "compile";
    private static final String MAVEN_COMPILER_PLUGIN_TEST_GOAL = "testCompile";
    private final MavenHelper helper;
    private final boolean isTestContext;

    public MavenBatchCompiler(MavenHelper helper, boolean isTestContext) {
        this.helper = helper;
        this.isTestContext = isTestContext;
    }

    public String getName() {
        return "Maven compiler";
    }

    public CompilerStatus compile(File classDirectory, Iterable<File> sourcePathDirectories, Iterable<File> classPathEntries, Iterable<File> modulePathEntries, String javaVersion, String encoding, boolean isCompilerMoreVerbose, OptimizationLevel optimizationLevel, PrintWriter outWriter, PrintWriter errWriter, Logger logger, IProgressMonitor progress) {
        block9: {
            try {
                Xpp3Dom child;
                Xpp3Dom mojoConfiguration;
                String goal;
                MojoDescriptor mojoDescriptor;
                PluginDescriptor pluginDescriptor;
                Map declaredPlugins = this.helper.getSession().getCurrentProject().getBuild().getPluginsAsMap();
                Plugin plugin = (Plugin)declaredPlugins.get(ArtifactUtils.versionlessKey((String)MAVEN_COMPILER_PLUGIN_GROUPID, (String)MAVEN_COMPILER_PLUGIN_ARTIFACTID));
                if (plugin == null) {
                    plugin = new Plugin();
                    plugin.setArtifactId(MAVEN_COMPILER_PLUGIN_ARTIFACTID);
                    plugin.setGroupId(MAVEN_COMPILER_PLUGIN_GROUPID);
                    plugin.setVersion(this.findVersion(logger));
                }
                if ((pluginDescriptor = this.helper.loadPlugin(plugin)) == null || (mojoDescriptor = pluginDescriptor.getMojo(goal = this.isTestContext ? MAVEN_COMPILER_PLUGIN_TEST_GOAL : MAVEN_COMPILER_PLUGIN_STANDARD_GOAL)) == null) break block9;
                try {
                    mojoConfiguration = this.helper.toXpp3Dom(mojoDescriptor.getMojoConfiguration());
                }
                catch (PlexusConfigurationException e1) {
                    throw new MojoExecutionException(e1.getLocalizedMessage(), (Exception)((Object)e1));
                }
                Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
                Xpp3Dom specificConfiguration = new Xpp3Dom("configuration");
                if (!Strings.isEmpty((String)javaVersion)) {
                    child = new Xpp3Dom("source");
                    child.setValue(javaVersion);
                    specificConfiguration.addChild(child);
                    child = new Xpp3Dom("target");
                    child.setValue(javaVersion);
                    specificConfiguration.addChild(child);
                }
                if (!Strings.isEmpty((String)encoding)) {
                    child = new Xpp3Dom("encoding");
                    child.setValue(encoding);
                    specificConfiguration.addChild(child);
                }
                child = new Xpp3Dom("outputDirectory");
                child.setValue(classDirectory.getAbsolutePath());
                specificConfiguration.addChild(child);
                Xpp3Dom configuration = specificConfiguration;
                if (pluginConfiguration != null) {
                    configuration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)pluginConfiguration);
                }
                if (mojoConfiguration != null) {
                    configuration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)mojoConfiguration);
                }
                MojoExecution execution = new MojoExecution(mojoDescriptor, configuration);
                this.helper.executeMojo(execution);
                return CompilerStatus.COMPILATION_SUCCESS;
            }
            catch (Exception exception) {
                if (logger == null) break block9;
                logger.log(Level.SEVERE, exception.getLocalizedMessage(), Throwables.getRootCause((Throwable)exception));
            }
        }
        return CompilerStatus.COMPILATION_FAILURE;
    }

    private String findVersion(Logger logger) throws MojoExecutionException {
        Set<Artifact> artifacts = this.helper.resolve(MAVEN_COMPILER_PLUGIN_GROUPID, MAVEN_COMPILER_PLUGIN_ARTIFACTID);
        Artifact pluginArtifact = (Artifact)Iterables.find(artifacts, it -> MAVEN_COMPILER_PLUGIN_ARTIFACTID.equals(it.getArtifactId()) && MAVEN_COMPILER_PLUGIN_GROUPID.equals(it.getGroupId()));
        if (pluginArtifact != null) {
            return pluginArtifact.getVersion();
        }
        logger.warning(MessageFormat.format(Messages.MavenBatchCompiler_0, DEFAULT_COMPILER_VERSION));
        return DEFAULT_COMPILER_VERSION;
    }
}

