/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.mojos;

import io.sarl.lang.maven.compiler.abstractmojos.AbstractSarlMojo;
import io.sarl.lang.maven.compiler.mojos.Messages;
import java.text.MessageFormat;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CleanMojo
extends AbstractSarlMojo {
    @Override
    protected boolean isSkipped() {
        boolean mavenCleanSkip = false;
        try {
            mavenCleanSkip = Boolean.parseBoolean(this.session.getUserProperties().getProperty("sarl.clean.skip", "false"));
        }
        catch (Throwable exception) {
            mavenCleanSkip = false;
        }
        return mavenCleanSkip || super.isSkipped();
    }

    @Override
    protected void executeMojo() throws MojoExecutionException, MojoFailureException, DependencyResolutionRequiredException {
        if (!this.isSkipped()) {
            this.getLogger().info(Messages.CleanMojo_0);
            String cleanerGroupId = this.mavenHelper.getConfig("cleaner.groupId");
            String cleanerArtifactId = this.mavenHelper.getConfig("cleaner.artifactId");
            String cleanerVersion = this.mavenHelper.getPluginDependencyVersion(cleanerGroupId, cleanerArtifactId);
            String cleanerMojo = this.mavenHelper.getConfig("cleaner.mojo");
            this.executeMojo(cleanerGroupId, cleanerArtifactId, cleanerVersion, cleanerMojo, MessageFormat.format(this.mavenHelper.getConfig("cleaner.configuration"), this.getOutput().getAbsolutePath(), this.getTestOutput().getAbsolutePath()), new Dependency[0]);
        }
    }
}

