/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.mojos;

import io.sarl.lang.maven.compiler.abstractmojos.AbstractCompileMojo;
import io.sarl.lang.maven.compiler.mojos.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompileMojo
extends AbstractCompileMojo {
    @Override
    protected boolean isTestContext() {
        return false;
    }

    private boolean isValidSourceDirectory(File file, File outputDirectory) {
        return !file.equals(outputDirectory) && !file.equals(this.getTestInput()) && !file.equals(this.getIntegrationTestInput());
    }

    private static List<String> getSourceRoots(MavenProject project) {
        TreeSet<String> testRoots = new TreeSet<String>();
        for (String root : project.getTestCompileSourceRoots()) {
            testRoots.add(root);
        }
        ArrayList<String> roots = new ArrayList<String>();
        for (String root : project.getCompileSourceRoots()) {
            if (testRoots.contains(root)) continue;
            roots.add(root);
        }
        return roots;
    }

    @Override
    protected void compileSARL() throws MojoExecutionException, MojoFailureException {
        String settingsValue;
        Logger log = this.getLogger();
        File outputDirectory = this.getOutput();
        log.info(Messages.CompileMojo_0);
        if (log.isDebugEnabled()) {
            StringBuilder properties = new StringBuilder();
            this.buildPropertyString(properties);
            log.debug(properties.toString());
        }
        if (this.getDefaultOutput().equals(this.getOutput()) && (settingsValue = this.readSarlEclipseSetting(this.getProject().getBuild().getSourceDirectory())) != null && !settingsValue.isEmpty()) {
            outputDirectory = new File(settingsValue);
            log.info(MessageFormat.format(Messages.CompileMojo_1, outputDirectory));
        }
        MavenProject project = this.getProject();
        ArrayList<File> compileSourceRoots = new ArrayList<File>();
        for (String filename : CompileMojo.getSourceRoots(project)) {
            File file = new File(filename);
            if (!this.isValidSourceDirectory(file, outputDirectory)) continue;
            compileSourceRoots.add(file);
        }
        List<File> classPath = this.getClassPath();
        List<File> modulePath = this.getModulePath();
        project.addCompileSourceRoot(outputDirectory.getAbsolutePath());
        this.compile(classPath, modulePath, compileSourceRoots, outputDirectory, this.makeAbsolute(new File(this.getProject().getBuild().getOutputDirectory())));
    }
}

