/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.mojos;

import io.sarl.lang.maven.compiler.abstractmojos.AbstractCompileMojo;
import io.sarl.lang.maven.compiler.mojos.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;

@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST)
public class TestCompileMojo
extends AbstractCompileMojo {
    @Override
    protected boolean isTestContext() {
        return true;
    }

    private boolean isValidSourceDirectory(File file, File outputDirectory) {
        return !file.equals(outputDirectory) && !file.equals(this.getInput());
    }

    private static List<String> getSourceRoots(MavenProject project) {
        return project.getTestCompileSourceRoots();
    }

    @Override
    protected void compileSARL() throws MojoExecutionException, MojoFailureException {
        String settingsValue;
        Logger log = this.getLogger();
        File outputDirectory = this.getTestOutput();
        log.info(Messages.TestCompileMojo_0);
        if (this.getDefaultTestOutput().equals(this.getTestOutput()) && (settingsValue = this.readSarlEclipseSetting(this.getProject().getBuild().getTestSourceDirectory())) != null && !settingsValue.isEmpty()) {
            outputDirectory = new File(settingsValue);
            log.info(MessageFormat.format(Messages.TestCompileMojo_1, outputDirectory));
        }
        MavenProject project = this.getProject();
        ArrayList<File> compileSourceRoots = new ArrayList<File>();
        for (String filename : TestCompileMojo.getSourceRoots(project)) {
            File file = new File(filename);
            if (!this.isValidSourceDirectory(file, outputDirectory)) continue;
            compileSourceRoots.add(file);
        }
        List<File> classPath = this.getTestClassPath();
        List<File> modulePath = this.getTestModulePath();
        project.addTestCompileSourceRoot(outputDirectory.getAbsolutePath());
        this.compile(classPath, modulePath, compileSourceRoots, outputDirectory, this.makeAbsolute(new File(this.getProject().getBuild().getTestOutputDirectory())));
    }
}

