/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.maven.compiler.utils;

import com.google.common.base.Strings;
import io.sarl.lang.maven.compiler.utils.Messages;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.slf4j.Logger;

public class MavenHelper {
    private static final String CONFIG_FILENAME = MavenHelper.class.getPackageName().replace('.', '/') + "/config";
    private Map<String, Dependency> pluginDependencies;
    private final MavenSession session;
    private final BuildPluginManager buildPluginManager;
    private final Logger log;
    private final Method getRepositorySessionMethod;
    private final Method loadPluginMethod;
    private final RepositorySystem repositorySystem;
    private final ResolutionErrorHandler resolutionErrorHandler;

    public MavenHelper(MavenSession session, BuildPluginManager buildPluginManager, RepositorySystem repositorySystem, ResolutionErrorHandler resolutionErrorHandler, Logger log) throws MojoExecutionException {
        this.session = session;
        this.buildPluginManager = buildPluginManager;
        this.log = log;
        this.repositorySystem = repositorySystem;
        this.resolutionErrorHandler = resolutionErrorHandler;
        Method method = null;
        for (Method m : this.session.getClass().getDeclaredMethods()) {
            if (!"getRepositorySession".equals(m.getName())) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new MojoExecutionException(Messages.MavenHelper_0, (Throwable)new NoSuchMethodError("getRepositorySystem"));
        }
        this.getRepositorySessionMethod = method;
        method = null;
        for (Method m : this.buildPluginManager.getClass().getDeclaredMethods()) {
            if (!"loadPlugin".equals(m.getName())) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new MojoExecutionException(Messages.MavenHelper_0, (Throwable)new NoSuchMethodError("loadPlugin"));
        }
        this.loadPluginMethod = method;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public BuildPluginManager getBuildPluginManager() {
        return this.buildPluginManager;
    }

    public String getConfig(String key) throws MojoExecutionException {
        return MavenHelper.getConfig(key, this.log);
    }

    public static String getConfig(String key, Logger logger) throws MojoExecutionException {
        ResourceBundle resource = null;
        try {
            resource = ResourceBundle.getBundle(CONFIG_FILENAME, Locale.getDefault(), MavenHelper.class.getClassLoader());
        }
        catch (MissingResourceException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
        String value = resource.getString(key);
        if (value == null || value.isEmpty()) {
            value = Strings.nullToEmpty((String)value);
            if (logger != null) {
                logger.warn(MessageFormat.format(Messages.MavenHelper_1, key));
            }
        }
        return value;
    }

    public PluginDescriptor loadPlugin(Plugin plugin) throws MojoExecutionException {
        try {
            Object repositorySessionObject = this.getRepositorySessionMethod.invoke((Object)this.session, new Object[0]);
            return (PluginDescriptor)this.loadPluginMethod.invoke((Object)this.buildPluginManager, plugin, this.getSession().getCurrentProject().getRemotePluginRepositories(), repositorySessionObject);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
    }

    public void executeMojo(MojoExecution mojo) throws MojoExecutionException, MojoFailureException {
        try {
            this.buildPluginManager.executeMojo(this.session, mojo);
        }
        catch (PluginConfigurationException | PluginManagerException e) {
            throw new MojoFailureException(e.getLocalizedMessage(), e);
        }
    }

    public Dependency toDependency(Artifact artifact) {
        Dependency result = new Dependency();
        result.setArtifactId(artifact.getArtifactId());
        result.setClassifier(artifact.getClassifier());
        result.setGroupId(artifact.getGroupId());
        result.setOptional(artifact.isOptional());
        result.setScope(artifact.getScope());
        result.setType(artifact.getType());
        result.setVersion(artifact.getVersion());
        return result;
    }

    public String getSarlMavenPluginGroupId() {
        return MavenHelper.getSarlMavenPluginGroupId(this.log);
    }

    public static String getSarlMavenPluginGroupId(Logger logger) {
        try {
            return MavenHelper.getConfig("plugin.groupId", logger);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSarlMavenPluginArtifactId() {
        return MavenHelper.getSarlMavenPluginArtifactId(this.log);
    }

    public static String getSarlMavenPluginArtifactId(Logger logger) {
        try {
            return MavenHelper.getConfig("plugin.artifactId", logger);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSarlMavenPluginVersion() {
        return MavenHelper.getSarlMavenPluginVersion(this.log);
    }

    public static String getSarlMavenPluginVersion(Logger logger) {
        try {
            return MavenHelper.getConfig("plugin.version", logger);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSarlSdkGroupId() {
        return MavenHelper.getSarlSdkGroupId(this.log);
    }

    public static String getSarlSdkGroupId(Logger logger) {
        try {
            return MavenHelper.getConfig("sarl-sdk.groupId", logger);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSarlSdkArtifactId() {
        return MavenHelper.getSarlSdkArtifactId(this.log);
    }

    public static String getSarlSdkArtifactId(Logger logger) {
        try {
            return MavenHelper.getConfig("sarl-sdk.artifactId", logger);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSarlSdkVersion() {
        return MavenHelper.getSarlSdkVersion(this.log);
    }

    public static String getSarlSdkVersion(Logger logger) {
        try {
            return MavenHelper.getConfig("plugin.version", logger);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Map<String, Dependency> getPluginDependencies() throws MojoExecutionException {
        if (this.pluginDependencies == null) {
            String groupId = this.getSarlMavenPluginGroupId();
            String artifactId = this.getSarlMavenPluginArtifactId();
            String pluginArtifactKey = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
            Set<Artifact> dependencies = this.resolveDependencies(pluginArtifactKey, true);
            TreeMap<String, Dependency> deps = new TreeMap<String, Dependency>();
            for (Artifact artifact : dependencies) {
                Dependency dep = this.toDependency(artifact);
                deps.put(ArtifactUtils.versionlessKey((Artifact)artifact), dep);
            }
            this.pluginDependencies = deps;
        }
        return this.pluginDependencies;
    }

    public ArtifactResolutionResult resolve(ArtifactResolutionRequest request) throws MojoExecutionException {
        return this.repositorySystem.resolve(request);
    }

    public Set<Artifact> resolve(String groupId, String artifactId) throws MojoExecutionException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setResolveRoot(true);
        request.setResolveTransitively(true);
        request.setLocalRepository(this.getSession().getLocalRepository());
        request.setRemoteRepositories(this.getSession().getCurrentProject().getRemoteArtifactRepositories());
        request.setOffline(this.getSession().isOffline());
        request.setForceUpdate(this.getSession().getRequest().isUpdateSnapshots());
        request.setServers(this.getSession().getRequest().getServers());
        request.setMirrors(this.getSession().getRequest().getMirrors());
        request.setProxies(this.getSession().getRequest().getProxies());
        request.setArtifact(this.createArtifact(groupId, artifactId));
        ArtifactResolutionResult result = this.resolve(request);
        return result.getArtifacts();
    }

    public Artifact createArtifact(String groupId, String artifactId) {
        return this.repositorySystem.createArtifact(groupId, artifactId, "RELEASE", "jar");
    }

    public Set<Artifact> resolveDependencies(String artifactId, boolean plugins) throws MojoExecutionException {
        Artifact pluginArtifact = plugins ? (Artifact)this.getSession().getCurrentProject().getPluginArtifactMap().get(artifactId) : (Artifact)this.getSession().getCurrentProject().getArtifactMap().get(artifactId);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setResolveRoot(false);
        request.setResolveTransitively(true);
        request.setLocalRepository(this.getSession().getLocalRepository());
        request.setRemoteRepositories(this.getSession().getCurrentProject().getRemoteArtifactRepositories());
        request.setOffline(this.getSession().isOffline());
        request.setForceUpdate(this.getSession().getRequest().isUpdateSnapshots());
        request.setServers(this.getSession().getRequest().getServers());
        request.setMirrors(this.getSession().getRequest().getMirrors());
        request.setProxies(this.getSession().getRequest().getProxies());
        request.setArtifact(pluginArtifact);
        ArtifactResolutionResult result = this.resolve(request);
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (MultipleArtifactsNotFoundException e) {
            HashSet missing = new HashSet(e.getMissingArtifacts());
            if (!missing.isEmpty()) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        return result.getArtifacts();
    }

    public String getPluginDependencyVersion(String groupId, String artifactId) throws MojoExecutionException {
        Map<String, Dependency> deps = this.getPluginDependencies();
        String key = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        this.log.debug("COMPONENT DEPENDENCIES(getPluginVersionFromDependencies):");
        this.log.debug(deps.toString());
        Dependency dep = deps.get(key);
        if (dep != null) {
            String version = dep.getVersion();
            if (version != null && !version.isEmpty()) {
                return version;
            }
            throw new MojoExecutionException(MessageFormat.format(Messages.MavenHelper_2, key));
        }
        throw new MojoExecutionException(MessageFormat.format(Messages.MavenHelper_3, key, deps));
    }

    public Xpp3Dom toXpp3Dom(PlexusConfiguration config) throws PlexusConfigurationException {
        Xpp3Dom result = new Xpp3Dom(config.getName());
        result.setValue(config.getValue(null));
        for (String string : config.getAttributeNames()) {
            result.setAttribute(string, config.getAttribute(string));
        }
        for (String string : config.getChildren()) {
            result.addChild(this.toXpp3Dom((PlexusConfiguration)string));
        }
        return result;
    }

    public Xpp3Dom toXpp3Dom(String content, Logger logger) {
        block8: {
            if (content != null && !content.isEmpty()) {
                StringReader sr = new StringReader(content);
                try {
                    Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)sr);
                    sr.close();
                    return xpp3Dom;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            sr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        if (logger == null) break block8;
                        logger.debug(exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
        }
        return null;
    }
}

