/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.api.experienceindex;

import io.sarl.api.experienceindex.Messages;
import io.sarl.api.experienceindex.SeiCanceler;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.DefaultValueSource;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SarlSpecification(value="0.15")
@SarlElementType(value=10)
@XbaseGenerated
public final class SarlExperienceIndex {
    public static final String VERSION = "1.0";
    private static final float LOWER_COMPRESSION_DELAY = SarlExperienceIndex.secs(3.0f);
    private static final float LOWER_ENCRYPTION_DELAY = SarlExperienceIndex.secs(4.0f);
    private static final float LOWER_ARITHMETIC_DELAY = SarlExperienceIndex.secs(30.0f);
    private static final float LOWER_MEMORY_DELAY = SarlExperienceIndex.secs(1.0f);
    private static final float LOWER_DISK_DELAY = SarlExperienceIndex.secs(5.0f);
    private static final int HIGHER_PROCESSOR_COUNT = 16;
    private static final float NS = 1.0E9f;
    private static final SEI SEI_SINGLETON = new SEI();

    @Pure
    private static float secs(float s) {
        return s * 1.0E9f;
    }

    @Pure
    private static float megaBytes(float m) {
        return m * 1024.0f * 1024.0f;
    }

    @Pure
    private static String wrap(float v) {
        String _xifexpression = null;
        boolean _isNaN = Float.isNaN(v);
        _xifexpression = _isNaN ? Messages.SarlExperienceIndex_0 : Float.toString(v);
        return _xifexpression;
    }

    @Pure
    private static float clamp(float v, float min, float max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    @Pure
    private static float normalize(float value) {
        float _xblockexpression = 0.0f;
        boolean _isNaN = Float.isNaN(value);
        if (_isNaN) {
            return Float.NaN;
        }
        int _round = Math.round(value * 10.0f);
        _xblockexpression = (float)_round / 10.0f;
        return _xblockexpression;
    }

    private static void normalize(float ... scores) {
        for (int i = 0; i < scores.length; ++i) {
            float s = scores[i];
            boolean _isNaN = Float.isNaN(s);
            if (!_isNaN) {
                for (int j = 0; j < scores.length; ++j) {
                    float score;
                    if (j == i || !(s >= (score = scores[j]) - 0.1f) || !(s <= score)) continue;
                    s = score;
                }
            }
            scores[i] = s;
        }
    }

    private static float avg(float ... scores) {
        int n = 0;
        float score = 0.0f;
        for (float subscore : scores) {
            boolean _isNaN = Float.isNaN(subscore);
            if (_isNaN) continue;
            score += subscore;
            ++n;
        }
        if (n > 0) {
            score /= (float)n;
            score = SarlExperienceIndex.normalize(score);
        } else {
            score = Float.NaN;
        }
        return score;
    }

    private static void garbage() {
        Runtime r = Runtime.getRuntime();
        for (int i = 0; i < 6; ++i) {
            r.gc();
        }
    }

    @Pure
    private static SeiCanceler wrap(SeiCanceler canceller) {
        SeiCanceler _function;
        SeiCanceler _xifexpression = null;
        _xifexpression = canceller == null ? (_function = () -> false) : canceller;
        return _xifexpression;
    }

    private SarlExperienceIndex() {
    }

    public static void main(String ... args) {
        InputOutput.println((Object)MessageFormat.format(Messages.SarlExperienceIndex_1, VERSION));
        SEI SEI2 = SarlExperienceIndex.getJanusExperienceIndex();
        InputOutput.println((Object)MessageFormat.format(Messages.SarlExperienceIndex_2, SarlExperienceIndex.wrap(SEI2.getBaseScore())));
        InputOutput.println((Object)MessageFormat.format(Messages.SarlExperienceIndex_3, Float.valueOf(SEI2.getCpuScore())));
        InputOutput.println((Object)MessageFormat.format(Messages.SarlExperienceIndex_4, Float.valueOf(SEI2.getMemoryScore())));
        InputOutput.println((Object)MessageFormat.format(Messages.SarlExperienceIndex_5, Float.valueOf(SEI2.getDiskScore())));
        InputOutput.println((Object)Messages.SarlExperienceIndex_6);
    }

    @DefaultValueSource
    @Pure
    public static SEI getJanusExperienceIndex(@DefaultValue(value="io.sarl.api.experienceindex.SarlExperienceIndex#GETJANUSEXPERIENCEINDEX_0") SeiCanceler canceller) {
        SEI _xblockexpression = null;
        SarlExperienceIndex.baseScore(canceller);
        _xblockexpression = SEI_SINGLETON;
        return _xblockexpression;
    }

    @DefaultValueSource
    public static float baseScore(@DefaultValue(value="io.sarl.api.experienceindex.SarlExperienceIndex#BASESCORE_0") SeiCanceler canceller) {
        SeiCanceler clr = SarlExperienceIndex.wrap(canceller);
        float score = SEI_SINGLETON.getBaseScore();
        if (!clr.isCanceled() && Float.isNaN(score)) {
            float _cpuScore = SarlExperienceIndex.cpuScore(canceller);
            float _memoryScore = SarlExperienceIndex.memoryScore(canceller);
            float _diskScore = SarlExperienceIndex.diskScore(canceller);
            List scores = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Float[]{Float.valueOf(_cpuScore), Float.valueOf(_memoryScore), Float.valueOf(_diskScore)}));
            boolean _isCanceled = clr.isCanceled();
            if (_isCanceled) {
                return Float.NaN;
            }
            SarlExperienceIndex.normalize((float[])Conversions.unwrapArray(scores, Float.TYPE));
            score = SarlExperienceIndex.avg((float[])Conversions.unwrapArray(scores, Float.TYPE));
            SEI_SINGLETON.setCpuScore(scores.get(0) == null ? 0.0f : ((Float)scores.get(0)).floatValue());
            SEI_SINGLETON.setMemoryScore(scores.get(1) == null ? 0.0f : ((Float)scores.get(1)).floatValue());
            SEI_SINGLETON.setDiskScore(scores.get(2) == null ? 0.0f : ((Float)scores.get(2)).floatValue());
            SEI_SINGLETON.setBaseScore(score);
        }
        return score;
    }

    @DefaultValueSource
    public static float cpuScore(@DefaultValue(value="io.sarl.api.experienceindex.SarlExperienceIndex#CPUSCORE_0") SeiCanceler canceller) {
        SeiCanceler clr = SarlExperienceIndex.wrap(canceller);
        float score = SEI_SINGLETON.getCpuScore();
        if (!clr.isCanceled() && Float.isNaN(score)) {
            List scores;
            float _computeCompressionScore = SarlExperienceIndex.computeCompressionScore(canceller);
            float _computeEncryptionScore = SarlExperienceIndex.computeEncryptionScore(canceller);
            float _computeArithmeticScore = SarlExperienceIndex.computeArithmeticScore(canceller);
            float _computeMultiProcessorScore = SarlExperienceIndex.computeMultiProcessorScore(canceller);
            List _converted_scores = scores = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Float[]{Float.valueOf(_computeCompressionScore), Float.valueOf(_computeEncryptionScore), Float.valueOf(_computeArithmeticScore), Float.valueOf(_computeMultiProcessorScore)}));
            score = SarlExperienceIndex.avg((float[])Conversions.unwrapArray(_converted_scores, Float.TYPE));
            score = SarlExperienceIndex.normalize(score);
            SEI_SINGLETON.setCpuScore(score);
        }
        return score;
    }

    private static float computeMultiProcessorScore(SeiCanceler canceller) {
        float _xtrycatchfinallyexpression = 0.0f;
        try {
            float _xblockexpression = 0.0f;
            Runtime r = Runtime.getRuntime();
            int n = r.availableProcessors();
            _xtrycatchfinallyexpression = _xblockexpression = SarlExperienceIndex.clamp((float)n * 5.0f / 16.0f + 1.0f, 1.0f, 6.0f);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                _xtrycatchfinallyexpression = Float.NaN;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private static float computeArithmeticScore(SeiCanceler canceller) {
        float _xtrycatchfinallyexpression = 0.0f;
        try {
            float _xblockexpression = 0.0f;
            long s = System.nanoTime();
            for (int i = 0; i < 100000000; ++i) {
                double atanResult = Math.atan2(123.0, 456.0);
                boolean _isCanceled = canceller.isCanceled();
                if (!_isCanceled) continue;
                return Float.NaN;
            }
            long e = System.nanoTime();
            long arithDelay = e - s;
            SarlExperienceIndex.garbage();
            float score = (float)arithDelay * 5.0f / LOWER_ARITHMETIC_DELAY;
            score = 6.0f - score;
            _xtrycatchfinallyexpression = _xblockexpression = SarlExperienceIndex.clamp(score, 1.0f, 6.0f);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                _xtrycatchfinallyexpression = Float.NaN;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private static float computeEncryptionScore(SeiCanceler canceller) {
        float _xtrycatchfinallyexpression = 0.0f;
        try {
            float _xblockexpression = 0.0f;
            Random rnd = new Random();
            StringBuilder t = new StringBuilder();
            for (int i = 0; i < 6000; ++i) {
                for (int j = 0; j < 1024; ++j) {
                    int _nextInt = rnd.nextInt();
                    t.append((char)_nextInt);
                    boolean _isCanceled = canceller.isCanceled();
                    if (!_isCanceled) continue;
                    return Float.NaN;
                }
            }
            t.trimToSize();
            byte[] buffer = t.toString().getBytes();
            SarlExperienceIndex.garbage();
            Properties p = System.getProperties();
            String _property = p.getProperty("user.name");
            String _plus = _property + "@";
            String _hostName = new InetSocketAddress(0).getHostName();
            String _plus_1 = _plus + _hostName + ":jdk_";
            String _property_1 = p.getProperty("java.version");
            String _plus_2 = _plus_1 + _property_1 + ":os_";
            String _property_2 = p.getProperty("os.name");
            String _plus_3 = _plus_2 + _property_2 + "-";
            String _property_3 = p.getProperty("os.version");
            String seed = _plus_3 + _property_3;
            byte[] original = SarlExperienceIndex.md5(seed).getBytes("UTF8");
            Object _newInstance = Array.newInstance(Byte.TYPE, 8);
            byte[] bkey = (byte[])_newInstance;
            for (int i = 0; i < 8; ++i) {
                int _length = original.length;
                bkey[i] = original[i % _length];
                boolean _isCanceled = canceller.isCanceled();
                if (!_isCanceled) continue;
                return Float.NaN;
            }
            SecretKeySpec kkey = new SecretKeySpec(bkey, "DES");
            Cipher cipher = Cipher.getInstance("DES");
            long s = System.nanoTime();
            MessageDigest.getInstance("MD5").digest(buffer);
            boolean _isCanceled = canceller.isCanceled();
            if (_isCanceled) {
                return Float.NaN;
            }
            MessageDigest.getInstance("SHA").digest(buffer);
            boolean _isCanceled_1 = canceller.isCanceled();
            if (_isCanceled_1) {
                return Float.NaN;
            }
            cipher.init(1, kkey);
            boolean _isCanceled_2 = canceller.isCanceled();
            if (_isCanceled_2) {
                return Float.NaN;
            }
            byte[] output = cipher.doFinal(buffer);
            boolean _isCanceled_3 = canceller.isCanceled();
            if (_isCanceled_3) {
                return Float.NaN;
            }
            cipher.init(2, kkey);
            boolean _isCanceled_4 = canceller.isCanceled();
            if (_isCanceled_4) {
                return Float.NaN;
            }
            cipher.doFinal(output);
            boolean _isCanceled_5 = canceller.isCanceled();
            if (_isCanceled_5) {
                return Float.NaN;
            }
            long e = System.nanoTime();
            long encryptionDelay = e - s;
            SarlExperienceIndex.garbage();
            float score = (float)encryptionDelay * 5.0f / LOWER_ENCRYPTION_DELAY;
            score = 6.0f - score;
            _xtrycatchfinallyexpression = _xblockexpression = SarlExperienceIndex.clamp(score, 1.0f, 6.0f);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                _xtrycatchfinallyexpression = Float.NaN;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private static String md5(String str) {
        String _xblockexpression = null;
        if (str == null) {
            return "";
        }
        byte[] uniqueKey = str.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchAlgorithmException) {
                NoSuchAlgorithmException e = (NoSuchAlgorithmException)_t;
                throw new Error(Messages.SarlExperienceIndex_7, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        StringBuilder hashString = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            int _length = hex.length();
            if (_length == 1) {
                hashString.append("0");
                int _length_1 = hex.length();
                hashString.append(hex.charAt(_length_1 - 1));
                continue;
            }
            int _length_2 = hex.length();
            hashString.append(hex.substring(_length_2 - 2));
        }
        _xblockexpression = hashString.toString();
        return _xblockexpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float computeCompressionScore(SeiCanceler canceller) {
        float _xtrycatchfinallyexpression = 0.0f;
        try {
            float _xblockexpression = 0.0f;
            Random rnd = new Random();
            StringBuilder t = new StringBuilder();
            for (int i = 0; i < 6000; ++i) {
                for (int j = 0; j < 1024; ++j) {
                    int _nextInt = rnd.nextInt();
                    t.append((char)_nextInt);
                    boolean _isCanceled = canceller.isCanceled();
                    if (!_isCanceled) continue;
                    return Float.NaN;
                }
            }
            t.trimToSize();
            byte[] buffer = t.toString().getBytes();
            SarlExperienceIndex.garbage();
            long compressionDelay = 0L;
            ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream();
            try (ZipOutputStream zos = new ZipOutputStream(_byteArrayOutputStream);){
                long s = System.nanoTime();
                ZipEntry _zipEntry = new ZipEntry("test.bin");
                zos.putNextEntry(_zipEntry);
                zos.write(buffer, 0, buffer.length);
                long e = System.nanoTime();
                compressionDelay = e - s;
            }
            boolean _isCanceled = canceller.isCanceled();
            if (_isCanceled) {
                return Float.NaN;
            }
            SarlExperienceIndex.garbage();
            float score = (float)compressionDelay * 5.0f / LOWER_COMPRESSION_DELAY;
            score = 6.0f - score;
            _xtrycatchfinallyexpression = _xblockexpression = SarlExperienceIndex.clamp(score, 1.0f, 6.0f);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                _xtrycatchfinallyexpression = Float.NaN;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    @DefaultValueSource
    public static float memoryScore(@DefaultValue(value="io.sarl.api.experienceindex.SarlExperienceIndex#MEMORYSCORE_0") SeiCanceler canceller) {
        SeiCanceler clr = SarlExperienceIndex.wrap(canceller);
        float score = SEI_SINGLETON.getMemoryScore();
        if (!clr.isCanceled() && Float.isNaN(score)) {
            float _megaBytes_5;
            long _maxMemory_4;
            float _megaBytes_4;
            long _maxMemory_3;
            float _megaBytes_3;
            long _maxMemory_2;
            float _megaBytes_2;
            long _maxMemory_1;
            boolean _isCanceled;
            int i;
            long s = System.nanoTime();
            float _megaBytes = SarlExperienceIndex.megaBytes(10.0f);
            Object _newInstance = Array.newInstance(Byte.TYPE, (int)_megaBytes);
            byte[] tab = (byte[])_newInstance;
            for (i = 0; i < tab.length; ++i) {
                int _length;
                _isCanceled = clr.isCanceled();
                if (_isCanceled) {
                    return Float.NaN;
                }
                tab[i] = 123;
                byte t = 0;
                if (i > 0) {
                    t = tab[i - 1];
                }
                if (i >= (_length = tab.length) - 1) continue;
                t = tab[i + 1];
            }
            for (i = 0; i < 10000; ++i) {
                new String("ABSD");
                _isCanceled = clr.isCanceled();
                if (!_isCanceled) continue;
                return Float.NaN;
            }
            long e = System.nanoTime();
            SarlExperienceIndex.garbage();
            score = (float)(e - s) * 5.0f / LOWER_MEMORY_DELAY;
            score = 6.0f - score;
            Runtime r = Runtime.getRuntime();
            long _maxMemory = r.maxMemory();
            float _megaBytes_1 = SarlExperienceIndex.megaBytes(64.0f);
            score = (float)_maxMemory <= _megaBytes_1 ? 1.0f : ((float)(_maxMemory_1 = r.maxMemory()) <= (_megaBytes_2 = SarlExperienceIndex.megaBytes(128.0f)) ? SarlExperienceIndex.clamp(score, 1.0f, 2.0f) : ((float)(_maxMemory_2 = r.maxMemory()) <= (_megaBytes_3 = SarlExperienceIndex.megaBytes(256.0f)) ? SarlExperienceIndex.clamp(score, 1.0f, 3.0f) : ((float)(_maxMemory_3 = r.maxMemory()) <= (_megaBytes_4 = SarlExperienceIndex.megaBytes(512.0f)) ? SarlExperienceIndex.clamp(score, 1.0f, 4.0f) : ((float)(_maxMemory_4 = r.maxMemory()) <= (_megaBytes_5 = SarlExperienceIndex.megaBytes(1024.0f)) ? SarlExperienceIndex.clamp(score, 1.0f, 5.0f) : SarlExperienceIndex.clamp(score, 1.0f, 6.0f)))));
            score = SarlExperienceIndex.normalize(score);
            SEI_SINGLETON.setMemoryScore(score);
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DefaultValueSource
    public static float diskScore(@DefaultValue(value="io.sarl.api.experienceindex.SarlExperienceIndex#DISKSCORE_0") SeiCanceler canceller) {
        SeiCanceler clr = SarlExperienceIndex.wrap(canceller);
        float score = SEI_SINGLETON.getDiskScore();
        if (clr.isCanceled()) return score;
        if (!Float.isNaN(score)) return score;
        try {
            boolean _isCanceled;
            File tempFile = File.createTempFile("SEI", ".bin");
            tempFile.deleteOnExit();
            long s = System.nanoTime();
            try (FileWriter fw = new FileWriter(tempFile);){
                for (int i = 0; i < 0x1400000; ++i) {
                    fw.write("A");
                    _isCanceled = clr.isCanceled();
                    if (!_isCanceled) continue;
                    float f = Float.NaN;
                    return f;
                }
                fw.flush();
            }
            try (FileReader fr = new FileReader(tempFile);){
                while (fr.read() != -1) {
                    _isCanceled = clr.isCanceled();
                    if (!_isCanceled) continue;
                    float f = Float.NaN;
                    return f;
                }
            }
            long e = System.nanoTime();
            tempFile.delete();
            score = (float)(e - s) * 5.0f / LOWER_DISK_DELAY;
            score = 6.0f - score;
            score = SarlExperienceIndex.clamp(score, 1.0f, 6.0f);
            score = SarlExperienceIndex.normalize(score);
        }
        catch (Throwable _t) {
            if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
            score = Float.NaN;
        }
        SEI_SINGLETON.setDiskScore(score);
        return score;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static SeiCanceler $DEFAULT_VALUE$GETJANUSEXPERIENCEINDEX_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static SeiCanceler $DEFAULT_VALUE$BASESCORE_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static SeiCanceler $DEFAULT_VALUE$CPUSCORE_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static SeiCanceler $DEFAULT_VALUE$MEMORYSCORE_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static SeiCanceler $DEFAULT_VALUE$DISKSCORE_0() {
        return null;
    }

    @DefaultValueUse(value="io.sarl.api.experienceindex.SeiCanceler")
    @SyntheticMember
    @Pure
    public static SEI getJanusExperienceIndex() {
        return SarlExperienceIndex.getJanusExperienceIndex(SarlExperienceIndex.$DEFAULT_VALUE$GETJANUSEXPERIENCEINDEX_0());
    }

    @DefaultValueUse(value="io.sarl.api.experienceindex.SeiCanceler")
    @SyntheticMember
    public static float baseScore() {
        return SarlExperienceIndex.baseScore(SarlExperienceIndex.$DEFAULT_VALUE$BASESCORE_0());
    }

    @DefaultValueUse(value="io.sarl.api.experienceindex.SeiCanceler")
    @SyntheticMember
    public static float cpuScore() {
        return SarlExperienceIndex.cpuScore(SarlExperienceIndex.$DEFAULT_VALUE$CPUSCORE_0());
    }

    @DefaultValueUse(value="io.sarl.api.experienceindex.SeiCanceler")
    @SyntheticMember
    public static float memoryScore() {
        return SarlExperienceIndex.memoryScore(SarlExperienceIndex.$DEFAULT_VALUE$MEMORYSCORE_0());
    }

    @DefaultValueUse(value="io.sarl.api.experienceindex.SeiCanceler")
    @SyntheticMember
    public static float diskScore() {
        return SarlExperienceIndex.diskScore(SarlExperienceIndex.$DEFAULT_VALUE$DISKSCORE_0());
    }

    @SarlSpecification(value="0.15")
    @SarlElementType(value=10)
    @XbaseGenerated
    public static class SEI {
        private float base = Float.NaN;
        private float cpu = Float.NaN;
        private float memory = Float.NaN;
        private float disk = Float.NaN;

        SEI() {
        }

        void setBaseScore(float score) {
            this.base = score;
        }

        @Pure
        public float getBaseScore() {
            return this.base;
        }

        void setCpuScore(float score) {
            this.cpu = score;
        }

        @Pure
        public float getCpuScore() {
            return this.cpu;
        }

        void setMemoryScore(float score) {
            this.memory = score;
        }

        @Pure
        public float getMemoryScore() {
            return this.memory;
        }

        void setDiskScore(float score) {
            this.disk = score;
        }

        @Pure
        public float getDiskScore() {
            return this.disk;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SEI other = (SEI)obj;
            if (Float.floatToIntBits(other.base) != Float.floatToIntBits(this.base)) {
                return false;
            }
            if (Float.floatToIntBits(other.cpu) != Float.floatToIntBits(this.cpu)) {
                return false;
            }
            if (Float.floatToIntBits(other.memory) != Float.floatToIntBits(this.memory)) {
                return false;
            }
            if (Float.floatToIntBits(other.disk) != Float.floatToIntBits(this.disk)) {
                return false;
            }
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            int prime = 31;
            result = 31 * result + Float.hashCode(this.base);
            result = 31 * result + Float.hashCode(this.cpu);
            result = 31 * result + Float.hashCode(this.memory);
            result = 31 * result + Float.hashCode(this.disk);
            return result;
        }
    }
}

