/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.api.game.tgob;

import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.DefaultValueSource;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Default implementation of a goal in the game time-based goal-oriented behavior.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version api.gametgob 0.15.1 20250911-224825
 * @mavengroupid io.sarl.sdk
 * @mavenartifactid api.gametgob
 * @since 0.13
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@XbaseGenerated
@SuppressWarnings("all")
public class BaseGoal extends AbstractGob implements Goal {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private double insistence;

  @Accessors
  private double insistenceChangePerTimeUnit;

  /**
   * Constructor.
   * 
   * @param name the name of the goal.
   * @param initialInsistence the initial value of insistence that is associated to this goal.
   * @param timeChange the insistence change per time unit.
   */
  @DefaultValueSource
  public BaseGoal(@DefaultValue("io.sarl.api.game.tgob.BaseGoal#NEW_0") final String name, @DefaultValue("io.sarl.api.game.tgob.BaseGoal#NEW_1") final double initialInsistence, @DefaultValue("io.sarl.api.game.tgob.BaseGoal#NEW_2") final double timeChange) {
    this.setName(name);
    this.setInsistence(initialInsistence);
    this.setInsistenceChangePerTimeUnit(timeChange);
  }

  @Override
  public void setInsistence(final double newInsistence) {
    if ((newInsistence > 0.0)) {
      this.insistence = newInsistence;
    } else {
      this.insistence = 0.0;
    }
  }

  @Override
  @Pure
  public String toString() {
    String _name = this.getName();
    String _formatNumber = AbstractGob.formatNumber(this.getInsistence());
    String _plus = (((("Goal: " + _name) + "\t=") + _formatNumber) + "\t");
    String _formatNumber_1 = AbstractGob.formatNumber(this.getInsistenceChangePerTimeUnit());
    return ((_plus + _formatNumber_1) + "/unit");
  }

  /**
   * Default value for the parameter name
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("null")
  private static String $DEFAULT_VALUE$NEW_0() {
    return null;
  }

  /**
   * Default value for the parameter initialInsistence
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("0.0")
  private static double $DEFAULT_VALUE$NEW_1() {
    return 0.0;
  }

  /**
   * Default value for the parameter timeChange
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("0.0")
  private static double $DEFAULT_VALUE$NEW_2() {
    return 0.0;
  }

  /**
   * Constructor.
   * 
   * @optionalparam name the name of the goal.
   * @optionalparam initialInsistence the initial value of insistence that is associated to this goal.
   * @optionalparam timeChange the insistence change per time unit.
   */
  @DefaultValueUse("java.lang.String,double,double")
  @SyntheticMember
  public BaseGoal() {
    this($DEFAULT_VALUE$NEW_0(), $DEFAULT_VALUE$NEW_1(), $DEFAULT_VALUE$NEW_2());
  }

  /**
   * Constructor.
   * 
   * @optionalparam name the name of the goal.
   * @optionalparam initialInsistence the initial value of insistence that is associated to this goal.
   * @optionalparam timeChange the insistence change per time unit.
   */
  @DefaultValueUse("java.lang.String,double,double")
  @SyntheticMember
  public BaseGoal(final double initialInsistence) {
    this($DEFAULT_VALUE$NEW_0(), initialInsistence, $DEFAULT_VALUE$NEW_2());
  }

  /**
   * Constructor.
   * 
   * @optionalparam name the name of the goal.
   * @optionalparam initialInsistence the initial value of insistence that is associated to this goal.
   * @optionalparam timeChange the insistence change per time unit.
   */
  @DefaultValueUse("java.lang.String,double,double")
  @SyntheticMember
  public BaseGoal(final String name) {
    this(name, $DEFAULT_VALUE$NEW_1(), $DEFAULT_VALUE$NEW_2());
  }

  /**
   * Constructor.
   * 
   * @optionalparam name the name of the goal.
   * @optionalparam initialInsistence the initial value of insistence that is associated to this goal.
   * @optionalparam timeChange the insistence change per time unit.
   */
  @DefaultValueUse("java.lang.String,double,double")
  @SyntheticMember
  public BaseGoal(final double initialInsistence, final double timeChange) {
    this($DEFAULT_VALUE$NEW_0(), initialInsistence, timeChange);
  }

  /**
   * Constructor.
   * 
   * @optionalparam name the name of the goal.
   * @optionalparam initialInsistence the initial value of insistence that is associated to this goal.
   * @optionalparam timeChange the insistence change per time unit.
   */
  @DefaultValueUse("java.lang.String,double,double")
  @SyntheticMember
  public BaseGoal(final String name, final double initialInsistence) {
    this(name, initialInsistence, $DEFAULT_VALUE$NEW_2());
  }

  @Override
  @Pure
  @SyntheticMember
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    BaseGoal other = (BaseGoal) obj;
    if (Double.doubleToLongBits(other.insistence) != Double.doubleToLongBits(this.insistence))
      return false;
    if (Double.doubleToLongBits(other.insistenceChangePerTimeUnit) != Double.doubleToLongBits(this.insistenceChangePerTimeUnit))
      return false;
    return super.equals(obj);
  }

  @Override
  @Pure
  @SyntheticMember
  public int hashCode() {
    int result = super.hashCode();
    final int prime = 31;
    result = prime * result + Double.hashCode(this.insistence);
    result = prime * result + Double.hashCode(this.insistenceChangePerTimeUnit);
    return result;
  }

  @Pure
  @Override
  public double getInsistence() {
    return this.insistence;
  }

  @Pure
  @Override
  public double getInsistenceChangePerTimeUnit() {
    return this.insistenceChangePerTimeUnit;
  }

  public void setInsistenceChangePerTimeUnit(final double insistenceChangePerTimeUnit) {
    this.insistenceChangePerTimeUnit = insistenceChangePerTimeUnit;
  }
}
