/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.api.game.tgob;

import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Describes a goal in the game time-based goal-oriented behavior.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version api.gametgob 0.15.1 20250911-224825
 * @mavengroupid io.sarl.sdk
 * @mavenartifactid api.gametgob
 * @since 0.13
 */
@SarlSpecification("0.15")
@SarlElementType(11)
@XbaseGenerated
@SuppressWarnings("all")
public interface Goal {
  /**
   * Replies the name of the goal.
   * 
   * @return the name.
   */
  @Pure
  String getName();

  /**
   * Replies the insistence value that is associated to the goal.
   * 
   * @return the positive value of the insistence.
   */
  @Pure
  double getInsistence();

  /**
   * Change the insistence value that is associated to the goal.
   * 
   * @param newInsistence the positive value of the insistence.
   */
  void setInsistence(final double newInsistence);

  /**
   * Replies the change to apply to the insistence of this goal when the time progress about one unit.
   * 
   * @return the insistence progress for a time unit.
   */
  @Pure
  default double getInsistenceChangePerTimeUnit() {
    return 0.0;
  }

  /**
   * Replies the discontenment value that corresponds to the given insistence value.
   * By default, the discontenment value is equal to the square of the insistence.
   * 
   * @param insistence the insistence value for which the discontenement must be computed.
   * @return the discontenement value.
   */
  @Pure
  default double getDiscontentmentFor(final double insistence) {
    return Math.pow(insistence, 2);
  }
}
