/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.api.game.tgob;

import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import java.util.List;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Capacity of an agent to select an action in the context of a game time-based goal-oriented behavior.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version api.gametgob 0.15.1 20250911-224825
 * @mavengroupid io.sarl.sdk
 * @mavenartifactid api.gametgob
 * @since 0.13
 */
@FunctionalInterface
@SarlSpecification("0.15")
@SarlElementType(20)
@XbaseGenerated
@SuppressWarnings("all")
public interface SelectAction extends Capacity {
  /**
   * Select an action among the given ones to progress towards the most insistent goal.
   * 
   * @param actions the list of available actions
   * @param goals the list of active goals
   * @return the selected action, i.e. the highest-change action for the most-insistent goal.
   */
  Action selectAction(final List<? extends Action> actions, final List<? extends Goal> goals);

  /**
   * @ExcludeFromApidoc
   */
  class ContextAwareCapacityWrapper<C extends SelectAction> extends Capacity.ContextAwareCapacityWrapper<C> implements SelectAction {
    public ContextAwareCapacityWrapper(final C capacity, final AgentTrait caller) {
      super(capacity, caller);
    }

    public Action selectAction(final List<? extends Action> actions, final List<? extends Goal> goals) {
      try {
        ensureCallerInLocalThread();
        return this.capacity.selectAction(actions, goals);
      } finally {
        resetCallerInLocalThread();
      }
    }
  }
}
